package GQ_comm;
use strict;

use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter);
@EXPORT= qw(askGenquire);

use subs qw (askGenquire);

my $dbug = 0;


=head2 askGenquire

 name:   askGenquire
 synopsis:  askGenquire($request_type, $request_data, $TkWindow);
 function:  perl function to pass a plugin request to Genquire
 args:      request type (see plugins documentation)
            Request data - whatever data needs to be sent with the request
            TkWindow - optional.  If the plugin is a GUI, then it can be updated
            instead of locked during communication

=cut


sub askGenquire {
	my ($request, $data, $window) = @_;
	
	unless ($^O =~ /win32/i){
	#unless (1){
		$| = 1;
		_log("\nREQUEST WAS \n$request $data\n");
		&_send("<REQUEST><$request>$data</$request></REQUEST>\n\n");
		my $response;
		my $partial;
		#sleep 1;
		for (;;){
			if ($window  && $window->isa("Tk::Toplevel")){$window->update}
			my $buf;
			my $len = sysread(STDIN, $buf, 1024);
			substr($buf,0,0)=$partial;  ## prepend from last sysread
			my @buf=split(/\r?\n/,$buf);   ## break into lines
			if ($buf=~/\n$/) { $partial=''; } else { $partial= pop(@buf); }
			_log("\npartial *". (length($partial)) . "*\ncontent $partial");
			foreach(@buf) { $response .= $_ }
			last if ($response =~ /<\/GQ_RESPONSE>/);
			last if ($len) < 1024;
		}
		_log("\nRESPONSE WAS $response\n\n");
		my $failed = (($response =~ /<FAILED>(.*)<\/FAILED/) && $1);
		if ($failed){
			return ($failed, "1");
		} else {
			my $sendback = (($response =~ /<$request>(.*)<\/$request>/) && $1);
			return $sendback;
		}
		
	} else {
		_log("Windows Request $request $data\n");
		open REQUEST, ">REQUESTtemp";	
		print REQUEST "<REQUEST><$request>$data</$request></REQUEST>\n\n";
		close REQUEST;
		_log("request done\n");
		
		rename "REQUESTtemp", "REQUEST";  	# necessary because Win32 has no file locking
											#capability, so we need to ensure that all
											#output has been written before it is opened up to the other process
		
		my $response;
		my $partial;
		#sleep 1;
		while (1){
			if (-e "RESPONSE"){  # if the output file exists
				_log("RESPONSE CAME \n");
				if (-r "RESPONSE"){
					_log("RESPONSE WAS READABLE \n");
					open RESPONSE,"<RESPONSE";
					$response = join "", <RESPONSE>;
					$response =~ s/\n//g;
					close RESPONSE;
					unlink "RESPONSE" || die "can't delete response $!";
					while (-e "RESPONSE"){next}
					_log("RESPONSE contained $response \n");
					last;
				}
			}
			if ($window  && $window->isa("Tk::Toplevel")){$window->update}
		}
		my $failed = (($response =~ /<FAILED>(.*)<\/FAILED/) && $1);
		if ($failed){
			return ($failed, "1");
		} else {
			my $sendback = (($response =~ /<$request>(.*)<\/$request>/) && $1);
			return $sendback;
		}
	}
}

sub _send {
	my ($return) = @_;
	my $len = length($return);
	my $offset = 0; my $tries = 0;
	while ($len){
		my $written = syswrite STDOUT, $return, $len, $offset; # may only write partial data...
		unless (defined $written){next}
		$offset += $written;
		$len -= $written;
		&_log("\nSENT PACKAGE OF LENGTH $written\n");
		
	}
	return;
}

sub _log{
	my ($m) = @_;
	return unless $dbug;
	#open LOGFILE, ">>c:\\temp\\gqcommlogfile.txt" || die "cant open /tmp/gqcommlogfile.txt:   $!";
	open LOGFILE, ">>/tmp/gqcommlogfile.txt" || die "cant open /tmp/gqcommlogfile.txt:   $!";
	print LOGFILE $m;
	close LOGFILE;
}


1;
