#!/usr/bin/perl

#use lib "";
#use lib "/home/markw/BIOPERL/bioperl/bioperl-live/";


BEGIN { (-e "genquire.conf") or die "can't find it $!\n";
	do "genquire.conf"
};

use strict;
use Carp;
use GQ_comm;

my $dbg = 0; # debug flag
my $import;
my $label;

use Tk;
use Tk::FileSelect;

sub log {
	return unless $dbg;
	open CHECK, ">>/tmp/simpleoutputtt.txt" or die "can't open output file";
	print CHECK @_;
	close CHECK;
}


begin();
MainLoop;

sub begin {
	my $mw = MainWindow->new(-title => "Import/Overlay GFF");
	my $chkImport = $mw->Checkbutton(
		-text => "Import into Database? (otherwise just overlay)",
		-variable =>\$import,
		-onvalue => 1,
		-offvalue => 0,
									);
	my $btnBegin = $mw->Button(
		-text => "Select GFF file",
		-command => sub {&importGFF($mw)},
							  );
	$label = $mw->Label(-background => "black", -foreground => "white");
	$chkImport->pack(-side => "top");
	$btnBegin->pack(-side => "top");
	$label->pack(-side => "top", -expand => 1, -fill => 'x');
}



sub importGFF {
    my ($self) = @_;

    my $FE = $self->FileSelect(	-directory => "./",
				-width => 35,
				-filelabel => "Select a GFF file to import",
				-filter => "*.gff",
				-filelistlabel => "Files",
				-dirlistlabel => "Directories",
				-dirlabel => "Select");
    my $GFF_File = $FE->Show;
    if (&load_gff_file($GFF_File)) {
	$label->configure(-text=>'The import was successful');
    } else {
	}
    $label->update;

}

sub load_gff_file {
	my ($filename) = @_;
    eval {open IN, $filename};
	if ($@){$label->configure(-text => "Couldn't open $filename: $@"); return 0}
	my ($return, $failure);
    while (my $string = <IN>) {
		chomp $string;
		next unless $string;
		&log("read $string\n");
		next unless ($string =~ /.*?\t.*?\t.*?\t.*?\t.*?\t.*?\t.*?/);  # must look a bit like gff
		&log("loading $string\n");
		($return, $failure) = &load_gff_string($string);
		if ($failure){$label->configure(-text => "$failure"); return 0}
	}
	return 1;	
}	

sub load_gff_string {

    my ($string)=@_;
    my ($contig, $source, $primary, $start, $end, $score, $strand, $frame, $attribs)=&parse_gff_string($string);
	&log("parsed $contig, $source, $primary, $start, $end, $score, $strand, $frame, $attribs\n");
	return 0 unless (defined($contig) && defined($source) && defined($primary) && defined($start) && defined($end) && defined($score) && defined($strand) && defined($frame));
	my $output = "<contig>$contig</contig>";
	unless (defined($strand)){$strand = "."}
	if ($strand eq "1"){$strand = "+"} # convert to GFF
	elsif ($strand eq "-1"){$strand = "-"}
	$output .="<start>$start</start>";
	$output .="<end>$end</end>";
	$output .="<feature>$primary</feature>";
	$output .="<source>$source</source>";
	$output .="<strand>$strand</strand>";
	$output .="<frame>$frame</frame>";
	$output .="<score>$score</score>";
	$output .="<attributes>$attribs</attributes>";
	$output = &checkImport($output);
	&log("output $output\n\n");
	my ($result, $failure) = &askGenquire("mapFeature", $output);
	
	return ($result, $failure);
}

sub parse_gff_string {
    my ($string)=@_;

    my ($seq, $source, $primary, $start, $end, $score, $strand, $frame, $attribs) = split(/\t+/, $string);

    return ($seq, $source, $primary, $start, $end, $score, $strand, $frame, $attribs);
}


sub checkImport {
	my ($message) = @_;
	if ($import){$message = "<import>$message</import>"}
	return $message;
}

	
