package GQ::Client::Object;

use strict;
use vars qw($AUTOLOAD);

{
#Encapsulated class data

    my %_attr_data = #    DEFAULT         ACCESSIBILITY
        (
        );

#Class methods, to operate on encapsulated class data

    # Does a specified attribute exist?
    sub _exists {
	my ($self, $attr) = @_;
	return exists $_attr_data{$attr};
    }

    # Is a specified object attribute accessible in a given mode
    sub _accessible  {
	my ($self, $attr, $mode) = @_;
	$_attr_data{$attr}[1] =~ /$mode/
    }

    # Classwide default value for a specified object attribute
    sub _default_for {
	my ($self, $attr) = @_;
	$_attr_data{$attr}[0];
    }

    # List of names of all specified object attributes
    sub _standard_keys {
	keys %_attr_data;
    }

}

sub new {
    my ($caller, %arg) = @_;
    my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;
    my $self = bless {}, $class;
    foreach my $attrname ( $self->_standard_keys() ) {
	if (exists $arg{$attrname}) {
	    $self->{$attrname} = $arg{$attrname} }
	elsif ($caller_is_obj) {
	    $self->{$attrname} = $caller->{$attrname} }
	else {
	    $self->{$attrname} = $self->_default_for($attrname) }
    }
    return $self;
}

sub DESTROY {}

sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {
	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) {
		$_[0]->{$attr} = $_[1];
	    }
	    return $_[0]->{$attr}
	};  ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval;
	}
	return $self->{$attr};
    } elsif ($self->_accessible($attr,'read')) {
	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} };
	return $self->{$attr};
    }
    # Must have been a mistake then...
    return;  #return undef
}

1;
