# $Id: ObjectAdaptor.pm,v 1.2 2002/01/03 20:51:22 markw Exp $
#
# Genquire module for GQ::Server::DB::Adaptor::ObjectAdaptor
#
# Cared for by David Block <dblock@gene.pbi.nrc.ca>
#
# Copyright David Block
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

GQ::Server::DB::Adaptor::ObjectAdaptor - Basic adaptor object for basic objects

=head1 SYNOPSIS

This adaptor should never be used, but it provides some basic functionality for its descendants.

=head1 DESCRIPTION

The Adaptor layer allows GQ::Server::XXX objects to SUID (Select, Update, Insert, Delete) from
some persistent data store.  This particular set of adaptors allows Genquire objects to connect
to the reference Genquire MySQL schema.  For documentation of the schema, do

>perldoc GQ/Server/DB/DatabaseAPI.pod

from the root of the Genquire directory structure.

=head1 FEEDBACK

=head2 Reporting Bugs

Like it or lump it, let me know at dblock@gene.pbi.nrc.ca

=head1 AUTHOR - David Block

Email dblock@gene.pbi.nrc.ca

=head1 CONTRIBUTORS

Genquire is the result of a collaboration between Mark Wilkinson
(mwilkinson@gene.pbi.nrc.ca) and David Block (dblock@gene.pbi.nrc.ca).

=head1 APPENDIX

The rest of the documentation details each of the object methods.
Internal methods are usually preceded with a _ .

=cut


package GQ::Server::DB::Adaptor::ObjectAdaptor;
use strict;
use Carp;
use DBI;
use GQ::Root;

{
#Encapsulated class data

                            #    DEFAULT         ACCESSIBILITY
    GQ::Root->create(
		rootlevel => 1,
		context   => [undef,             'read'],
		    );
}

=head2 dbh

 Title   : dbh
 Usage   : my $dbh = $adaptor->dbh;
 Function: returns the database handle from the adaptor's context
 Returns : a valid DBI:mysql dbh
 Args    : none


=cut

sub dbh {
    return $_[0]->context->dbh;
}

=head2 table

 Title   : table
 Usage   : my $table = $adaptor->table;
 Function: returns the table where the data will come from to fill
           the adaptor's object.  If table returns undef, the adaptor
           will not attempt to update the database at all.
 Returns : a string containing a MySQL table name
 Args    : none

=cut

sub table {}

=head2 adaptor

 Title   : adaptor
 Usage   : my $adaptor=$adaptor->adaptor;
 Function: In case the developer gets confused, the adaptor will respond
           to an adaptor call by returning itself
 Returns : itself
 Args    : none

=cut

sub adaptor {return $_[0]}

=head2 update_db

 Title   : update_db
 Usage   : $self->adaptor->update_db($self,'contig_start',47);
 Function: this method changes the value of the given attribute of the given object in the
           database, and returns 1 on success.
 Returns : 1 on success
 Args    : the attribute name to be updated (corresponding to a column in a MySQL table)
           the new value

=cut

sub update_db {
    my ($self,$feat,$attr,$newval)=@_;
    return 1 unless $self->table && $attr && $newval;
    my $table=$self->table;
    my $sth=$self->dbh->prepare("UPDATE $table set $attr = ?".
				" WHERE id = ?");
    $sth->execute($newval,$feat->id) or die "Problem with update: $DBI::errstr";
    $self->context->commit;
    return 1;
}

1;
