# $Id: Contig.pm,v 1.2 2002/03/05 16:53:57 markw Exp $
#
# Genquire module for Contig
#
# Cared for by David Block <dblock@gene.pbi.nrc.ca>
#
# Copyright NRC
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

GQ::Server::Contig - Lightweight object to store start/stop/length values of contigs

=head1 SYNOPSIS

my $contig=GQ::Server::Contig->new(name=>'FCA_ALL',
                                   context=>$context);
my $length=$contig->length;
my $name=$contig->name;
my $contig_id=$contig->id;
my $seq=$contig->sequence;
my $id=$contig->id;

=head1 DESCRIPTION

This class concentrates the database lookups relating to individual contigs in one place.

=head1 FEEDBACK

=head2 Reporting Bugs

Like it or lump it, send feedback to dblock@gene.pbi.nrc.ca

=head1 AUTHOR - David Block

Email dblock@gene.pbi.nrc.ca

=head1 CONTRIBUTORS

Mark Wilkinson (mwilkinson@gene.pbi.nrc.ca).

=head1 APPENDIX

The rest of the documentation details each of the object methods.
Internal methods are usually preceded with a _

=cut


# Let the code begin...


package GQ::Server::Contig;
use strict;
use vars qw(@ISA $AUTOLOAD ); #keep 'use strict' happy
use Carp;
use GQ::Server::Object;
use GQ::Root;

@ISA=qw(GQ::Server::Object);

{
	#Encapsulated class data

                                     #     DEFAULT    ACCESSIBILITY
    GQ::Root->create(	  name          =>  ['',           'read'],
			  context       =>  ['',           'read'],
			  id            =>  [0,            'read'],
			  assembly      =>  [0,            'read'],
			  length        =>  [0,            'read'],
			  VC_start      =>  [0,            'read'],
			  VC_length     =>  [0,            'read'],
			  abs_start     =>  [0,            'read'],
			  sequence      =>  ['',           'read'],
		    );

}

sub _initialize {
    my ($self) = @_;
    $self->adaptor($self->context->adaptor($self));
    my ($length,$VC_start,$VC_length,$abs_start,$id,$assembly)=$self->adaptor->initialize($self);
    $self->{length}=$length;
    $self->{VC_start}=$VC_start;
    $self->{VC_length}=$VC_length;
    $self->{abs_start}=$abs_start;
    $self->{id}=$id;
    $self->{assembly}=$assembly;
	#print "\nreturning from initialize contig\n";
    return $self;
}

sub sequence {
    my ($self)=@_;
    unless ($self->{sequence}) {
	$self->{sequence}=$self->adaptor->sequence($self);
    }
    return $self->{sequence};
}

sub boundaries {
    my ($self)=@_;
    return (1,$self->VC_length);
}

1;
