#!/usr/bin/perl -w
use strict;
use DBI;
use Term::ReadKey;

main();
sub main {
    intro();
    my ($user, $pass) = getNameAndPassword();
    my ($IP, $host, $port) = getNetworkSettings();
    my $dbh = testConnect($IP, $user, $pass);
    unless ($dbh) {
	print "This will not work unless we can get root access to the database.\n";
	print "Please correct the above errors and try again.\n";
	exit;
    }
    print "\nPlease tell me the name of the database you would like to create and/or connect to by default: ";
    chomp(my $def_db=<STDIN>);
    createDatabaseIfNecessary($dbh, $def_db);
    importDatabaseSchemaIfNecessary($user, $pass, $host, $port, $def_db);    
    updateConfigFile($def_db, $IP);
    addUsers($dbh, $def_db);
    importOrgData($user, $pass, $host, $port, $def_db);

    print "\nThank you for using the Genquire database initialization utility.\nEnjoy Genquire!\n\n\n";
    $dbh->disconnect;
    
}


sub intro {
    print qq{
Welcome to the Genquire I mysql database initialization script.  We
are going to ensure that the database is ready to be used as part of
Genquire.  As a prerequisite, please make sure that you know the
password for the root user of mysql (often the root user is either
'root' or 'mysql'
									 
BEFORE RUNNING THIS ensure that you have updated the org.data file to
correctly represent the default organisms you will be working with)
};
}


sub getNameAndPassword {
    print "\nLet's connect to the mysql server now.  Please enter the root user's name and password:\n";
    print "Enter root username: ";
    chomp(my $user=<STDIN>);
    print "Enter root password: ";
    ReadMode 'noecho';
    my $pass = ReadLine 0;
    chomp $pass;
    ReadMode 'normal';
    print "\n";
    return ($user, $pass);
}



sub getNetworkSettings {
    print "\nNow we need to know where the database is on the network.  If the database is on your\n";
    print "local machine, just hit enter.  Otherwise, enter the IP address of the mysql server host.\n";
    print "Mysql IP address: ";
    chomp(my $IP=<STDIN>);
    my $host = $IP;
    my $port;
    if ($IP) {
	print "\nThank you.  What is the port mysql is listening on (default 3306)?\n";
	print "If you don't know, the default is probably fine.\n";
	print "Mysql port: [3306] ";
	chomp($port=<STDIN>);
	$IP .=":$port" if $port;
    }
    return ($IP, $host, $port);
}



sub testConnect {
    my ($IP, $user, $pass) = @_;
    my $db="test";
    if ($IP) {
	$db .= ":$IP";
    }
    if (my $drh=DBI->install_driver('mysql')) {
	if (my $dbh=$drh->connect($db, $user, $pass)) {
	    return $dbh;
	} else {
	    print "Failed to connect to mySQL server: $DBI::errstr\n";
	    return undef;
	}
    } else {
	print "Could not load mysql driver: $DBI::errstr\nPlease download it from CPAN\n";
	return undef;
    }   
}



sub createDatabaseIfNecessary {
    my ($dbh, $def_db) = @_;
    my $must_create=0;
    print "\n\nThank you.  Does $def_db exist? (y/n)";
    chomp(my $yn=<STDIN>);
    if ($yn =~ /n/i) {
	$dbh->do("create database $def_db") or die "Couldn't create database $def_db: $DBI::errstr",
	"\nAre you sure you are the root user of mysql?  You should be able to do this.\n";
    }
}



sub importDatabaseSchemaIfNecessary {
    my ($user, $pass, $host, $port, $def_db) = @_;
    print "\nDoes $def_db need the schema imported?  If you haven't been here before, and you\n";
    print "haven't done it manually, hit 'y'! : ";
    chomp(my $schem=<STDIN>);

    if ($schem =~ /y/i) {
	open SCHEM, "schema" or die "There should be a 'schema' definition file in the present working directory! $!";
	open LOCAL, ">local_schema" or die "Can't write a new file: $!";
	while (<SCHEM>) {
	    s/use .*;/use $def_db;/;
	    print LOCAL $_;
	}
	close LOCAL;
	close SCHEM;
	my $string = ("mysql  -u $user -p$pass "
		      .($host ? "--host $host ": '')
		      .($port ? "--port $port ": '')
		      . "$def_db <local_schema");
	`$string`;
    }
}



sub updateConfigFile {
    my ($def_db, $IP) = @_;
    open CONF,">>../genquire.conf" or die "Can't open config file for writing: $!";
    print CONF "\n".'$DEFAULT_DB='."'$def_db';\n";
    print CONF '$MySQL_IP='."'$IP';\n";
    close CONF;
}




sub addUsers {
    my ($dbh, $def_db) = @_;
    print "\n\nNow it's time to give users access to the database.\n";
    print "This utility will allow you to add as many users as you like,\n";
    print "but you need to enter their passwords as well.  Ask your users\n";
    print "to change their passwords immediately if this is a concern.\n";

    my $more_users='y';
    while ($more_users =~/y/i) {
	my ($newuser, $newpass);
	print "\nEnter the username to be given access to the database: ";
	chomp($newuser=<STDIN>);
	if($newuser) {
	    print "Enter ${newuser}'s password (This is not secure): ";
	    chomp($newpass=<STDIN>);
	}
	if ($newpass) {
	    $dbh->do("GRANT ALL ON $def_db.* to $newuser\@localhost identified by '$newpass'");
	    $dbh->do("GRANT ALL ON $def_db.* to $newuser\@'%' identified by '$newpass'");
	}
	print "\nAre there any more users you want to add to the database (y/n)? ";
	$more_users=<STDIN>;
    }
}


sub importOrgData {
    my ($user, $pass, $host, $port, $def_db) = @_;
    my $string = ("mysql  -u $user -p$pass "
		  .($host ? "--host $host ": '')
		  .($port ? "--port $port ": '')
		  . "$def_db <org.data");
    `$string`;
}
