package GQ::Server::BioSQL::Adaptor::ContigAdaptor;
use strict;
use vars qw(@ISA $AUTOLOAD);
use Carp;
use DBI;
use GQ::Root;
use GQ::Server::BioSQL::Adaptor::ObjectAdaptor;
@ISA=qw(GQ::Server::BioSQL::Adaptor::ObjectAdaptor);


{
#Encapsulated class data

    GQ::Root->create();

	my $id=0;
	sub _next_id {
		return $id++;
	}
}


=head2 initialize

 Title   : initialize
 Usage   : my ($length,$VC_start,$VC_length,$abs_start,$id,$assembly)=$self->adaptor->initialize($self);
 Function: get the basic information from the persistent store about the given contig
 Returns : length, VC_start, VC_length, absolute start(assembly coordinates), contig id, and assembly id of the contig
           For details about the above attributes, see the DatabaseAPI.pod file.
 Args    : the contig object, which should have a name and not much else known about it


=cut

sub initialize {
    my ($self,$contig_object)=@_;
	#returns  (length,VC_start,VC_length,abs_start,ContigAssembly.id,assembly.version)
	my $sa = $self->context->DB->get_SeqAdaptor;
	my $length = ${$sa->get_seq_lengths($contig_object->name)}{$contig_object->name};
	
	return ($length,  # contig length
			1,			  # virtual contig start (in this case, just start of the contig)
			$length,  # length of the virtual contig (in this case, length of the contig)
			1,            # absolute start (in this case, start of the contig)
			$self->_next_id,  	# unique ID for this contig, or some default
			$contig_object->context->DEFAULT_VERSION # assembly version number, or some default
			);
}

=head2 sequence

 Title   : sequence
 Usage   : $self->{sequence}=$self->adaptor->sequence($self);
 Function: return the sequence of the contig
 Returns : the sequence as a string
 Args    : the contig whose sequence is to be found


=cut

sub sequence {
    my ($self,$contig_obj)=@_;    
    return $self->context->DB->get_SeqAdaptor->fetch_by_db_and_accession($self->context->dbname, $contig_obj->name)->seq
	
}

1;
