package GQ::Server::DB::Adaptor::ContigAdaptor;
use strict;
use vars qw(@ISA $AUTOLOAD);
use Carp;
use DBI;
use GQ::Root;
use GQ::Server::DB::Adaptor::ObjectAdaptor;
@ISA=qw(GQ::Server::DB::Adaptor::ObjectAdaptor);


{
#Encapsulated class data

    GQ::Root->create();

}

=head2 initialize

 Title   : initialize
 Usage   : my ($length,$VC_start,$VC_length,$abs_start,$id,$assembly)=$self->adaptor->initialize($self);
 Function: get the basic information from the persistent store about the given contig
 Returns : length, VC_start, VC_length, absolute start(assembly coordinates), contig id, and assembly id of the contig
           For details about the above attributes, see the DatabaseAPI.pod file.
 Args    : the contig object, which should have a name and not much else known about it


=cut

sub initialize {
    my ($self,$contig)=@_;
    my $sth=$self->dbh->prepare("SELECT length,VC_start,VC_length,abs_start,ContigAssembly.id,assembly ".
				"FROM Tiling_Path,Contig,ContigAssembly ".
				"WHERE Tiling_Path.contig_id=ContigAssembly.id AND ContigAssembly.contig_id=Contig.id ".
				"AND version=? AND name=?"
			       );
    $sth->execute($self->context->version,$contig->name);
    return $sth->fetchrow_array;
}

=head2 sequence

 Title   : sequence
 Usage   : $self->{sequence}=$self->adaptor->sequence($self);
 Function: return the sequence of the contig
 Returns : the sequence as a string
 Args    : the contig whose sequence is to be found


=cut

sub sequence {
    my ($self,$contig)=@_;
    my $sth=$self->dbh->prepare("SELECT seq FROM Sequence ".
				"WHERE contig_id=?");
    $sth->execute($contig->id);
    my ($seq)=$sth->fetchrow_array;
    return $seq;
}

1;
