package GQ::Server::DB::Adaptor::GeneAdaptor;
use strict;

use vars qw( $AUTOLOAD @ISA );  #Keep 'use strict' happy

use Carp;
use DBI;
use Storable qw(dclone);
use GQ::Root;
use GQ::Server::DB::Adaptor::ContainerAdaptor;
@ISA = qw (GQ::Server::DB::Adaptor::ContainerAdaptor);


{
#Encapsulated class data
#replace with your column names, and sensible defaults

    GQ::Root->create();

### replace this with your table name
    my $_table='Feature';
    my $_discard_table='Discard';

   # Private table name method
    sub table {$_table}

    sub discard_table {$_discard_table}

}

### write in any custom subroutines here
=head2 generate_name

 Title   : generate_name
 Usage   : $self->{name}=$self->adaptor->generate_name($self);
 Function: come up with a unique gene name for a new gene
 Example : PBIGENAt_F14N39_000021 would be the 21st GENe created on
           the F14N39 contig of At (Arabidopsis thaliana) at PBI
 Returns : a name
 Args    : a nameless gene
 Note    : this is going to be somewhat installation-specific


=cut

sub generate_name {
    my ($self,$feat)=@_;
    my $table =$self->table;
    my $sth_last=$self->dbh->prepare("SELECT $table.name FROM $table,FeatureType WHERE contig_id=? ".
				     "AND FeatureType.type=? AND $table.type=FeatureType.id ".
				     "ORDER BY name DESC LIMIT 1");
    $sth_last->execute($feat->contig_id,$feat->type);
    my ($last_id)=$sth_last->fetchrow_array;
    unless (defined $last_id && $last_id =~ /^PBIGEN/) {
	my ($org_code)=$feat->context->organism->code;
	my ($prefix)=$feat->context->organism->can(GENE_PREFIX)?$feat->context->organism->GENE_PREFIX():"Gene_";
	$last_id='PBIGEN'.$org_code.'_'.$feat->seq_id.'_000000';
    }
    $last_id =~ /(\d+)$/;                    #get the previous highest gene id
    my $last_num = $1;
    my $new_num = sprintf "%06d", ($last_num + 1);  #increment it
    my $new_id = $last_id;
    $new_id =~ s/$last_num/$new_num/;         #put the new number in the new gene id
    return $new_id;
}

=head2 add_transcript

 Title   : add_transcript
 Usage   : $self->adaptor->add_transcript($self,$new);
 Function: associate a transcript with a gene
           This routine simply calls add_element
 Returns : nothing
 Args    : the gene and new transcript objects


=cut

sub add_transcript {
    my ($self,$fea,$new)=@_;
    $self->add_element($fea,$new);
}

=head2 remove_transcript

 Title   : remove_transcript
 Usage   : $self->adaptor->remove_transcript($self,$new);
 Function: disassociate a transcript from a gene
           This routine simply calls remove_element
 Returns : nothing
 Args    : the gene and new gene objects


=cut

sub remove_transcript {
    my ($self,$fea,$old)=@_;
    $self->remove_element($fea,$old);
}


1;
