package GenquireINIT;

use strict;
use Carp;
use vars qw(
	$AUTOLOAD
	@ISA

	$context

	@Organisms
	$Username
	$Password
	$Filename
	$IPAddress
	$Default_DB
	);
use Tk::ErrorDialog;
use Tk::BrowseEntry;
use GQ::Server::DB::Context;
use GQ::Server::DB::DbObj;
use GQ::Client::QueryScreen;
@ISA = qw(Tk::MainWindow);

{
	#Encapsulated class data
	
	#___________________________________________________________
	#ATTRIBUTES
    my %_attr_data = #     				DEFAULT    	ACCESSIBILITY
                  (
					top			=>	[undef, 	'read/write'],	# this is the MainWindow
					QS  		=>  [undef, 	'read/write'],  # holds the query screen

																# variables needed by all of Genquire
					DATA_SOURCES=>	[undef, 	'read/write'],	# list of datasource names and .cfg files from genquire.conf
					BLAST_URL	=>	[undef, 	'read/write'],	# list of datasource names and .cfg files from genquire.conf
					BLAST_CONFIG=>	[undef, 	'read/write'],	# anon hash of the parameters for Blasting (eg. -p, -d,) and how they map onto your specific CGI interface
					TEMP_DIR	=> 	[undef, 	'read/write'],	# full path to /tmp
					WORKING_DIR	=>	[undef, 	'read/write'],	# full path to a directory which is read/writeable for input and output.
					PLUGINS_DIR	=>	[undef, 	'read/write'],	# full path to a directory which is read/writeable for input and output.
					BROWSER		=>	[undef, 	'read/write'],	# full path to a directory which is read/writeable for input and output.

																# variables used by this GUI window
					txtFilename => 	[undef, 	'read/write'],  # these are references to GUI elements
					txtUsername => 	[undef, 	'read/write'],  # that are needed in various places
					txtPassword => 	[undef, 	'read/write'],	#
					lbxOrganism => 	[undef, 	'read/write'],	#
					lbxDataSource =>[undef, 	'read/write'],	#
					txtIPAddress =>	[undef,		'read/write'],  # 
					
                    );

   #_____________________________________________________________

    # METHODS, to operate on encapsulated class data

    # Is a specified object attribute accessible in a given mode
    sub _accessible  {
	my ($self, $attr, $mode) = @_;
	$_attr_data{$attr}[1] =~ /$mode/
    }

    # Classwide default value for a specified object attribute
    sub _default_for {
	my ($self, $attr) = @_;
	$_attr_data{$attr}[0];
    }

    # List of names of all specified object attributes
    sub _standard_keys {
	keys %_attr_data;
    }

}

sub new {
	my ($caller, %args) = @_;
	my $context;
	my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;

	my $top = MainWindow->new;
    my $self = bless $top, $class;
	
    foreach my $attrname ( $self->_standard_keys ) {
    	if (exists $args{$attrname}) {
		$self->{$attrname} = $args{$attrname} }
    elsif ($caller_is_obj) {
		$self->{$attrname} = $caller->{$attrname} }
    else {
		$self->{$attrname} = $self->_default_for($attrname) }
    }

	return 0 unless ($self->TEMP_DIR && $self->WORKING_DIR && $self->DATA_SOURCES);
	$self->top($top);
	
    $self->title("Genquire");
	my $ttframe = $self->Frame(-relief => 'ridge', -borderwidth => '5', -background => 'lightblue');
	my $tframe = $self->Frame(-relief => 'ridge', -borderwidth => '2', -background => 'white');
	my $bframe = $self->Frame(-relief => 'ridge', -borderwidth => '5', -background => 'red');

	my $lbldatasource = $ttframe->Label(-text => "      SELECT DATA SOURCE      ", -background => 'lightblue')->pack(-side => "top", -anchor => 'w');
	  $self->lbxDataSource($ttframe->BrowseEntry(
						     -listwidth => 75,-background => 'lightblue',
						     -variable=>\$self->{selDataSource},
						     -browsecmd => sub {
									 $context = $self->attemptConnection;
									unless ($context){
									    $self->GenerateErrorMessage("Attempt to connect to this datasource failed.  Config file for this datasource may be incorrect.");
									}
								    }
						    )
			      );
	
	my $lblorganism = $tframe->Label(-text => "data source", -background => 'white')->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');	
	$self->lbxOrganism($tframe->BrowseEntry(-listwidth => 85,
											-background => 'white',
											-variable => \$self->{selOrganism}, # variable holds the contents of the widget
											 )->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x'));
	
	my $lblfilename = $tframe->Label(-text => "filename", -background => 'white')->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');
	$self->txtFilename($tframe->Entry(-width => 25,
									  -background => 'white',
									  -textvariable => \$self->{selFilename}, # variable holds the contents of the widget
									  )->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x'));

	my $lblusername = $tframe->Label(-text => "username", -background => 'white')->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');
	$self->txtUsername($tframe->Entry(-width => 15,
									  -background => 'white',
									  -textvariable => \$self->{selUsername}, # variable holds the contents of the widget
									  )->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x'));

	my $lblpassword = $tframe->Label(-text => "password", -background => 'white')->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');	
	$self->txtPassword($tframe->Entry(-width => 15,
									  -show => "*",
									  -background => 'white',
									  -textvariable => \$self->{selPassword}, # variable holds the contents of the widget
									  )->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x'));

	my $lblipaddress = $tframe->Label(-text => "URL/IP", -background => 'white')->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');	
	$self->txtIPAddress($tframe->Entry(-width => 15,
									   -background => 'white',
									   -textvariable => \$self->{selIPAddress}, # variable holds the contents of the widget
									   )->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x'));

	my $btnContinue = $bframe->Button(-text => "Begin with these settings",
									  - command =>sub {
											my $success = $self->GenerateQueryScreen($context);
											unless ($success){
												$self->GenerateErrorMessage("failed to create full connection with these parameters");
											    }
											}
									  )->pack(-side => 'bottom');	
	
	foreach my $source(@{$self->DATA_SOURCES}){
		my ($name, $cfg) = @{$source};
		$self->lbxDataSource->insert(1,$name); # add to the BrowseEntry widget
	}
	$self->lbxDataSource->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');

	$ttframe->pack(-side => 'top', -expand => 1, -fill => 'both');
	$tframe->pack(-side => 'top', -expand => 1, -fill => 'both');
	$bframe->pack(-side => 'bottom', -fill => 'x');
	
	return 1;

}

sub attemptConnection {
	my ($self) = @_;
	my $source = $self->{selDataSource};	# get the item from the encapsulated ref bound to the listbox

	foreach my $sources(@{$self->DATA_SOURCES}){
		my ($known, $cfg) = @{$sources};
		if ($known eq $source){
                        do $cfg; 
		}
	}
	unless ($context) {		#the context object contains all stuff, including a list of organisms
	    return 0;
	}

	# do various housekeeping things here
	# like updating the organisms box, ip address box
	# based on what was returned from the config file
	$self->{selFilename} = $Filename;
	$self->{selUsername} = $Username;
	$self->{selPassword} = $Password;
	$self->{selIPAddress} = $IPAddress;
	#print "deleting organisms\n";
	$self->lbxOrganism->delete(0, 1000);
	foreach my $org($context->all_orgs_by_id){
		next unless $org->common;
		#print "found ",$org->common,"\n";
		$self->lbxOrganism->insert(1, $org->common);  # add to the BrowseEntry widget
		$self->{selOrganism} = $org->common;  # update the visible contents of the widget
	}
	# make sure the fields enabled/disabled as required, etc.etc.
	
	return $context;  # say that a connection can, in principle, happen
}

sub GenerateQueryScreen {
	my ($self,$context)	 = @_;

	foreach my $org($context->all_orgs_by_id){
	    if ($self->{selOrganism} eq $org->common){
		$context->organism($org);
	    }
	}
	return 0 unless ($context->organism->latin);

	my $QS = GQ::Client::QueryScreen->new(
		$self->toplevel,
		context			=> $context,
		TEMP_DIR		=> $self->TEMP_DIR,
		WORKING_DIR		=> $self->WORKING_DIR,
		PLUGINS_DIR		=> $self->PLUGINS_DIR,
		BLAST_URL		=> $self->BLAST_URL,
		BLAST_CONFIG	=> $self->BLAST_CONFIG,
		BROWSER			=> $self->BROWSER,
		);
	$self->QS($QS);
	return $QS;
}

sub GenerateErrorMessage {
	my ($self, $message) = @_;
	my $top = $self->top;
	my $return = $top->DialogBox(-title => "Error");
	$return->add("Label", -text => $message)->pack;
	$return->Show;
}

sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {

	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) { $_[0]->{$attr} = $_[1] }
	    return $_[0]->{$attr};
	};    ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval
	}
	return $self->{$attr};

    } elsif ($self->_accessible($attr,'read')) {

	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} }; ### end of created subroutine
	return $self->{$attr}  }


    # Must have been a mistake then...
    croak "No such method: $AUTOLOAD";
}

1;
