#!/usr/bin/perl

use lib "/home/markw/cvs_genquire/Genquire/PLUGINS/";
use strict;
use Tk;
use GQ_comm;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST GET);

my $URL = $ARGV[0];
my $TMP = $ARGV[1];


&begin;
MainLoop;



sub begin {
	my $mw = MainWindow->new(-title => "Blast via HTTP");
	my $text = $mw->Scrolled('Text', -background => 'white')->pack;
	$mw->update;

	my $result = askGenquire("getSelectedFeatures");
	exit 0 unless $result;

	my @fids = ($result =~ /<feature>(.*?)<\/feature>/g);
	$text->delete("1.0", 'end');

	foreach my $fid(@fids){
		my $result = askGenquire("getFeatureByID", "$fid");
		next unless $result;
		my $seq = (($result =~ /<sequence>(.*?)<\/sequence>/) && $1);

		my @content = CGI_blast($fid, $seq);    # BioPerl Blast Object
		if ($content[0]){
			
			foreach my $line(@content){
				$text->insert('end', "$line\n");     # write it to the text window
			}
		} else {
			$text->insert('end', "\n\nFeature: $fid\n*** No hits found\n");
    	}
    }
}


sub CGI_blast {

    my ($id, $seq)=@_;
    my ($flag, $seqin, $seqout, $seqobj);
    my ($count)=0;
    
    $seq =~ s/\n//g;                                         # get rid of newlines
    $seq = ">FEATURE_INDEX_$id\n" . $seq;    # add a FASTA header
    my $ua = LWP::UserAgent->new();                          # prepare for net connection


 ################################################################
 #			Make Your Local Blast Modifications to the line below
 ################################################################

	my $req = POST $URL, [seq => $seq, blastprogram => 'blastn', database => 'nt']; # prepare net command line

 ################################################################
 ################################################################
 ################################################################


    my $content = $ua->request($req)->as_string;             # execute HTTP call and receive respone
	my @content = split /\n/, $content;                      # split into an array
	return @content;
	
#    open OUT, ">$TMP/blastout";                           # write to a temp file
#    my $line;
#    while ($line = shift @content){
#		if ($line =~ /BLAST(\w)/){print OUT "$line\n"; last}  	 # throw away CGI headers etc. up to this line (the first line of a Blast header...)
#    }                                                            # eg. BLASTX
#	return @content;
	
#    foreach my $line(@content){print OUT "$line\n"}
#    close OUT;
}
