/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PromotSitePanel
extends JPanel {
    Component parent;
    String mrnaVersion = "";
    private JLabel directionJL;
    private JButton trackColorHJB;
    private JTextField wSizeUpJTF;
    private JComboBox trackShadeJCB;
    private JButton trackShadeHJB;
    private JLabel distanceJL;
    private JTextField distanceJTF;
    private JTextField trackColorRJTF;
    private JLabel coordinatesJL;
    private JLabel titleJL;
    private JTextField trackColorBJTF;
    private JLabel trackColorJL;
    private JTextField coordinatesJTF;
    private JButton distanceHJB;
    private JLabel trackShadeJL;
    private JTextField trackColorGJTF;
    private JTextField wSizeDownJTF;
    private JLabel wSizeJL;
    private JComboBox directionJCB;
    private JButton wSizeHJB;
    private JButton coordinatesHJB;
    private JButton directionHJB;

    public PromotSitePanel(Component component) {
        this.parent = component;
        this.initComponents();
        this.directionJCB.addItem(new String("u"));
        this.directionJCB.addItem(new String("d"));
        this.directionJCB.addItem(new String("b"));
        this.setUpStream();
    }

    public int setMrnaVersion(String string) {
        if (string == null) {
            return -1;
        }
        this.mrnaVersion = string;
        return 1;
    }

    public void resetItems() {
        this.mrnaVersion = "";
        this.wSizeUpJTF.setText("10000");
        this.setUpStream();
        this.directionJCB.setSelectedIndex(0);
        this.distanceJTF.setText("1000000");
        this.coordinatesJTF.setText("");
        this.trackColorRJTF.setText("128");
        this.trackColorRJTF.setEnabled(true);
        this.trackColorGJTF.setText("128");
        this.trackColorGJTF.setEnabled(true);
        this.trackColorBJTF.setText("128");
        this.trackColorBJTF.setEnabled(true);
        this.trackShadeJCB.setSelectedIndex(0);
    }

    public void setUpStream() {
        this.directionJCB.setSelectedItem("u");
        this.wSizeUpJTF.setEditable(true);
        this.wSizeDownJTF.setText("0");
        this.wSizeDownJTF.setEditable(false);
    }

    public void setDownStream() {
        this.directionJCB.setSelectedItem("d");
        this.wSizeDownJTF.setEditable(true);
        this.wSizeUpJTF.setText("0");
        this.wSizeUpJTF.setEditable(false);
    }

    public void setBothStreams() {
        this.directionJCB.setSelectedItem("b");
        this.wSizeUpJTF.setEditable(true);
        this.wSizeDownJTF.setEditable(true);
    }

    public String getTrackColor() {
        String string = this.trackColorRJTF.getText().trim() + "," + this.trackColorGJTF.getText().trim() + "," + this.trackColorBJTF.getText().trim();
        return string;
    }

    public String getTrackShade() {
        return ((String)this.trackShadeJCB.getSelectedItem()).trim();
    }

    public String getDirection() {
        return ((String)this.directionJCB.getSelectedItem()).trim();
    }

    public String getCoordinates() {
        return this.coordinatesJTF.getText().trim();
    }

    public String getPsParamsText() {
        String string = "";
        String string2 = this.getDirection();
        if (string2.equals("u")) {
            string = string + "wsize " + this.wSizeUpJTF.getText().trim() + "\n";
        } else if (string2.equals("d")) {
            string = string + "wsize " + this.wSizeDownJTF.getText().trim() + "\n";
        } else if (string2.equals("b")) {
            string = string + "wsize " + this.wSizeUpJTF.getText().trim() + " " + this.wSizeDownJTF.getText().trim() + "\n";
        }
        string = string + "mrnaversion " + this.mrnaVersion.trim() + "\n";
        string = string + "psdistance " + this.distanceJTF.getText().trim() + "\n";
        string = string + "direction " + this.getDirection() + "\n";
        String string3 = this.getCoordinates();
        if (!string3.equals("")) {
            string = string + "coordinates " + string3 + "\n";
        }
        string = string + "trackcolor " + this.getTrackColor();
        System.out.println("PSParams file:\n" + string);
        return string;
    }

    protected int validateWSizeUp(String string) {
        return this.validateWSize(string);
    }

    protected int validateWSizeDown(String string) {
        return this.validateWSize(string);
    }

    protected int validateWSize(String string) {
        if (string == null) {
            return -1;
        }
        if (!MyUtils.isULong(string)) {
            return -1;
        }
        return 1;
    }

    protected int validateMRNAVersion(String string) {
        if (string == null) {
            return -1;
        }
        return 1;
    }

    protected int validateDirection(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim().toLowerCase();
        if (!(string2.equals("u") || string2.equals("d") || string2.equals("b"))) {
            return -1;
        }
        return 1;
    }

    protected int validateCoordinates(String string) {
        return 1;
    }

    protected int validatePSDistance(String string) {
        if (string == null) {
            return -1;
        }
        if (!MyUtils.isULong(string)) {
            return -1;
        }
        return 1;
    }

    protected int validateTrackColor(String string, String string2, String string3) {
        if (!(MyUtils.isInteger(string, 0, 255) && MyUtils.isInteger(string2, 0, 255) && MyUtils.isInteger(string3, 0, 255))) {
            return -1;
        }
        return 1;
    }

    public String i2a(int n) {
        return String.valueOf(n);
    }

    public String parsePSParams() {
        int n = 1;
        int n2 = 1;
        String string = "";
        n2 = this.validateWSizeUp(this.wSizeUpJTF.getText());
        if (n2 < 0) {
            string = string + this.getErrorMesg(7);
            n = -1;
        }
        if ((n2 = this.validateWSizeDown(this.wSizeDownJTF.getText())) < 0) {
            string = string + this.getErrorMesg(8);
            n = -1;
        }
        if ((n2 = this.validateDirection((String)this.directionJCB.getSelectedItem())) < 0) {
            string = string + this.getErrorMesg(3);
            n = -1;
        }
        if ((n2 = this.validatePSDistance(this.distanceJTF.getText())) < 0) {
            string = string + this.getErrorMesg(4);
            n = -1;
        }
        if ((n2 = this.validateCoordinates(this.coordinatesJTF.getText())) < 0) {
            string = string + this.getErrorMesg(5);
            n = -1;
        }
        if ((n2 = this.validateTrackColor(this.trackColorRJTF.getText(), this.trackColorGJTF.getText(), this.trackColorBJTF.getText())) < 0) {
            string = string + this.getErrorMesg(6);
            n = -1;
        }
        if (n > 0) {
            string = "";
        }
        return string;
    }

    public String getErrorMesg(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "Error in MRNA Version\n";
                break;
            }
            case 2: {
                string = "Error in Window Size\n";
                break;
            }
            case 3: {
                string = "Error in Direction\n";
                break;
            }
            case 4: {
                string = "Error in PS Distance\n";
                break;
            }
            case 5: {
                string = "Error in Search Coordinates String\n";
                break;
            }
            case 6: {
                string = "Error in Track Colors\n";
                break;
            }
            case 7: {
                string = "Error in Upstream window size\n";
                break;
            }
            case 8: {
                string = "Error in Downstream window size\n";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private void initComponents() {
        this.titleJL = new JLabel();
        this.wSizeJL = new JLabel();
        this.wSizeUpJTF = new JTextField();
        this.wSizeDownJTF = new JTextField();
        this.wSizeHJB = new JButton();
        this.directionJL = new JLabel();
        this.directionJCB = new JComboBox();
        this.directionHJB = new JButton();
        this.distanceJL = new JLabel();
        this.distanceJTF = new JTextField();
        this.distanceHJB = new JButton();
        this.coordinatesJL = new JLabel();
        this.coordinatesJTF = new JTextField();
        this.coordinatesHJB = new JButton();
        this.trackColorJL = new JLabel();
        this.trackColorRJTF = new JTextField();
        this.trackColorHJB = new JButton();
        this.trackColorGJTF = new JTextField();
        this.trackColorBJTF = new JTextField();
        this.trackShadeJL = new JLabel();
        this.trackShadeJCB = new JComboBox();
        this.trackShadeHJB = new JButton();
        this.setLayout(new GridBagLayout());
        this.setForeground(new Color(0, 0, 0));
        this.titleJL.setForeground(new Color(0, 0, 0));
        this.titleJL.setHorizontalAlignment(0);
        this.titleJL.setText("Enter the promotsite parameters");
        this.titleJL.setBorder(new LineBorder(new Color(0, 0, 0)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.titleJL, gridBagConstraints);
        this.wSizeJL.setText("Window Size(Upstr Downstr)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wSizeJL, gridBagConstraints);
        this.wSizeUpJTF.setColumns(8);
        this.wSizeUpJTF.setText("10000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wSizeUpJTF, gridBagConstraints);
        this.wSizeDownJTF.setColumns(8);
        this.wSizeDownJTF.setText("10000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wSizeDownJTF, gridBagConstraints);
        this.wSizeHJB.setText("Help");
        this.wSizeHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.wSizeHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wSizeHJB, gridBagConstraints);
        this.directionJL.setText("Search Direction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.directionJL, gridBagConstraints);
        this.directionJCB.setMaximumRowCount(3);
        this.directionJCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.directionJCBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.directionJCB, gridBagConstraints);
        this.directionHJB.setText("Help");
        this.directionHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.directionHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.directionHJB, gridBagConstraints);
        this.distanceJL.setText("Distance between Paralogs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceJL, gridBagConstraints);
        this.distanceJTF.setColumns(8);
        this.distanceJTF.setText("1000000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceJTF, gridBagConstraints);
        this.distanceHJB.setText("Help");
        this.distanceHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.distanceHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceHJB, gridBagConstraints);
        this.coordinatesJL.setText("Search Coordinates String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.coordinatesJL, gridBagConstraints);
        this.coordinatesJTF.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.coordinatesJTF, gridBagConstraints);
        this.coordinatesHJB.setText("Help");
        this.coordinatesHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.coordinatesHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.coordinatesHJB, gridBagConstraints);
        this.trackColorJL.setText("Track Color(RGB)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackColorJL, gridBagConstraints);
        this.trackColorRJTF.setColumns(3);
        this.trackColorRJTF.setText("128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackColorRJTF, gridBagConstraints);
        this.trackColorHJB.setText("Help");
        this.trackColorHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.trackColorHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackColorHJB, gridBagConstraints);
        this.trackColorGJTF.setColumns(3);
        this.trackColorGJTF.setText("128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackColorGJTF, gridBagConstraints);
        this.trackColorBJTF.setColumns(3);
        this.trackColorBJTF.setText("128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackColorBJTF, gridBagConstraints);
        this.trackShadeJL.setText("Track Shade");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackShadeJL, gridBagConstraints);
        this.trackShadeJCB.setModel(new DefaultComboBoxModel<String>(new String[]{"", "100,50,0", "0,60,120"}));
        this.trackShadeJCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.trackShadeJCBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackShadeJCB, gridBagConstraints);
        this.trackShadeHJB.setText("Help");
        this.trackShadeHJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromotSitePanel.this.trackShadeHJBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.trackShadeHJB, gridBagConstraints);
    }

    private void trackShadeHJBActionPerformed(ActionEvent actionEvent) {
        String string = "For all user defined track colors, the track\n";
        string = string + "is displayed in shades of grey unless the \n";
        string = string + "track color is set to 100,50,0(shades of brown)\n";
        string = string + "or 0,60,120(shades of blue)\n";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }

    private void trackShadeJCBActionPerformed(ActionEvent actionEvent) {
        switch (this.trackShadeJCB.getSelectedIndex()) {
            case 0: {
                this.trackColorRJTF.setEnabled(true);
                this.trackColorGJTF.setEnabled(true);
                this.trackColorBJTF.setEnabled(true);
                break;
            }
            case 1: {
                this.trackColorRJTF.setEnabled(false);
                this.trackColorRJTF.setText(this.i2a(100));
                this.trackColorGJTF.setEnabled(false);
                this.trackColorGJTF.setText(this.i2a(50));
                this.trackColorBJTF.setEnabled(false);
                this.trackColorBJTF.setText(this.i2a(0));
                break;
            }
            case 2: {
                this.trackColorRJTF.setEnabled(false);
                this.trackColorRJTF.setText(this.i2a(0));
                this.trackColorGJTF.setEnabled(false);
                this.trackColorGJTF.setText(this.i2a(60));
                this.trackColorBJTF.setEnabled(false);
                this.trackColorBJTF.setText(this.i2a(120));
                break;
            }
            default: {
                this.trackColorRJTF.setEnabled(true);
                this.trackColorGJTF.setEnabled(true);
                this.trackColorBJTF.setEnabled(true);
            }
        }
    }

    private void directionJCBActionPerformed(ActionEvent actionEvent) {
        if (this.directionJCB.getSelectedItem().equals("d")) {
            this.setDownStream();
        } else if (this.directionJCB.getSelectedItem().equals("u")) {
            this.setUpStream();
        } else if (this.directionJCB.getSelectedItem().equals("b")) {
            System.out.println("in both streams");
            this.setBothStreams();
        }
    }

    private void trackColorHJBActionPerformed(ActionEvent actionEvent) {
        String string = "TrackColor: The color in RGB for the genome browser display\n";
        string = string + "Values for each of R, G, and B: 0..255\n";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }

    private void coordinatesHJBActionPerformed(ActionEvent actionEvent) {
        String string = "Search Coordinates String:\n";
        string = string + "Specify the coordinate range and the chromosome names\n";
        string = string + "list to pull the sites. A site is reported if its \n";
        string = string + "coordinate lies within the given range.\n\n";
        string = string + "Cordinate String format: BASIC;BASIC;....\n";
        string = string + "BASIC Format: chrNUM:COORD,COORD,....\n";
        string = string + "NUM format: 1..22/X/Y\n";
        string = string + "COORD Format: START-END,START-END,...\n";
        string = string + "START format: Any positive integer\n";
        string = string + "END format: Any positive integer\n";
        string = string + "\n";
        string = string + "Ex: \n";
        string = string + ":-  #a valid string to repesent all chromosomes and all ranges\n";
        string = string + "chr:-    #same as above, 'chr' means all chromosomes\n";
        string = string + "chrX:1000-\t\t#sites on X above coordinate 1000 \n";
        string = string + "chr4:-4000\t\t#sites on 4 below coordinate 4000 \n";
        string = string + "chrX:1000\t\t#same as chrX:1000-\n";
        string = string + "chr10:100-200\t#sites on 10 between coordinates 100 and 200\t\n";
        string = string + "chr:10000-20000\t#sites on all chromosomes between coordinates 10000 and 20000\n";
        string = string + "chr5:100000-200000,3000000-400000   #two different ranges on chromosome 5\n";
        string = string + "chrY:200-5000,10000-40000;chr1:3000;chr1:5000-10000\t#multiple chrmosomes\n";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }

    private void distanceHJBActionPerformed(ActionEvent actionEvent) {
        String string = "Distance Between Paralogs: Minimum distance between the paralogs\n";
        string = string + "with the same accession number\n";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }

    private void directionHJBActionPerformed(ActionEvent actionEvent) {
        String string = "Direction for search of binding sites from \n";
        string = string + "the gene start coordinate\n\n";
        string = string + "u : upstream from the start coordinate\n";
        string = string + "d : downstream from the start coordinate\n";
        string = string + "b : both upstream and downstream from the start coordinate\n";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }

    private void wSizeHJBActionPerformed(ActionEvent actionEvent) {
        String string = "Window size:Distance from the gene start co-ordinate\n";
        string = string + "in which the search for binding sites is performed";
        JOptionPane.showMessageDialog(this.parent, string, "Promotsite Help", 1);
    }
}

