/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class WMatrixPanel
extends JPanel {
    Component parent;
    JTextField[][] acgt;
    int length = 0;
    int nSeq = 0;
    boolean freqEntered = false;
    private JButton goJB;
    private JTextField riblTitleJTF;
    private JLabel lengthJL;
    private JLabel nSeqJL;
    private JLabel titleJL;
    private JTextField nSeqJTF;
    private JButton helpJB;
    private JPanel acgtJP;
    private JScrollPane matrixJSP;
    private JLabel riblTitleJL;
    private JTextField lengthJTF;

    public void resetItems() {
        this.length = 0;
        this.nSeq = 0;
        this.nSeqJTF.setText("");
        this.freqEntered = false;
        this.acgt = null;
        this.matrixJSP.setMinimumSize(new Dimension(25, 25));
        this.matrixJSP.setPreferredSize(new Dimension(150, 150));
        this.matrixJSP.setViewportView(null);
    }

    public WMatrixPanel(Component parent) {
        this.parent = parent;
        this.initComponents();
        this.resetItems();
        this.setVisible(true);
    }

    private void initComponents() {
        this.matrixJSP = new JScrollPane();
        this.acgtJP = new JPanel();
        this.titleJL = new JLabel();
        this.lengthJL = new JLabel();
        this.lengthJTF = new JTextField();
        this.nSeqJL = new JLabel();
        this.nSeqJTF = new JTextField();
        this.goJB = new JButton();
        this.riblTitleJL = new JLabel();
        this.riblTitleJTF = new JTextField();
        this.helpJB = new JButton();
        this.setLayout(new GridBagLayout());
        this.matrixJSP.setMinimumSize(new Dimension(25, 25));
        this.matrixJSP.setPreferredSize(new Dimension(100, 100));
        this.acgtJP.setLayout(new GridLayout(0, 5, 2, 2));
        this.acgtJP.setPreferredSize(new Dimension(100, 50));
        this.matrixJSP.setViewportView(this.acgtJP);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.matrixJSP, gridBagConstraints);
        this.titleJL.setHorizontalAlignment(0);
        this.titleJL.setText("Generic Weight Matrix Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.add((Component)this.titleJL, gridBagConstraints);
        this.lengthJL.setText("Length of the site");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.lengthJL, gridBagConstraints);
        this.lengthJTF.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.lengthJTF, gridBagConstraints);
        this.nSeqJL.setFont(new Font("Dialog", 0, 12));
        this.nSeqJL.setText("Number of Sequences");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.nSeqJL, gridBagConstraints);
        this.nSeqJTF.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.nSeqJTF, gridBagConstraints);
        this.goJB.setText("Fill the positional frequencies(as integers) of bases");
        this.goJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WMatrixPanel.this.goJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.goJB, gridBagConstraints);
        this.riblTitleJL.setText("Site Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.riblTitleJL, gridBagConstraints);
        this.riblTitleJTF.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.riblTitleJTF, gridBagConstraints);
        this.helpJB.setText("Help");
        this.helpJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WMatrixPanel.this.helpJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.helpJB, gridBagConstraints);
    }

    private void helpJBActionPerformed(ActionEvent evt) {
        String mesg = "";
        mesg = mesg + "Title: Title of the weight matrix generated\n\n";
        mesg = mesg + "Length of the Site: Number of positions in the site\n\n";
        mesg = mesg + "Number of sequences simulated:\n";
        mesg = mesg + "Using the frequencies of bases at each position of a site,\n";
        mesg = mesg + "a random number generator is used to make up sequences.\n";
        mesg = mesg + "Using these sequences, a pseudo information weight matrix is\n";
        mesg = mesg + "created for performing the scans.\n";
        mesg = mesg + "This parameter defines the number of such sequences generated.\n";
        mesg = mesg + "   default: If the parameter is left empty, it takes the default\n";
        mesg = mesg + "   value of the minimum of the summed up frquencies for a,c,g,t \n";
        mesg = mesg + "   overall all the positions\n\n";
        mesg = mesg + "Frequencies: These indicate the number of occurences of a,c,g,t \n";
        mesg = mesg + "at each position in the site from a given set of sequences\n";
        mesg = mesg + "which define that site\n\n";
        mesg = mesg + "NOTE: The matrix region in the generated information matrix is \n";
        mesg = mesg + "defined from 0 to (length of the site -1). So, set the from,to \n";
        mesg = mesg + "parameters accordingly in the corresponding scanp file\n";
        JOptionPane.showMessageDialog(this.parent, mesg, "Help", 1);
    }

    private void goJBActionPerformed(ActionEvent evt) {
        if (!MyUtils.isInteger(this.lengthJTF.getText(), 1, Integer.MAX_VALUE)) {
            this.showError("Length parameter is not a positive integer", "ERROR");
            return;
        }
        this.length = Integer.parseInt(this.lengthJTF.getText());
        System.out.println("length=" + this.length);
        if (!this.nSeqJTF.getText().trim().equals("")) {
            if (!MyUtils.isInteger(this.nSeqJTF.getText(), 1, Integer.MAX_VALUE)) {
                this.showError("Number of sequences is not a positive integer", "ERROR");
                return;
            }
            this.nSeq = Integer.parseInt(this.nSeqJTF.getText());
        }
        this.setMatrix(this.length);
        this.freqEntered = true;
    }

    public String parseMatrix() {
        String errStr = "";
        if (!MyUtils.isInteger(this.lengthJTF.getText(), 1, Integer.MAX_VALUE)) {
            errStr = "Length parameter is not a positive integer";
            return errStr;
        }
        int len = Integer.parseInt(this.lengthJTF.getText());
        if (len != this.length) {
            errStr = "Length does not match with the number of freq. rows. Fill values again";
            return errStr;
        }
        if (!this.nSeqJTF.getText().trim().equals("") && !MyUtils.isInteger(this.nSeqJTF.getText(), 1, Integer.MAX_VALUE)) {
            errStr = "Number of sequences parameter is not a positive integer";
            return errStr;
        }
        if (!this.freqEntered) {
            errStr = "Frequency values not entered";
            return errStr;
        }
        String[] ncl = new String[]{"a", "c", "g", "t"};
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < 4) {
                if (!MyUtils.isInteger(this.acgt[i][j].getText(), 0, Integer.MAX_VALUE)) {
                    errStr = "The frequency value at position " + i + "," + ncl[j] + " is not a positive integer";
                    return errStr;
                }
                ++j;
            }
            ++i;
        }
        return "";
    }

    public String getMatrixText() {
        StringBuffer str = new StringBuffer("");
        str.append(this.riblTitleJTF.getText() + "\n");
        str.append(Integer.toString(this.length) + "\n");
        String nSeqStr = this.nSeqJTF.getText().trim();
        if (!nSeqStr.equals("")) {
            str.append(this.nSeqJTF.getText() + "\n");
        } else {
            int minfreq = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.length) {
                int tmp = 0;
                String[] ncl = new String[]{"a", "c", "g", "t"};
                int j = 0;
                while (j < 4) {
                    try {
                        tmp += Integer.parseInt(this.acgt[i][j].getText());
                    }
                    catch (NumberFormatException e) {
                        this.showError("Frequency not an integer at position " + i + "," + ncl[j] + ",", "parseError");
                        return str.toString();
                    }
                    ++j;
                }
                if (tmp < minfreq) {
                    minfreq = tmp;
                }
                ++i;
            }
            str.append(Integer.toString(minfreq) + "\n");
        }
        int i = 0;
        while (i < this.length) {
            int j = 0;
            while (j < 4) {
                str.append(this.acgt[i][j].getText() + " ");
                ++j;
            }
            str.append("\n");
            ++i;
        }
        return str.toString();
    }

    public void setMatrix(int len) {
        if (this.acgtJP != null) {
            this.acgtJP.removeAll();
        }
        this.acgt = null;
        this.acgtJP = null;
        this.acgtJP = new JPanel();
        this.acgtJP.setLayout(new GridLayout(0, 5, 2, 2));
        System.out.println("In setMatrix len");
        JLabel[] header = new JLabel[5];
        int i = 0;
        while (i < 5) {
            header[i] = new JLabel();
            header[i].setMinimumSize(new Dimension(20, 10));
            header[i].setPreferredSize(new Dimension(20, 10));
            header[i].setHorizontalAlignment(0);
            header[i].setEnabled(true);
            header[i].setVisible(true);
            this.acgtJP.add(header[i]);
            ++i;
        }
        header[0].setText("Position");
        header[1].setText("A");
        header[2].setText("C");
        header[3].setText("G");
        header[4].setText("T");
        this.acgt = new JTextField[len][4];
        int i2 = 0;
        while (i2 < len) {
            int j = 0;
            while (j < 4) {
                this.acgt[i2][j] = new JTextField(10);
                this.acgt[i2][j].setMinimumSize(new Dimension(20, 10));
                this.acgt[i2][j].setPreferredSize(new Dimension(20, 10));
                this.acgt[i2][j].setEnabled(true);
                this.acgt[i2][j].setVisible(true);
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < len) {
            JLabel tmpJL = new JLabel(Integer.toString(i3));
            tmpJL.setMinimumSize(new Dimension(20, 10));
            tmpJL.setPreferredSize(new Dimension(20, 10));
            this.acgtJP.add(tmpJL);
            int j = 0;
            while (j < 4) {
                this.acgtJP.add(this.acgt[i3][j]);
                ++j;
            }
            ++i3;
        }
        this.acgtJP.setEnabled(true);
        this.acgtJP.setVisible(true);
        this.acgtJP.setPreferredSize(new Dimension(150, 25 * len));
        this.matrixJSP.setViewportView(this.acgtJP);
        if (30 * len < 350) {
            this.matrixJSP.setPreferredSize(new Dimension(150, 30 * len));
        } else {
            this.matrixJSP.setPreferredSize(new Dimension(150, 300));
        }
        this.matrixJSP.setMaximumSize(new Dimension(150, 300));
        this.matrixJSP.repaint();
        this.acgtJP.repaint();
    }

    protected void showError(String errString, String errTitle) {
        if (errString != null) {
            JOptionPane.showMessageDialog(this.parent, errString, errTitle, 0);
        }
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("Test");
        WMatrixPanel wm = new WMatrixPanel(jf);
        wm.setEnabled(true);
        jf.getContentPane().add(wm);
        jf.pack();
        jf.show();
    }
}

