/*
 * MyUtils.java
 *
 * Created on December 17, 2002, 11:18 AM
 */

/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class MyUtils {
    
    /** Creates a new instance of MyUtils */
    public MyUtils() {
    }
    
    protected static boolean isDouble(String line)
    {
        boolean flag = true;
        try{
            Double.parseDouble(line);
        }catch(Exception e )
        {   
            flag = false;
        }
        return flag;
    }//isDouble()
    
    protected static boolean isInteger(String line)
    {
        boolean flag = true;
        try{
            String tline = line.trim();
            if(tline.startsWith("+"))
            {
                    tline = tline.substring(1);
                    line = tline;
            }
            Integer.parseInt(line);
        }catch(Exception e )
        {   
            flag = false;
        }
        return flag;
    }//isInteger()
    
    protected static boolean isUInteger(String line)
    {
        return isInteger(line, 0, Integer.MAX_VALUE );
    }
    protected static boolean isInteger(String line, int low, int high)
    {
        boolean flag = true;
        try{
            String tline = line.trim();
            if(tline.startsWith("+"))
            {
                tline = tline.substring(1);
                line = tline;
            }
            int value = Integer.parseInt(line);
            if (value<low || value>high)
                flag=false;
                //throw new Exception();            
        }catch(Exception e )
        {   
            flag = false;
        }
        return flag;
    }
    
    protected static boolean isLong(String line)
    {
        boolean flag = true;
        try{
            String tline = line.trim();
            if(tline.startsWith("+"))
            {
                    tline = tline.substring(1);
                    line = tline;
            }
            Long.parseLong(line);
        }catch(Exception e )
        {   
            flag = false;
        }
        return flag;
    }//isInteger()
    
    protected static boolean isULong(String line)
    {
        return isLong(line, (long)0, Long.MAX_VALUE );
    }
    protected static boolean isLong(String line, long low, long high)
    {
        boolean flag = true;
        try{
            String tline = line.trim();
            if(tline.startsWith("+"))
            {
                tline = tline.substring(1);
                line = tline;
            }
            long value = Long.parseLong(line);;
            if (value<low || value>high)
                throw new Exception();            
        }catch(Exception e )
        {   
            flag = false;
        }
        return flag;
    }
    
}
