#!/usr/bin/perl

# Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


#program : scan2ps
#version : 2.1
#Description:
#This program converts the output file 'data' of scan and converts
#it to a format required by promotsite.The data file is initially
#sorted first on the orientation of the binding site and then on
#the coordinate. This program sorts the data file on the coordinate 
#of the binding site only. This uses the sort -m (merge) option of
#linux to do this time efficiently.

$dirpos = 4;	#the direction position in the data file, the first position is 0
$bscoordpos = 3;	#the BS coordinate position, the first position is 0
$datafile = "data";	#input file name
$opfile = "psdatainp";	#output file name
$tmp1 = "datacomments.tmp";	#temporary data comments file
$tmp2 = "datapos.tmp";	#temporary data positive BS file
$tmp3 = "dataneg.tmp";	#temporary data negative BS file

if(@ARGV > 0)
{	$datafile = $ARGV[0];	}
open(DATA,"<$datafile") || die "cannot open file $datafile";
open(TMP1,">$tmp1") || die "cannot open temporary file $tmp1";
open(TMP2,">$tmp2") || die "cannot open temporary file $tmp2";
open(TMP3,">$tmp3") || die "cannot open temporary file $tmp3";
while(<DATA>)
{
	my $dataline = &trim($_);
	if( ($dataline =~ /^\s*\*/) || ($dataline =~ /^\s*$/) )
	{	print TMP1 "$dataline\n";	}	#comment line
	else
	{
		my @data = split( /\s+/, $dataline);
		if( $data[$dirpos] == 1 )
		{	print TMP2 "$dataline\n";	} 
		elsif( $data[$dirpos] == -1 )
		{	print TMP3 "$dataline\n";	} 
		else
		{	warn "Binding Site orientation not +/- in $datafile at $.\n";	}
	}
}
close TMP1;
close TMP2;
close TMP3;

#Print the comments into the output file
my $res = system("cp $tmp1 $opfile");
if($res)
{	warn "Error in writing comments to file $opfile: $!";	}
#sort the input files and produce the output file
$res = system("sort +${bscoordpos}n -m $tmp2 $tmp3 >> $opfile");
if($res)
{	warn "Error in sorting input file:$!";	}
else
{	print "scan2ps process completed successfully\n";	}
print "removing temporary file\n";
unlink $tmp1;
unlink $tmp2;
unlink $tmp3;
#END OF MAIN SUBROUTINE

#trim takes a string a removes the leading and trailing whitespaces
sub trim
{
	my $ret = shift;
	$ret =~ s/^\s*//;	#remove leading ws
	$ret =~ s/\s*$//;	#remove trailing ws
	$ret;
}#trim()
