/*
 * DelgenFront.java
 *
 * Created on March 5, 2003, 1:09 PM
 */

/**
 *
 * @author  sashidhar gadiraju
 */
/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

public class DelgenFront extends javax.swing.JFrame {

    /** Creates new form DelgenFront */
    public DelgenFront() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        titleJP = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        midJP = new javax.swing.JPanel();
        programJL = new javax.swing.JLabel();
        programJCB = new javax.swing.JComboBox();
        serverAddrJL = new javax.swing.JLabel();
        serverAddrJTF = new javax.swing.JTextField();
        serverPortJL = new javax.swing.JLabel();
        serverPortJTF = new javax.swing.JTextField();
        bottomJP = new javax.swing.JPanel();
        goJB = new javax.swing.JButton();

        setTitle("DelgenFront");
        setName("DelgenFront");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 3, 12));
        jLabel1.setText("Delila Genome Frontend");
        titleJP.add(jLabel1);

        getContentPane().add(titleJP, java.awt.BorderLayout.NORTH);

        midJP.setLayout(new java.awt.GridBagLayout());

        programJL.setText("Program to run");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        midJP.add(programJL, gridBagConstraints);

        programJCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Scan", "Promotsite", "Scan+Promotsite" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        midJP.add(programJCB, gridBagConstraints);

        serverAddrJL.setText("Server Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        midJP.add(serverAddrJL, gridBagConstraints);

        serverAddrJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        midJP.add(serverAddrJTF, gridBagConstraints);

        serverPortJL.setText("Server Port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        midJP.add(serverPortJL, gridBagConstraints);

        serverPortJTF.setColumns(10);
        serverPortJTF.setText("7070");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        midJP.add(serverPortJTF, gridBagConstraints);

        getContentPane().add(midJP, java.awt.BorderLayout.CENTER);

        goJB.setText("Go!");
        goJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goJBActionPerformed(evt);
            }
        });

        bottomJP.add(goJB);

        getContentPane().add(bottomJP, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void goJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_goJBActionPerformed
        // Add your handling code here:
        if( getProgram().equals("scan") )
            new ScanFront( getHash() );
        else if( getProgram().equals("promotsite") )
            new ScanFront( getHash() );
        else if( getProgram().equals("scan+promotsite") )
            new ScanFront( getHash() );
    }//GEN-LAST:event_goJBActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    
    public String getServerAddr()    {   return serverAddrJTF.getText(); }
    
    public String getPort() { return String.valueOf( serverPortJTF.getText() ); }
    
    public String getProgram()  {   return ((String)programJCB.getSelectedItem()).trim().toLowerCase(); }
    
    public java.util.HashMap getHash()
    {
        java.util.HashMap hm = new java.util.HashMap();
        hm.put("serveraddress", getServerAddr() );
        hm.put("port", getPort() );
        hm.put("program", getProgram() );
        
        return hm;
    }//getHash()
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        DelgenFront pp = new DelgenFront();
        pp.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        pp.show();        
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel programJL;
    private javax.swing.JButton goJB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField serverAddrJTF;
    private javax.swing.JPanel bottomJP;
    private javax.swing.JLabel serverAddrJL;
    private javax.swing.JPanel titleJP;
    private javax.swing.JPanel midJP;
    private javax.swing.JLabel serverPortJL;
    private javax.swing.JTextField serverPortJTF;
    private javax.swing.JComboBox programJCB;
    // End of variables declaration//GEN-END:variables
    
}
