/*
 * ScanpPanel.java
 *
 * Created on December 12, 2002, 11:48 PM
 */


/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class ScanpPanel extends javax.swing.JPanel {
    
    java.awt.Component parent;   //This is the component in which the messages of this panel are displayed
    java.io.BufferedReader infile;
    java.util.StringTokenizer stk;
    
    String version = "";
    String seqs="";
    String riRange = "";
    String zScore ="";
    String probRange ="";
    String wanted="";
    String from="",to="";
    String fromWanted="";
    String toWanted="";
    String ways="";
    String siteDefn="";
    String printDefn="";
    String fileOp="";
    String normalizeRi="";
    String inst="";
    String instFrom="";
    String instTo="";
    
    
    
    /** Creates new form ScanpPanel */
    public ScanpPanel(java.awt.Component parent) {
        this.parent = parent;        
        initComponents();
        waysJC.addItem(new String("0") );
        waysJC.addItem(new String("1") );
        waysJC.addItem(new String("2") );
        normalizeJC.addItem(new String("n") );
        normalizeJC.addItem(new String("s") );
        normalizeJC.addItem(new String("d") );
    }
    
    public String getScanpText()
    {
        String ret = "";

        String ver = versionJTF.getText().trim();
        ret += (ver.equals("") )? "" : (ver+"\n");

        ret += seqsJTF.getText().trim() + "\n";

        ret += riRangeJTF.getText().trim() + "\n";

        ret += zScoreJTF.getText().trim() + "\n";	

        ret += probRangeJTF.getText().trim() + "\n";

        ret += fromWantedJTF.getText().trim() + " " + toWantedJTF.getText().trim() + "\n";

        String  tways =(String) waysJC.getSelectedItem();
        ret += tways.trim() + "\n";

        String sited = siteDefnJTF.getText().trim();
        ret += (sited.equals("") )? "" : (sited+"\n");

        ret += printDefnJTA.getText().trim() + "\n";

        ret += fileOpJTF.getText().trim() + "\n";

        String  tnorm =(String) normalizeJC.getSelectedItem();
        ret += tnorm.trim() + "\n";

        ret += instFromJTF.getText().trim() + " " + instToJTF.getText().trim() + "\n";

        System.out.println("Scanp File\n" + ret);
        return ret;
    }//getScanpText()
    
    protected int validateVersion(String line)
    {
        int result = 0;
        String ver = "";
        if(line == null)
        {
            result = 0;
            version = "";
        }
        else
        {
            System.out.println("version::"+line);
            stk = new java.util.StringTokenizer(line);
            if(stk.hasMoreTokens() )
            {
                ver = stk.nextToken();
                if( MyUtils.isInteger(ver) )
                {
                    result = 0; //no version defined
                    version = "";
                }
                else if( MyUtils.isDouble(ver) )
                {
                    result = 1;
                    version  = ver;
                }
                else
                {
                    result = -1;
                    version = line;
                }
                
            }
            else    //no input tokens
            {
                result = 0;
                version  = line;
            }
        }
        return result;
    }//validateVersion()
    
    protected int validateSeqs(String line)
    {
		int result = 1;
        
        String vseq = "";
        if(line == null)
        {
            result = 0;
            seqs = "";
        }
        else
        {
			System.out.println("Seqs::"+line);			
            stk = new java.util.StringTokenizer(line);
            if(stk.hasMoreTokens() )
            {
                vseq = stk.nextToken();
                if( MyUtils.isInteger(vseq) )
                {
                    seqs = vseq;
                    result = 1;
                }
                else 
                {
                    seqs = line;
                    result = -1;
                }
            }
            else
            {
                seqs = "";
                result = -1;
            }
        }
        return result;
    }
    
    protected int validateRiRange(String line)
    {
		System.out.println("RiRange::"+line);		
        return validateRange(line, riRange, 1);
    }
    
    protected int validateZScore(String line)
    {
		System.out.println("ZScore::"+line);		
        return validateRange(line, zScore, 2);
    }
    
    protected int validateProbRange(String line)
    {
		System.out.println("ProbRange::"+line);		
        return validateRange(line, probRange, 3);
    }
        
    protected int validateRange(String line, String seqs, int option)
    {
        int result = 1;
        
        String vseq = "";
        if(line == null)
        {
            result = -1;
            seqs = "";
        }
        else
        {
            stk = new java.util.StringTokenizer(line);
            if(stk.hasMoreTokens() )
            {
                vseq = stk.nextToken();
                if( MyUtils.isDouble(vseq) )
                {
                    seqs = vseq;
                    result = 1;
                    if(stk.hasMoreTokens())
                    {
                        vseq = stk.nextToken();
                        if( MyUtils.isDouble(vseq) )                        
                            seqs+= " " + vseq.trim();
                    }
                            
                }
                else 
                {
                    seqs = line;
                    result = -1;
                }
                
            }
            else
            {
                seqs = "";
                result = -1;
            }
        }
		System.out.println("::"+seqs);
		switch(option)
		{
			case 1:{	riRange = seqs;	break;	}
			case 2:{	zScore = seqs;	break;	}		
			case 3:{	probRange = seqs;	break;	}
		}
        return result;
    }//validateRiRange()

    
    protected int validateFromToWanted(String line)
    {
		System.out.println("FromToWanted::"+line);		
		int res = validateFromTo(line);
		fromWanted = from;
		toWanted = to;
		return res;
    }
    
    protected int validateInstFromTo(String line)
    {
		System.out.println("InstFromTo::"+line);		
		int res = validateFromTo(line);
        instFrom = from;
		instTo = to;
		return res;		
    }
    
    protected int validateFromTo(String line)
    {
        int result = 1;
		String tseqs="", tseqs2="";
        
        String vseq = "";
        if(line == null)
        {
            result = -1;
            tseqs = "";
            tseqs2 = "";
        }
        else
        {
            stk = new java.util.StringTokenizer(line);
            if(stk.hasMoreTokens() )
            {
                vseq = stk.nextToken();
				System.out.println("vseq::"+vseq);
                if( MyUtils.isInteger(vseq) )
                {
                    tseqs = vseq;
                    result = 1;
                    if(stk.hasMoreTokens())
                    {
                        vseq = stk.nextToken();
						System.out.println("vseq::"+vseq);
                        if( MyUtils.isInteger(vseq) )                        
                            tseqs2 =  vseq.trim();
                        else
                        {
                            tseqs = line;
                            tseqs2 = "";
                            result = -1;
                        }
                    }
                    else
                    {
                        tseqs = line;
                        tseqs2 = "";
                        result = -1;
                    }                            
                }
                else 
                {
                    tseqs = line;
                    tseqs2 = "";
                    result = -1;
                }
                
            }
            else
            {
                tseqs = "";
                tseqs2 = "";
                result = -1;
            }
        }
		System.out.println("::from:"+tseqs+" to:"+tseqs2);
		from=tseqs;
		to=tseqs2;
        return result;
    }//validateFromTo()

    
    protected int validateWays(String line)
    {
        int result = 1;
        
        String vseq = "";
        if(line == null)
        {
            result = -1;
            ways = "";
        }
        else
        {
            System.out.println("Ways::"+line);			
            stk = new java.util.StringTokenizer(line);
            if(stk.hasMoreTokens() )
            {
                vseq = stk.nextToken();
                if( MyUtils.isInteger(vseq) )
                {
                    int iways = Integer.parseInt(vseq);
                    if ( iways!=0 && iways!=1 && iways!=2 )
                    {
                        result = -1;
                        ways =  line;
                    }
                    else
                    {
                            result = 1;
                            ways = vseq;
                    }
                }
                else
                {
                    result = -1;
                    ways =  line;
                }
            }
            else
            {
                result = -1;
                ways = "";
            }
        }
        return result;
    }//validateWays()
        
    protected int validateSiteDefn(String line)
    {
        int result = 1;        
        
        if(line == null)
        {
            result = -1;
            ways = "";
        }
        else
        {
			System.out.println("SiteDefn::"+line);			
            if( line.trim().startsWith("d") )
            {
                result = 1;
                siteDefn = line;
            }
            else
            {
                result = 0;
                siteDefn = "";
            }
        }
        return result;
    }//validateSiteDefn()
    
	protected int validatePrintDefnFull(String line) 
    {
        int result = 1;        
        
        if(line == null)
        {
            result = -1;
            printDefn = "";
        }
        else
        {
            System.out.println("PrintDefn::"+line);					
            printDefn="";
            if(!line.trim().endsWith("."))
            {
                    result = -1;
                    printDefn = "";
            }
            else
                    result = 1;
        }

        return result;
    }//validatePrintDefn()
    protected int validatePrintDefn(String line, java.io.BufferedReader inf) throws java.io.IOException
    {
        int result = 1;        
        
        if(line == null)
        {
            result = -1;
            printDefn = "";
        }
        else
        {
            System.out.println("PrintDefn::"+line);					
            printDefn="";
            while(! line.trim().startsWith(".") )
            {
                printDefn+=line+"\n";
                line = inf.readLine();
                if(line == null) 
                    break;
            }
            if( line == null)
            {
                result = -1;
            }
            else printDefn += ".";
        }

        return result;
    }//validatePrintDefn()
    
    protected int validateFileOp(String line )
    {
        int result = 1;                
        if(line == null)
        {
            result = -1;
            fileOp = "";
        }
        else
        {     
            System.out.println("FileOp::"+line);					
            String tline = line.trim();
            if(tline.length() <3)
            {
                result = -1;
                fileOp = line;
            }
            else
            {
                boolean flag = true;
                char c1,c2,c3;
                c1 = tline.toLowerCase().charAt(0);
                c2 = tline.toLowerCase().charAt(1);
                c3 = tline.toLowerCase().charAt(2);
                
                if( c1 != 'd' && c1 != 'f' && c1 != 'i' )
                    flag = false;
                if( c2 != 'd' && c2 != 'f' && c2 != 'i' )
                    flag = false;
                if( c3 != 'd' && c3 != 'f' && c3 != 'i' )
                    flag = false;
                
                if(!flag)
                {
                    result = -1;
                    fileOp = line;
                }
                else
                {
                    result = 1;
                    fileOp = tline.substring(0,3);
                }
            }
        }         
        
        return result;
    }//validateFileOp()
    
    
    protected int validateNormalizeRi(String line)
    {
        int result = 1;                
        if(line == null)
        {
            result = -1;
            normalizeRi = "";
        }
        else
        {     
            System.out.println("NormalizeRi::"+line);					
            String tline = line.trim();
            if(tline.length() <1)
            {
                result = -1;
                normalizeRi = line;
            }
            else
            {
                char c1 = tline.toLowerCase().charAt(0);
                
                if( c1 != 'n' && c1 != 's' && c1 != 'd' )
                {
                    result = -1;
                    normalizeRi = line;
                }
                else
                {
                    result = 1;
                    char[] tch = { tline.charAt(0) };
                    normalizeRi = new String( tch );
                }
            }
        }
        return result;
    }//validateNormalizeRi()
                
    
        
    protected String getErrorMesg(int err)
    {
        String mesg ="";

        switch(err)
        {
            case 0:{	mesg = ""; break;	}
            case 1:{	mesg = "Error in Paramter Version\n"; break;	}				   
            case 2:{	mesg = "Error in Seqs\n"; break;	}				   
            case 3:{	mesg = "Error in Ri Range\n"; break;	}    
            case 4:{	mesg = "Error in ZScore Range\n"; break;	}				   
            case 5:{	mesg = "Error in Probability Range\n"; break;	}				   
            case 6:{	mesg = "Error in From To Wanted\n"; break;	}				   
            case 7:{	mesg = "Error in Ways\n"; break;	}
            case 8:{	mesg = "Error in Site Definitions\n"; break;	}
            case 9:{	mesg = "Error in Print Definitions\n"; break;	} 
            case 10:{	mesg = "Error in File Output Definitions\n"; break;	}
            case 11:{	mesg = "Error in NormalizeRi\n"; break;	}				   
            case 12:{	mesg = "Error in Inst From To\n"; break;	}				   
            default:{	mesg = ""; break;	}
        }

        return mesg;
    }//getErrorMessage()

    public String parseScanp()
    {
        int gret = 1,ret = 1;
        String errString="";

        ret = validateVersion(versionJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(1);
                gret = -1;
        }

        ret = validateSeqs(seqsJTF.getText() );
        if(ret<0)
        {
                errString+= getErrorMesg(2);
                gret = -1;
        }

        ret = validateRiRange(riRangeJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(3);
                gret = -1;
        }

        ret = validateZScore(zScoreJTF.getText() );
        if(ret<0)
        {
                errString+= getErrorMesg(4);
                gret = -1;
        }

        ret = validateProbRange(probRangeJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(5);
                gret = -1;
        }

        ret = validateFromToWanted(fromWantedJTF.getText().trim() + " " + toWantedJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(6);
                gret = -1;
        }

        String  tways =(String) waysJC.getSelectedItem();		
        ret = validateWays(tways.trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(7);
                gret = -1;
        }

        ret = validateSiteDefn(siteDefnJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(8);
                gret = -1;
        }

        ret = validatePrintDefnFull(printDefnJTA.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(9);
                gret = -1;
        }

        ret = validateFileOp(fileOpJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(10);
                gret = -1;
        }

        String  tnor =(String) normalizeJC.getSelectedItem();		
        ret = validateNormalizeRi(tnor.trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(11);
                gret = -1;
        }

        ret = validateInstFromTo(instFromJTF.getText().trim() + " " + instToJTF.getText().trim() );
        if(ret<0)
        {
                errString+= getErrorMesg(12);
                gret = -1;
        }

        if(gret>0)
            return "";
        else
            return errString;
    }//parseScanp()
    
    public String parseScanp(String file) throws java.io.IOException
    {
        String retStr ="";
        if(file!= null)
        {
            char[] charr = file.toCharArray();
            retStr = parseScanp(new java.io.CharArrayReader(charr) );
            return retStr;
        }
        else return "No input file";
    }//parseScanp(String)
    
    public String parseScanp(java.io.InputStream inf) throws java.io.IOException
    {
        String retStr ="";
        if(inf!= null)
        {   
            retStr = parseScanp(new java.io.InputStreamReader(inf) );
            return retStr;
        }
        else return "No input file";
    }//parseScanp(InputStream)
        
            
    public String parseScanp(java.io.Reader inf) throws java.io.IOException
    {
        String retString ="";
        if( inf == null )
            return "No input file";
        
        this.infile = new java.io.BufferedReader(inf);
        
        String ipline = infile.readLine();
        int result = validateVersion(ipline);
        if(result == -1)    //incorrect parameter definition
        {
            retString = "Error in Parameter Version";
            versionJTF.setText(version);
            return retString;
        }
        else if(result == 0)    //no version given, so assume this is a Seqs argument
        {
            versionJTF.setText("");
        }
        else    //version number given
        {
            versionJTF.setText(version);
            ipline = infile.readLine();
        }
        
        //Seqs
        result = validateSeqs(ipline);
        if(result < 0)
        {
            retString = "Error in Seqs";
            seqsJTF.setText(seqs);
            return retString;
        }
        else
            seqsJTF.setText(seqs);
        
        //Ri Range
        ipline = infile.readLine();
        result = validateRiRange(ipline);
		System.out.println(":"+riRange);        
		if(result < 0)
        {
            retString = "Error in Ri Range";
            riRangeJTF.setText(riRange);
            return retString;
        }
        else
            riRangeJTF.setText(riRange);
        
        //Z Score Range
        ipline = infile.readLine();
        result = validateZScore(ipline);
		System.out.println(":"+zScore);        
        if(result < 0)
        {
            retString = "Error in Z Score";
            zScoreJTF.setText(zScore);
            return retString;
        }
        else
            zScoreJTF.setText(zScore);
        
        //Probability Range
        ipline = infile.readLine();
        result = validateProbRange(ipline);
		System.out.println(":"+probRange);        
        if(result < 0)
        {
            retString = "Error in Probability Range";
            probRangeJTF.setText(probRange);
            return retString;
        }
        else
            probRangeJTF.setText(probRange);
        
        //FromToWanted
        ipline = infile.readLine();
        result = validateFromToWanted(ipline);
        if(result < 0)
        {
            retString = "Error in From To Wanted";
            fromWantedJTF.setText( fromWanted );
            toWantedJTF.setText( toWanted );
            return retString;
        }
        else
        {
            fromWantedJTF.setText( fromWanted);
            toWantedJTF.setText( toWanted );
        }
        
        //Ways
        ipline = infile.readLine();
        result = validateWays(ipline);
        if(result < 0)
        {
            retString = "Error in Ways";
            //waysJC.setText(ways);
            return retString;
        }
        else
		{
			System.out.println("ways:"+ways);
			String tways = ways.trim();
			if(tways.equals("0") )
				waysJC.setSelectedIndex(0);
			else if(tways.equals("1") )
				waysJC.setSelectedIndex(1);
			else if(tways.equals("2") )
				waysJC.setSelectedIndex(2);
            //waysJTF.setText(ways);
		}
        
        //site Definitions
        ipline = infile.readLine();
        result = validateSiteDefn(ipline);
        if(result < 0)
        {
            retString = "Error in Site Definitions";
            siteDefnJTF.setText(siteDefn);
            return retString;
        }
        else if (result == 0)   //no site definition given        
            siteDefnJTF.setText(siteDefn);
        else    //site definition given
        {
            siteDefnJTF.setText(siteDefn);
            ipline = infile.readLine();
        }
        
        //Print Definitions
        // do not read the ipline here. it was done in the prev stage
        result = validatePrintDefn(ipline, infile);
        if(result < 0)
        {
            retString = "Error in Print Definitions";
            printDefnJTA.setText(printDefn);
            return retString;
        }
        else
            printDefnJTA.setText(printDefn);
        
        
        //File output definitions
        ipline = infile.readLine();
        result = validateFileOp(ipline);
        if(result < 0)
        {
            retString = "Error in File Output Definition";
            fileOpJTF.setText(fileOp);
            return retString;
        }
        else
            fileOpJTF.setText(fileOp);
            
        //Normalize Ri
        ipline = infile.readLine();
        result = validateNormalizeRi(ipline);
        if(result < 0)
        {
            retString = "Error in Normalize Ri";
            normalizeJC.setSelectedIndex(0);
            return retString;
        }
        else
        {		
            String tnri = normalizeRi.trim();
            if(tnri.equals("n") )
                    normalizeJC.setSelectedIndex(0);
            else if(tnri.equals("s") )
                    normalizeJC.setSelectedIndex(1);
            else if(tnri.equals("d") )
                    normalizeJC.setSelectedIndex(2);

        //normalizeJC.setText(normalizeRi);
        }
        
        //Inst From To
        ipline = infile.readLine();
        result = validateInstFromTo(ipline);
        if(result < 0)
        {
            retString = "Error in Inst From To";
            instFromJTF.setText( instFrom );
            instToJTF.setText( instTo );
            return retString;
        }
        else
        {
            instFromJTF.setText( instFrom );
            instToJTF.setText( instTo );
        }
        
        return "";
            
    }//parseScanp    
        
    public void resetItems()
    {
        versionJTF.setText("");
        seqsJTF.setText("");
        riRangeJTF.setText("");
        zScoreJTF.setText("");
        probRangeJTF.setText("");
        fromWantedJTF.setText("");
        toWantedJTF.setText("");
        waysJC.setSelectedIndex(0);
        siteDefnJTF.setText("");
        printDefnJTA.setText("");
        fileOpJTF.setText("");
        normalizeJC.setSelectedIndex(0);
        instFromJTF.setText("");
        instToJTF.setText("");
        
        version = "";
        seqs="";
        riRange = "";
        zScore ="";
        probRange ="";
        wanted="";
        from=""; to="";
        fromWanted="";
        toWanted="";
        ways="";
        siteDefn="";
        printDefn="";
        fileOp="";
        normalizeRi="";
        inst="";
        instFrom="";
        instTo="";
        
        infile = null;  
        stk = null;
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        titleJL = new javax.swing.JLabel();
        versionJL = new javax.swing.JLabel();
        versionJTF = new javax.swing.JTextField();
        versionHJB = new javax.swing.JButton();
        seqsJL = new javax.swing.JLabel();
        seqsJTF = new javax.swing.JTextField();
        seqsHJB = new javax.swing.JButton();
        riRangeJL = new javax.swing.JLabel();
        riRangeJTF = new javax.swing.JTextField();
        riRangeHJB = new javax.swing.JButton();
        zScoreJL = new javax.swing.JLabel();
        zScoreJTF = new javax.swing.JTextField();
        zScoreHJB = new javax.swing.JButton();
        probRangeJL = new javax.swing.JLabel();
        probRangeJTF = new javax.swing.JTextField();
        probRangeHJB = new javax.swing.JButton();
        fromWantedJL = new javax.swing.JLabel();
        fromWantedJTF = new javax.swing.JTextField();
        fromToHJB = new javax.swing.JButton();
        toWantedJL = new javax.swing.JLabel();
        toWantedJTF = new javax.swing.JTextField();
        waysJL = new javax.swing.JLabel();
        waysJC = new javax.swing.JComboBox();
        waysHJB = new javax.swing.JButton();
        siteDefnJL = new javax.swing.JLabel();
        siteDefnJTF = new javax.swing.JTextField();
        siteDefnHJB = new javax.swing.JButton();
        printDefnJL = new javax.swing.JLabel();
        printJSP = new javax.swing.JScrollPane();
        printDefnJTA = new javax.swing.JTextArea();
        printDefnHJB = new javax.swing.JButton();
        fileOpJL = new javax.swing.JLabel();
        fileOpJTF = new javax.swing.JTextField();
        fileOpHJB = new javax.swing.JButton();
        normalizeJL = new javax.swing.JLabel();
        normalizeJC = new javax.swing.JComboBox();
        normalizeHJB = new javax.swing.JButton();
        instFromJL = new javax.swing.JLabel();
        instFromJTF = new javax.swing.JTextField();
        instFromToHJB = new javax.swing.JButton();
        instToJL = new javax.swing.JLabel();
        instToJTF = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(475, 650));
        titleJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleJL.setText("Enter/Modify the scanp parameters");
        titleJL.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(titleJL, gridBagConstraints);

        versionJL.setText("Parameter Version");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(versionJL, gridBagConstraints);

        versionJTF.setColumns(5);
        versionJTF.setHorizontalAlignment(javax.swing.JTextField.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(versionJTF, gridBagConstraints);

        versionHJB.setText("Help");
        versionHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                versionHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(versionHJB, gridBagConstraints);

        seqsJL.setText("Seqs");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(seqsJL, gridBagConstraints);

        seqsJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(seqsJTF, gridBagConstraints);

        seqsHJB.setText("Help");
        seqsHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                seqsHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(seqsHJB, gridBagConstraints);

        riRangeJL.setText("Ri Range");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(riRangeJL, gridBagConstraints);

        riRangeJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(riRangeJTF, gridBagConstraints);

        riRangeHJB.setText("Help");
        riRangeHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                riRangeHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(riRangeHJB, gridBagConstraints);

        zScoreJL.setText("Z Score Range");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(zScoreJL, gridBagConstraints);

        zScoreJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(zScoreJTF, gridBagConstraints);

        zScoreHJB.setText("Help");
        zScoreHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zScoreHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(zScoreHJB, gridBagConstraints);

        probRangeJL.setText("Probability Range");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(probRangeJL, gridBagConstraints);

        probRangeJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(probRangeJTF, gridBagConstraints);

        probRangeHJB.setText("Help");
        probRangeHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                probRangeHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(probRangeHJB, gridBagConstraints);

        fromWantedJL.setText("FromWanted");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(fromWantedJL, gridBagConstraints);

        fromWantedJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(fromWantedJTF, gridBagConstraints);

        fromToHJB.setText("Help");
        fromToHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fromToHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 0);
        add(fromToHJB, gridBagConstraints);

        toWantedJL.setText("ToWanted");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(toWantedJL, gridBagConstraints);

        toWantedJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(toWantedJTF, gridBagConstraints);

        waysJL.setText("Ways");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(waysJL, gridBagConstraints);

        waysJC.setMaximumRowCount(3);
        waysJC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                waysJCActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(waysJC, gridBagConstraints);

        waysHJB.setText("Help");
        waysHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                waysHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(waysHJB, gridBagConstraints);

        siteDefnJL.setText("Site Definition");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(siteDefnJL, gridBagConstraints);

        siteDefnJTF.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(siteDefnJTF, gridBagConstraints);

        siteDefnHJB.setText("Help");
        siteDefnHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                siteDefnHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(siteDefnHJB, gridBagConstraints);

        printDefnJL.setText("Print Definitions");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(printDefnJL, gridBagConstraints);

        printDefnJTA.setColumns(20);
        printDefnJTA.setRows(5);
        printJSP.setViewportView(printDefnJTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(printJSP, gridBagConstraints);

        printDefnHJB.setText("Help");
        printDefnHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                printDefnHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(printDefnHJB, gridBagConstraints);

        fileOpJL.setText("File Output Defn");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(fileOpJL, gridBagConstraints);

        fileOpJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(fileOpJTF, gridBagConstraints);

        fileOpHJB.setText("Help");
        fileOpHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileOpHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(fileOpHJB, gridBagConstraints);

        normalizeJL.setText("Normalize Ri");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(normalizeJL, gridBagConstraints);

        normalizeJC.setMaximumRowCount(3);
        normalizeJC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                normalizeJCActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(normalizeJC, gridBagConstraints);

        normalizeHJB.setText("Help");
        normalizeHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                normalizeHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(normalizeHJB, gridBagConstraints);

        instFromJL.setText("Inst From");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(instFromJL, gridBagConstraints);

        instFromJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(instFromJTF, gridBagConstraints);

        instFromToHJB.setText("Help");
        instFromToHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                instFromToHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 0);
        add(instFromToHJB, gridBagConstraints);

        instToJL.setText("Inst To");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(instToJL, gridBagConstraints);

        instToJTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 4, 2);
        add(instToJTF, gridBagConstraints);

    }//GEN-END:initComponents

    private void normalizeJCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_normalizeJCActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_normalizeJCActionPerformed

    private void waysJCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_waysJCActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_waysJCActionPerformed

    private void instFromToHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_instFromToHJBActionPerformed
        // Add your handling code here:
        String mesg = "instfrom, instto: range of Delila instructions produced in scaninst\n";
        mesg += "if that file is created.\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_instFromToHJBActionPerformed

    private void normalizeHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_normalizeHJBActionPerformed
        // Add your handling code here:
        String mesg = "normalizeRi:  The first character defines how to normalize\n";
        mesg += "the reported Ri values.  The Ri value at coordinate zero\n";
        mesg += "is called Ri0.\n\n";

        mesg += "n: normal: scan and report Ri\n\n";

        mesg += "s: subtract: compute Ri(l) - Ri(0) at each position l\n\n";

        mesg += "d: divide: compute Ri(l) / Ri(0) at each position l\n\n";

        mesg += "The s and d modes are usually to be used in conjunction with\n";
        mesg += "renumbering by Delila (the 'default coordinate zero' command).\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE);         
    }//GEN-LAST:event_normalizeHJBActionPerformed

    private void fileOpHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileOpHJBActionPerformed
        // Add your handling code here:
        String mesg = "file output definitions:  The first three characters on the line define\n";
        mesg += "which files will be output.  Capital characters turn on the output.\n";
        mesg += "Small characters turn it off.  The files are data, (scan)features,\n";
        mesg += "and (scan)inst so the characters are d, f and i, respectively.  Thus\n";
        mesg += "DfI turns on the data and scaninst files and leaves the scanfeatures\n";
        mesg += "off.  (Unidentified characters default to upper case.)\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_fileOpHJBActionPerformed

    private void printDefnHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_printDefnHJBActionPerformed
        // Add your handling code here:
        String mesg = "print definitions:  Any number of lines that define how to print the\n";
        mesg += "\"other\" feature string in each feature definition.  The data that may\n";
        mesg += "be printed are the same as those in the data file.  They are:\n";
        mesg += "\n";
        mesg += "#              width\n";
        mesg += "length         width\n";
        mesg += "name           width\n";
        mesg += "coordinate     width\n";
        mesg += "orientation    width\n";
        mesg += "Ri             width decimal\n";
        mesg += "Z              width decimal\n";
        mesg += "probability    width decimal\n";
        mesg += "string         \"quote string\"\n";
        mesg += ".              end of print definitions\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_printDefnHJBActionPerformed

    private void siteDefnHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_siteDefnHJBActionPerformed
        // Add your handling code here:
        String mesg = "sitedefinition:  If the first non-blank character on the line is 'd',\n";
        mesg += "then the rest of the line contains a definition of how to write out\n";
        mesg += "the sites.  If no site is defined, the scanfeatures file will not be\n";
        mesg += "written to.  See program lister.p for details.  The basic format for\n";
        mesg += "an ASCII definition looks like this:\n";
        mesg += "\n";
        mesg += "define \"Fis\" \"-\" \"[0]\" \"[0]\" -7  0 +7\n";
        mesg += "\n";
        mesg += "For a walker it looks like:\n";
        mesg += "\n";
        mesg += "define \"Fis\" \" w\" \"  \" \"  \" -7 +7\n";
        mesg += "\n";
        mesg += "NOTE: the range for walker display (given in this site definition)\n";
        mesg += "is independent of the range of the weight matrix used for\n";
        mesg += "computation (given in the fromwanted and towanted parameters).";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_siteDefnHJBActionPerformed

    private void waysHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_waysHJBActionPerformed
        // Add your handling code here:
        String mesg = "ways:  One integer.  2 means scan both the sequence and its\n";
        mesg += "complement.  1 means simply scan the sequence.  0 means to let the\n";
        mesg += "program figure it out.  The Ri program determines the symmetry of\n";
        mesg += "the matrix.  If it is symmetrical, it will only scan one way.  If it\n";
        mesg += "is asymmetrical, both scans are done.";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_waysHJBActionPerformed

    private void fromToHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fromToHJBActionPerformed
        // Add your handling code here:
        String mesg = "fromwanted towanted range: two integers that define the FROM-TO range\n";
         mesg += "of the ribl matrix to use for computations.  This is independent of\n";
         mesg += "the range displayed in the walker.";
         javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_fromToHJBActionPerformed

    private void probRangeHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_probRangeHJBActionPerformed
        // Add your handling code here:
        String mesg = "Probability range: Two real numbers on the fourth line give the range\n";
         mesg += "of probability to report in the data file.  The probability of a\n";
         mesg += "site is determined from the mean and standard deviation of the Ri\n";
         mesg += "distribution.  Note: normally one would want the lower number to be\n";
         mesg += "zero.\n";
         javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_probRangeHJBActionPerformed

    private void zScoreHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zScoreHJBActionPerformed
        // Add your handling code here:
        String mesg = "Z score range: Two real numbers on the third line give the range of the\n";
        mesg += "Z score to report in the data file.  A negative sign will be\n";
        mesg += "converted to a positive sign so that this parameter limits the range\n";
        mesg += "of acceptable sites to an interval on the real line.\n";
        mesg += "Note: normally one would want the lower number to be zero.";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_zScoreHJBActionPerformed

    private void riRangeHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_riRangeHJBActionPerformed
        // Add your handling code here:
        String mesg = "Ri Range: Two real numbers on the second line give the range of\n";
        mesg += "information content to report in the data file.";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_riRangeHJBActionPerformed

    private void seqsHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_seqsHJBActionPerformed
        // Add your handling code here:
        String mesg ="Seqs: One integer on the first line is the number of sequences to scan\n";
        mesg += "to produce the vector.  0 = none, positive = that number; negative = all.";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_seqsHJBActionPerformed

    private void versionHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_versionHJBActionPerformed
        // Add your handling code here:
        
        String mesg = "Parameter Version: the version number of the program.\n";
        mesg += "This allows the user to be warned if an old parameter file is used.";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Scanp Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_versionHJBActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton siteDefnHJB;
    private javax.swing.JTextField riRangeJTF;
    private javax.swing.JLabel waysJL;
    private javax.swing.JTextField toWantedJTF;
    private javax.swing.JLabel versionJL;
    private javax.swing.JButton fileOpHJB;
    private javax.swing.JLabel printDefnJL;
    private javax.swing.JTextField fromWantedJTF;
    private javax.swing.JLabel zScoreJL;
    private javax.swing.JTextField probRangeJTF;
    private javax.swing.JTextField siteDefnJTF;
    private javax.swing.JTextField seqsJTF;
    private javax.swing.JButton fromToHJB;
    private javax.swing.JButton normalizeHJB;
    private javax.swing.JTextArea printDefnJTA;
    private javax.swing.JTextField instFromJTF;
    private javax.swing.JLabel siteDefnJL;
    private javax.swing.JButton seqsHJB;
    private javax.swing.JScrollPane printJSP;
    private javax.swing.JTextField instToJTF;
    private javax.swing.JButton printDefnHJB;
    private javax.swing.JLabel instToJL;
    private javax.swing.JLabel titleJL;
    private javax.swing.JLabel fileOpJL;
    private javax.swing.JComboBox waysJC;
    private javax.swing.JButton riRangeHJB;
    private javax.swing.JLabel fromWantedJL;
    private javax.swing.JButton versionHJB;
    private javax.swing.JComboBox normalizeJC;
    private javax.swing.JLabel instFromJL;
    private javax.swing.JLabel seqsJL;
    private javax.swing.JButton probRangeHJB;
    private javax.swing.JButton waysHJB;
    private javax.swing.JLabel normalizeJL;
    private javax.swing.JTextField versionJTF;
    private javax.swing.JButton zScoreHJB;
    private javax.swing.JButton instFromToHJB;
    private javax.swing.JLabel toWantedJL;
    private javax.swing.JTextField zScoreJTF;
    private javax.swing.JTextField fileOpJTF;
    private javax.swing.JLabel probRangeJL;
    private javax.swing.JLabel riRangeJL;
    // End of variables declaration//GEN-END:variables
    
}
