#
# Tables pour les objets partages (cross-objects)

#___________________________________________________________________________________
#						     References associees aux objets

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS co_Submission;

CREATE TABLE co_Submission		# Informations sur l'auteur des donnees
 (
  Submitter_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

  Submitter_date	tinytext,
  Submitter_name	tinytext,
  Submitter_email	tinytext,
  Submitter_institute	text,
  Submitter_department	text,
  Submitter_address	text,
  Submitter_city	tinytext,
  Submitter_phone	tinytext,
  Submitter_web_link	text,

  PRIMARY KEY (Submitter_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "Submitter");
INSERT INTO md_ObjectMetaData VALUES
  (
   "Submitter",
   "co_Submission",
   "*",
   "Submitter_ID",
   "",
   "Submitter_",
   "",
   "Hyperlink:email|Hyperlink:web_link"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "Submitter.%");
INSERT INTO md_FieldMetaData VALUES ("Submitter.CARD", "date,|,name,email,|,institute,department,address,city,phone,|,web_link", 0);

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS co_Reference;

CREATE TABLE co_Reference			# Informations sur les donnees
 (
  Reference_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

  Reference_status	text,
  Reference_keyword	text,
  Reference_author	text,

  Reference_pubmed_id	tinytext,	# pour les articles
  Reference_book	tinytext,	# pour les livres, revues, etc.

  Reference_web_link	text,
  Reference_note 	text,

  PRIMARY KEY (Reference_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "Reference");
INSERT INTO md_ObjectMetaData VALUES
  (
   "Reference",
   "co_Reference",
   "*",
   "Reference_ID",
   "",
   "Reference_",
   "",
   "Hyperlink:pubmed_id|Hyperlink:web_link"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "Reference.%");
INSERT INTO md_FieldMetaData VALUES ("Reference.CARD", "status,|,author,pubmed_id,web_link,|,keyword", 0);
INSERT INTO md_FieldMetaData VALUES ("Reference.keyword", "STRING/SPLIT[,|]", 1);

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS co_Evidence;

CREATE TABLE co_Evidence
 (
  Evidence_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

  Evidence_code		text NOT NULL,		# ID(s) du type de preuve, separes par "|"

  Evidence_submitter_id	int unsigned,		# Submitter
  Evidence_reference_id	tinytext,		# Reference(s)

  Evidence_note		text,			# Notes eventuelles

  PRIMARY KEY (Evidence_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "Evidence");
INSERT INTO md_ObjectMetaData VALUES
  (
   "Evidence",
   "co_Evidence",
   "*",
   "Evidence_ID",
   "",
   "Evidence_",
   "",
   "Submitter:submitter_id|Reference:reference_id"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "Evidence.%");
INSERT INTO md_FieldMetaData VALUES ("Evidence.code", "STRING", 1);
INSERT INTO md_FieldMetaData VALUES ("Evidence.reference_id", "NUMBER", 1);

#___________________________________________________________________________________
#						     Liens vers des sources externes

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS co_Hyperlink;

CREATE TABLE co_Hyperlink				# Liens vers des sources externes
 (
  Hyperlink_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

  Hyperlink_links	text NOT NULL,		# Lien(s), separes par "|" (ex: "GO:12345")
  Hyperlink_note	text,

  Hyperlink_submitter_id int unsigned,		# Submitter
  Hyperlink_reference_id tinytext,		# Reference(s)

  PRIMARY KEY (Hyperlink_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "Hyperlink");
INSERT INTO md_ObjectMetaData VALUES
  (
   "Hyperlink",
   "co_Hyperlink",
   "*",
   "Hyperlink_ID",
   "",
   "Hyperlink_",
   "",
   "Submitter:submitter_id|Reference:reference_id"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "Hyperlink.%");
INSERT INTO md_FieldMetaData VALUES ("Hyperlink.link", "STRING/SPLIT[|]", 1);
INSERT INTO md_FieldMetaData VALUES ("Hyperlink.reference_id", "NUMBER", 1);

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS co_ExternalResource;

CREATE TABLE co_ExternalResource		# Parametres d'acces a des donnees externes
 (
  Resource_ID		varchar(50) NOT NULL,	# Identifiant du lien (ex: "GO")

  Resource_title	tinytext NOT NULL,	# Nom de la ressource
  Resource_field	tinytext NOT NULL,	# Intitule du champ (pour affichage)

  Resource_description	text,

  Resource_query_prefix	tinytext,		# Prefixe pour la requete d'acces (URL)
  Resource_query_suffix tinytext,		# Suffixe pour la requete d'acces (URL)

  PRIMARY KEY (Resource_ID)
 );

INSERT INTO co_ExternalResource VALUES ("HTTP", "Web page", "Web link", "", "http://", "");
INSERT INTO co_ExternalResource VALUES ("FTP", "File server", "Ftp", "", "ftp://", "");
INSERT INTO co_ExternalResource VALUES ("MAIL", "Mail", "e-mail", "", "mailto:", "");
INSERT INTO co_ExternalResource VALUES
 (
  "PUBMED",
  "Entrez PubMed",
  "PubMed",
  "PubMed is designed to provide access to citations from biomedical literature", 
  "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=PubMed&term=",
  "&dopt=Abstract"
 );

