# --------------------------------------------------------------
#  Platform GeNetDB (http://www.genetdb.net/)
# --------------------------------------------------------------

# Installation: sous MySQL, taper "source [chemin]tables.sql.txt"

# L'option ") TYPE = ISAM;" doit etre indiquee avec CREATE lorsque les tables doivent etre utilisees
# avec une version de MySQL inferieure a la 3.23; sinon retirer cette option (le type par defaut
# est alors MyISAM). Pour convertir une table: ALTER TABLE table TYPE = {ISAM | MYISAM};

# Autres fichiers a inclure:
#   bio.sql.txt			- objets biologiques
#   expression.sql.txt		- donnees d'expression
#   network.sql.txt		- reseaux genetiques
#   crossobj.sql.txt		- objets partages

#DROP DATABASE IF EXISTS genetdb;
#CREATE DATABASE genetdb;
#USE genetdb;

#___________________________________________________________________________________
#							    Informations sur la base

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS md_dbMetaData;

CREATE TABLE md_dbMetaData			# Informations sur la base
 (
  db_version		varchar(20) NOT NULL,	# Version de la base
  db_client_version	int NOT NULL,		# Version du client necessaire
  db_last_creation	datetime NOT NULL,	# Date de creation de la base

  PRIMARY KEY (db_version)
 );

INSERT INTO md_dbMetaData VALUES ("0.1 alpha", 1, NOW());

#___________________________________________________________________________________
#			       Meta-informations sur les objets stockes dans la base

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS md_ObjectMetaData;

CREATE TABLE md_ObjectMetaData
 (
  Object_name		varchar(20) NOT NULL,	# Nom de l'objet ("Experiment", "Group", etc.)
  Object_table		varchar(50) NOT NULL,	# Table correspondante

  # Informations pour construire les requetes SQL
  Object_sql_columns	varchar(100) NOT NULL,	# Champs a recuperer lors d'un listing
  Object_sql_ID		varchar(50) NOT NULL,	# Champ correspondant a l'identifiant de l'objet
  Object_sql_sort	varchar(50),		# Champ permettant le tri
  Object_sql_prefix	varchar(50) NOT NULL,	# Prefixe pour la recuperation des champs

  # Acces aux parents
  Object_parents	text,			# Champs des parents qui referencent cet objet
						# (non obligatoire: peut etre reconstitue si
						# un parent indique cet objet comme fils)
  # Acces aux descendants
  Object_childs		text,			# Champ de cet objet qui referencent des fils

  PRIMARY KEY (Object_name, Object_table)
 );

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS md_FieldMetaData;

CREATE TABLE md_FieldMetaData
 (
	# Nom du champ ([nom de l'objet].[nom du champ]), ou "CARD" si
	# stockage de la structure de la carte de l'objet
  Field_name		varchar(100) NOT NULL,

	# Description du format du champ
	# STRING|NUMBER|BOOLEAN{/SPLIT[separateurs]}
  Field_content		text NOT NULL,
  Field_is_list		tinyint DEFAULT '0' NOT NULL,

  PRIMARY KEY (Field_name)
 );

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS md_ElementDescription;

CREATE TABLE md_ElementDescription	# Description des objets et des champs
 (
  Element_name		varchar(100) NOT NULL,	# Nom de l'objet ou du champ
  Element_type		enum("OBJECT", "FIELD") NOT NULL DEFAULT "FIELD",

  Element_title		tinytext,
	# Titre associe a l'element (affiche dans les formulaires)

  Element_description	text NOT NULL,

	# Reserves aux champs de type liste
  Element_field_values	text,		# Intitule des items (separes par "|")
  Element_field_infos	text,		# Description des items (separes par "|")

  PRIMARY KEY (Element_name)
 );

#___________________________________________________________________________________
#						      Tables de stockage extensibles

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS d_DataHeader;

CREATE TABLE d_DataHeader		# Description des donnees (pour chaque colonne: nom et description)
 (
  DataHeader_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

# Les colonnes suivantes sont crees lors de l'importation (import.pl): 1 <= X <= n 
# headerX_name		tinytext,		# Nom de la variable
# headerX_description	text,			# Description de la variable

# Note: normalement le champ headerXX_name devrait etre NOT NULL, mais comme
# tous les champs de ce type ne seront pas utilises (en fonction de l'objet appelant),
# il n'est pas possible de le declarer comme tel

  PRIMARY KEY (DataHeader_ID)
 );

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS d_DataIndex;

CREATE TABLE d_DataIndex		# Index des blocs de donnees presents dans gData
 (
  Block_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

  First_entry		int unsigned NOT NULL,
  Last_entry		int unsigned NOT NULL,

  PRIMARY KEY (Block_ID)
 );

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DROP TABLE IF EXISTS d_Data;

CREATE TABLE d_Data			# Donnees, a raison d'un identifiant par entree
 (
  Entry_ID		int unsigned DEFAULT '0' NOT NULL AUTO_INCREMENT,

# Les colonnes suivantes sont crees lors de l'importation (import.pl): 1 <= X <= n 
# valueX		tinytext,	# Valeur de la colonne

  PRIMARY KEY (Entry_ID)
 );

