#
# Tables pour la partie reseaux genetiques

#___________________________________________________________________________________
#									 Annotations

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# Reseaux biologiques (GRN)

DROP TABLE IF EXISTS net_Network;

CREATE TABLE net_Network		# Reseau de regulation
 (
  Network_ID		varchar(50) NOT NULL,		# Identifiant du reseau

  Network_title		tinytext NOT NULL,		# Intitule
  Network_organisms	text NOT NULL,			# Organisme(s)

  Network_description	text NOT NULL,			# Description
  Network_evidences_note text,				# Notes supplementaires sur l'experimentation

  Network_submitter_id	int unsigned,			# Submitter
  Network_reference_id	tinytext,			# Reference(s)

  PRIMARY KEY (Network_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "Network");
INSERT INTO md_ObjectMetaData VALUES
  (
   "Network",
   "net_Network",
   "*",
   "Network_ID",
   "Network_title",
   "Network_",
   "",
   "Organism:organisms|Submitter:submitter_id|Reference:reference_id"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "Network.%");
INSERT INTO md_FieldMetaData VALUES ("Network.CARD", "ID,title,|,organism,|,description,evidences_note", 0);
INSERT INTO md_FieldMetaData VALUES ("Network.reference_id", "NUMBER", 1);
INSERT INTO md_FieldMetaData VALUES ("Network.organisms", "STRING", 1);

#___________________________________________________________________________________
#									     Donnees

# ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DROP TABLE IF EXISTS net_RegulatoryLink;

CREATE TABLE net_RegulatoryLink		# Liens unissant une entite source et un gene cible
 (
  Link_ID		varchar(80) NOT NULL,
  Link_network_id	varchar(50) NOT NULL,

  Link_source		varchar(60) NOT NULL,
	# ID de l'entite a l'origine du lien (bio_Entity): gene,
	# proteine, ou proteines assemblees en un complexe.
	# Plusieurs entites peuvent etre combinees par des operateurs
	# booleens

  Link_target		varchar(60) NOT NULL,
	# ID de l'entite qui recoit le lien: gene ou proteine

	# note: source et target peuvent employer ici des notations pseudo-xml
	# pour notifier un ensemble (complexe, liste) d'entites. La liste des
	# entites ainsi concernees sera indiquee dans les champs virtuels
	# source_entities et target_entities (cree par le logiciel client)

  #::::::::::::::::::::::::::::::::::::::::::::::::::::: Description du type de lien

  Link_effect		enum(
			     "ACTIVATION",
			     "INHIBITION",
			     "UNKNOWN"
			    ) NOT NULL DEFAULT "UNKNOWN",
	# Resultat de la mise en place du lien sur l'activite du gene cible

  Link_influence	enum(
			     "TRANSCRIPTIONAL",
			     "ACCESSIBILITY",
			     "POST_TRANSCRIPTIONAL",
			     "POST_TRANSLATIONAL",
			     "OTHER", "UNKNOWN"
			    ) NOT NULL DEFAULT "UNKNOWN",
	# Processus de la cible concerne par la modulation:
	# - modification du taux de transcription (la source est donc un f. de transcription)
	# - accessibilite du gene (methylation, remaniement de la chromatine, etc.)
	# - modifications post-transcriptionnelles (epissage alternatif, etc.)
	# - modifications post-traductionnelles (etat de phosphorylation, etc.)

  Link_distance		enum(
                             "DIRECT",
                             "INDIRECT",
                             "UNKNOWN"
                            ) NOT NULL DEFAULT "UNKNOWN",
	# Distance (existence d'intermediaires) entre l'entite source et le gene cible:
	# - action directe du premier sur le second
	# - action indirecte, par l'intermediaire d'entites non identifiees

  Link_combination	enum(
                             "SIMPLE",
                             "BOOLEAN",
                             "COMPLEX"
                            ) NOT NULL DEFAULT "SIMPLE",

	# Combinaison des element:
	# - aucune (un seul element)
	# - booleen et/ou sequentiel (porte logique, succession dans le temps)

  #:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  Link_evidences	text,
	# Liste des ID des preuves experimentales de ce lien

  Link_note		text,		# Notes eventuelles

  PRIMARY KEY (Link_ID)
 );

DELETE FROM md_ObjectMetaData WHERE (Object_name = "RegulatoryLink");
INSERT INTO md_ObjectMetaData VALUES
  (
   "RegulatoryLink",
   "net_RegulatoryLink",
   "*,Link_effect+0",
   "Link_ID",
   "Link_ID",
   "Link_",
   "Network:network_id",
   "BioEntity:source_entities|BioEntity:target_entities|Evidence:evidences"
  );

DELETE FROM md_FieldMetaData WHERE (Field_name LIKE "RegulatoryLink.%");
INSERT INTO md_FieldMetaData VALUES ("RegulatoryLink.CARD", "ID,network_id,|,source,source_entities,target,target_entities,|,effect,distance,influence,combination,|,note", 0);
INSERT INTO md_FieldMetaData VALUES ("RegulatoryLink.evidences", "NUMBER", 1);

