//WinBLAST is a graphical front-end for NCBI BLAST.
//Copyright (C) 2003 Alan Li, alanli@bioinformatics.org
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace WinBLAST
{
	/// <summary>
	/// Summary description for AddDBForm.
	/// </summary>
	internal class AddDBForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Button fileDialogButton1;
		private System.Windows.Forms.Button okButton;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.OpenFileDialog dbPathDialog;
		private System.Windows.Forms.TextBox dbName;
		private System.Windows.Forms.TextBox dbPath;

		private String m_dbName;
		private String m_dbPath;
		private System.Windows.Forms.Label uniqueLabel;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private Databases m_databasesForm = null;

		internal AddDBForm( Databases databasesForm )
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			m_databasesForm = databasesForm;
			m_dbName = "";
			m_dbName = "";

			CheckAndSetOkButtonStatus();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AddDBForm));
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.dbName = new System.Windows.Forms.TextBox();
			this.dbPath = new System.Windows.Forms.TextBox();
			this.fileDialogButton1 = new System.Windows.Forms.Button();
			this.okButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.dbPathDialog = new System.Windows.Forms.OpenFileDialog();
			this.uniqueLabel = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 32);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Name:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Path:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// dbName
			// 
			this.dbName.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.dbName.Location = new System.Drawing.Point(64, 32);
			this.dbName.Name = "dbName";
			this.dbName.Size = new System.Drawing.Size(240, 20);
			this.dbName.TabIndex = 6;
			this.dbName.Text = "";
			this.dbName.TextChanged += new System.EventHandler(this.dbName_TextChanged);
			// 
			// dbPath
			// 
			this.dbPath.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.dbPath.Location = new System.Drawing.Point(64, 64);
			this.dbPath.Name = "dbPath";
			this.dbPath.Size = new System.Drawing.Size(208, 20);
			this.dbPath.TabIndex = 7;
			this.dbPath.Text = "";
			this.dbPath.TextChanged += new System.EventHandler(this.dbPath_TextChanged);
			// 
			// fileDialogButton1
			// 
			this.fileDialogButton1.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.fileDialogButton1.Location = new System.Drawing.Point(272, 64);
			this.fileDialogButton1.Name = "fileDialogButton1";
			this.fileDialogButton1.Size = new System.Drawing.Size(32, 23);
			this.fileDialogButton1.TabIndex = 10;
			this.fileDialogButton1.Text = "...";
			this.fileDialogButton1.Click += new System.EventHandler(this.fileDialogButton1_Click);
			// 
			// okButton
			// 
			this.okButton.Location = new System.Drawing.Point(336, 32);
			this.okButton.Name = "okButton";
			this.okButton.Size = new System.Drawing.Size(56, 24);
			this.okButton.TabIndex = 11;
			this.okButton.Text = "Ok";
			this.okButton.Click += new System.EventHandler(this.okButton_Click);
			// 
			// cancelButton
			// 
			this.cancelButton.Location = new System.Drawing.Point(336, 64);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.Size = new System.Drawing.Size(56, 24);
			this.cancelButton.TabIndex = 12;
			this.cancelButton.Text = "Cancel";
			this.cancelButton.Click += new System.EventHandler(this.cancelButton_Click);
			// 
			// uniqueLabel
			// 
			this.uniqueLabel.ForeColor = System.Drawing.Color.Red;
			this.uniqueLabel.Location = new System.Drawing.Point(16, 8);
			this.uniqueLabel.Name = "uniqueLabel";
			this.uniqueLabel.Size = new System.Drawing.Size(288, 16);
			this.uniqueLabel.TabIndex = 13;
			// 
			// AddDBForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(408, 101);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.uniqueLabel,
																		  this.cancelButton,
																		  this.okButton,
																		  this.fileDialogButton1,
																		  this.dbPath,
																		  this.dbName,
																		  this.label2,
																		  this.label1});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(416, 128);
			this.MinimumSize = new System.Drawing.Size(416, 128);
			this.Name = "AddDBForm";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "BLAST Database";
			this.Load += new System.EventHandler(this.AddDBForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void fileDialogButton1_Click(object sender, System.EventArgs e)
		{
			DialogResult result = dbPathDialog.ShowDialog();
			if( result != DialogResult.Cancel )
				dbPath.Text = dbPathDialog.FileName;	
		}

		private void dbName_TextChanged( object sender, System.EventArgs e )
		{
			CheckAndSetOkButtonStatus();

			if( checkDBHasName( dbName.Text ) )
				uniqueLabel.Text = "Please enter a unique name.";
			else
				uniqueLabel.Text = "";
		}

		private void dbPath_TextChanged(object sender, System.EventArgs e)
		{
			CheckAndSetOkButtonStatus();
		}

		internal Databases getDatabaseForm()
		{
			return m_databasesForm;
		}

		protected virtual bool checkDBHasName( string name )
		{
			return m_databasesForm.hasName( name, false /* isEdit */ );
		}

		private void CheckAndSetOkButtonStatus()
		{
			if( dbPath.Text.Equals( "" ) || 
				checkDBHasName( dbName.Text ) ||
				dbName.Text.Equals( "" ) )
				okButton.Enabled = false;
			else
				okButton.Enabled = true;
		}

		private void okButton_Click(object sender, System.EventArgs e)
		{
			this.Hide();
			setName( dbName.Text );
			setPath( dbPath.Text );
			ResetNameAndPathLabels();
			this.DialogResult = DialogResult.OK;
		}

		private void cancelButton_Click(object sender, System.EventArgs e)
		{
			this.Hide();
			ResetNameAndPathLabels();
			ResetNameAndPath();
		}

		private void AddDBForm_Closed(object sender, System.EventArgs e)
		{
			ResetNameAndPathLabels();
			ResetNameAndPath();
		}

		private void ResetNameAndPathLabels()
		{
			dbPath.Text = "";
			dbName.Text = "";
		}

		internal void ResetNameAndPath()
		{
			m_dbPath = "";
			m_dbName = "";
		}

		internal string getName()
		{
			return m_dbName;
		}

		internal string getPath()
		{
			return m_dbPath;
		}

		internal void setName( string name )
		{
			m_dbName = name;
		}

		internal void setPath( string path )
		{
			m_dbPath = path;
		}

		private void AddDBForm_Load(object sender, System.EventArgs e)
		{
			dbName.Text = m_dbName;
			dbPath.Text = m_dbPath;
		}
	}

	internal class EditDBForm : AddDBForm
	{
		internal EditDBForm( Databases databasesForm )
		:	base( databasesForm )
		{
		}

		protected override bool checkDBHasName( string name )
		{
			return getDatabaseForm().hasName( name, true /* isEdit */ );
		}
	}
}
