//WinBLAST is a graphical front-end for NCBI BLAST.
//Copyright (C) 2003 Alan Li, alanli@bioinformatics.org
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace WinBLAST
{
	/// <summary>
	/// Summary description for Databases.
	/// </summary>
	internal class Databases : System.Windows.Forms.Form
	{
		private BlastGrid dataGrid1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button openButton;
		private System.Windows.Forms.Button addButton;
		private System.Windows.Forms.Button editButton;
		private System.Windows.Forms.Button removeButton;

		private DataSet m_databases;
		private AddDBForm m_addForm;
		private EditDBForm m_editForm;
		private string m_blastDBName;
		private bool m_isGridDoubleClick;

		internal Databases( DataSet dataSet )
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			initializeGrid( dataSet );
			setInitButtonState();
			m_blastDBName = "";
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Databases));
			this.dataGrid1 = new BlastGrid();
			this.openButton = new System.Windows.Forms.Button();
			this.removeButton = new System.Windows.Forms.Button();
			this.addButton = new System.Windows.Forms.Button();
			this.editButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			this.SuspendLayout();
			// 
			// dataGrid1
			// 
			this.dataGrid1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dataGrid1.BackgroundColor = System.Drawing.SystemColors.Window;
			this.dataGrid1.CaptionVisible = false;
			this.dataGrid1.DataMember = "";
			this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.ReadOnly = true;
			this.dataGrid1.RowHeadersVisible = false;
			this.dataGrid1.RowHeaderWidth = 0;
			this.dataGrid1.Size = new System.Drawing.Size(390, 160);
			this.dataGrid1.TabIndex = 0;
			this.dataGrid1.DoubleClick += new System.EventHandler(this.dataGrid1_DoubleClick);
			this.dataGrid1.Click += new System.EventHandler(this.dataGrid1_Click);
			this.dataGrid1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.dataGrid1_MouseUp);
			// 
			// openButton
			// 
			this.openButton.Location = new System.Drawing.Point(400, 8);
			this.openButton.Name = "openButton";
			this.openButton.Size = new System.Drawing.Size(56, 24);
			this.openButton.TabIndex = 6;
			this.openButton.Text = "Open";
			this.openButton.Click += new System.EventHandler(this.openButton_Click);
			// 
			// removeButton
			// 
			this.removeButton.Location = new System.Drawing.Point(400, 104);
			this.removeButton.Name = "removeButton";
			this.removeButton.Size = new System.Drawing.Size(56, 24);
			this.removeButton.TabIndex = 4;
			this.removeButton.Text = "Remove";
			this.removeButton.Click += new System.EventHandler(this.removeButton_Click);
			// 
			// addButton
			// 
			this.addButton.Location = new System.Drawing.Point(400, 40);
			this.addButton.Name = "addButton";
			this.addButton.Size = new System.Drawing.Size(56, 24);
			this.addButton.TabIndex = 5;
			this.addButton.Text = "Add";
			this.addButton.Click += new System.EventHandler(this.addButton_Click);
			// 
			// editButton
			// 
			this.editButton.Location = new System.Drawing.Point(400, 72);
			this.editButton.Name = "editButton";
			this.editButton.Size = new System.Drawing.Size(56, 24);
			this.editButton.TabIndex = 3;
			this.editButton.Text = "Edit";
			this.editButton.Click += new System.EventHandler(this.editButton_Click);
			// 
			// Databases
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(467, 163);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.editButton,
																		  this.addButton,
																		  this.removeButton,
																		  this.openButton,
																		  this.dataGrid1});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(475, 190);
			this.MinimumSize = new System.Drawing.Size(475, 190);
			this.Name = "Databases";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "BLAST Databases";
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void dataGrid1_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if( e.Button != MouseButtons.Left )
				return;

			Point currentSelection = new Point( e.X, e.Y );
			DataGrid.HitTestInfo info = dataGrid1.HitTest( currentSelection );
			if( info.Type != DataGrid.HitTestType.Cell )
				return;

			dataGrid1.CurrentCell = new DataGridCell( info.Row, info.Column );
			selectRowAndChangeButtonState( info.Row );

			if( m_isGridDoubleClick )
			{
				m_isGridDoubleClick = false;
				selectRow();
			}
		}

		private void initializeGrid( DataSet dataSet )
		{
			if( dataSet != null )
				m_databases = dataSet;
			else
			{
				// we'll need to initialize it ourselves
				m_databases = new DataSet( "Blast Databases" );

				DataTable dataTable = new DataTable( "Databases" );
				m_databases.Tables.Add( dataTable );

				DataColumn dbLabel = 
					new DataColumn( "Name", typeof(String) );
				DataColumn dbLocation = 
					new DataColumn( "Path", typeof(String) );

				dataTable.Columns.Add( dbLabel );
				dataTable.Columns.Add( dbLocation );

				DataColumn[] primaryKeys = new DataColumn[1];
				primaryKeys[0] = dbLabel;
				dataTable.PrimaryKey = primaryKeys;
			}

			dataGrid1.SetDataBinding( m_databases, "Databases" );

			DataGridTableStyle tableStyle = new DataGridTableStyle();
			tableStyle.MappingName = "Databases";
			tableStyle.RowHeadersVisible = false;
			tableStyle.GridLineStyle = System.Windows.Forms.DataGridLineStyle.None;
			tableStyle.PreferredRowHeight = 15;

			DataGridColumnStyle textCol1 = new BlastGridTextBoxColumn();
			textCol1.MappingName = "Name";
			textCol1.HeaderText = "Name";
			textCol1.Width = 125;
			textCol1.ReadOnly = true;
			tableStyle.GridColumnStyles.Add( textCol1 );

			DataGridColumnStyle textCol2 = new BlastGridTextBoxColumn();
			textCol2.MappingName = "Path";
			textCol2.HeaderText = "Path";
			textCol2.Width = 245;
			textCol2.ReadOnly = true;
			tableStyle.GridColumnStyles.Add( textCol2 );

			dataGrid1.TableStyles.Add( tableStyle );
			dataGrid1.ReadOnly = true;
		}

		internal DataSet getDataSet()
		{
			return m_databases;
		}

		private void changeButtonState( int rowIndex )
		{
			if( m_databases.Tables[ "Databases" ].Rows.Count <= rowIndex )
			{
				setInitButtonState();
				return;
			}

			if( rowIndex < 0 )
				return;

			String rowDescription = (String) dataGrid1[rowIndex, 0];
			if( rowDescription.Equals( "" ) )
				setInitButtonState();
			else
			{
				openButton.Enabled = true;
				addButton.Enabled = true;
				editButton.Enabled = true;
				removeButton.Enabled = true;
			}
		}

		private void setInitButtonState()
		{
			openButton.Enabled = false;
			addButton.Enabled = true;
			editButton.Enabled = false;
			removeButton.Enabled = false;
		}

		private void selectRowAndChangeButtonState( int rowIndex )
		{
			if( m_databases.Tables[ "Databases" ].Rows.Count > rowIndex && rowIndex >= 0 )
				dataGrid1.Select( rowIndex );

			changeButtonState( rowIndex );
		}

		private AddDBForm getAddDBForm()
		{
			if( m_addForm == null )
				m_addForm = new AddDBForm( this );

			return m_addForm;
		}

		private EditDBForm getEditForm()
		{
			if( m_editForm == null )
				m_editForm = new EditDBForm( this );

			return m_editForm;
		}

		internal string getBlastDBName()
		{
			return m_blastDBName;
		}

		// add a db to the grid
		private void addButton_Click(object sender, System.EventArgs e)
		{
			getAddDBForm().ResetNameAndPath();
			DialogResult result = getAddDBForm().ShowDialog();

			if( result != DialogResult.OK )
				return;

			String dbName = getAddDBForm().getName();
			String dbPath = getAddDBForm().getPath();

			// if the user didn't actually add anything, then 
			// we won't put it in the grid
			if( dbName.Equals( "" ) ||
				dbPath.Equals( "" ) )
				return;

			// unselect current row
			if( dataGrid1.CurrentRowIndex >= 0 )
				dataGrid1.UnSelect( dataGrid1.CurrentRowIndex );

			DataTable table = m_databases.Tables[ "Databases" ];
			bool foundEmptyRow = false;
			for( int i = 0; i < table.Rows.Count; i++ )
			{
				if( ! dataGrid1[i, 0].Equals( "" ) )
					continue;

				foundEmptyRow = true;
				dataGrid1[i, 0] = dbName;
				dataGrid1[i, 1] = dbPath;
				break;
			}

			if( ! foundEmptyRow )
			{
				DataRow row = table.NewRow();
				row[0] = dbName;
				row[1] = dbPath;
				table.Rows.Add( row );
			}

			// select the newly added row and change the button state
			int rowIndex = dataGrid1.CurrentRowIndex;
			selectRowAndChangeButtonState( rowIndex );
		}

		// edit an entry in the grid
		private void editButton_Click(object sender, System.EventArgs e)
		{
			int rowIndex = dataGrid1.CurrentRowIndex;
			getEditForm().setName( (string) dataGrid1[rowIndex, 0] );
			getEditForm().setPath( (string) dataGrid1[rowIndex, 1] );
			DialogResult result = getEditForm().ShowDialog();
			
			if( result == DialogResult.OK )
			{
				dataGrid1[rowIndex, 0] = getEditForm().getName();
				dataGrid1[rowIndex, 1] = getEditForm().getPath();
			}
		}

		// use an entry in the grid
		private void openButton_Click(object sender, System.EventArgs e)
		{	
			selectRow();
		}

		private void selectRow()
		{
			int rowIndex = dataGrid1.CurrentRowIndex;

			if( rowIndex < 0 || 
				rowIndex >= m_databases.Tables[ "Databases" ].Rows.Count )
				return;

			m_blastDBName = (string) dataGrid1[rowIndex, 0];
			this.DialogResult = DialogResult.OK;
			this.Hide();
		}

		// remove an entry from the grid
		private void removeButton_Click(object sender, System.EventArgs e)
		{
			int rowIndex = dataGrid1.CurrentRowIndex;
			if( rowIndex < 0 )
				return;

			String dbName = (string) dataGrid1[rowIndex, 0];
			if( dbName == null || dbName.Equals( "" ) )
				return;

			dataGrid1.UnSelect( rowIndex );
			DataTable table = m_databases.Tables[ "Databases" ];
			table.Rows.RemoveAt( rowIndex );

			selectRowAndChangeButtonState( rowIndex );
		}

		internal string findDBLocation( string name )
		{
			DataTable table = m_databases.Tables[ "Databases" ];
			string strExp = "Name = \'" + name + "\'";
			DataRow[] foundRows = table.Select( strExp );

			if( foundRows == null || foundRows.Length <= 0 )
				return "";
			else
				return (string) foundRows[0][1];
		}

		// check whether the grid already has an entry with the same name
		internal bool hasName( string name, bool isEdit )
		{
			DataTable table = m_databases.Tables[ "Databases" ];

			// if we're editing an entry, then the current entry will intially match 
			// the value in the edit dialog, but we should allow that.
			// we don't want to allow them to edit to the same name of some other entry though.
			if( isEdit )
			{
				string currentEntryName = (string) table.Rows[ dataGrid1.CurrentRowIndex ][0];
				if( currentEntryName.Equals( name ) )
					return false;
			}

			string strExp = "Name = \'" + name + "\'";
			DataRow[] foundRows = table.Select( strExp );
			return ( foundRows != null && foundRows.Length > 0 );
		}

		private void dataGrid1_DoubleClick(object sender, System.EventArgs e)
		{
			m_isGridDoubleClick = true;
		}

		private void dataGrid1_Click(object sender, System.EventArgs e)
		{
			m_isGridDoubleClick = false;
		}
	}
}
