
/*========================================================================*/
/*                                                                        */
/* Karine PIOT  --  SEPT 2003                                             */
/*                                                                        */
/* Demonstration of data analysis with AnovArray                          */
/*                                                                        */
/*========================================================================*/


/* Sas Data Set creation from the file Bovine_Tissu.txt */

data BOVINE;
infile 'Bovine_Tissu.txt' firstobs=2 expandtabs;
input TISSU$ PROBE MEMBRANE GENE$ SIGNALMEAN;
logsign = log(SIGNALMEAN);
run;


/* command which load the AnovArray Package */

%include 'AnovArray.1.0.sas';


/* Analysis of Variance of logsign with two factors (tissu and gene), and their */
/* interaction. We use the global_analysis Macro */

%global_analysis (data = BOVINE,
                  outdata = RESULT1,
                  outgraph = global_graphs.ps,
                  stmts=%str(class tissu gene;
                              model logsign = tissu|gene@2;
                              means tissu));


%cleandata (data=RESULT1,
            outdatakeep=BOVKEEP,
            outdatadrop=BOVDROP,
            outdataoutliers=BOVOUTLIERS,
            limit=3)


%global_analysis (data = BOVKEEP,
                  outdata = RESULT2,
                  outgraph = global_graphs2.ps,
                  stmts=%str(class tissu GENE;
                              model logsign = tissu|gene@2;
                              means tissu ));


%differential_analysis(data=RESULT2,
                       outdata=BOVHOM ,
                       outgraph='diff_hom_graph.ps',
                       hypothesis=hom,
                       signal=logsign,
                       treatment=tissu,
                       FDR=0.05);


%differential_analysis(data=RESULT2,
                       outdata=BOVHET ,
                       outgraph='diff_het_graph.ps',
                       hypothesis=het,
                       signal=logsign,
                       treatment=tissu,
                       FDR=0.05);


%comparison ( data1=BOVHOM,
              data2=BOVHET,
              outdata=BOVCOMPAR,
              outgraph='diff_compar_graph.ps',
              FDR=0.05 );
