(*******************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which
typically will have the same name as this file except ending in
".nb" instead of ".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent
to using the Evaluate Initialization Cells menu command in the front
end.

DO NOT EDIT THIS FILE.  This entire file is regenerated
automatically each time the parent Notebook file is saved in the
Mathematica front end.  Any changes you make to this file will be
overwritten.
***********************************************************************)

(*  Author:     R. Urbanczik,
     Load with:  <<"SNAmat.m",
     Use:     :   cf. EXPORTS (in SNAmat.nb)
  *)


BeginPackage["SNAmat`"]



ZH2gset::usage = \
"For matrices Z and H, {G,nr} = ZH2gset[Z,H] computes a generating set G of the cone Z.x  \[Equal] 0, H.x \[GreaterEqual] 0. The first nr elements of G are reversible";\

ZH2elvs::usage = \
"For matrices Z and H, {elvs,nr} = ZH2elvs[Z,H] computes the elementary vectors elvs of the cone Z.x  \[Equal] 0, H.x \[GreaterEqual] 0. The first nr elements of elvs are reversible";\

fluxgset::usage="For a stoichiometry matrix Ns with the first nrev cols reversible, {gflxs,nr} = fluxgset[Ns,nrev] computes a generating set gflxs of elementary fluxes. The first nr elements of gflxs are reversible.";\

 fluxelvs::usage= \
"For a stoichiometry matrix Ns with the first nrev cols reversible, {eflxs,nr} = fluxelvs[Ns,nrev] computes the complete set eflxs of elementary fluxes. The first nr elements of eflxs are reversible.";\

real2rat::usage = \
"real2rat[Reals], converts the real numbers in Reals to rational numbers. Reals can be a single number, vector, matrix , ... ";\

pruning::usage \
="For ZH2..., if the rows of H are redundant, setting pruning = True, may improve performance. Default, pruning = False";\

msg::usage =
    "msg[expr] outputs expr, controlled by chatter";
chatter::usage \
="With default setting, chatter = 1, the SNA routines print out all kinds of intermediate stuff to the Messages notebook. chatter = 0: shut  up, chatter = -1: output goes to the evaluation notebook.";\

needsboxes::usage="";
signfluxelvs::usage="";
SNApath::usage="";

Begin["`Private`"];

\!\(\(\(\[IndentingNewLine]\)\(\(SNApath\ \  = \ DirectoryName[$Input];\)\(\[IndentingNewLine]\)
  \(If[SNApath\  \[Equal] \ "\<\>", \ SNApath\  = \ \ DirectoryName[FileNames[$Input, $Path] // First]];\)\(\[IndentingNewLine]\)
  \(SNApath\  = \ SNApath\  <> \ "\<../\>";\)\(\[IndentingNewLine]\)
  \(pairelvslink\  = Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \ pairelvslink\ \  // Print;\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
  \(ZH2gset[Z_, H_]\  := \ cutter[setupelv[Z, H, {}]];\)\(\[IndentingNewLine]\)
  \(ZH2elvs[Z_, H_, Rev_]\  := \ \ \ \ cutter[setupelv[Z, H, Rev]];\)\(\[IndentingNewLine]\)
  \(ZH2elvs[Z_, H_]\  := \ \ cutter[setupelv[Z, H, IdentityMatrix[\ d\_2[H]]]];\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\[IndentingNewLine]fluxgset[N_, nrev_]\  := \ Block[\ {K, Kir, \[Beta]s, trans, revs}, \[IndentingNewLine]K\  = \ NullSpace[N] // Trp; \[IndentingNewLine]If[\ K\  \[Equal] \ {}, \ Return[\ {\ {}, 0}\ ]]; \ \[IndentingNewLine]Kir\  = \ Drop[K, nrev]; \[IndentingNewLine]If[Kir\  \[Equal] \ {}, \ Kir\  = \ {0  First@K\ }]; \[IndentingNewLine]{\ {\[Beta]s, trans}\ , revs}\ \  = \ \ cutterf[setupelv[\ {}, Kir, \ \ {}]]; \ \[IndentingNewLine]{\[Beta]s . \((trans . Trp[K])\), revs}\ ]; \[IndentingNewLine]fluxelvs[N_, nrev_]\  := \ Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, bl}, {nN, nnrev, vrtriv, vitriv, bl}\  = \ fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ If[nN\  \[Equal] \ \ {}, {}, \ NullSpace[nN] // Trp]; \[IndentingNewLine]If[\ K\  \[Equal] \ {}, \ Return[\ {\ {Join[vrtriv, vitriv]}, Length[vrtriv]}\ ]]; \[IndentingNewLine]{\ {\[Beta]s, trans}\ , revs}\ \  = \ \ cutterf[setupelv[\ {}, Drop[K, nnrev], \ \ Take[K, nnrev]]\ ]; \ \[IndentingNewLine]{Join[vrtriv, \[Beta]s . \((trans . Trp[K] . Trp[bl])\), vitriv], \[IndentingNewLine]revs + Length[vrtriv]}\ ]; \[IndentingNewLine]signfluxelvs[N_, nrev_]\  := \ Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, bl}, \[IndentingNewLine]{nN, nnrev, vrtriv, vitriv, bl}\  = \ fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ NullSpace[nN] // Trp; \[IndentingNewLine]{\ {\[Beta]s, trans}\ , revs}\ \  = \ \ cutterf[setupelv[\ {}, Drop[K, nnrev], \ \ Take[K, nnrev]]\ \ ]; \[IndentingNewLine]Uninstall[pairelvslink]; \ pairelvslink\  = Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \[IndentingNewLine]trans\  = \ trans . Trp[K] . Trp[bl]; \[IndentingNewLine]\[Beta]s\  = \ Map[sconvvec[Sign[# . trans]] &, \[Beta]s\ ]; \[IndentingNewLine]vrtriv\  = \ Map[sconvvec, vrtriv]; \[IndentingNewLine]vitriv\  = \ Map[sconvvec, vitriv]; \[IndentingNewLine]{Join[vrtriv, \[Beta]s, vitriv]\ , revs + Length[vrtriv]}];\[IndentingNewLine]*) \)\(\[IndentingNewLine]\)
  \(fluxes[N_, nrev_, what_]\  := \ Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, bl, m, M}, \[IndentingNewLine]{nN, nnrev, vrtriv, vitriv, bl}\  = \ fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ If[nN\  \[Equal] \ \ {}, {}, \ NullSpace[nN] // Trp]; \[IndentingNewLine]If[\ K\  \[Equal] \ {}, \[IndentingNewLine]{{\[Beta]s, trans}, revs}\  = \ {\ \ {{}, {}}, 0}\[IndentingNewLine], \[IndentingNewLine]Kir\  = \ Drop[K, nnrev]; \[IndentingNewLine]If[Kir\  \[Equal] \ {}, \ Kir\  = \ {0  First@K\ }]; \[IndentingNewLine]{\ {\[Beta]s, trans}\ , revs}\ \  = \ \ cutterf[setupelv[\ {}, Kir, \ If[what\ \  === \ gset, {}, \ Take[K, nnrev]]\ ]]; \ \[IndentingNewLine]trans\  = \ trans . Trp[K] . Trp[bl]]; \[IndentingNewLine]If[what\ \  =!= \ selvs, \[IndentingNewLine]\ \ {Join[vrtriv, If[\[Beta]s\  \[Equal] \ {}, {}, \[Beta]s . trans], vitriv], \ revs + Length[vrtriv]}\[IndentingNewLine]\ \ , \[IndentingNewLine]\ \ Uninstall[pairelvslink]; \ pairelvslink\  = Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \[IndentingNewLine]\ \ M\  = \ \ d\_1[\[Beta]s]; \[IndentingNewLine]\ \ For[\ m\  = \ 1, \ m\  \[LessEqual] \ M, \ \(m++\), \ \[Beta]s[\([m]\)]\  = \ sconvvec@Sign[\ \[Beta]s[\([m]\)] . trans]\ ]; \[IndentingNewLine]\ \ vrtriv\  = \ Map[sconvvec, vrtriv]; \[IndentingNewLine]\ \ vitriv\  = \ Map[sconvvec, vitriv]; \[IndentingNewLine]\ {Join[vrtriv, \[Beta]s, vitriv]\ , revs + Length[vrtriv]}]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
  \(fluxgset[N_, nrev_]\  := \ fluxes[N, nrev, gset];\)\(\[IndentingNewLine]\)
  \(fluxelvs[N_, nrev_]\  := \ fluxes[N, nrev, elvs];\)\(\[IndentingNewLine]\)
  \(signfluxelvs[N_, nrev_]\  := \ fluxes[N, nrev, selvs];\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
  \(real2rat[r_]\  := \ Block[\ {dig, exp}, \[IndentingNewLine]{dig, exp}\  = \ RealDigits[SetPrecision[r, 12]]; \[IndentingNewLine]exp\  = \ Max[Position[dig, \ x_\  /; \ x\  \[NotEqual] 0]] - exp; \[IndentingNewLine]If[exp\  \[Equal] \ \(-\[Infinity]\), \ 0, \ \[IndentingNewLine]Round[r\ 10^exp]/10^exp]];\)\(\[IndentingNewLine]\)
  \(SetAttributes[real2rat, Listable];\)\(\[IndentingNewLine]\)\(\ \ \ \ \ \ \ \ \)\(\[IndentingNewLine]\)
  \(\ \ \ \ \ \)\)\)\)

\!\(\(fluxprep[N_, nrev_]\  := \ Block[\ {rtriv, itriv, triv, vrtriv, vitriv, bl, x, nN, nnrev}, \[IndentingNewLine]triv\  = \ Position[Trp[N], \ x_\  /; \ x\  \[Equal] \ 0  x, {1}] // Flatten; \[IndentingNewLine]rtriv\  = \ Cases[triv, \ x_\  /; \ x\  \[LessEqual] \ nrev]; \[IndentingNewLine]itriv\  = \ Cases[triv, \ x_\  /; \ x\  > \ nrev]; \[IndentingNewLine]{vrtriv, vitriv, bl}\  = \ blowupf[rtriv, itriv, d\_2[N]]; \[IndentingNewLine]nN\  = \ DeleteCases[Trp[N], \ x_\  /; \ x\  \[Equal] \ 0  x, {1}] // Trp; \[IndentingNewLine]nnrev\  = \ nrev\  - \ Length[rtriv]; \[IndentingNewLine]{nN, nnrev, vrtriv, vitriv, bl}];\)\[IndentingNewLine]
  \(blowupf[rtriv_, itriv_, len_]\  := \ Block[{vrtriv, vitriv, blowup, x}, \[IndentingNewLine]blowup\  = \ IdentityMatrix[len]; \[IndentingNewLine]vrtriv\  = \ blowup[\([rtriv]\)]; \[IndentingNewLine]vitriv\  = \ blowup[\([itriv]\)]; \[IndentingNewLine]blowup[\([rtriv]\)]\  = \ 0*blowup[\([rtriv]\)]\ ; \[IndentingNewLine]blowup[\([itriv]\)]\  = \ 0*blowup[\([itriv]\)]\ ; \[IndentingNewLine]blowup\  = \ DeleteCases[Trp[blowup], x_\  /; \ x\ \  \[Equal] \ 0\ x, {1}] // Trp; \[IndentingNewLine]If[\ blowup \[NotEqual] \ {}, \ blowup\  = \ SparseArray@blowup]; \[IndentingNewLine]{vrtriv, vitriv, blowup}];\)\)

pruning = False;
chatter = 1;

{negc,zerc,posc} = {"a","b","c"};
conv = ToCharacterCode[ negc<>zerc<>posc];

\!\(\(cutter[setup_]\ \  := \ Block[\ {\[Beta]sDtrans, nrev}, \[IndentingNewLine]{\ \[Beta]sDtrans\ , nrev}\  = \ \ cutterf[setup]; \[IndentingNewLine]{Apply[Dot, \[Beta]sDtrans], \ nrev}];\)\n
  \(\(cutterf[setup_]\  := \[IndentingNewLine]\ Block[\[IndentingNewLine]\ \ \ \ \ \ \ \ \ {Kperm, Kdone, \ nextK, revmarks, rev, revs, nrev, slv, orth, image, n, m, newnegs, new, cmbsi, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \[Beta]s, \ rv, hasrev, tmp, keep, cnt, cntm, more, trans, SK\[Beta]sT\ , ScmbsiT, i, x\ , irrevs, prune}, \[IndentingNewLine]{Kperm, revmarks, nrev, slv, orth, image} = setup; \[IndentingNewLine]n\  = \ \ d\_1[Kperm]; \ \[IndentingNewLine]If[\ n\  \[Equal] \ 0, \ \[Beta]s\ \  = \ {}, \[IndentingNewLine]m\  = \ n\ \  - \ d\_2[Kperm]; \[IndentingNewLine]\[Beta]s\  = \ IdentityMatrix[n - m]; \[IndentingNewLine]Kperm\  = \ MapThread[List, {Drop[Kperm, n - m], Drop[revmarks, n - m]}]; \[IndentingNewLine]Kdone\  = \ IdentityMatrix[n - m]; \[IndentingNewLine]irrevs\ \  = \ Position[Take[revmarks, n - m], False]\  // Flatten; \[IndentingNewLine]revs\  = \ Complement[Range[n - m], irrevs]; \[IndentingNewLine]msg[{"\<cutterf:revs\>", revs}]; \[IndentingNewLine]SK\[Beta]sT\  = \ Map[sconvvec, Transpose[Sign[\[Beta]s]]]; \[IndentingNewLine]hasrev\  = \ revs\  \[NotEqual] \ {}; \[IndentingNewLine]cnt\  = \ 0; \ cntm\  = \ 50; \ prune\  = \ pruning; \[IndentingNewLine]While[Kperm\  \[NotEqual] \ {}, \[IndentingNewLine]{{nextK, rev}, Kperm}\  = {Kperm[\([1]\)], Drop[Kperm, 1]}; If[prune\  && \ \((rev\  || \ \((cntm\ \((1 + Length[Kdone]/\ Length[\[Beta]s])\)\ \  \[LessEqual] \ \ Length[Kdone])\))\), \[IndentingNewLine]prune\  = \ \[Not] rev; \[IndentingNewLine]keep = nonreds[Kdone, SK\[Beta]sT\ \ , revs, Range[n - m + 1, d\_1[Kdone]]]\ ; \[IndentingNewLine]Kdone\  = \ Kdone[\([keep]\)]; \[IndentingNewLine]SK\[Beta]sT\ \  = \ SK\[Beta]sT[\([keep]\)]; \[IndentingNewLine]cntm\  = \ Length[Kdone];\[IndentingNewLine]]; \[IndentingNewLine]tmp\  = \ Join[Kdone, {nextK}]; \[IndentingNewLine]new\  = \ \[Beta]s\  . nextK; \[IndentingNewLine]newnegs\  = \ Count[new, \ x_ /; \ x\  < \ 0]\  > \ 0; \[IndentingNewLine]If[\ hasrev\  || \ newnegs, \[IndentingNewLine]more\  = \ sconvvec[Sign[new]]; \[IndentingNewLine]{cmbsi, ScmbsiT}\  = Global`pairelvs[StringJoin[SK\[Beta]sT]\  <> more, Length[\[Beta]s], irrevs, n - m - 1]; \[IndentingNewLine]If[\((Length[cmbsi]\  > \ 0)\)\  || \((\ newnegs\  && \ \ \[Not] rev)\), \[IndentingNewLine]cnt\  = \ cnt + 1; \[IndentingNewLine]If[\ \[Not] rev, \ keep\  = \ Position[new, x_\  /; \ x\  \[GreaterEqual] \ 0] // Flatten]; \[IndentingNewLine]\[Beta]s\  = \ Join[\ If[rev, \[Beta]s, \[Beta]s\ [\([keep]\)]]\ , \ candcomb[\[Beta]s\ , cmbsi, new]]; \[IndentingNewLine]If[\ \[Beta]s\  \[Equal] \ \ {}, \ Break[]]; \[IndentingNewLine]SK\[Beta]sT\  = \ Join[SK\[Beta]sT, {more}]; \[IndentingNewLine]SK\[Beta]sT\ \  = \ Scomb[rev, keep, SK\[Beta]sT\ \ , StringPartition[ScmbsiT, Length[cmbsi]]]; \[IndentingNewLine]ScmbsiT\  = \ {}; \[IndentingNewLine]Kdone\  = \ tmp; \[IndentingNewLine]msg[{"\<cutterf\>", rev, Length[Kperm], \ Length[\[Beta]s], Length[Kdone], cnt, {Count[new, \ x_ /; \ x\  > \ 0], Count[new, \ x_ /; \ x\  < \ 0]}}];\[IndentingNewLine]]];\[IndentingNewLine]];\[IndentingNewLine]]; \[IndentingNewLine]SK\[Beta]sT\ \  = \ {}; \[IndentingNewLine]rv\  = Map[\[Not] reversible[irrevs, #] &, \[Beta]s]; \[IndentingNewLine]\[Beta]s\  = \ \[Beta]s\ [\([Ordering[rv]]\)]; \[IndentingNewLine]trans\  = \ Trp[slv] . Trp[image]; \[IndentingNewLine]If[\ orth\  \[NotEqual] \ {}, \[IndentingNewLine]If[\[Beta]s\  \[NotEqual] \ {}, \ \[Beta]s\  = \[Beta]s . trans]; \[IndentingNewLine]\[Beta]s\  = \ Join[orth, \[Beta]s\ ]; \[IndentingNewLine]trans\  = \ SparseArray[{\ {i_, i_}\  \[Rule] \ 1}, \ {d\_2[\ \[Beta]s], d\_2[\ \[Beta]s]}];]; \[IndentingNewLine]{{\[Beta]s, trans}, \ Count[rv, False]\  + Length[orth]}];\)\(\n\)
  \)\[IndentingNewLine]
  \(\(reversible[irrevs_, \ \[Beta]_]\ \  := \ \((Length[irrevs]\ \  \[Equal] \ Count[\[Beta][\([irrevs]\)], 0])\);\)\(\[IndentingNewLine]\)
  \)\[IndentingNewLine]
  \(candcomb[\[Beta]s_, cmbsi_, new_\ ]\  := \ \ Block[\ {comb, \ \[Lambda]\ , \[Mu]\ , s, t}, \[IndentingNewLine]comb[pair_]\  := \ \((\[IndentingNewLine]{\ \[Lambda]\ , \[Mu]\ }\  = \ new[\([pair]\)]; \ \[IndentingNewLine]s\  = \ \ Sign[\[Lambda]]\ \ Sign[\(-\[Mu]\)]\ ; \[IndentingNewLine]t\ \  = \ \((\[Lambda]\ s)\) \[Beta]s[\([pair // Last]\)]\  - \ \((\[Mu]\ \ s)\) \[Beta]s[\([pair // First]\)]; \[IndentingNewLine]t/GCD @@ t)\); \[IndentingNewLine]Map[comb, cmbsi]\[IndentingNewLine]];\)\)

StringPartition["",len_]   := {};
StringPartition[s_,len_]  := Block[ {a,b},
      b = s;
      Table[ 
        (a = StringTake[b,len]; b = StringDrop[b,len]; a),
        {StringLength[s]/len}]];

Scomb[rev_,keeps_,SK\[Beta]sT_,ScmbsiT_] := Block[{tt,keep},
      If[rev, tt= SK\[Beta]sT,
        tt=Map[FromCharacterCode[ToCharacterCode[#][[keeps]]]&,SK\[Beta]sT]];
      If[ScmbsiT \[NotEqual] {}, MapThread[StringJoin,{tt,ScmbsiT}], tt]
      ];

sconvvec[x_] := FromCharacterCode[ Map[conv[[#]]&,x+2]];

\!\(\(\(setupelv[orth_, H_, Rev_] := \ Block[\[IndentingNewLine]{HH1, HH2, HH, image, orth2, image2, \ nrev, Kt, Ktr, Kperm, identK, slv, sortby, prm, revmarks, x}, HH\  = \ Join[Rev, H]; \[IndentingNewLine]image\  = \ NullSpace[\ If[\ orth\  \[NotEqual] \ {}, \ orth, \ 0\ {HH[\([1]\)]}\ ]]\  // Transpose; \[IndentingNewLine]HH1\  = \ If[Rev\  \[Equal] \ {}, {}, DeleteCases[Rev . image, x_\  /; \ x\  \[Equal] \ 0\ x]]; \[IndentingNewLine]HH2\  = \ If[\ \ \ \ \ H\  \[Equal] \ {}, {}, DeleteCases[H . image, x_\  /; \ x\  \[Equal] \ 0\ x]]; \[IndentingNewLine]HH\  = \ Join[HH1, HH2]; \[IndentingNewLine]nrev\  = \ d\_1[HH1]\ ; \[IndentingNewLine]\[IndentingNewLine]{image2, orth2}\  = \ split[HH, image]; \[IndentingNewLine]Kt = HH . image2; \[IndentingNewLine]\[IndentingNewLine]If[\ Kt\  \[Equal] \ 0, \ \ Return\ @{{}, {}, 0, {}, orth2, {}}\ \ \ \ \ ]; \[IndentingNewLine]\[IndentingNewLine]prm\  = \ PreRowRedOrderingheuristic[Drop[Kt, nrev]]; \[IndentingNewLine]prm\  = \ Join[nrev + prm, \ Range[nrev]]; \[IndentingNewLine]{Ktr, identK}\ \  = \ RowRedPiv[Kt, prm]; \[IndentingNewLine]slv\  = \ Inverse[Kt[\([identK]\)]]; \ \ Clear[Kt]; \[IndentingNewLine]sortby = Table[0, {d\_1[Ktr]}]; sortby\[LeftDoubleBracket]Range[nrev]\[RightDoubleBracket] = \(-1\); sortby\[LeftDoubleBracket]identK\[RightDoubleBracket] = d\_2[Ktr] + 1 - Range[d\_2[Ktr]]; \[IndentingNewLine]prm\  = \ ordr[Ktr, sortby]; \[IndentingNewLine]Kperm = Ktr\[LeftDoubleBracket]prm\[RightDoubleBracket]; \[IndentingNewLine]If[d\_2[Ktr]\  < \ d\_1[Ktr], \[IndentingNewLine]msg[\ {"\<setupelv: chain\>", Map[Min[Position[#, \ x_\  /; \ x\  \[NotEqual] \ 0]] &, Trp[Drop[Kperm, d\_2[Ktr]]]] /. \ \[Infinity]\  \[Rule] \ 0}]\[IndentingNewLine]]; \[IndentingNewLine]revmarks = \((# \[LessEqual] nrev &)\) /@ prm; \[IndentingNewLine]msg[{"\<setupelv: gset steps \>", Count[Drop[revmarks, d\_2[Ktr]], False], d\_1[Ktr] - d\_2[Ktr] - 1}]; \[IndentingNewLine]If[orth2\  \[NotEqual] \ {}, \ orth2\ \  = \ orth2\  . Transpose[image]]; \[IndentingNewLine]{Kperm, revmarks, nrev, slv, orth2, image . image2}];\)\(\[IndentingNewLine]\)
  \)\[IndentingNewLine]
  \(\(split[H_, along_]\  := \ Block[\ {rr, piv, aug, pivi, pivo, image, orth, slv}, \[IndentingNewLine]aug\  = \ Join[H, along]; \[IndentingNewLine]{rr, piv}\  = \ RowRedPiv[aug, Range[d\_1[aug]]\ ]; \[IndentingNewLine]slv\  = \ Inverse[aug[\([piv]\)]] // Trp; \[IndentingNewLine]pivi\  = \ Count[piv, \ x_\  /; \ x\  \[LessEqual] \ d\_1[H]]; \[IndentingNewLine]pivr\  = \ Count[piv, \ x_\  /; \ x\  > \ d\_1[H]]\ ; \[IndentingNewLine]{image, orth}\  = \ \[IndentingNewLine]{If[pivi\ \  \[Equal] \ 0, \ {}, \(slv[\([Range[pivi]]\)] // RowReduce\) // Trp], \[IndentingNewLine]slv[\([Range[pivr] + pivi]\)]}; \[IndentingNewLine]{image, orth}\ \[IndentingNewLine]]\)\(\[IndentingNewLine]\)
  \)\[IndentingNewLine]
  \(first[\ {}\ ]\  := \ {};\)\n
  \(first[x_]\  := \ First[x];\)\[IndentingNewLine]
  \(RowRedPiv[H_, prm_] := Block[{r, inv, piv}, \[IndentingNewLine]inv = prm; \ inv[\([prm]\)] = Range[Length[prm]]; \[IndentingNewLine]r\  = \ RowReduce[Transpose[H[\([prm]\)]]] // Transpose; \[IndentingNewLine]piv\  = \ Flatten[\((first[Position[r, #1]] &)\) /@ IdentityMatrix[d\_2[r]]]; \[IndentingNewLine]{r[\([inv]\)], prm[\([piv]\)]}];\)\)

chaincrit[H_] := Block[ {ZH,zcnts,p,mp},
      ZH= 1-Abs[Sign[H]];
      zcnts = Plus@@ZH; 
      p = Ordering[-zcnts];
      ZH = Transpose[ZH][[p]]//Transpose;
      Map[Min[Position[#,0]]&,ZH] /. \[Infinity] \[Rule] Length[p]+1];

sparsecrit[H_] :=  Map[Count[#,0]&,H];

ordr[H_,basecrit_] := Block[ {prm,crit},
    crit = {basecrit,chaincrit[H],sparsecrit[H]};
    prm = Ordering[ - Transpose[crit]];
    prm]

\!\(\(PreRowRedOrderingheuristic[{}]\ \  := \ {};\)\[IndentingNewLine]
  \(PreRowRedOrderingheuristic[H_]\  := Block[\[IndentingNewLine]{HN, cov, evals, cuteval, sei, sevecs, Hl, ovlaps, ovlapsr, reps, prm, Kperm, chains, tries, eval, qual, i, v, x}, \ \[IndentingNewLine]If[\ \ d\_1[H]\  \[LessEqual] \ d\_2[H], \ Return[\ Range[d\_1[H]]]\ ]; \[IndentingNewLine]SeedRandom[1]; \ \[IndentingNewLine]Hl = H; \[IndentingNewLine]HN\  = \ H\  // N; \[IndentingNewLine]HN\  = \ Map[\((#/Norm[#])\) &, HN]; \[IndentingNewLine]cov\  = \ Transpose[HN] . HN; \[IndentingNewLine]evals\  = Eigenvalues[cov]; \[IndentingNewLine]cuteval\  = \ Max[Min[evals], \ \(d\_1[H]/d\_2[H]\)/10]; \n\ \ \ \ \ \ \ sei = Position[evals, \ x_\  /; \ x\  \[LessEqual] \ \ cuteval] // \ \ Flatten; \n\ \ \ \ \ \ \ sevecs = \(Eigenvectors[cov]\)[\([sei]\)]; \[IndentingNewLine]ovlaps\  = \ HN . Transpose[sevecs]; \[IndentingNewLine]reps[]\  := \ \[IndentingNewLine]\((ovlapsr\  = \ ovlaps . DiagonalMatrix[1 + 0.5  Table[Random[], {i, Length[sei]}]]; \n\ \ \ \ \ \ \ \ \ \ \ prm = Ordering[Map[Norm, ovlapsr]]; \[IndentingNewLine]Kperm\ \  = \ SortedRowRed[H, prm]; \[IndentingNewLine]chains = Map[Min[Position[#, \ x_\  /; \ x\  \[NotEqual] \ 0]] &, Trp[Drop[Kperm, d\_2[Kperm]]]]\  /. \ \[Infinity]\  \[Rule] \ 0; \[IndentingNewLine]{prm, chains})\); \[IndentingNewLine]tries\  = Table[reps[], {i, 5}]; \[IndentingNewLine]eval[v_]\  := \ Plus @@ \((v^\((1.3)\))\); \[IndentingNewLine]qual = Map[eval, \(Transpose[tries]\)[\([2]\)]]; \[IndentingNewLine]tries[\([Ordering[\(-qual\)] // First]\)] // First\[IndentingNewLine]];\)\[IndentingNewLine]
  \(SortedRowRed[H_, prm_]\  := \ Block[\ {ident, Ktr, sortby}, \[IndentingNewLine]{Ktr, identK}\ \  = \ RowRedPiv[H, prm]; \[IndentingNewLine]sortby = Table[\(-1\), {d\_1[Ktr]}]; \ sortby\[LeftDoubleBracket]identK\[RightDoubleBracket] = d\_2[Ktr] + 1 - Range[d\_2[Ktr]]; \[IndentingNewLine]Ktr[\([ordr[Ktr, sortby]]\)]];\)\)


nonreds[Kdone_,SK\[Beta]sT_ ,revs_,checks_]  := 
    Block[ {ind,sc,j,jj,jsc, ksc, keep},
      keep = Range[Length[SK\[Beta]sT]];
      msg["nonreds: pruning"];
      For[ind = 1, ind \[LessEqual] Length[checks], ind++,
         jj= checks[[ind]];
        j = Position[keep,jj][[1,1]];
         sc = SymbolicCoral[j,SK\[Beta]sT[[keep]],revs];
         If[ sc \[NotEqual] {},
          ksc =  keep[[sc]]\[Union]{jj};
          jsc = Position[ksc,jj][[1,1]];
          If[redundant[ Kdone[[ksc ]],jsc] ,
            keep  = DeleteCases[keep,jj];]]
        ];
      msg[{"nonreds: pruned",Length[SK\[Beta]sT]-Length[keep]}];
      keep];

SymbolicCoral[i_,SK_,revs_] := Block[ {keep,j,sl,checks},
      keep =Complement[ Range[Length[SK]],revs];
      keep = DeleteCases[keep,i];
      sl = StringLength[SK//First];
      For [j = 1, j \[LessEqual] sl, j++,
        If[keep \[Equal] {},Break[]];
        If[ StringTake[SK[[i]],{j}] \[NotEqual] zerc, Continue[]];
        checks = Map[StringTake[#,{j}]&,SK[[keep]]];
        keep = Extract[keep,Position[checks,zerc]];
        ];
      keep];
redundant[vecl_,check_]  := Block[ 
      { K,opt,l,m,box,constr,v,vv,cv,red},
      K = NullSpace[Trp[vecl]]//Trp;
      If[ K \[Equal] {}, Return[False]];
      opt = K[[check]];
      {m,l} = Dimensions[K];
      box =  Table[{-1,1},{i,l}];
      constr = Table[{0,1},{i,m}];
      constr[[check]] = {0,-1};
       v=LinearProgramming[opt,K,constr,box ,Method\[Rule]RevisedSimplex];
      If[\[Not]VectorQ[ v,NumericQ], v = Table[0,{i,l}]];
      vv= K.v;
      cv = vv.vecl;
      vv[[check]]=-vv[[check]];
      red = (vv[[check]]  > 0) && (cv \[Equal] 
              0 cv) &&(Min[vv]\[GreaterEqual] 0)];


\!\(\(\(\[IndentingNewLine]\)\(\(d\_i_[M_]\  := \ \ \(Dimensions[M]\)[\([i]\)]\ ;\)\[IndentingNewLine]
  \(Trp[a_]\  := \ Transpose[a];\)\n
  \(Trp[{}]\  := \ {};\)\n
  \(msgmsg1[expr_needsboxes]\  := \ \((\[IndentingNewLine]\(NotebookWrite[messagesNotebook, \[IndentingNewLine]Cell[BoxData[expr\  /. \ needsboxes[a_]\  :> \ MakeBoxes[a, StandardForm]], "\<Output\>"]];\))\);\)\[IndentingNewLine]
  \(msgmsg1[expr_]\  := \ NotebookWrite[messagesNotebook, \[IndentingNewLine]Cell[TextData[ToString[expr]], "\<Output\>"]];\)\[IndentingNewLine]
  \(msgmsg[expr_]\  := \[IndentingNewLine]\((If[Head[messagesNotebook]\  \[Equal] \ Symbol, messagesNotebook\  = \ \(Notebooks["\<Messages\>"]\)[\([1]\)]\ ]; \ \[IndentingNewLine]msgmsg1[expr];\ \[IndentingNewLine])\);\)\[IndentingNewLine]
  \(msg[expr_]\  := \ \[IndentingNewLine]If[\ Abs[chatter]\  > \ 0, \[IndentingNewLine]If[\ chatter\  > \ 0, \ msgmsg[expr], \ Print[expr\  /. \ needsboxes[a_]\  :> \ a]]];\)\[IndentingNewLine]
  \(msg1[expr_]\  := \ msg[expr];\)\)\)\)

End[]  EndPackage[];                                        