(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     34628,        701]*)
(*NotebookOutlinePosition[     35288,        724]*)
(*  CellTagsIndexPosition[     35244,        720]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{
      RowBox[{"(*", "  ", 
        RowBox[{\(Author : \ \ \ \ \ R . \ Urbanczik\), ",", 
          "\[IndentingNewLine]", 
          "   ", \(Load\ \(with : \ \ << "\<SNAmat.m\>"\)\), ",", 
          "\[IndentingNewLine]", "   ", 
          RowBox[{"Use", ":", "     ", 
            RowBox[{":", "   ", 
              RowBox[{\(cf . \ EXPORTS\), " ", 
                StyleBox[\((in\ SNAmat . nb)\),
                  FontSize->12]}]}]}]}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    StyleBox[\(BeginPackage["\<SNAmat`\>"]\),
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontTracking->"Plain",
      FontVariations->{"Underline"->False,
      "Outline"->False,
      "Shadow"->False,
      "StrikeThrough"->False,
      "Masked"->False,
      "CompatibilityType"->0,
      "RotationAngle"->0}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(EXPORTS\)\)\)], "Input",
  Evaluatable->False],

Cell[BoxData[{
    \(\(ZH2gset::usage\  = \ "\<For matrices Z and H, {G,nr} = ZH2gset[Z,H] \
computes a generating set G of the cone Z.x  \[Equal] 0, H.x \[GreaterEqual] \
0. The first nr elements of G are reversible\>";\)\), "\[IndentingNewLine]", 
    \(\(ZH2elvs::usage\  = \ "\<For matrices Z and H, {elvs,nr} = \
ZH2elvs[Z,H] computes the elementary vectors elvs of the cone Z.x  \[Equal] \
0, H.x \[GreaterEqual] 0. The first nr elements of elvs are \
reversible\>";\)\), "\[IndentingNewLine]", 
    \(\(fluxgset::usage = "\<For a stoichiometry matrix Ns with the first \
nrev cols reversible, {gflxs,nr} = fluxgset[Ns,nrev] computes a generating \
set gflxs of elementary fluxes. The first nr elements of gflxs are \
reversible.\>";\)\), "\n", 
    \(\ \(fluxelvs::usage = \ "\<For a stoichiometry matrix Ns with the first \
nrev cols reversible, {eflxs,nr} = fluxelvs[Ns,nrev] computes the complete \
set eflxs of elementary fluxes. The first nr elements of eflxs are \
reversible.\>";\)\), "\[IndentingNewLine]", 
    \(\(real2rat::usage\  = \ "\<real2rat[Reals], converts the real numbers \
in Reals to rational numbers. Reals can be a single number, vector, matrix , \
... \>";\)\), "\[IndentingNewLine]", 
    \(\(pruning::usage\  = "\<For ZH2..., if the rows of H are redundant, \
setting pruning = True, may improve performance. Default, pruning = False\>";\
\)\), "\[IndentingNewLine]", 
    \(\(msg::usage\  = \[IndentingNewLine]"\<msg[expr] outputs expr, \
controlled by chatter\>";\)\), "\[IndentingNewLine]", 
    \(\(chatter::usage\  = "\<With default setting, chatter = 1, the SNA \
routines print out all kinds of intermediate stuff to the Messages notebook. \
chatter = 0: shut  up, chatter = -1: output goes to the evaluation \
notebook.\>";\)\), "\[IndentingNewLine]", 
    \(\(needsboxes::usage = "\<\>";\)\), "\[IndentingNewLine]", 
    \(\(signfluxelvs::usage = "\<\>";\)\), "\[IndentingNewLine]", 
    \(\(SNApath::usage = "\<\>";\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(SNApath\ \  = \ 
        DirectoryName[$Input];\)\(\[IndentingNewLine]\)
    \(If[SNApath\  \[Equal] \ "\<\>", \ 
        SNApath\  = \ \ DirectoryName[
            FileNames[$Input, $Path] // First]];\)\(\[IndentingNewLine]\)
    \(SNApath\  = \ SNApath\  <> \ "\<../\>";\)\(\[IndentingNewLine]\)
    \(pairelvslink\  = Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \ 
    pairelvslink\ \  // 
      Print;\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(ZH2gset[Z_, H_]\  := \ 
        cutter[setupelv[Z, H, {}]];\)\(\[IndentingNewLine]\)
    \(ZH2elvs[Z_, H_, Rev_]\  := \ \ \ \ cutter[
          setupelv[Z, H, Rev]];\)\(\[IndentingNewLine]\)
    \(ZH2elvs[Z_, H_]\  := \ \ cutter[
          setupelv[Z, H, 
            IdentityMatrix[\ 
              d\_2[H]]]];\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( \
(*\[IndentingNewLine]fluxgset[N_, nrev_]\  := \ 
        Block[\ {K, Kir, \[Beta]s, trans, revs}, \[IndentingNewLine]K\  = \ 
            NullSpace[N] // Trp; \[IndentingNewLine]If[\ K\  \[Equal] \ {}, \ 
            Return[\ {\ {}, 0}\ ]]; \ \[IndentingNewLine]Kir\  = \ 
            Drop[K, nrev]; \[IndentingNewLine]If[Kir\  \[Equal] \ {}, \ 
            Kir\  = \ {0  First@K\ }]; \[IndentingNewLine]{\ {\[Beta]s, 
                trans}\ , revs}\ \  = \ \ cutterf[
              setupelv[\ {}, 
                Kir, \ \ {}]]; \ \[IndentingNewLine]{\[Beta]s . \((trans . 
                  Trp[K])\), revs}\ ]; \[IndentingNewLine]fluxelvs[N_, 
          nrev_]\  := \ 
        Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, 
            bl}, {nN, nnrev, vrtriv, vitriv, bl}\  = \ 
            fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ 
            If[nN\  \[Equal] \ \ {}, {}, \ 
              NullSpace[nN] // Trp]; \[IndentingNewLine]If[\ 
            K\  \[Equal] \ {}, \ 
            Return[\ {\ {Join[vrtriv, vitriv]}, 
                Length[vrtriv]}\ ]]; \[IndentingNewLine]{\ {\[Beta]s, 
                trans}\ , revs}\ \  = \ \ cutterf[
              setupelv[\ {}, 
                Drop[K, nnrev], \ \ Take[K, 
                  nnrev]]\ ]; \ \[IndentingNewLine]{Join[
              vrtriv, \[Beta]s . \((trans . Trp[K] . Trp[bl])\), 
              vitriv], \[IndentingNewLine]revs + 
              Length[vrtriv]}\ ]; \[IndentingNewLine]signfluxelvs[N_, 
          nrev_]\  := \ 
        Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, 
            bl}, \[IndentingNewLine]{nN, nnrev, vrtriv, vitriv, bl}\  = \ 
            fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ 
            NullSpace[nN] // Trp; \[IndentingNewLine]{\ {\[Beta]s, trans}\ , 
              revs}\ \  = \ \ cutterf[
              setupelv[\ {}, 
                Drop[K, nnrev], \ \ Take[K, 
                  nnrev]]\ \ ]; \[IndentingNewLine]Uninstall[pairelvslink]; \ 
          pairelvslink\  = 
            Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \
\[IndentingNewLine]trans\  = \ 
            trans . Trp[K] . Trp[bl]; \[IndentingNewLine]\[Beta]s\  = \ 
            Map[sconvvec[
                  Sign[# . 
                      trans]] &, \[Beta]s\ ]; \[IndentingNewLine]vrtriv\  = \ 
            Map[sconvvec, vrtriv]; \[IndentingNewLine]vitriv\  = \ 
            Map[sconvvec, vitriv]; \[IndentingNewLine]{Join[vrtriv, \[Beta]s, 
              vitriv]\ , 
            revs + Length[
                vrtriv]}];\[IndentingNewLine]*) \)\(\[IndentingNewLine]\)
    \(fluxes[N_, nrev_, what_]\  := \ 
        Block[\ {K, \[Beta]s, trans, revs, nN, nnrev, vrtriv, vitriv, bl, m, 
            M}, \[IndentingNewLine]{nN, nnrev, vrtriv, vitriv, bl}\  = \ 
            fluxprep[N, nrev]; \[IndentingNewLine]K\  = \ 
            If[nN\  \[Equal] \ \ {}, {}, \ 
              NullSpace[nN] // Trp]; \[IndentingNewLine]If[\ 
            K\  \[Equal] \ {}, \[IndentingNewLine]{{\[Beta]s, trans}, 
                revs}\  = \ {\ \ {{}, {}}, 
                0}\[IndentingNewLine], \[IndentingNewLine]Kir\  = \ 
              Drop[K, nnrev]; \[IndentingNewLine]If[Kir\  \[Equal] \ {}, \ 
              Kir\  = \ {0  First@K\ }]; \[IndentingNewLine]{\ {\[Beta]s, 
                  trans}\ , revs}\ \  = \ \ cutterf[
                setupelv[\ {}, Kir, \ 
                  If[what\ \  === \ gset, {}, \ 
                    Take[K, nnrev]]\ ]]; \ \[IndentingNewLine]trans\  = \ 
              trans . Trp[K] . Trp[bl]]; \[IndentingNewLine]If[
            what\ \  =!= \ 
              selvs, \[IndentingNewLine]\ \ {Join[vrtriv, 
                If[\[Beta]s\  \[Equal] \ {}, {}, \[Beta]s . trans], 
                vitriv], \ 
              revs + Length[
                  vrtriv]}\[IndentingNewLine]\ \ , \[IndentingNewLine]\ \ \
Uninstall[pairelvslink]; \ 
            pairelvslink\  = 
              Install[SNApath <> "\<pairelvs/pairelvsIFsh\>"]; \
\[IndentingNewLine]\ \ M\  = \ \ d\_1[\[Beta]s]; \[IndentingNewLine]\ \ For[\ 
              m\  = \ 1, \ 
              m\  \[LessEqual] \ M, \ \(m++\), \ \[Beta]s[\([m]\)]\  = \ 
                sconvvec@
                  Sign[\ \[Beta]s[\([m]\)] . 
                      trans]\ ]; \[IndentingNewLine]\ \ vrtriv\  = \ 
              Map[sconvvec, vrtriv]; \[IndentingNewLine]\ \ vitriv\  = \ 
              Map[sconvvec, vitriv]; \[IndentingNewLine]\ {Join[
                vrtriv, \[Beta]s, vitriv]\ , 
              revs + Length[
                  vrtriv]}]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \(fluxgset[N_, nrev_]\  := \ 
        fluxes[N, nrev, gset];\)\(\[IndentingNewLine]\)
    \(fluxelvs[N_, nrev_]\  := \ 
        fluxes[N, nrev, elvs];\)\(\[IndentingNewLine]\)
    \(signfluxelvs[N_, nrev_]\  := \ 
        fluxes[N, nrev, 
          selvs];\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(real2rat[r_]\  := \ 
        Block[\ {dig, exp}, \[IndentingNewLine]{dig, exp}\  = \ 
            RealDigits[SetPrecision[r, 12]]; \[IndentingNewLine]exp\  = \ 
            Max[Position[dig, \ x_\  /; \ x\  \[NotEqual] 0]] - 
              exp; \[IndentingNewLine]If[exp\  \[Equal] \ \(-\[Infinity]\), \ 
            0, \ \[IndentingNewLine]Round[r\ 10^exp]/
              10^exp]];\)\(\[IndentingNewLine]\)
    \(SetAttributes[real2rat, 
        Listable];\)\(\[IndentingNewLine]\)\(\ \ \ \ \ \ \ \ \)\(\
\[IndentingNewLine]\)
    \(\ \ \ \ \ \)\)\)\)], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(fluxprep[N_, nrev_]\  := \ 
        Block[\ {rtriv, itriv, triv, vrtriv, vitriv, bl, x, nN, 
            nnrev}, \[IndentingNewLine]triv\  = \ 
            Position[Trp[N], \ x_\  /; \ x\  \[Equal] \ 0  x, {1}] // 
              Flatten; \[IndentingNewLine]rtriv\  = \ 
            Cases[triv, \ 
              x_\  /; \ x\  \[LessEqual] \ 
                  nrev]; \[IndentingNewLine]itriv\  = \ 
            Cases[triv, \ 
              x_\  /; \ x\  > \ nrev]; \[IndentingNewLine]{vrtriv, vitriv, 
              bl}\  = \ 
            blowupf[rtriv, itriv, d\_2[N]]; \[IndentingNewLine]nN\  = \ 
            DeleteCases[Trp[N], \ x_\  /; \ x\  \[Equal] \ 0  x, {1}] // 
              Trp; \[IndentingNewLine]nnrev\  = \ 
            nrev\  - \ Length[rtriv]; \[IndentingNewLine]{nN, nnrev, vrtriv, 
            vitriv, bl}];\)\), "\[IndentingNewLine]", 
    \(\(blowupf[rtriv_, itriv_, len_]\  := \ 
        Block[{vrtriv, vitriv, blowup, x}, \[IndentingNewLine]blowup\  = \ 
            IdentityMatrix[len]; \[IndentingNewLine]vrtriv\  = \ 
            blowup[\([rtriv]\)]; \[IndentingNewLine]vitriv\  = \ 
            blowup[\([itriv]\)]; \[IndentingNewLine]blowup[\([rtriv]\)]\  = \ 
            0*blowup[\([rtriv]\)]\ ; \[IndentingNewLine]blowup[\([itriv]\)]\  \
= \ 0*blowup[\([itriv]\)]\ ; \[IndentingNewLine]blowup\  = \ 
            DeleteCases[Trp[blowup], x_\  /; \ x\ \  \[Equal] \ 0\ x, {1}] // 
              Trp; \[IndentingNewLine]If[\ blowup \[NotEqual] \ {}, \ 
            blowup\  = \ SparseArray@blowup]; \[IndentingNewLine]{vrtriv, 
            vitriv, blowup}];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(pruning\  = \ False;\)\), "\[IndentingNewLine]", 
    \(\(chatter\  = \ 1;\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\({negc, zerc, 
          posc}\  = \ {"\<a\>", "\<b\>", "\<c\>"};\)\), \
"\[IndentingNewLine]", 
    \(\(conv\  = \ ToCharacterCode[\ negc <> zerc <> posc];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(cutter[setup_]\ \  := \ 
        Block[\ {\[Beta]sDtrans, 
            nrev}, \[IndentingNewLine]{\ \[Beta]sDtrans\ , 
              nrev}\  = \ \ cutterf[setup]; \[IndentingNewLine]{Apply[
              Dot, \[Beta]sDtrans], \ nrev}];\)\), "\n", 
    \(\(\(cutterf[setup_]\  := \[IndentingNewLine]\ 
        Block[\[IndentingNewLine]\ \ \ \ \ \ \ \ \ {Kperm, Kdone, \ nextK, 
            revmarks, rev, revs, nrev, slv, orth, image, n, m, newnegs, new, 
            cmbsi, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \[Beta]s, \ rv, 
            hasrev, tmp, keep, cnt, cntm, more, trans, SK\[Beta]sT\ , 
            ScmbsiT, i, x\ , irrevs, 
            prune}, \[IndentingNewLine]{Kperm, revmarks, nrev, slv, orth, 
              image} = 
            setup; \[IndentingNewLine]n\  = \ \ d\_1[
              Kperm]; \ \[IndentingNewLine]If[\ 
            n\  \[Equal] \ 
              0, \ \[Beta]s\ \  = \ {}, \[IndentingNewLine]m\  = \ 
              n\ \  - \ d\_2[Kperm]; \[IndentingNewLine]\[Beta]s\  = \ 
              IdentityMatrix[n - m]; \[IndentingNewLine]Kperm\  = \ 
              MapThread[
                List, {Drop[Kperm, n - m], 
                  Drop[revmarks, n - m]}]; \[IndentingNewLine]Kdone\  = \ 
              IdentityMatrix[n - m]; \[IndentingNewLine]irrevs\ \  = \ 
              Position[Take[revmarks, n - m], False]\  // 
                Flatten; \[IndentingNewLine]revs\  = \ 
              Complement[Range[n - m], 
                irrevs]; \[IndentingNewLine]msg[{"\<cutterf:revs\>", 
                revs}]; \[IndentingNewLine]SK\[Beta]sT\  = \ 
              Map[sconvvec, 
                Transpose[Sign[\[Beta]s]]]; \[IndentingNewLine]hasrev\  = \ 
              revs\  \[NotEqual] \ {}; \[IndentingNewLine]cnt\  = \ 0; \ 
            cntm\  = \ 50; \ 
            prune\  = \ pruning; \[IndentingNewLine]While[
              Kperm\  \[NotEqual] \ {}, \[IndentingNewLine]{{nextK, rev}, 
                  Kperm}\  = {Kperm[\([1]\)], Drop[Kperm, 1]}; 
              If[prune\  && \ \((rev\  || \ \((cntm\ \((1 + 
                                Length[Kdone]/\ 
                                  Length[\[Beta]s])\)\ \  \[LessEqual] \ \ \
Length[Kdone])\))\), \[IndentingNewLine]prune\  = \ \[Not] rev; \
\[IndentingNewLine]keep = 
                  nonreds[Kdone, SK\[Beta]sT\ \ , revs, 
                    Range[n - m + 1, 
                      d\_1[Kdone]]]\ ; \[IndentingNewLine]Kdone\  = \ 
                  Kdone[\([keep]\)]; \[IndentingNewLine]SK\[Beta]sT\ \  = \ 
                  SK\[Beta]sT[\([keep]\)]; \[IndentingNewLine]cntm\  = \ 
                  Length[Kdone];\[IndentingNewLine]]; \[IndentingNewLine]tmp\ \
 = \ Join[Kdone, {nextK}]; \[IndentingNewLine]new\  = \ \[Beta]s\  . 
                  nextK; \[IndentingNewLine]newnegs\  = \ 
                Count[new, \ x_ /; \ x\  < \ 0]\  > \ 
                  0; \[IndentingNewLine]If[\ 
                hasrev\  || \ newnegs, \[IndentingNewLine]more\  = \ 
                  sconvvec[Sign[new]]; \[IndentingNewLine]{cmbsi, 
                    ScmbsiT}\  = 
                  Global`pairelvs[StringJoin[SK\[Beta]sT]\  <> more, 
                    Length[\[Beta]s], irrevs, 
                    n - m - 
                      1]; \[IndentingNewLine]If[\((Length[cmbsi]\  > \ 
                        0)\)\  || \((\ 
                      newnegs\  && \ \ \[Not] rev)\), \[IndentingNewLine]cnt\ \
 = \ cnt + 1; \[IndentingNewLine]If[\ \[Not] rev, \ 
                    keep\  = \ 
                      Position[new, x_\  /; \ x\  \[GreaterEqual] \ 0] // 
                        Flatten]; \[IndentingNewLine]\[Beta]s\  = \ 
                    Join[\ If[rev, \[Beta]s, \[Beta]s\ [\([keep]\)]]\ , \ 
                      candcomb[\[Beta]s\ , cmbsi, 
                        new]]; \[IndentingNewLine]If[\ \[Beta]s\  \[Equal] \ \
\ {}, \ Break[]]; \[IndentingNewLine]SK\[Beta]sT\  = \ 
                    Join[SK\[Beta]sT, {more}]; \[IndentingNewLine]SK\[Beta]sT\
\ \  = \ Scomb[rev, keep, SK\[Beta]sT\ \ , 
                      StringPartition[ScmbsiT, 
                        Length[
                          cmbsi]]]; \[IndentingNewLine]ScmbsiT\  = \ {}; \
\[IndentingNewLine]Kdone\  = \ 
                    tmp; \[IndentingNewLine]msg[{"\<cutterf\>", rev, 
                      Length[Kperm], \ Length[\[Beta]s], Length[Kdone], 
                      cnt, {Count[new, \ x_ /; \ x\  > \ 0], 
                        Count[new, \ 
                          x_ /; \ x\  < \ 
                              0]}}];\[IndentingNewLine]]];\[IndentingNewLine]]\
;\[IndentingNewLine]]; \[IndentingNewLine]SK\[Beta]sT\ \  = \ {}; \
\[IndentingNewLine]rv\  = 
            Map[\[Not] reversible[
                    irrevs, #] &, \[Beta]s]; \[IndentingNewLine]\[Beta]s\  = \
\ \[Beta]s\ [\([Ordering[rv]]\)]; \[IndentingNewLine]trans\  = \ 
            Trp[slv] . Trp[image]; \[IndentingNewLine]If[\ 
            orth\  \[NotEqual] \ {}, \[IndentingNewLine]If[\[Beta]s\  \
\[NotEqual] \ {}, \ \[Beta]s\  = \[Beta]s . 
                  trans]; \[IndentingNewLine]\[Beta]s\  = \ 
              Join[orth, \[Beta]s\ ]; \[IndentingNewLine]trans\  = \ 
              SparseArray[{\ {i_, i_}\  \[Rule] \ 1}, \ {d\_2[\ \[Beta]s], 
                  d\_2[\ \[Beta]s]}];]; \[IndentingNewLine]{{\[Beta]s, 
              trans}, \ Count[rv, False]\  + Length[orth]}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(reversible[
          irrevs_, \ \[Beta]_]\ \  := \ \((Length[irrevs]\ \  \[Equal] \ 
            Count[\[Beta][\([irrevs]\)], 0])\);\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(candcomb[\[Beta]s_, cmbsi_, 
          new_\ ]\  := \ \ Block[\ {comb, \ \[Lambda]\ , \[Mu]\ , s, 
            t}, \[IndentingNewLine]comb[
              pair_]\  := \ \((\[IndentingNewLine]{\ \[Lambda]\ , \[Mu]\ }\  \
= \ new[\([pair]\)]; \ \[IndentingNewLine]s\  = \ \ \
Sign[\[Lambda]]\ \ Sign[\(-\[Mu]\)]\ ; \[IndentingNewLine]t\ \  = \ \((\
\[Lambda]\ s)\) \[Beta]s[\([pair // 
                          Last]\)]\  - \ \((\[Mu]\ \ s)\) \[Beta]s[\([pair // 
                          First]\)]; \[IndentingNewLine]t/
                GCD @@ t)\); \[IndentingNewLine]Map[comb, 
            cmbsi]\[IndentingNewLine]];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(StringPartition["\<\>", 
          len_]\ \ \  := \ {};\)\), "\[IndentingNewLine]", 
    \(\(StringPartition[s_, len_]\ \  := \ 
        Block[\ {a, b}, \[IndentingNewLine]b\  = \ 
            s; \[IndentingNewLine]Table[\ \[IndentingNewLine]\((a\  = \ 
                StringTake[b, len]; \ b\  = \ StringDrop[b, len]; \ 
              a)\), \[IndentingNewLine]{StringLength[s]/
                len}]];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(Scomb[rev_, keeps_, SK\[Beta]sT_, ScmbsiT_]\  := \ 
        Block[{tt, keep}, \[IndentingNewLine]If[rev, \ 
            tt = \ SK\[Beta]sT, \[IndentingNewLine]tt = 
              Map[FromCharacterCode[\(ToCharacterCode[#]\)[\([keeps]\)]] &, 
                SK\[Beta]sT]]; \[IndentingNewLine]If[
            ScmbsiT\  \[NotEqual] \ {}, \ 
            MapThread[StringJoin, {tt, ScmbsiT}], \ 
            tt]\[IndentingNewLine]];\)\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(sconvvec[x_]\  := \ 
        FromCharacterCode[\ Map[conv[\([#]\)] &, x + 2]];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(setupelv[orth_, H_, Rev_] := \ 
        Block[\[IndentingNewLine]{HH1, HH2, HH, image, orth2, image2, \ nrev, 
            Kt, Ktr, Kperm, identK, slv, sortby, prm, revmarks, x}, 
          HH\  = \ Join[Rev, H]; \[IndentingNewLine]image\  = \ 
            NullSpace[\ 
                If[\ orth\  \[NotEqual] \ {}, \ orth, \ 
                  0\ {HH[\([1]\)]}\ ]]\  // 
              Transpose; \[IndentingNewLine]HH1\  = \ 
            If[Rev\  \[Equal] \ {}, {}, 
              DeleteCases[Rev . image, 
                x_\  /; \ x\  \[Equal] \ 0\ x]]; \[IndentingNewLine]HH2\  = \ 
            If[\ \ \ \ \ H\  \[Equal] \ {}, {}, 
              DeleteCases[H . image, 
                x_\  /; \ x\  \[Equal] \ 0\ x]]; \[IndentingNewLine]HH\  = \ 
            Join[HH1, HH2]; \[IndentingNewLine]nrev\  = \ 
            d\_1[HH1]\ ; \[IndentingNewLine]\[IndentingNewLine]{image2, 
              orth2}\  = \ split[HH, image]; \[IndentingNewLine]Kt = 
            HH . image2; \[IndentingNewLine]\[IndentingNewLine]If[\ 
            Kt\  \[Equal] \ 
              0, \ \ Return\ @{{}, {}, 0, {}, 
                orth2, {}}\ \ \ \ \ ]; \
\[IndentingNewLine]\[IndentingNewLine]prm\  = \ 
            PreRowRedOrderingheuristic[
              Drop[Kt, nrev]]; \[IndentingNewLine]prm\  = \ 
            Join[nrev + prm, \ Range[nrev]]; \[IndentingNewLine]{Ktr, 
              identK}\ \  = \ 
            RowRedPiv[Kt, prm]; \[IndentingNewLine]slv\  = \ 
            Inverse[Kt[\([identK]\)]]; \ \ Clear[
            Kt]; \[IndentingNewLine]sortby = Table[0, {d\_1[Ktr]}]; 
          sortby\[LeftDoubleBracket]Range[
                nrev]\[RightDoubleBracket] = \(-1\); 
          sortby\[LeftDoubleBracket]identK\[RightDoubleBracket] = 
            d\_2[Ktr] + 1 - Range[d\_2[Ktr]]; \[IndentingNewLine]prm\  = \ 
            ordr[Ktr, sortby]; \[IndentingNewLine]Kperm = 
            Ktr\[LeftDoubleBracket]
              prm\[RightDoubleBracket]; \[IndentingNewLine]If[
            d\_2[Ktr]\  < \ 
              d\_1[Ktr], \[IndentingNewLine]msg[\ {"\<setupelv: chain\>", 
                Map[Min[Position[#, \ x_\  /; \ x\  \[NotEqual] \ 0]] &, 
                    Trp[Drop[Kperm, d\_2[Ktr]]]] /. \ \[Infinity]\  \[Rule] \ 
                    0}]\[IndentingNewLine]]; \[IndentingNewLine]revmarks = \
\((# \[LessEqual] nrev &)\) /@ 
              prm; \[IndentingNewLine]msg[{"\<setupelv: gset steps \>", 
              Count[Drop[revmarks, d\_2[Ktr]], False], 
              d\_1[Ktr] - d\_2[Ktr] - 1}]; \[IndentingNewLine]If[
            orth2\  \[NotEqual] \ {}, \ 
            orth2\ \  = \ 
              orth2\  . Transpose[image]]; \[IndentingNewLine]{Kperm, 
            revmarks, nrev, slv, orth2, 
            image . image2}];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(split[H_, along_]\  := \ 
      Block[\ {rr, piv, aug, pivi, pivo, image, orth, 
          slv}, \[IndentingNewLine]aug\  = \ 
          Join[H, along]; \[IndentingNewLine]{rr, piv}\  = \ 
          RowRedPiv[aug, Range[d\_1[aug]]\ ]; \[IndentingNewLine]slv\  = \ 
          Inverse[aug[\([piv]\)]] // Trp; \[IndentingNewLine]pivi\  = \ 
          Count[piv, \ 
            x_\  /; \ x\  \[LessEqual] \ 
                d\_1[H]]; \[IndentingNewLine]pivr\  = \ 
          Count[piv, \ 
            x_\  /; \ x\  > \ d\_1[H]]\ ; \[IndentingNewLine]{image, 
            orth}\  = \ \[IndentingNewLine]{If[
              pivi\ \  \[Equal] \ 
                0, \ {}, \(slv[\([Range[pivi]]\)] // RowReduce\) // 
                Trp], \[IndentingNewLine]slv[\([Range[pivr] + 
                  pivi]\)]}; \[IndentingNewLine]{image, 
          orth}\ \[IndentingNewLine]]\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(first[\ {}\ ]\  := \ {};\)\), "\n", 
    \(\(first[x_]\  := \ First[x];\)\), "\[IndentingNewLine]", 
    \(\(RowRedPiv[H_, prm_] := 
        Block[{r, inv, piv}, \[IndentingNewLine]inv = prm; \ 
          inv[\([prm]\)] = Range[Length[prm]]; \[IndentingNewLine]r\  = \ 
            RowReduce[Transpose[H[\([prm]\)]]] // 
              Transpose; \[IndentingNewLine]piv\  = \ 
            Flatten[\((first[Position[r, #1]] &)\) /@ 
                IdentityMatrix[d\_2[r]]]; \[IndentingNewLine]{r[\([inv]\)], 
            prm[\([piv]\)]}];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(\(chaincrit[H_]\  := \ 
        Block[\ {ZH, zcnts, p, mp}, \[IndentingNewLine]ZH = \ 
            1 - Abs[Sign[H]]; \[IndentingNewLine]zcnts\  = \ 
            Plus @@ ZH; \ \[IndentingNewLine]p\  = \ 
            Ordering[\(-zcnts\)]; \[IndentingNewLine]ZH\  = \ \(Transpose[
                  ZH]\)[\([p]\)] // Transpose; \[IndentingNewLine]Map[
              Min[Position[#, 0]] &, ZH]\  /. \ \[Infinity]\  \[Rule] \ 
              Length[p] + 1];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(sparsecrit[H_]\  := \ \ Map[Count[#, 0] &, H];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(ordr[H_, basecrit_]\  := \ 
      Block[\ {prm, 
          crit}, \[IndentingNewLine]crit\  = \ {basecrit, chaincrit[H], 
            sparsecrit[H]}; \[IndentingNewLine]prm\  = \ 
          Ordering[\ \(-\ 
              Transpose[crit]\)]; \[IndentingNewLine]prm]\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[{
    \(\(PreRowRedOrderingheuristic[{}]\ \  := \ {};\)\), \
"\[IndentingNewLine]", 
    \(\(PreRowRedOrderingheuristic[H_]\  := 
        Block[\[IndentingNewLine]{HN, cov, evals, cuteval, sei, sevecs, Hl, 
            ovlaps, ovlapsr, reps, prm, Kperm, chains, tries, eval, qual, i, 
            v, x}, \ \[IndentingNewLine]If[\ \ d\_1[H]\  \[LessEqual] \ 
              d\_2[H], \ 
            Return[\ Range[d\_1[H]]]\ ]; \[IndentingNewLine]SeedRandom[
            1]; \ \[IndentingNewLine]Hl = H; \[IndentingNewLine]HN\  = \ 
            H\  // N; \[IndentingNewLine]HN\  = \ 
            Map[\((#/Norm[#])\) &, HN]; \[IndentingNewLine]cov\  = \ 
            Transpose[HN] . HN; \[IndentingNewLine]evals\  = 
            Eigenvalues[cov]; \[IndentingNewLine]cuteval\  = \ 
            Max[Min[evals], \ \(d\_1[H]/d\_2[H]\)/10]; \n\ \ \ \ \ \ \ sei = 
            Position[evals, \ 
                x_\  /; \ 
                  x\  \[LessEqual] \ \ cuteval] // \ \ Flatten; \n\ \ \ \ \ \ \
\ sevecs = \(Eigenvectors[cov]\)[\([sei]\)]; \[IndentingNewLine]ovlaps\  = \ 
            HN . Transpose[
                sevecs]; \[IndentingNewLine]reps[]\  := \ \[IndentingNewLine]\
\((ovlapsr\  = \ 
                ovlaps . 
                  DiagonalMatrix[
                    1 + 0.5 
                         Table[
                          Random[], {i, 
                            Length[sei]}]]; \n\ \ \ \ \ \ \ \ \ \ \ prm = 
                Ordering[
                  Map[Norm, ovlapsr]]; \[IndentingNewLine]Kperm\ \  = \ 
                SortedRowRed[H, prm]; \[IndentingNewLine]chains = 
                Map[Min[Position[#, \ x_\  /; \ x\  \[NotEqual] \ 0]] &, 
                    Trp[Drop[Kperm, 
                        d\_2[Kperm]]]]\  /. \ \[Infinity]\  \[Rule] \ 
                    0; \[IndentingNewLine]{prm, 
                chains})\); \[IndentingNewLine]tries\  = 
            Table[reps[], {i, 5}]; \[IndentingNewLine]eval[v_]\  := \ 
            Plus @@ \((v^\((1.3)\))\); \[IndentingNewLine]qual = 
            Map[eval, \(Transpose[
                  tries]\)[\([2]\)]]; \
\[IndentingNewLine]tries[\([Ordering[\(-qual\)] // First]\)] // 
            First\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(\(SortedRowRed[H_, prm_]\  := \ 
        Block[\ {ident, Ktr, 
            sortby}, \[IndentingNewLine]{Ktr, identK}\ \  = \ 
            RowRedPiv[H, prm]; \[IndentingNewLine]sortby = 
            Table[\(-1\), {d\_1[Ktr]}]; \ 
          sortby\[LeftDoubleBracket]identK\[RightDoubleBracket] = 
            d\_2[Ktr] + 1 - 
              Range[d\_2[Ktr]]; \[IndentingNewLine]Ktr[\([ordr[Ktr, 
                sortby]]\)]];\)\)}], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(nonreds[Kdone_, SK\[Beta]sT_\ , revs_, 
          checks_]\ \  := \ 
        Block[\ {ind, sc, j, jj, jsc, \ ksc, \ 
            keep}, \[IndentingNewLine]keep\  = \ 
            Range[Length[
                SK\[Beta]sT]]; \[IndentingNewLine]msg["\<nonreds: \
pruning\>"]; \[IndentingNewLine]For[ind\  = \ 1, \ 
            ind\  \[LessEqual] \ 
              Length[checks], \ \(ind++\), \[IndentingNewLine]\ 
            jj = \ checks[\([ind]\)]; \[IndentingNewLine]j\  = \ \(Position[
                  keep, jj]\)[\([1, 1]\)]; \[IndentingNewLine]\ 
            sc\  = \ SymbolicCoral[j, SK\[Beta]sT[\([keep]\)], 
                revs]; \[IndentingNewLine]\ 
            If[\ sc\  \[NotEqual] \ {}, \[IndentingNewLine]ksc\  = \ \ \
keep[\([sc]\)] \[Union] {jj}; \[IndentingNewLine]jsc\  = \ \(Position[ksc, 
                    jj]\)[\([1, 1]\)]; \[IndentingNewLine]If[
                redundant[\ Kdone[\([ksc\ ]\)], 
                  jsc]\ , \[IndentingNewLine]\(keep\ \  = \ 
                    DeleteCases[keep, 
                      jj];\)]]\[IndentingNewLine]]; \[IndentingNewLine]msg[{"\
\<nonreds: pruned\>", 
              Length[SK\[Beta]sT] - 
                Length[keep]}]; \
\[IndentingNewLine]keep];\)\[IndentingNewLine]\[IndentingNewLine]
    \(SymbolicCoral[i_, SK_, revs_]\  := \ 
        Block[\ {keep, j, sl, checks}, \[IndentingNewLine]keep\  = 
            Complement[\ Range[Length[SK]], 
              revs]; \[IndentingNewLine]keep\  = \ 
            DeleteCases[keep, i]; \[IndentingNewLine]sl\  = \ 
            StringLength[SK // First]; \[IndentingNewLine]For\ [j\  = \ 1, \ 
            j\  \[LessEqual] \ sl, \ \(j++\), \[IndentingNewLine]If[
              keep\  \[Equal] \ {}, Break[]]; \[IndentingNewLine]If[\ 
              StringTake[SK[\([i]\)], {j}]\  \[NotEqual] \ zerc, \ 
              Continue[]]; \[IndentingNewLine]checks\  = \ 
              Map[StringTake[#, {j}] &, 
                SK[\([keep]\)]]; \[IndentingNewLine]keep\  = \ 
              Extract[keep, 
                Position[checks, 
                  zerc]];\[IndentingNewLine]]; \[IndentingNewLine]keep];\)\
\[IndentingNewLine]
    \(redundant[vecl_, check_]\ \  := \ 
        Block[\ \[IndentingNewLine]{\ K, opt, l, m, box, constr, v, vv, cv, 
            red}, \[IndentingNewLine]K\  = \ 
            NullSpace[Trp[vecl]] // Trp; \[IndentingNewLine]If[\ 
            K\  \[Equal] \ {}, \ Return[False]]; \[IndentingNewLine]opt\  = \ 
            K[\([check]\)]; \[IndentingNewLine]{m, l}\  = \ 
            Dimensions[
              K]; \[IndentingNewLine]box\  = \ \ Table[{\(-1\), 1}, {i, 
                l}]; \[IndentingNewLine]constr\  = \ 
            Table[{0, 1}, {i, 
                m}]; \[IndentingNewLine]constr[\([check]\)]\  = \ {0, \
\(-1\)}; \[IndentingNewLine]\ 
          v = LinearProgramming[opt, K, constr, box\ , 
              Method \[Rule] RevisedSimplex]; 
          If[\[Not] VectorQ[\ v, NumericQ], \ 
            v\  = \ Table[0, {i, l}]]; \[IndentingNewLine]vv = \ 
            K . v; \[IndentingNewLine]cv\  = \ 
            vv . vecl; \[IndentingNewLine]vv[\([check]\)] = \
\(-vv[\([check]\)]\); \[IndentingNewLine]red\  = \ \((vv[\([check]\)]\ \  > \ 
                  0)\)\  && \ \((cv\  \[Equal] \ 
                  0\ cv)\)\  && \((Min[vv] \[GreaterEqual] \ 
                  0)\)];\)\[IndentingNewLine]
    \)\)\)], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(d\_i_[
          M_]\  := \ \ \(Dimensions[M]\)[\([i]\)]\ ;\)\[IndentingNewLine]
    \(Trp[a_]\  := \ Transpose[a];\)\n
    \(Trp[{}]\  := \ {};\)\n
    \(msgmsg1[
          expr_needsboxes]\  := \ \((\[IndentingNewLine]\(NotebookWrite[
              messagesNotebook, \[IndentingNewLine]Cell[
                BoxData[
                  expr\  /. \ 
                    needsboxes[a_]\  :> \ 
                      MakeBoxes[a, 
                        StandardForm]], "\<Output\>"]];\))\);\)\
\[IndentingNewLine]
    \(msgmsg1[expr_]\  := \ 
        NotebookWrite[
          messagesNotebook, \[IndentingNewLine]Cell[
            TextData[ToString[expr]], "\<Output\>"]];\)\[IndentingNewLine]
    \(msgmsg[
          expr_]\  := \[IndentingNewLine]\((If[
            Head[messagesNotebook]\  \[Equal] \ Symbol, 
            messagesNotebook\  = \ \(Notebooks["\<Messages\>"]\)[\([1]\)]\ ]; \
\ \[IndentingNewLine]msgmsg1[
            expr];\ \[IndentingNewLine])\);\)\[IndentingNewLine]
    \(msg[expr_]\  := \ \[IndentingNewLine]If[\ 
          Abs[chatter]\  > \ 0, \[IndentingNewLine]If[\ chatter\  > \ 0, \ 
            msgmsg[expr], \ 
            Print[expr\  /. \ 
                needsboxes[a_]\  :> \ a]]];\)\[IndentingNewLine]
    \(msg1[expr_]\  := \ msg[expr];\)\)\)\)], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(\(End[]\ \ EndPackage[];\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  InitializationCell->True,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
},
FrontEndVersion->"5.1 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
AutoGeneratedPackage->Automatic,
WindowSize->{897, 712},
WindowMargins->{{Automatic, 8}, {2, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 568, 13, 91, "Input",
  InitializationCell->True],
Cell[2325, 66, 380, 12, 27, "Input",
  InitializationCell->True],
Cell[2708, 80, 93, 2, 43, "Input",
  Evaluatable->False],
Cell[2804, 84, 2070, 33, 459, "Input",
  InitializationCell->True],
Cell[4877, 119, 88, 2, 27, "Input",
  InitializationCell->True],
Cell[4968, 123, 6487, 122, 1131, "Input",
  InitializationCell->True],
Cell[11458, 247, 1720, 30, 283, "Input",
  InitializationCell->True],
Cell[13181, 279, 208, 5, 43, "Input",
  InitializationCell->True],
Cell[13392, 286, 289, 7, 43, "Input",
  InitializationCell->True],
Cell[13684, 295, 6367, 111, 1115, "Input",
  InitializationCell->True],
Cell[20054, 408, 1159, 22, 235, "Input",
  InitializationCell->True],
Cell[21216, 432, 4388, 81, 779, "Input",
  InitializationCell->True],
Cell[25607, 515, 1012, 20, 219, "Input",
  InitializationCell->True],
Cell[26622, 537, 2786, 53, 475, "Input",
  InitializationCell->True],
Cell[29411, 592, 3527, 66, 715, "Input",
  InitializationCell->True],
Cell[32941, 660, 1436, 32, 283, "Input",
  InitializationCell->True],
Cell[34380, 694, 244, 5, 27, "Input",
  InitializationCell->True]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

