(*******************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which
typically will have the same name as this file except ending in
".nb" instead of ".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent
to using the Evaluate Initialization Cells menu command in the front
end.

DO NOT EDIT THIS FILE.  This entire file is regenerated
automatically each time the parent Notebook file is saved in the
Mathematica front end.  Any changes you make to this file will be
overwritten.
***********************************************************************)

(*  Author:     R. Urbanczik,
     Load with:  <<"SNAsym.m"
  *)

defaultpath = "~/SNA/mathcode/";
Get[If[$Input \[Equal] "",defaultpath,DirectoryName[$Input]]<>"SNAmat.m"];






BeginPackage["SNAsym`",{"SNAmat`","Global`"}];


iwith[pat_List,l_List] := Module[{mark},
      iwith[mark, l /. Map[ (#\[Rule] mark)&,pat]]];
iwith[pat_,l_List] := Map[First,Position[l,pat]] //Union;
with[pat_,l_List] := l[[iwith[pat,l]]];



Trp[a_] := Transpose[a];
Trp[{}] := {};

gcd[x___] := If [ x \[Equal] 0 x, 1, GCD[x]];





meta /: MakeBoxes[meta[Int,species_String,compartment_String],StandardForm] := 
    SuperscriptBox[
      MakeBoxes[species,StandardForm],
      MakeBoxes[compartment]];
meta /: MakeBoxes[meta[role_,species_String,compartment_String],
      StandardForm] := SubsuperscriptBox[
      MakeBoxes[species,StandardForm],
      MakeBoxes[role,StandardForm],
      MakeBoxes[compartment]];
MakeExpression[
       SubsuperscriptBox[species_String,role_,compartment_String],
      StandardForm] :=
    MakeExpression[
      RowBox[{"meta","[",role,",",species,",",compartment,"]"}],
      StandardForm];
 MakeExpression[ 
      SuperscriptBox[species_String,compartment_String],StandardForm] :=
    
    MakeExpression[
      RowBox[{"meta","[",Int,",",species,",",compartment,"]"}],
      StandardForm];

RightVector /: MakeBoxes[ RightVector[a_,b_],StandardForm]:=
  
  RowBox[{MakeBoxes[a,StandardForm],
      StyleBox["\[RightVector]",
        FontSize\[Rule]Options[Notebook,FontSize][[1,2]]+6],
      MakeBoxes[b,StandardForm]}]
 Equilibrium /:  MakeBoxes[Equilibrium[a_,b_],StandardForm]:=
  
  RowBox[{MakeBoxes[a,StandardForm],
      StyleBox["\[Equilibrium]",
        FontSize\[Rule]Options[Notebook,FontSize][[1,2]]+6],
      MakeBoxes[b,StandardForm]}]



roles = {Int,Xt,Xtin,Xtout};



makemnet[reacs_,tags_] := Block[ {t},
      t = {reacs,tags} //Transpose //Sort //Transpose;
      Apply[mnet, t]];
makemnet[ {}, {}] = mnet[ {},{}];


metabolites[mnet[reacs_,tags_]] := 
    Cases[reacs,meta[___],\[Infinity]]//Union;
reactions[mnet[reacs_,tags_]] := reacs;
tags[mnet[reacs_,tgs_]]  := tgs;
trpairs[mnet[reacs_,tgs_]] := {tgs,reacs}//Transpose

roleQ[x_] := MemberQ[roles,x] || (Head[x] === Xt);

setrole::"norole" = "`1` not in `2`";
setrole[net_mnet,metas_List,role_] := 
    Block[ {x,y,nm,tmp},
      nm = metas/. meta[_,x_,y_] \[Rule] meta[role,x,y];
      tmp =  reactions[net] /. MapThread[Rule,{metas,nm}];
      makemnet[tmp, net//tags]
        /;
        
        If[roleQ[role],True, Message[setrole::"norole",role,roles]]
      ];
setrole[net_mnet,met_meta,role_] := setrole[net,{met},role];



mnet2stoich[net_mnet] := Block[ {rr,intsl,nrev,rep,mat,fac},
      rr = reactions[net];
      nrev =({0}\[Union]Position[rr,x_ \[Equilibrium] y_])//Max;
      intsl= metabolites[net];
      If[ intsl \[Equal] {}, Return[ {{0 rr},nrev}]];
      rrl = 
        rr/.  (x_ \[Equilibrium]y_ )\[Rule]  
              y-x + fac intsl[[1]] /. (x_ \[RightVector] y_ )\[Rule]  
            y-x +fac intsl[[1]] ;
      rep = MapThread[Rule,{intsl,IdentityMatrix[Length[intsl]]}];
      mat = rrl /. rep /. fac \[Rule] 0;
      {mat //Trp, nrev} ];

stoich2reacs[mm_,ints_, nr_] := Block[ {rr,arrsimp,x,y},
      arrsimp[ b_] := Module[ {ins},
          ins =Plus@@Cases[b, x_  y_/; x< 0,{0,1}];
          (-ins) \[RightVector] (b-ins) 
          ];
      rr = Transpose[mm].ints;
      rr = Map[arrsimp,rr] ;
      MapIndexed[ 
        If[#2[[1]] > 
              nr,#1, #1 /. (x_ \[RightVector] y_) \[Rule] (x \[Equilibrium] 
                    y)]&,rr]
      ];
stoich2reacs[{},_, 0]  := {}; 
stoich2reacs[mm_,{}, nr_] := stoich2reacs[0 mm,{dummy},nr];


constructmnet::"Length"  = "Length[reacs] \[NotEqual] Length[tagnames]";
constructmnet::"Metabolite Syntax" = "Errors in `1`";
constructmnet::"Reaction Syntax" = "Errors in `1`";
constructmnet::"Stoichiometric Factors" = "`1` illegal";
constructmnet[reacs_List,tagnames_List] := 
    Block[ {nn,mets,badmets,r,mm,nrev,mml,a,b},
      If[ Length[reacs] \[NotEqual] Length[tagnames], 
        Message[constructmnet::"Length"]; Return[$Failed]];
      nn=makemnet[reacs,Map[R,tagnames]];
      mets = metabolites@nn;
      badmets = DeleteCases[mets, meta[r_ /;  roleQ[r], _String, _String]];
      If[badmets \[NotEqual] {}, 
        Message[constructmnet::"Metabolite Syntax",badmets]; 
        Return[$Failed]];
      mml = (reactions@nn) /. 
            meta[___] \[Rule] 
              0 /. (a_ \[Equilibrium] b_) \[Rule] (a \[RightVector] b);
      mml = {mml, reactions@nn} //Trp;
      mml = DeleteCases[mml, {0 \[RightVector] 0, _}];
             If[mml \[NotEqual] {}, 
          Message[constructmnet::"Reaction Syntax",Map[Last,mml]]; 
        Return[$Failed]];
      {mm,nrev} = mnet2stoich[nn];
      mml = DeleteCases[DeleteCases[Flatten[mm],_Integer],_Rational];
      If[mml \[NotEqual] {}, 
        Message[constructmnet::"Stoichiometric Factors",mml//Union]; 
        Return[$Failed]];
      makemnet[ stoich2reacs[mm,mets,nrev], tags@nn]
      ];



exch[ext_meta]  :=
    Switch[ext[[1]], 
        Xt,        Rx[ ext \[Equilibrium] 0],
        Xtin,   Rx[0  \[RightVector] ext],
        Xtout, Rx [ext   \[RightVector] 0],
         _        , Hold[Sequence[]]] //ReleaseHold;
SetAttributes[exch,Listable];

addexchanges::"double"="Exchange reactions already previously added";
addexchanges[net_mnet,mRx_] := Block[{ex,a},
    If[ {} \[NotEqual] iwith[Rx[_],tags@net],
      Message[addexchanges::"double" ]; Return[net]];
    ex = with[{Xt,Xtin,Xtout},metabolites@net]//exch;
    ex = ex /. Rx[a_] \[Rule] a;
    makemnet[Join[reactions[net],ex], Join[tags[net], Map[mRx,ex]]]
    ]
addexchanges[net_mnet] :=addexchanges[net,Rx];


irrevmnet[net_mnet] := Block[{ x,y,revpos,revrev,r,t},
      r = reactions[net];
      t = tags[net];
      revpos = Position[r, x_ \[Equilibrium] y_ ] //Flatten;
      revrev = 
        r[[revpos]] /. x_ \[Equilibrium] y_ \[Rule] y \[RightVector] x;
      r = r /. x_ \[Equilibrium] y_ \[Rule] x \[RightVector] y;
      makemnet[ Join[r,revrev], Join[t,-t[[revpos]]]]
      ];

revmnet[net_mnet] := Block[ {x,y,z,abs,pairs,inet,rpairs,rr},
      abs[{z_,x_  \[RightVector] y_}] := Sort[{x,y,z,-z}];
      inet = irrevmnet[net];
      pairs = {tags[inet],reactions[inet]} //Transpose;
      pairs =pairs[[ Ordering[Map[abs,pairs]] ]];
      pairs = Split[pairs,(abs[#1] \[Equal] abs[#2])&];
      pairs = Map[Sort,pairs];
      rpairs = Map[Last,pairs];
      rr = Map[Last,rpairs];
      revpos = Position[pairs, x_ /; Length[x] > 1,{1}]//Flatten;
      rr[[revpos]] = 
        rr[[revpos]] /. x_  \[RightVector] y_ \[Rule] x \[Equilibrium]y;
      makemnet[rr,Map[First,rpairs]]
      ];








submnet[net_mnet,keep_]  :=makemnet[reactions[net][[keep]],tags[net][[keep]]];
submnetwith[metas_,net_mnet]  :=
  submnet[net,iwith[metas, reactions[net]]];
splitmnet[net_mnet, onmets_] := Block[ {hasis},
    hasis = iwith[onmets, reactions[net]];
    {submnet[net,hasis],
      submnet[net,Complement[ net//reactions//Length//Range,hasis]]}]

joinmnet[net1_mnet, net2_mnet] := 
    makemnet[ Join[reactions[net1],reactions[net2]],  
                          Join[tags[net1],tags[net2]]];




fixduplicates[net_mnet] := Block[ {rr,tgs,reacs,a,b},
      rr = {reactions@net, tags@net} //Transpose;
      rr= 
        Split[rr,( (First[#1] \[Equal] First[#2])&&
                MatchQ[First[#1], a_ \[RightVector] b_])&];
      reacs = Map[(First@First@#)&,rr];
      tgs = Map[Last,rr,{2}];
      tgs = Replace[tgs , { {a_} \[Rule] a , {a__} \[Rule] ALT[a]},{1}];
      makemnet[reacs,tgs]
      ];
fixdeadend[net_mnet] := 
  Block[ {rr,tgs,duds,duds1,dudreacs,mr,mrt,posm,negm ,pmm,nrev,keep,y},
    {mr,nrev} = mnet2stoich[net]; 
    mr = Sign[mr];
    duds = Position[ Map[Count[#, x_ /; x \[NotEqual] 0]&,mr], 1]; 
    mrt = Trp[mr];
    posm = Position[Map[(Max@@#)&,         Trp[Drop[mrt,nrev]]],1];
    negm = Position[Map[(Min@@#)&,         Trp[Drop[mrt,nrev]]],-1];
    pmm   = Position[Map[(Max@@#)&,Abs[Trp[Take[mrt,nrev]]]],1];
    pmm = pmm\[Union](posm \[Intersection]negm );
    duds1 = Complement[posm\[Union]negm,pmm];
    duds = (duds\[Union]duds1) //Flatten;
    msg[{"fixdeadend",metabolites[net][[duds]]}//needsboxes];
    dudreacs = Map[Position[ mr[[#]], y_/; y \[NotEqual] 0][[1]]&,duds];
    dudreacs = 
      Position[ Plus@@Abs[mr[[duds]]],x_ /; x \[NotEqual]0] //Flatten;
    
    rr = reactions[net]; tgs = tags[net];
    keep = Complement[Range[Length[rr]],dudreacs];
    makemnet[rr[[keep]],tgs[[keep]]]
    ]


fixsingles[mnet[{},{}],keepext_] := mnet[{},{}];
fixsingles[net_mnet,keepext_] := Block[ {m,mT,nrev,rrnew,i,combs,maxmet},
    msg["fixsingles"];
    {m,nrev} = mnet2stoich[net]; 
    m = Join[m,{tags[net]}];
    maxmet = If[keepext, 
                           iwith[Int,metabolites[net]]//Length,
                           First[Dimensions[m]]-1];
    Do[m = simp[m,i,nrev],{i,maxmet}];
    mT = Trp[m];
    mT=Map[ (#/gcd@@Drop[#,-1])&,mT];
    m = Trp[mT];
    rrnew = stoich2reacs[Drop[m,-1],metabolites[net],nrev]; 
    combs = Expand[Last[m]] ;
    FixedPoint[fixdeadend,
      makemnet[rrnew,combs]//fixduplicates]
    ];
simp[m_,i_,nrev_] := Block[ {nz1,nz2,nzr,j,vl,vk,l,k,mmT,vli,vki},
      nzr = Position[Take[m[[i]],nrev], x_/; x \[NotEqual]0]//Flatten;
      If[Length[nzr] > 1, Return[m]];                
      nz1 = nrev+Position[Drop[m[[i]],nrev], x_/; x >0]//Flatten;
      nz2 = nrev+Position[Drop[m[[i]],nrev], x_/; x <0]//Flatten;
      If[Length[nz1] *Length[nz2]*Length[nzr] > 0, Return[m]];
      If[Length[nz1]  > Length[nz2] , {nz1,nz2} = {nz2,nz1}];
      nz1=Join[nzr,nz1];
      If[Length[nz1]  \[NotEqual] 1, {nz1,nz2} = {nz2,nz1}];
      If[ Length[nz1]  \[NotEqual] 1,    Return[m],   
        l = nz1[[1]];
        mmT = Trp[m];
        vl = mmT[[l]];
        Do[
          k  = nz2[[j]];
          vk = mmT[[k]];
          {vli,vki} = {vl[[i]],vk[[i]] }/GCD[vl[[i]],vk[[i]]];
          mmT[[k]] =Sign[-vki vli]Abs[vki] vl +Abs[vli]vk ,
          {j,Length[nz2]}];
        Transpose[mmT]
        ]
      ];

firstnz[x_] := If[ x \[Equal] 0 x, 1,First@DeleteCases[x,0] ];

linksimp[mnet[{},{}]] := mnet[{},{}];
linksimp[net_mnet] := 
  Block[{mm,nrev,K,sub,pp,gr,grf,first,nmmT,irr,nirr,nmm,nnrev},
    {mm,nrev} = mnet2stoich[net]; 
         K =NullSpace[mm]//Transpose;
    mm = Join[mm,{tags@net}];
    first = Map[firstnz,K];
        sub=K/first;
    pp=Ordering[sub];
        gr=Split[pp,(sub[[#1]] \[Equal] sub[[#2]])&];
    grf = Map[( first[[#]])&,gr];
    grf = Map[ (Sign[Last[#]]#)&,grf];
    cc=MapThread[ 
        MapThread[Function[{a,b},If[ b\[LessEqual]nrev,Abs[a],a]],{#1,#2}]& ,
                                    {grf,gr}];
    cc=Map[Min,cc];
    gr=MapThread[ If[#2 < 0,Sequence@@Transpose[{#1}],#1]&, {gr,cc}];
    grf = Map[( first[[#]])&,gr];
    grf = Map[(#/gcd@@#)&,grf];
    grf = Map[ (Sign[Last[#]]#)&,grf];
    nmmT=MapThread[Plus@@(Transpose[mm][[#1]]*#2)&, {gr,grf}];
    irr = Table[i > nrev,{i,Last@Dimensions@mm}];
    nirr =Map[ (Or@@irr[[#]])&,gr];
    nmm = nmmT[[Ordering[nirr]]]//Transpose;
    nnrev = Count[nirr,False];
    msg[{"linksimp",Map[((tags@net)[[#]])&,Cases[gr, {_,__}]]}//needsboxes];
    makemnet[ 
      stoich2reacs[Drop[nmm,-1],metabolites@net,nnrev],
      Expand@Last@nmm]
    ]









kersimp[mnet[{},{}]] := mnet[{},{}];
kersimp[net_mnet] := Block[
       {mm,nrev,K,Kir,box,cc,constr,vv, keep,l,m},
      {mm,nrev} = mnet2stoich[net]; 
      K =NullSpace[mm];
      If[K \[Equal] {}, Return[ mnet[{},{}]]];
      Kir = Drop[Trp[K],nrev]//Trp;
      If[Kir \[Equal] {}, Return[ net]];
      {m,l}=Dimensions[Kir];
      cc = Table[1,{i,l}];
      constr = Table[{0,0},{i,m}];
      box =  Table[{0,1},{i,l}];
      vv=LinearProgramming[-cc,Kir,constr,box ,Method->"RevisedSimplex"];
      keep= Position[vv, 0] //Flatten;
      keep = Join[Range[1,nrev], nrev+keep];
      msg[{"kersimp", Complement[tags@net,tags[net][[keep]]]}//needsboxes];
      submnet[net,keep]];



feasiblereac[net_mnet,target_] :=
    
    Block[ {targetl,K,Kir,m,n,constr,box,mm,nrev,cc,res,check},
      targetl = If[AtomQ[target],{target},target];
      {mm,nrev} =   mnet2stoich[net];
      K = NullSpace[mm]//Trp;
      If[K  \[Equal] {}, 
        Return@Map[ If[ #  \[LessEqual] nrev, {0,0},0]&,targetl]];
      Kir = Drop[K,nrev];
      If[Kir \[Equal] {}, Return@Table[{1,-1},{Length@target}]];
      m =First@ Dimensions@Kir;
      n =  Last@Dimensions@Kir;
      constr = Table[{0,1},{m}];
      box =  Table[{-1,1},{n}];
      check[targt_] := (
          cc = K[[targt]];
          
          res =cc.LinearProgramming[-cc,Kir,constr,box,
                Method->"RevisedSimplex"];
          If[targt \[LessEqual] nrev,
            {res,
              cc.LinearProgramming[cc,Kir,constr,box,
                  Method->"RevisedSimplex"]},
            res]);
      Map[check,targetl] 
      ];
revsimp[net_mnet] := Module[{nrev,checks,keep,ir1,ir2,trs,x,y,z},
      nrev =({0}\[Union]Position[reactions@net,x_ \[Equilibrium] y_])//Max;
      checks = feasiblereac[net,Range[nrev]];
      keep = Position[checks, x_ /; x \[NotEqual] {0,0},{1}]//Flatten;
      ir1 =  Position[checks, x_List /; x[[2]] \[Equal]  0,{1}]//Flatten;
      ir2 =  Position[checks, x_List /; x[[1]] \[Equal]  0,{1}]//Flatten;
      msg[{"revsimp",tags[net][[ir1]],tags[net][[ir2]]}//needsboxes];
      trs = trpairs@net;
      trs[[ir1]] = 
        trs[[ir1]] /. {z_,x_\[Equilibrium] y_} \[Rule] {z, 
              x \[RightVector]y};
      trs[[ir2]] = 
        trs[[ir2]] /. {z_,x_\[Equilibrium] y_} \[Rule] {z, 
              y \[RightVector]x};
      keep = Join[keep, Range[nrev+1,Length@trs]] ;
      trs = If[ keep \[NotEqual] {},trs[[keep]] //Transpose,  { {},{} } ];
      makemnet[Last@trs,First@trs]
      ];

fluxsimp[net_mnet,keepext_] := Block[ {s},
      s = net//fixduplicates//fixdeadend;
      s = FixedPoint[fixsingles[#,keepext]&,s];
      s=If[keepext,
          
          FixedPoint[
            Composition[fixsingles[#,keepext]&,
              kersimp                        ],s],
          FixedPoint[Composition[fixsingles[#,keepext]&,kersimp ,linksimp],
            s]];
      s=revsimp[s];
      If[keepext,
        FixedPoint[fixsingles[#,keepext]&,s],
        FixedPoint[Composition[linksimp,fixsingles[#,keepext]&],s]]
      ];
fluxsimp[net_mnet] := fluxsimp[net,False];


feasiblemnet0[net_mnet] := Block[ {fn,fr,x},
      fr = reactions@net;
      fn = makemnet[ fr, Map[R,Range@Length@fr]];
      fn = fluxsimp[fn,False];
      fn = Cases[tags@fn, R[x_] \[Rule]x,{0,\[Infinity]}] //Union;
      makemnet[fr[[fn]], (tags@net)[[fn]]]
      ];
feasiblemnet[net_mnet] := Block[ {fn,tgs,keep}, Module[{myRx},
         fn = feasiblemnet0[addexchanges[net,myRx]];
        tgs = tags[fn];
        keep = Complement[Range[Length[tgs]], iwith[myRx,tgs]];
        submnet[fn,keep ]]];





ALTexp[sf_] := Block[{first,trans},
      first = Cases[sf //Expand,ALT[__],{0,2}] ;
      If[ first \[Equal]  {}, Return[{sf}]];
      first = First[first];
      trans = List@@first;
      {(sf /. first \[Rule] trans) //Expand}
      ];
ALTexp[sf_List] := Map[ALTexp,sf]//Flatten;
ALTexpfull[sf_] := FixedPoint[ALTexp,sf];

symflux[net_mnet, elvsorgset_] := Block[{t,m,nrev,res},
      t = fluxsimp[addexchanges[net],False];
      {m,nrev} = mnet2stoich[t];
      If[m \[Equal] {{}}, Return[{{},0}]];
      {res ,nrev} = elvsorgset[m,nrev];
      res = Map[(#/gcd@@#)&,res];
      res = res.tags[t] //Expand;
      res = Map[ALTexpfull,res];
      nrev = Plus@@Map[Length,res[[nrev //Range]] ];
      res =
         Map[
           Expand[#/gcd@@(Cases[#,x_. y_/; NumberQ[x]\[Rule]x,{1}])]&, 
           res//Flatten];
      {res ,nrev}];
symfluxelvs[net_mnet] := symflux[net,fluxelvs];
symfluxgset[net_mnet] := symflux[net,fluxgset];

factorsof[names_List,sum_] := Block[ {sum0,res}, Module[ {zero},
        sum0 = sum /. Map[(# \[Rule] 0)&,names];
        res = Expand[sum - sum0 +zero];
        res  = 
          res  /.
            Join[ {zero \[Rule] Table[0,{Length@names}]},
                        MapThread[Rule,{names ,IdentityMatrix@Length@names}]]
        ]];
factorsof[name_,sum_List] :=  factorsof[{name},sum] //Flatten;
factorsof[name_,sum_] :=  factorsof[{name},sum] //First;



fixrevints[mnet[{},{}]] := mnet[{},{}];
fixrevints[net_mnet] := Block[ {m,nrev,rrnew,i,combs,maxint,drop,keep},
    msg["fixrevints"];
    {m,nrev} = mnet2stoich[net]; 
    m = Join[m,{tags[net]}];
    maxint =  iwith[Int,metabolites[net]]//Length;
    m= revsimpint[m,nrev,maxint];
    rrnew = stoich2reacs[Drop[m,-1],metabolites[net],nrev]; 
    combs = Expand[Last[m]] ;
    makemnet[rrnew,combs]//fixdeadend];
revsimpint[m_,nrev_,maxpiv_] := Block[ {mmT,l,k,piv,i,vli,vki,nrm}, 
    mmT = Trp[m];
    For[ l =1, l \[LessEqual] nrev, l++,
      vl = mmT[[l]];
      piv = Position[vl, x_ /;x \[NotEqual]0,{1}] //Flatten; 
      piv = Cases[piv,x_ /; x \[LessEqual] maxpiv];
      If[ Length[piv]  >  0,
        i = First[piv];
        For[k = l+1, k\[LessEqual] Length[mmT], k++, 
          vk = mmT[[k]]; 
          If[vk[[i]] \[NotEqual] 0, 
            {vli,vki} = {vl[[i]],vk[[i]] }/GCD[vl[[i]],vk[[i]]];
            vk =Expand[Sign[-vki vli]Abs[vki] vl +Abs[vli]vk ]; 
            mmT[[k]] = vk/gcd@@Drop[vk,-1];
            ]]]];
    Trp[mmT]]




convsimp[net_mnet ] := Block[{snet,keep,tgs},Module[{myRx},
        snet= fluxsimp[addexchanges[net,myRx],True] //fixrevints;
        snet=FixedPoint[fixsingles[#,True]&,snet];
        tgs = tags[snet];
        keep = Complement[Range[Length[tgs]], iwith[myRx,tgs]];
        submnet[snet,keep ]
        ]];



nonredl[vecl_]  := Block[ {keep,K,i,j,opt,l,m,box,constr,v},
      keep = Range[Length[vecl]];
      red = True;
      For[j = Length[vecl], j \[GreaterEqual] 1, j--,
        If[red, 
          K = NullSpace[Trp[vecl[[keep]]]]//Trp; 
          If[ K \[Equal]{}, Return[keep]];
          {m,l} = Dimensions[K]; 
          red=False];
        opt = K[[j]];
        box =  Table[{-1,1},{i,l}];
        constr = Table[{0,1},{i,m}];
        constr[[j]] = {0,-1};
         v=
          LinearProgramming[opt,K//N,constr,box ,
            Method\[Rule]InteriorPoint]; 
         If[\[Not]VectorQ[ v,NumericQ] , msg[{"nonredl x",j}];v = -opt];
         If[ opt.v\[LessEqual] -0.0003,
           v=LinearProgramming[opt,K,constr,box ,Method\[Rule]RevisedSimplex];
          If[\[Not]VectorQ[ v,NumericQ], v = 0 opt];
          vv= K.v;
          cv = vv.vecl[[keep]];
          vv[[j]]=-vv[[j]];
          
          red = (vv[[j]]  > 0) && (cv \[Equal] 
                  0 cv) &&(Min[vv] \[GreaterEqual] 0);
          If[red,
            keep =Drop[keep,{j}];
            msg[{"nonredl",j,Length[keep]}]]];
        ];
      keep];
nonredmnet[mnet[{},{}]] := mnet[{},{}];
nonredmnet[net__mnet] := Block[ {inet,mreac,nrev,keep,nnrev},
      inet = irrevmnet[net];
      {mreac,nrev} = mnet2stoich[inet];
      keep = nonredl[Trp[mreac]];
      revmnet[submnet[inet,keep]]];

convfullsimp[net_mnet ]  :=
    
    FixedPoint[Composition[nonredmnet,convsimp],net];



conversions[mnet[{},{}],_] := mnet[{},{}];
conversions[net_mnet ,ZH2gsetorelvs_ ] := 
    Block[ {m,nrev,dg,drev,intnum,xtmet,id,newconstr,oprun},
      {m,nrev} = mnet2stoich[net];
      m = Trp[m];
      {dg,drev} = ZH2gset[Take[m,nrev],Drop[m,nrev]];
      intnum = iwith[Int,metabolites[net]] //Length;
      xtmet = Drop[metabolites[net],intnum];
      dg = Map[Drop[#,intnum]&,dg];
      dg = Map[(#/(gcd@@#))&,dg];
      id = IdentityMatrix[Length[xtmet]];
      newconstr = (-id[[iwith[Xtin,xtmet]]])\[Union]id[[iwith[Xtout,xtmet]]];
      dg = Join[dg,newconstr];
      oprun = pruning; pruning = intnum > 0;
      {dg,drev}  =
         If[dg  \[NotEqual] {},ZH2gsetorelvs [Take[dg,drev],Drop[dg,drev]],
                                    {id,Length[id]}];
      pruning = oprun;
      dg = Map[(#/(gcd@@#))&,dg];
      makemnet[
        stoich2reacs[Trp[dg],xtmet,drev],
        MapIndexed[(Unique[dummy][#2])&,dg]]
      ];



partialconversions[mnet[{},{}],_List] := mnet[{},{}];
partialconversions[net_mnet , intmets_List] := Block[
    {metas,iintmets,effxt,teffxt,part,rest,pc},
    metas = metabolites[net];
    iintmets = with[Int,metas] \[Intersection] intmets;
    {part,rest} = splitmnet[net,iintmets];
    effxt = Complement[metabolites[part],iintmets];
    teffxt  = effxt /. meta[a_,b_,c_] \[Rule] meta[Xt[ToString[a]],b,c];
    part = part /. MapThread[Rule,{effxt,teffxt}];
    pc = conversions[part,ZH2gset] /.  MapThread[Rule,{teffxt,effxt}];
    joinmnet[pc,rest]
    ];











conversiongset[net_mnet] := 
    conversions[convfullsimp[net],ZH2gset] //reactions;
conversionelvs[net_mnet] := 
    conversions[convfullsimp[net],ZH2elvs] //reactions;



FBAsimp[net_mnet,{simplification_,exchonly_ }] := 
    Block[ {res,tgs,keep}, Module[ {myRx},
        If[simplification \[Equal] 0, Return[net]];
        res =addexchanges[net,myRx];
        If[\[Not]exchonly,
          res =  FixedPoint[fixdeadend,res];
          If[simplification > 1, res =  feasiblemnet0[res]];
          ,
          If[simplification \[Equal] 1,
                res = FixedPoint[fixdeadend,fixduplicates@res] ;
                res=fixrevints@FixedPoint[fixsingles[#,True]&,res]
            ];
          If[simplification == 2,
              res  = fluxsimp[res,True]; 
              res =FixedPoint[fixsingles[#,True]&, fixrevints@res]
            ];
          If[simplification > 2,
                res=convfullsimp[net];
            ];
          ];
        tgs = tags[res];
        keep = Complement[Range[Length[tgs]], iwith[myRx,tgs]];
        res=submnet[res,keep ];
        msg[{"FBAsimp", Length@reactions@res,Length@metabolites@res}];
        res
        ]];

Options[FBAprep] = {simplification \[Rule] 1,  exchonly \[Rule] False, 
      numeric \[Rule] False};
FBAprep[inet_mnet, opts___] := 
    Block[ {m,nrev,ints,Kint,extmat,rconstr,mconstr,extmet,tmp,xlat,
                     simplification , exchonly , numeric,net},
      {simplification ,exchonly , numeric} = 
        {simplification , exchonly , numeric}  /. {opts} /. Options[FBAprep];
      net = FBAsimp[inet,{simplification , exchonly }];
      {m,nrev} = mnet2stoich[net];
      ints = iwith[Int,metabolites@net];
      Kint = NullSpace[ m[[ints]] ]//Trp;
      extmet = with[{Xt,Xtin,Xtout},metabolites@net] ;
      extmat = m[[ iwith[{Xt,Xtin,Xtout},metabolites@net]  ]].Kint;
      tmp = iwith[Xtin,extmet];
      extmat[[tmp]] = -extmat[[tmp]];
      rconstr = 
        Join[Table[ {-\[Infinity],\[Infinity]},{nrev}],
          Table[ {0,\[Infinity]},{Length[Kint]-nrev}]];
      mconstr =
        extmet /.  meta[Xt,_,_] \[Rule] {-\[Infinity],\[Infinity]} /. 
          meta[_,_,_] \[Rule]   {0,\[Infinity]};
      xlat = Join[tags@net,exch[extmet]];
      xlat = MapThread[Rule,{xlat,Range@Length@xlat}];
      {net,Join[Kint,extmat],Join[rconstr,mconstr],xlat,numeric}];







FBA::"Objective Reaction" = "`1` not found";
FBA::"Infeasible constraints" = "`1`, ignored";
FBA[ {net_mnet,K_,dconstr_,xlat_,numeric_},
              fac_. opt_R |  fac_. opt_Rx,
              constr_] :=
     
    Block[ {nconstr,a,b,c,Constr,optv,lpm,lpb,nontriv,eqs,ineqs,res,infeas,
        infeas1},
       nconstr = constr /. xlat;
      infeas = DeleteCases[nconstr,{_Integer,_}];
      infeas1 = 
        infeas /. {a_,{b_,c_}}  \[RuleDelayed]( 
              b \[LessEqual] 0 \[LessEqual]c);
      infeas1 = iwith[False,infeas1];
      If[ infeas1 \[NotEqual] {}, 
        Message[FBA::"Infeasible constraints",infeas[[infeas1]]]]; 
       nconstr = Cases[nconstr,{_Integer,_}]//Trp;
       Constr = dconstr; 
      If[constr \[NotEqual] {}, Constr[[First@nconstr]] = Last@nconstr];
      eqs = Position[Constr,{a_,a_},{1}] //Flatten;
      ineqs = Complement[Range@Length@Constr,eqs];
      lpm = Join[K[[eqs]],K[[ineqs]],K[[ineqs]]];
      lpb = Join[ 
           Constr[[eqs]]      /. {a_,a_} \[Rule] {a,0},
           Constr[[ineqs]] /. {a_,b_} \[Rule] {a,1}, 
          Constr [[ineqs]] /. {a_,b_} \[Rule] {b,-1}];
      nontriv=Position[lpb, {a_,b_}/; a b \[NotEqual]-\[Infinity],{1}];
      lpm = Extract[lpm,nontriv];
      lpb = Extract[lpb,nontriv];
      optv =  opt /. xlat;
      If[\[Not]IntegerQ[optv],
        Message[FBA::"Objective Reaction",opt]; Return[$Failed]];
      optv = -fac K[[ optv]];
      res=If[numeric,
          LinearProgramming[optv,lpm//N,lpb,-\[Infinity]+0First[lpm]],
          
          LinearProgramming[optv,lpm,          lpb,-\[Infinity]+0First[lpm],
            Method\[Rule]RevisedSimplex]
          ];
      {-(optv.res)/fac,Map[First,xlat].(K.res)//Expand}
      ];







EndPackage[];