/***************************************************************************

Author: Robert  Urbanczik
Call:  C = ssuperset(X,Y,bitlen)
       X      : np by m uint32-Array
       Y      : np by l uint32-Array
       bitlen : double
       C      : l by 1 double array

       The columns of X and Y must be lexicographically ordered and only
       the first bitlen bits in each column may be nonzero.
Does:  Assume j=C(i).
       If j >  0 then:  X(:,j) is a superset of Y(:,i), i.e.
                        If a bit in  Y(:,i) is 1, so is the corresponding 
                        bit in X(:,j).
       If j <= 0 then:  There is no superset to  Y(:,i) in X. Further,
                        -j is the largest index such  that  X(:,j) <=  Y(:,i)
                        holds in lexicographic ordering.
       Moreover, Y(:,i) == Y(:,i+1) implies C(i) == C(i+1).

***************************************************************************/
#include <math.h>
#include "mex.h"

#define	X_IN	prhs[0]
#define	Y_IN	prhs[1]
#define	len_IN	prhs[2]
#define	C_OUT	plhs[0]

#define ULI unsigned long int
#define  LI long int

ULI masks[] = {
	0x80000000,0x40000000,0x20000000,0x10000000,
        0x8000000 ,0x4000000 ,0x2000000 ,0x1000000,
        0x800000  ,0x400000  ,0x200000  ,0x100000,
        0x80000   ,0x40000   ,0x20000   ,0x10000,
        0x8000    ,0x4000    ,0x2000    ,0x1000,
        0x800     ,0x400     ,0x200     ,0x100,
        0x80      ,0x40      ,0x20      ,0x10,
        0x8       ,0x4       ,0x2       ,0x1 };

ULI *X,*Y,len,checkcnt;
LI *C,MX,MY;
unsigned int d1X,d2X,d2Y; 

void rcheck(ULI  lev, LI bx, LI tx, LI by, LI ty) {
    ULI ind,off,mask,val,tmp;
    LI mx,my,b,t,m;
    
    while ( (by <= ty)&&(C[by] > 0) ) by++;
    while ( (by <= ty)&&(C[ty] > 0) ) ty--;
    if (by > ty) return; 
    
    if (bx > tx) {
      while (by <= ty) {if (C[by] <= 0) C[by] = -tx-1; by++;}; 
      return;
    };

    if (lev == len) {
      while (by <= ty) {C[by] = bx+1; by++;};
      return;};
    checkcnt++;
    
    ind = lev/32; off = lev%32;
    if (ind ==  (len-1)/32)
	off = off + (31-(len-1)%32);
    mask = masks[off];

    /*printf("%i %i %i %u\n",lev, ind,off,mask);
    printf("%u   %u %u   %u %u %u %u\n", 
	   lev, bx,tx, by,ty, off, (Y[ind+d1X*0]&mask) != 0);*/

    b = bx; t =tx+1;
    while ( b < t) {
      m = (b+t)/2;
      val = X[ind+d1X*m]&mask;
      if (val)   t = m; else b = m+1;
    }; 
    if (val) ; else m++;
    mx =m;
    
    b = by; t =ty+1;
    while ( b < t) {
      m = (b+t)/2;
      val = Y[ind+d1X*m]&mask;
      if (val)   t = m; else b = m+1;
    }; 
    if (val) ; else m++;
    my =m;

    lev++;
    MX = -1; MY=-1;
    if (my <= ty) rcheck(lev, mx,  tx,  my,  ty); 
    if (by < my) { 
      rcheck(lev, mx,  tx,  by, my-1);
      rcheck(lev, bx, mx-1, by, my-1);
    };
  };  

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    double *flen;
    const int *dimp;
    int dd[2];
    
    /* Check for proper number of arguments */
 
   if (nrhs != 3){ 
	mexErrMsgTxt("Three or four input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
	} 

    dimp =  mxGetDimensions(X_IN);
    d1X = dimp[0];
    d2X = dimp[1];
    dimp =  mxGetDimensions(Y_IN);
    d2Y = dimp[1]; 

    dd[0] = d2Y;
    C_OUT = mxCreateNumericArray(1, dd, mxINT32_CLASS, mxREAL);
    
    X    = mxGetData(X_IN); 
    Y    = mxGetData(Y_IN);
    flen = mxGetData(len_IN);
    len = flen[0];
    C = mxGetData(C_OUT);
    
    checkcnt = 0;
    rcheck(0,0,d2X-1,0,d2Y-1);
     
    /*printf("%i\n",checkcnt);*/

}


