(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28716,        959]*)
(*NotebookOutlinePosition[     29376,        982]*)
(*  CellTagsIndexPosition[     29332,        978]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["SNAsym basics\n",
  FontSize->18,
  FontSlant->"Italic"]], "Title"],

Cell[TextData[{
  "The basic data type SNAsym operates on, is called ",
  StyleBox["mnet",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[".  ",
    FontSlant->"Plain"],
  "The tutorial shows how to input ",
  StyleBox["mnet",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSlant->"Plain"],
  " metabolic networks and some basic analysis of networks. "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell["\<\
Make sure you are in the SNA tutorials directory, before loading \
SNAsym.  Note that executing the following command automatically loads SNAmat \
as well.\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(<< "\<../mathcode/SNAsym.m\>";\)\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Now we construct an  ",
  StyleBox["mnet",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " starting from the list of reactions given\nbelow. The third reaction is \
reversible, while the others are not."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(reacs\  = \[IndentingNewLine]{\ "\<x\>"\  \[RightVector] \ 
          2\ "\<c\>", \[IndentingNewLine]"\<x\>"\  \[RightVector] \ \ "\<e\>"\
\  + \ "\<d\>", \[IndentingNewLine]"\<a\>" + "\<b\>"\  \[Equilibrium] \ \
"\<c\>", \[IndentingNewLine]"\<e\>"\  \[RightVector] \ "\<c\>", \
\[IndentingNewLine]"\<d\>"\  \[RightVector] \ "\<c\>", \
\[IndentingNewLine]"\<e\>"\  + \ 
            2\ "\<b\>"\ \  \[RightVector] \ "\<y\>", \
\[IndentingNewLine]"\<d\>"\  + \ 
            2\ "\<a\>"\  \[RightVector] \ \ "\<y\>"}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"\<\"x\"\>", 
          StyleBox["\[RightVector]",
            FontSize->18], \(2\ "c"\)}], ",", 
        RowBox[{"\<\"x\"\>", 
          StyleBox["\[RightVector]",
            FontSize->18], \("d" + "e"\)}], ",", 
        RowBox[{\("a" + "b"\), 
          StyleBox["\[Equilibrium]",
            FontSize->18], "\<\"c\"\>"}], ",", 
        RowBox[{"\<\"e\"\>", 
          StyleBox["\[RightVector]",
            FontSize->18], "\<\"c\"\>"}], ",", 
        RowBox[{"\<\"d\"\>", 
          StyleBox["\[RightVector]",
            FontSize->18], "\<\"c\"\>"}], ",", 
        RowBox[{\(2\ "b" + "e"\), 
          StyleBox["\[RightVector]",
            FontSize->18], "\<\"y\"\>"}], ",", 
        RowBox[{\(2\ "a" + "d"\), 
          StyleBox["\[RightVector]",
            FontSize->18], "\<\"y\"\>"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
In the above reactions, metabolite names are strings.  This is \
inappropriate for SNAsym, where metabolites are more complicated constructs \
of the form\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[TextData[{
  StyleBox["meta",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["[ role",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["compound",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ", ",
  StyleBox["compartment].",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[TextData[{
  StyleBox["role",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " can be one of the four symbols ",
  StyleBox["Int",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ,",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" Xt",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[",",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" Xtin",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Xtout",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ". An internal metabolite has ",
  StyleBox["Int",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ", an external one ",
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Xt",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[",",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " and ",
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Xtin",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Xtout",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "denote external metabolites which are restricted to being inputs or, \
respectively, outputs.\n",
  StyleBox["compound",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " is a string , typically giving the chemical species of the metabolite.\n\
",
  StyleBox["compartment",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " is a string giving the cellular compartment of the metabolite,  you might \
e.g. use ",
  StyleBox["\"c\"",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " for cytosol and ",
  StyleBox["\"m\"",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " for mitochondria.\n\nThe next input line converts the string in",
  StyleBox[" ",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["reacs ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "to proper metabolites, making all metabolites internal and being  in the \
same compartment  , ",
  StyleBox["\"\".",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(reacs1\  = 
      reacs\  /. \ x_String\  \[Rule] \ meta[Int, x, "\<\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\("x"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \(2\ "c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("x"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("d"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("a"\^\*"\<\"\"\>" + "b"\^\*"\<\"\"\>"\), 
          StyleBox["\[Equilibrium]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "b"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "a"\^\*"\<\"\"\>" + "d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\^\*"\<\"\"\>"\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing to ",
  StyleBox["reacs",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ", it seems that nothing has changed. The outputs seems the same,  because \
metabolites are pretty printed on output.\nBut using ",
  StyleBox["InputForm ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "on the first element of ",
  StyleBox["reacs",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " and ",
  StyleBox["reacs1 ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " reveals the difference."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[reacs]\  // InputForm\)], "Input"],

Cell["\"x\" \[RightVector] 2*\"c\"", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[reacs1]\  // InputForm\)], "Input"],

Cell["\<\
meta[Int, \"x\", \"\"] \[RightVector] 2*meta[Int, \"c\", \
\"\"]\
\>", "Output"]
}, Open  ]],

Cell["\<\
The next thing is, to give each reaction a name. Here we shall just \
number them sequentially.\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(names\  = \ Range[Length[reacs]]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7}\)], "Output"]
}, Open  ]],

Cell["Finally, we can construct the network.", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(net = \ constructmnet[reacs1, names];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "SNAsym provides  functions for inspecting metabolic nets, which we \
illustrate on the",
  StyleBox[" net",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " just constructed.  \n",
  StyleBox["metabolites ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "lists all metabolites in the net; ",
  StyleBox[" reactions ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "lists the reactions; ",
  StyleBox["tags ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "lists the names, and ",
  StyleBox["trpairs ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "makes the association between names and reactions more explicit. "
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(metabolites@net\)], "Input"],

Cell[BoxData[
    \({"a"\^\*"\<\"\"\>", "b"\^\*"\<\"\"\>", "c"\^\*"\<\"\"\>", 
      "d"\^\*"\<\"\"\>", "e"\^\*"\<\"\"\>", "x"\^\*"\<\"\"\>", 
      "y"\^\*"\<\"\"\>"}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(reactions@net\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\("a"\^\*"\<\"\"\>" + "b"\^\*"\<\"\"\>"\), 
          StyleBox["\[Equilibrium]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "a"\^\*"\<\"\"\>" + "d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "b"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("x"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \(2\ "c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("x"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("d"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\)}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tags@net\)], "Input"],

Cell[BoxData[
    \({R[3], R[5], R[7], R[4], R[6], R[1], R[2]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(trpairs@net\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{\(R[3]\), ",", 
            RowBox[{\("a"\^\*"\<\"\"\>" + "b"\^\*"\<\"\"\>"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[5]\), ",", 
            RowBox[{\("d"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[7]\), ",", 
            RowBox[{\(2\ "a"\^\*"\<\"\"\>" + "d"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("y"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[4]\), ",", 
            RowBox[{\("e"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[6]\), ",", 
            RowBox[{\(2\ "b"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("y"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[1]\), ",", 
            RowBox[{\("x"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \(2\ "c"\^\*"\<\"\"\>"\)}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(R[2]\), ",", 
            RowBox[{\("x"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("d"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\)}]}], 
          "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Note that the reactions are listed in canonical ordering and not in the \
order they appeared in ",
  StyleBox[" reacs1",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " . However using the names you could reconstruct the original ordering. \
Further, ",
  StyleBox["R[..]",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " has been wrapped around the numbers we used to name the reactions. This \
is so that you can safely use not just numbers but also strings or even \
general ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions to name the reactions.  For instance, in a large model,  you \
might name reactions by something like ",
  StyleBox["{",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" mnemonic, pathway",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["}.",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Finally we use SNAsym to actually calculate something meaningful for this \
simple ",
  StyleBox[" net.",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " \nFirst we compute the elementary flux vectors."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\({fluxes, nrev}\  = \ symfluxelvs[net];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nrev\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fluxes\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This somewhat disappointing result means that there are no elementary \
fluxes and 0 of them are reversible. This is not surprising, since",
  StyleBox[" net",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "  has no futile cycles and all metabolites are internal.  \nSo, next we \
use the function ",
  StyleBox["setrole",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " to change the role of  ",
  StyleBox["\"x\" ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "and  ",
  StyleBox["\"y\" ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "from",
  StyleBox[" Int",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " to",
  StyleBox[" Xt",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(net1\  = \ 
        setrole[net, {meta[Int, "\<x\>", "\<\>"], \ 
            meta[Int, "\<y\>", "\<\>"]}, Xt];\)\), "\n", 
    \(reactions@net1\)}], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\("a"\^\*"\<\"\"\>" + "b"\^\*"\<\"\"\>"\), 
          StyleBox["\[Equilibrium]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "a"\^\*"\<\"\"\>" + "d"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\_Xt\%\(\*"\<\"\"\>"\)\)}], ",", 
        RowBox[{\("e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\(2\ "b"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("y"\_Xt\%\(\*"\<\"\"\>"\)\)}], ",", 
        RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
          StyleBox["\[RightVector]",
            FontSize->18], \(2\ "c"\^\*"\<\"\"\>"\)}], ",", 
        RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
          StyleBox["\[RightVector]",
            FontSize->18], \("d"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\)}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Note that in the output, external metabolites have their role shown \
in the subscript.
Now calculating the elementary fluxes yields:\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({fluxes, nrev}\  = \ symfluxelvs[net1];\)\), "\n", 
    \(nrev\)}], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fluxes\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(R[1]\), "+", \(R[2]\), "-", \(2\ R[3]\), "+", \(R[6]\), 
          "+", \(R[7]\), "-", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}]}], ",", 
        RowBox[{\(2\ R[2]\), "-", \(2\ R[3]\), "+", \(R[4]\), "+", \(R[5]\), 
          "+", \(R[6]\), "+", \(R[7]\), "-", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "So ",
  StyleBox["net1",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " has two irreversible elementary fluxes.  An elementary flux is listed by \
showing the tag for each reaction with the scalar pre-factor of the tag \
giving the flow through the reaction. Note that ",
  StyleBox["symfluxelvs  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "has automatically added the appropriate exchange reactions. For simplicity \
the exchange reactions themselves are also their names, wrapped in  ",
  StyleBox["Rx ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "to distinguish them from the internal reactions. In effect the output of \
",
  StyleBox["symfluxelvs  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "refers to the following network:"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(trpairs@\(addexchanges@net1\)\  // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(R[3]\), 
            RowBox[{\("a"\^\*"\<\"\"\>" + "b"\^\*"\<\"\"\>"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]},
          {
            RowBox[{"Rx", "[", 
              RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}], 
            RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}]},
          {
            RowBox[{"Rx", "[", 
              RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}], 
            RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}]},
          {\(R[5]\), 
            RowBox[{\("d"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]},
          {\(R[7]\), 
            RowBox[{\(2\ "a"\^\*"\<\"\"\>" + "d"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("y"\_Xt\%\(\*"\<\"\"\>"\)\)}]},
          {\(R[4]\), 
            RowBox[{\("e"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("c"\^\*"\<\"\"\>"\)}]},
          {\(R[6]\), 
            RowBox[{\(2\ "b"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("y"\_Xt\%\(\*"\<\"\"\>"\)\)}]},
          {\(R[1]\), 
            RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
              StyleBox["\[RightVector]",
                FontSize->18], \(2\ "c"\^\*"\<\"\"\>"\)}]},
          {\(R[2]\), 
            RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("d"\^\*"\<\"\"\>" + "e"\^\*"\<\"\"\>"\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now, to illustrate ",
  StyleBox[" Xtin",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(net2\  = \ 
        setrole[net1, {meta[Xt, "\<x\>", "\<\>"]}, Xtin];\)\), "\n", 
    \(metabolites@net2\)}], "Input"],

Cell[BoxData[
    \({"a"\^\*"\<\"\"\>", "b"\^\*"\<\"\"\>", "c"\^\*"\<\"\"\>", 
      "d"\^\*"\<\"\"\>", "e"\^\*"\<\"\"\>", "y"\_Xt\%\(\*"\<\"\"\>"\), 
      "x"\_Xtin\%\(\*"\<\"\"\>"\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({fluxes, nrev}\  = \ symfluxelvs[net2];\)\), "\[IndentingNewLine]", 
    \(fluxes\)}], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(R[1]\), "+", \(R[2]\), "-", \(2\ R[3]\), "+", \(R[6]\), 
          "+", \(R[7]\), "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{"0", 
                StyleBox["\[RightVector]",
                  FontSize->18], \("x"\_Xtin\%\(\*"\<\"\"\>"\)\)}], "]"}]}]}],
         ",", 
        RowBox[{\(2\ R[2]\), "-", \(2\ R[3]\), "+", \(R[4]\), "+", \(R[5]\), 
          "+", \(R[6]\), "+", \(R[7]\), "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{\("y"\_Xt\%\(\*"\<\"\"\>"\)\), 
                StyleBox["\[Equilibrium]",
                  FontSize->18], "0"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{"Rx", "[", 
              RowBox[{"0", 
                StyleBox["\[RightVector]",
                  FontSize->18], \("x"\_Xtin\%\(\*"\<\"\"\>"\)\)}], 
              "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "To calculate the elementary conversions of ",
  StyleBox["net1",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " use:"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(conversionelvs[net1]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\("x"\_Xt\%\(\*"\<\"\"\>"\)\), 
        StyleBox["\[RightVector]",
          FontSize->18], \("y"\_Xt\%\(\*"\<\"\"\>"\)\)}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(conversionelvs[net]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{702, 569},
WindowMargins->{{32, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 91, 2, 65, "Title"],
Cell[1848, 55, 578, 21, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2451, 80, 363, 11, 66, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2839, 95, 67, 1, 31, "Input"],
Cell[2909, 98, 89, 1, 23, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3047, 105, 423, 14, 66, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3495, 123, 544, 9, 143, "Input"],
Cell[4042, 134, 878, 23, 46, "Output"]
}, Open  ]],
Cell[4935, 160, 285, 9, 45, "Text",
  Evaluatable->False],
Cell[5223, 171, 613, 24, 30, "Text",
  Evaluatable->False],
Cell[5839, 197, 3408, 113, 198, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9272, 314, 105, 2, 31, "Input"],
Cell[9380, 318, 1094, 23, 46, "Output"]
}, Open  ]],
Cell[10489, 344, 825, 28, 72, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11339, 376, 60, 1, 31, "Input"],
Cell[11402, 379, 46, 0, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11485, 384, 61, 1, 31, "Input"],
Cell[11549, 387, 90, 3, 59, "Output"]
}, Open  ]],
Cell[11654, 393, 226, 8, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11905, 405, 65, 1, 31, "Input"],
Cell[11973, 408, 55, 1, 46, "Output"]
}, Open  ]],
Cell[12043, 412, 161, 5, 30, "Text",
  Evaluatable->False],
Cell[12207, 419, 74, 1, 31, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12318, 425, 855, 30, 112, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13198, 459, 48, 1, 31, "Input"],
Cell[13249, 462, 181, 3, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13467, 470, 46, 1, 31, "Input"],
Cell[13516, 473, 1101, 24, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14654, 502, 41, 1, 31, "Input"],
Cell[14698, 505, 76, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14811, 511, 44, 1, 31, "Input"],
Cell[14858, 514, 1644, 38, 62, "Output"]
}, Open  ]],
Cell[16517, 555, 1220, 36, 90, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[17774, 596, 422, 14, 66, "Subsubsection",
  Evaluatable->False],
Cell[18199, 612, 75, 1, 31, "Input"],

Cell[CellGroupData[{
Cell[18299, 617, 37, 1, 31, "Input"],
Cell[18339, 620, 35, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18411, 626, 39, 1, 31, "Input"],
Cell[18453, 629, 36, 1, 46, "Output"]
}, Open  ]],
Cell[18504, 633, 1085, 38, 72, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19614, 675, 180, 4, 47, "Input"],
Cell[19797, 681, 1133, 24, 48, "Output"]
}, Open  ]],
Cell[20945, 708, 264, 9, 57, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21234, 721, 99, 2, 47, "Input"],
Cell[21336, 725, 35, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21408, 731, 39, 1, 31, "Input"],
Cell[21450, 734, 1146, 26, 66, "Output"]
}, Open  ]],
Cell[22611, 763, 1043, 30, 90, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23679, 797, 77, 1, 31, "Input"],
Cell[23759, 800, 2150, 52, 211, "Output"]
}, Open  ]],
Cell[25924, 855, 280, 12, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[26229, 871, 141, 3, 47, "Input"],
Cell[26373, 876, 199, 3, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26609, 884, 118, 2, 47, "Input"],
Cell[26730, 888, 1174, 28, 66, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27953, 922, 338, 13, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28316, 939, 53, 1, 31, "Input"],
Cell[28372, 942, 188, 4, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28597, 951, 52, 1, 31, "Input"],
Cell[28652, 954, 36, 1, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

