(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17506,        462]*)
(*NotebookOutlinePosition[     18168,        485]*)
(*  CellTagsIndexPosition[     18124,        481]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Importing external formats I.",
  FontSize->18,
  FontSlant->"Italic"]], "Title"],

Cell[TextData[{
  "This tutorial shows how to construct an  ",
  StyleBox["mnet",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  ", if  you have a stoichiometry matrix (and some other information) ."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(<< "\<../mathcode/SNAsym.m\>";\)\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " The data for our network  is in CSV-format in the subdirectory",
  StyleBox[" humit",
    FontSlant->"Plain"],
  ". \nWe first read in the stoichiometry matrix, note that the \"54rev \" in \
the filename means that the first 54 columns are reversible."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(stoich\  = \ 
        Import[SNApath <> "\<tutorials/humit/stoich54rev.csv\>", \ \
"\<CSV\>"];\)\), "\n", 
    \(Dimensions[stoich]\)}], "Input"],

Cell[BoxData[
    \({164, 123}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(stoich[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 1.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`}\)], "Output"]
}, Open  ]],

Cell["\<\
Since the entries of stoich are real numbers, we convert them to \
rational numbers.\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(stoich\  = \ real2rat[stoich];\)\), "\n", 
    \(stoich[\([1]\)]\)}], "Input"],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Next,  we read in some auxiliary information regarding metabolite & \
reaction names.\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(metaspec\  = \ \ Import[
        SNApath <> "\<tutorials/humit/metabolites_species.csv\>", \ \
"\<CSV\>"]\)], "Input"],

Cell[BoxData[
    \({{"10fthf", "12dgr_m", "2mop", "34hpp", "3hacoa", "3oacoa", "5aop", 
        "5fthf", "aacoa", "acac", "accoa", "adp", "aglyc3p_m", "ahcys", 
        "akg", "amet", "amp", "arg-L", "ascb-L", "asp-L", "atp", "c204coa", 
        "c204crn", "c226coa", "c226crn", "cbp", "cdp", "cdpdag_m", "cdpea", 
        "chol", "cit", "citr-L", "clpn_m", "cmp", "co2", "coa", "creat", 
        "crn", "ctp", "dgmp", "dgsn", "dhap", "dhdascb", "dhor-S", "dtmp", 
        "dump", "dutp", "facoa_m", "fad", "fadh2", "fe2", "ficytC", "focytC", 
        "for", "fum", "gdp", "glu-L", "gly", "glyc", "glyc3p", "gthox", 
        "gthrd", "gtp", "gudac", "h", "h2co3", "h2o", "h2o2", "hco3", 
        "hmgcoa", "icit", "idp", "itp", "lys-L", "mal-L", "methf", "mlthf", 
        "mmcoa-S", "nad", "nadh", "nadp", "nadph", "nh4", "o2", "o2-", "oaa", 
        "ocdycacoa", "ocdycrn", "odecoa", "odecrn", "orn", "orot", "pa_m", 
        "pc_m", "pcreat", "pe_m", "pep", "pg_m", "pgp_m", "pheme", "pi", 
        "pmtcoa", "pmtcrn", "ppcoa", "ppi", "ppp9", "pppg9", "ps_m", "pyr", 
        "q10", "q10h2", "ser-L", "stcoa", "stcrn", "succ", "succoa", "thf", 
        "thymd", "tyr-L", "udp", "5aop", "adp", "akg", "arg-L", "asp-L", 
        "atp", "c204crn", "c226crn", "cdp", "cit", "citr-L", "co2", "coa", 
        "crn", "fe2", "fum", "gdp", "glu-L", "gly", "glyc", "glyc3p", 
        "gthrd", "gtp", "h", "h2o", "lys-L", "mal-L", "nh4", "o2", "ocdycrn", 
        "odecrn", "orn", "pc_m", "pep", "pheme", "pi", "PL", "pmtcrn", 
        "pppg9", "ps_m", "pyr", "stcrn", "succ", "udp"}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads in CSV as a matrix. We just want a simple list, so we replace the \
above with:"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(metaspec\  = \ \ \(Import[
          SNApath <> "\<tutorials/humit/metabolites_species.csv\>", \ \
"\<CSV\>"]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({"10fthf", "12dgr_m", "2mop", "34hpp", "3hacoa", "3oacoa", "5aop", 
      "5fthf", "aacoa", "acac", "accoa", "adp", "aglyc3p_m", "ahcys", "akg", 
      "amet", "amp", "arg-L", "ascb-L", "asp-L", "atp", "c204coa", "c204crn", 
      "c226coa", "c226crn", "cbp", "cdp", "cdpdag_m", "cdpea", "chol", "cit", 
      "citr-L", "clpn_m", "cmp", "co2", "coa", "creat", "crn", "ctp", "dgmp", 
      "dgsn", "dhap", "dhdascb", "dhor-S", "dtmp", "dump", "dutp", "facoa_m", 
      "fad", "fadh2", "fe2", "ficytC", "focytC", "for", "fum", "gdp", 
      "glu-L", "gly", "glyc", "glyc3p", "gthox", "gthrd", "gtp", "gudac", 
      "h", "h2co3", "h2o", "h2o2", "hco3", "hmgcoa", "icit", "idp", "itp", 
      "lys-L", "mal-L", "methf", "mlthf", "mmcoa-S", "nad", "nadh", "nadp", 
      "nadph", "nh4", "o2", "o2-", "oaa", "ocdycacoa", "ocdycrn", "odecoa", 
      "odecrn", "orn", "orot", "pa_m", "pc_m", "pcreat", "pe_m", "pep", 
      "pg_m", "pgp_m", "pheme", "pi", "pmtcoa", "pmtcrn", "ppcoa", "ppi", 
      "ppp9", "pppg9", "ps_m", "pyr", "q10", "q10h2", "ser-L", "stcoa", 
      "stcrn", "succ", "succoa", "thf", "thymd", "tyr-L", "udp", "5aop", 
      "adp", "akg", "arg-L", "asp-L", "atp", "c204crn", "c226crn", "cdp", 
      "cit", "citr-L", "co2", "coa", "crn", "fe2", "fum", "gdp", "glu-L", 
      "gly", "glyc", "glyc3p", "gthrd", "gtp", "h", "h2o", "lys-L", "mal-L", 
      "nh4", "o2", "ocdycrn", "odecrn", "orn", "pc_m", "pep", "pheme", "pi", 
      "PL", "pmtcrn", "pppg9", "ps_m", "pyr", "stcrn", "succ", 
      "udp"}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(metacomp = \ \ \(Import[
          SNApath <> "\<tutorials/humit/metabolites_compartments.csv\>", \ \
"\<CSV\>"]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({"m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", "m", 
      "m", "m", "m", "m", "m", "m", "m", "m", "c", "c", "c", "c", "c", "c", 
      "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", 
      "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c", 
      "e", "c", "e", "c", "c", "c", "c", "c", "c", "c"}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rnames = \ \ \(Import[
          SNApath <> "\<tutorials/humit/reactionnames.csv\>", \ "\<CSV\>"]\)[\
\([1]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rnames\\)\\\" is similar to existing symbol \
\\\"\\!\\(names\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \({"ASPTAm", "ADK1m", "ETHAPTm", "ACONTm", "CITRtm", "CK", "GLYAMDTR", 
      "PGSAm", "GACMTR", "H2CO3Dm", "HCO3Em", "FUMm", "GTHPm", "HMGCOASm", 
      "ADK4m", "HACDm", "MDHm", "DHORDm", "DASYNm", "CLPNSm", "SUCD3-u10m", 
      "SUCD1m", "SUCOASm", "OCOAT1m", "FTHFLm", "GHMT2rm", "TYRTAm", 
      "5AOPtm", "ARGtm", "DNC1C", "CITtam", "CITtbm", "CO2tm", "COAtm", 
      "DNC1G", "GLYtm", "GLYCtm", "THD1m", "ORNt3m", "ORNt4m", "GLUt2m", 
      "ASPGLUm", "H2Otm", "GTHRDt", "LYStm", "AKGMALtm", "MALtm", "NH4tm", 
      "O2tm", "PIt2m", "PPPG9tm", "PYRt2m", "SUCCt2m", "DNC1U", "ACACT1m", 
      "DAGKm", "Satpctp", "C204CRN3", "C226CRN3", "CRNtim", "DGNSKm", 
      "AGATm", "GLYKm", "G3PATm", "G3PDm", "GTHDHm", "DUTPDPm", "CATm", 
      "HMGLm", "THFATm", "MMSAD1m", "AKGDm", "ICDHxm", "FAOXC204", 
      "FAOXC226", "ICDHym", "ME2m", "GTHOm", "CBMKm", "CYOOm3", "SPODMm", 
      "PEPCKm", "CSm", "FAOXC182", "C182CRN3", "FAOXC181", "C181CRN3", 
      "OCBTm", "PAPAm", "PCHOLPm", "DMPL", "PGPPm", "DMheme", "FAOXC160", 
      "C160CPT2", "PPCOACm", "PPAm", "FCLTm", "PPPGOm", "PSDm", "PCm", 
      "PDHm", "NADH2-u10m", "CYOR-u10m", "FASYNm", "FAOXC180", "C180CPT2", 
      "ALASm", "TMDK1m", "ATPtm", "C204CRN2", "C226CRN2", "FRDcm", "GTPtm", 
      "GLYC3Ptm", "FE2tm", "ATPS4m", "C182CRN2", "C181CRN2", "PCtm", 
      "C160CRN", "PStm", "C180CRN"}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "From ",
  StyleBox["metaspec",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " and ",
  StyleBox["metacomp ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "we construct the metabolites of the network by:"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(metas\  = \ 
      MapThread[\ meta[Int, #1, #2] &, {metaspec, metacomp}]\)], "Input"],

Cell[BoxData[
    \({"10fthf"\^"m", "12dgr_m"\^"m", "2mop"\^"m", "34hpp"\^"m", 
      "3hacoa"\^"m", "3oacoa"\^"m", "5aop"\^"m", "5fthf"\^"m", "aacoa"\^"m", 
      "acac"\^"m", "accoa"\^"m", "adp"\^"m", "aglyc3p_m"\^"m", "ahcys"\^"m", 
      "akg"\^"m", "amet"\^"m", "amp"\^"m", "arg-L"\^"m", "ascb-L"\^"m", 
      "asp-L"\^"m", "atp"\^"m", "c204coa"\^"m", "c204crn"\^"m", 
      "c226coa"\^"m", "c226crn"\^"m", "cbp"\^"m", "cdp"\^"m", 
      "cdpdag_m"\^"m", "cdpea"\^"m", "chol"\^"m", "cit"\^"m", "citr-L"\^"m", 
      "clpn_m"\^"m", "cmp"\^"m", "co2"\^"m", "coa"\^"m", "creat"\^"m", 
      "crn"\^"m", "ctp"\^"m", "dgmp"\^"m", "dgsn"\^"m", "dhap"\^"m", 
      "dhdascb"\^"m", "dhor-S"\^"m", "dtmp"\^"m", "dump"\^"m", "dutp"\^"m", 
      "facoa_m"\^"m", "fad"\^"m", "fadh2"\^"m", "fe2"\^"m", "ficytC"\^"m", 
      "focytC"\^"m", "for"\^"m", "fum"\^"m", "gdp"\^"m", "glu-L"\^"m", 
      "gly"\^"m", "glyc"\^"m", "glyc3p"\^"m", "gthox"\^"m", "gthrd"\^"m", 
      "gtp"\^"m", "gudac"\^"m", "h"\^"m", "h2co3"\^"m", "h2o"\^"m", 
      "h2o2"\^"m", "hco3"\^"m", "hmgcoa"\^"m", "icit"\^"m", "idp"\^"m", 
      "itp"\^"m", "lys-L"\^"m", "mal-L"\^"m", "methf"\^"m", "mlthf"\^"m", 
      "mmcoa-S"\^"m", "nad"\^"m", "nadh"\^"m", "nadp"\^"m", "nadph"\^"m", 
      "nh4"\^"m", "o2"\^"m", "o2-"\^"m", "oaa"\^"m", "ocdycacoa"\^"m", 
      "ocdycrn"\^"m", "odecoa"\^"m", "odecrn"\^"m", "orn"\^"m", "orot"\^"m", 
      "pa_m"\^"m", "pc_m"\^"m", "pcreat"\^"m", "pe_m"\^"m", "pep"\^"m", 
      "pg_m"\^"m", "pgp_m"\^"m", "pheme"\^"m", "pi"\^"m", "pmtcoa"\^"m", 
      "pmtcrn"\^"m", "ppcoa"\^"m", "ppi"\^"m", "ppp9"\^"m", "pppg9"\^"m", 
      "ps_m"\^"m", "pyr"\^"m", "q10"\^"m", "q10h2"\^"m", "ser-L"\^"m", 
      "stcoa"\^"m", "stcrn"\^"m", "succ"\^"m", "succoa"\^"m", "thf"\^"m", 
      "thymd"\^"m", "tyr-L"\^"m", "udp"\^"m", "5aop"\^"c", "adp"\^"c", 
      "akg"\^"c", "arg-L"\^"c", "asp-L"\^"c", "atp"\^"c", "c204crn"\^"c", 
      "c226crn"\^"c", "cdp"\^"c", "cit"\^"c", "citr-L"\^"c", "co2"\^"c", 
      "coa"\^"c", "crn"\^"c", "fe2"\^"c", "fum"\^"c", "gdp"\^"c", 
      "glu-L"\^"c", "gly"\^"c", "glyc"\^"c", "glyc3p"\^"c", "gthrd"\^"c", 
      "gtp"\^"c", "h"\^"c", "h2o"\^"c", "lys-L"\^"c", "mal-L"\^"c", 
      "nh4"\^"c", "o2"\^"c", "ocdycrn"\^"c", "odecrn"\^"c", "orn"\^"c", 
      "pc_m"\^"c", "pep"\^"c", "pheme"\^"e", "pi"\^"c", "PL"\^"e", 
      "pmtcrn"\^"c", "pppg9"\^"c", "ps_m"\^"c", "pyr"\^"c", "stcrn"\^"c", 
      "succ"\^"c", "udp"\^"c"}\)], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["Now we construct the reactions, note that 54 is the \
number of reversible reactions.",
  FontSlant->"Italic"]], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(reacs\  = \ stoich2reacs[stoich, metas, 54];\)\), "\n", 
    \(reacs // First\)}], "Input"],

Cell[BoxData[
    RowBox[{\("akg"\^"m" + "asp-L"\^"m"\), 
      StyleBox["\[Equilibrium]",
        FontSize->18], \("glu-L"\^"m" + "oaa"\^"m"\)}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(reacs // Last\)], "Input"],

Cell[BoxData[
    RowBox[{\("stcrn"\^"c"\), 
      StyleBox["\[RightVector]",
        FontSize->18], \("stcrn"\^"m"\)}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[" Using the reactions and their names,  we first \
construct the network",
  FontSlant->"Italic"]], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(newhumit\  = \ constructmnet[reacs, rnames];\)\)], "Input"],

Cell[TextData[{
  StyleBox["and then change the role of all extramitochondrial metabolites to \
",
    FontSlant->"Italic"],
  StyleBox["Xt",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(newhumit\ \  = \ 
        setrole[newhumit, \ 
          with[{"\<c\>", "\<e\>"}, \ metabolites@newhumit], \ 
          Xt];\)\)], "Input"],

Cell[TextData[{
  StyleBox["Now ",
    FontSlant->"Italic"],
  StyleBox["newhumit",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" should be just the network we used in Tutorial 4.\nTo check if \
this is indeed the case:",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{\({name, 
          humit}\  = \ << \((SNApath <> \
"\<tutorials/HumanMitochondria.m\>")\);\), "\n", 
    RowBox[{
      StyleBox[" ",
        FontSlant->"Italic"], 
      StyleBox[\(newhumit\  === \ humit\),
        FontWeight->"Bold",
        FontSlant->"Plain",
        FontVariations->{"CompatibilityType"->0}]}]}], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{790, 799},
WindowMargins->{{167, Automatic}, {Automatic, 36}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 105, 2, 35, "Title"],
Cell[1862, 55, 322, 11, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2209, 70, 67, 1, 31, "Input"],
Cell[2279, 73, 89, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2405, 79, 468, 13, 89, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2898, 96, 168, 4, 47, "Input"],
Cell[3069, 102, 44, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3150, 108, 48, 1, 31, "Input"],
Cell[3201, 111, 705, 9, 126, "Output"]
}, Open  ]],
Cell[3921, 123, 215, 8, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4161, 135, 101, 2, 47, "Input"],
Cell[4265, 139, 438, 6, 94, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4752, 151, 293, 10, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5070, 165, 138, 3, 31, "Input"],
Cell[5211, 170, 1591, 21, 222, "Output"]
}, Open  ]],
Cell[6817, 194, 277, 10, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7119, 208, 153, 3, 31, "Input"],
Cell[7275, 213, 1549, 21, 222, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8861, 239, 156, 3, 31, "Input"],
Cell[9020, 244, 931, 12, 110, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9988, 261, 143, 3, 31, "Input"],
Cell[10134, 266, 359, 5, 39, "Message"],
Cell[10496, 273, 1390, 19, 222, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11935, 298, 430, 17, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12390, 319, 106, 2, 31, "Input"],
Cell[12499, 323, 2460, 34, 254, "Output"]
}, Open  ]],
Cell[14974, 360, 251, 7, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15250, 371, 114, 2, 47, "Input"],
Cell[15367, 375, 157, 3, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15561, 383, 46, 1, 31, "Input"],
Cell[15610, 386, 131, 3, 46, "Output"]
}, Open  ]],
Cell[15756, 392, 237, 7, 30, "Text",
  Evaluatable->False],
Cell[15996, 401, 81, 1, 31, "Input"],
Cell[16080, 404, 396, 15, 30, "Text",
  Evaluatable->False],
Cell[16479, 421, 161, 4, 31, "Input"],
Cell[16643, 427, 427, 15, 57, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17095, 446, 342, 9, 47, "Input"],
Cell[17440, 457, 38, 1, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

