(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28624,        858]*)
(*NotebookOutlinePosition[     29286,        881]*)
(*  CellTagsIndexPosition[     29242,        877]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Importing external formats II.",
  FontSize->18,
  FontSlant->"Italic"]], "Title"],

Cell[TextData[{
  "This tutorial shows how to construct an  ",
  StyleBox["mnet",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " given a textual representation of the reaction system."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(<< "\<../mathcode/SNAsym.m\>";\)\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "We first acknowledge and then inspect the data in  ",
  StyleBox["humit.csv",
    FontSlant->"Plain"],
  "."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<!grep \"#\" humit.csv\>", "\<Lines\>"]\  // 
      TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"#\"\>"},
          {"\<\"#  Metabolic network of human cardiac mitochondria \"\>"},
          {"\<\"#\"\>"},
          {"\<\"#  Vo, T.D., Greenberg, H.J., and Palsson, B.O.\"\>"},
          {"\<\"#  Journal of Biological Chemistry, 2004.\"\>"},
          {"\<\"#\"\>"},
          {"\<\"#  This file was generated by converting the reaction sheet \
of\"\>"},
          {"\<\"# \"\>"},
          {"\<\"#    \
http://gcrg.ucsd.edu/organisms/mitochondria/Supplemental_data.xls\"\>"},
          {"\<\"#\"\>"},
          {"\<\"#  to CSV format, and replacing the header.\"\>"},
          {"\<\"#\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"#", "#  Metabolic network of human cardiac mitochondria ", 
        "#", "#  Vo, T.D., Greenberg, H.J., and Palsson, B.O.", 
        "#  Journal of Biological Chemistry, 2004.", "#", 
        "#  This file was generated by converting the reaction sheet of", 
        "# ", "#    \
http://gcrg.ucsd.edu/organisms/mitochondria/Supplemental_data.xls", "#", 
        "#  to CSV format, and replacing the header.", "#"}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(rawtext = 
        Import["\<!grep -v \"#\" humit.csv\>", "\<CSV\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(rawtext // First\)\  // InputForm\)}], "Input"],

Cell["\<\
{1, \"HEX1\", \"hexokinase (D-glucose:ATP)\", \"[c] : atp + glc-D \
--> adp + g6p + h\", 4, \"Glycolysis \", 
 \"2.7.1.1\", \"yes\", \"(Voet, Voet et al. 1999)\"}\
\>", "Output"]
}, Open  ]],

Cell[TextData[{
  "The second column of",
  StyleBox[" rawtext",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " has the reaction name and the fourth column has the reaction.\nThe \
following sample shows the reaction syntax."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(indexes\  = \ {1, 10, 21, 26};\)\), "\[IndentingNewLine]", 
    \(sample\  = \ \(\(Transpose[rawtext]\)[\([4]\)]\)[\([indexes]\)]; \ 
    sample\  // TableForm\)}], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"[c] : atp + glc-D --> adp + g6p + h\"\>"},
          {"\<\"[c] : 2pg <==> 3pg\"\>"},
          {"\<\"[m] : fum + h2o <==> mal-L\"\>"},
          {"\<\"(4) focytC[m] + (7.92) h[m] + o2[m] --> (4) ficytC[m] + (4) \
h[c] + (1.96) h2o[m] + (0.02) o2-[m]\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"[c] : atp + glc-D --> adp + g6p + h", "[c] : 2pg <==> 3pg",
         "[m] : fum + h2o <==> mal-L", 
        "(4) focytC[m] + (7.92) h[m] + o2[m] --> (4) ficytC[m] + (4) h[c] + \
(1.96) h2o[m] + (0.02) o2-[m]"}]]], "Output"]
}, Open  ]],

Cell["\<\
If all in involved metabolites are within one compartment, the \
compartment is noted as the head of the reaction but not in the names of the \
metabolites.
If, as in the last reaction, metabolites from different compartments are \
involved, the compartments are noted as part of the  metabolite name.\
\>", \
"Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Our goal will be to let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " do the parsing of this syntax. The problem is that the above reactions \
are not ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions,  e.g. some metabolite names start with a  number and thus \
are not valid symbols in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nHowever, we can use substitutions based on regular expression to \
'beautify' the reactions and make them conform to ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "syntax. From Mathematica 5.1, this could be done within Mathematica.  Here \
we shall use the Unix utility ",
  StyleBox["sed",
    FontSlant->"Plain"],
  " to do the beautifying. \nThe following preprocesses ",
  StyleBox["humit.csv",
    FontSlant->"Plain"],
  " and inspects the result."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(text = 
        Import["\<!grep -v \"#\" humit.csv | sed -f humitsedscript\>", "\<CSV\
\>"];\)\), "\[IndentingNewLine]", 
    \(\(text // First\) // InputForm\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(text\\)\\\" is similar to existing symbols \
\\!\\({ext, Text}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"],

Cell["\<\
{1, \"HEX1\", \"hexokinase (DDashglucose:ATP)\", \"c: atp + \
glcDashD > adp + g6p + h\", 4, 
 \"Glycolysis \", \"2.7.1.1\", \"yes\", \"(Voet, Voet et al. 1999)\"}\
\>", \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sample\  = \ \(\(Transpose[text]\)[\([4]\)]\)[\([indexes]\)]; \ 
    sample\  // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"c: atp + glcDashD > adp + g6p + h\"\>"},
          {"\<\"c: NuM2pg == NuM3pg\"\>"},
          {"\<\"m: fum + h2o == malDashL\"\>"},
          {"\<\"(4) focytC[m] + (7.92) h[m] + o2[m] > (4) ficytC[m] + (4) \
h[c] + (1.96) h2o[m] + (0.02) o2Dash[m]\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"c: atp + glcDashD > adp + g6p + h", "c: NuM2pg == NuM3pg", 
        "m: fum + h2o == malDashL", 
        "(4) focytC[m] + (7.92) h[m] + o2[m] > (4) ficytC[m] + (4) h[c] + \
(1.96) h2o[m] + (0.02) o2Dash[m]"}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The syntax of the transformed reactions now conforms to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  The following shows what happens \nwhen Mathematica parses the syntax."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[FullForm[ToExpression[#]] &, sample]\  // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            TagBox[
              
              StyleBox[\(Pattern[c, 
                  Greater[Plus[atp, glcDashD], Plus[adp, g6p, h]]]\),
                ShowSpecialCharacters->False,
                ShowStringCharacters->True,
                NumberMarks->True],
              FullForm]},
          {
            TagBox[
              StyleBox[\(Pattern[c, Equal[NuM2pg, NuM3pg]]\),
                ShowSpecialCharacters->False,
                ShowStringCharacters->True,
                NumberMarks->True],
              FullForm]},
          {
            TagBox[
              StyleBox[\(Pattern[m, Equal[Plus[fum, h2o], malDashL]]\),
                ShowSpecialCharacters->False,
                ShowStringCharacters->True,
                NumberMarks->True],
              FullForm]},
          {
            TagBox[
              
              StyleBox[\(Greater[
                  Plus[Times[4, focytC[m]], Times[7.92`, h[m]], o2[m]], 
                  Plus[Times[4, ficytC[m]], Times[4, h[c]], 
                    Times[1.96`, h2o[m]], Times[0.02`, o2Dash[m]]]]\),
                ShowSpecialCharacters->False,
                ShowStringCharacters->True,
                NumberMarks->True],
              FullForm]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        FullForm[ 
          Pattern[ c, 
            Greater[ 
              Plus[ atp, glcDashD], 
              Plus[ adp, g6p, h]]]], 
        FullForm[ 
          Pattern[ c, 
            Equal[ NuM2pg, NuM3pg]]], 
        FullForm[ 
          Pattern[ m, 
            Equal[ 
              Plus[ fum, h2o], malDashL]]], 
        FullForm[ 
          Greater[ 
            Plus[ 
              Times[ 4, 
                focytC[ m]], 
              Times[ 7.9199999999999999, 
                h[ m]], 
              o2[ m]], 
            Plus[ 
              Times[ 4, 
                ficytC[ m]], 
              Times[ 4, 
                h[ c]], 
              Times[ 1.96, 
                h2o[ m]], 
              Times[ 0.02, 
                o2Dash[ m]]]]]}]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "While Mathematica can make sense of the syntax,  parsing does not result \
in expressions which are valid SNAsym reactions.\nSo we shall use the \
following function  which further transforms  the result of ",
  StyleBox["ToExpression",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  ":"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(toreaction[s_]\  := \ 
        Block[\ {r, c, a, b}, \[IndentingNewLine]r\  = \ 
            ToExpression[s]; \[IndentingNewLine]If[
            Head[r]\  \[Equal] \ Pattern, \[IndentingNewLine]c\  = \ 
              r\ [\([1]\)]; \[IndentingNewLine]r\  = \ 
              r\ [\([2]\)]; \[IndentingNewLine]r\  = 
              Replace[r\ , 
                a_Symbol\  \[Rule] \ 
                  a[c], {\(-1\)}]]; \[IndentingNewLine]\(\(r\  /. \ 
                a_[b_]\  \[Rule] \ 
                  meta[Int, a, b]\)\  /. \ \((a_\  > \ 
                    b_)\)\  \[Rule] \ \((a\  \[RightVector] \ 
                    b)\)\)\  /. \ \((a_\ \  == \ 
                  b_)\)\  \[Rule] \ \((a\ \  \[Equilibrium] 
                  b)\)];\)\)], "Input"],

Cell[TextData[{
  "We now apply ",
  StyleBox["toreaction",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " to the fourth column of ",
  StyleBox["text ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "and inspect the result."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(reacs1 = Map[toreaction[#[\([4]\)]] &, text];\)\), "\n", 
    \(reacs1[\([indexes]\)]\ \  // TableForm\)}], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(meta[Int, atp, c] + meta[Int, glcDashD, c]\), 
              StyleBox["\[RightVector]",
                FontSize->18], \(meta[Int, adp, c] + meta[Int, g6p, c] + 
                meta[Int, h, c]\)}]},
          {
            RowBox[{\(meta[Int, NuM2pg, c]\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \(meta[Int, NuM3pg, c]\)}]},
          {
            RowBox[{\(meta[Int, fum, m] + meta[Int, h2o, m]\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \(meta[Int, malDashL, m]\)}]},
          {
            
            RowBox[{\(4\ meta[Int, focytC, m] + 7.92`\ meta[Int, h, m] + 
                meta[Int, o2, m]\), 
              StyleBox["\[RightVector]",
                FontSize->18], \(4\ meta[Int, ficytC, m] + 
                4\ meta[Int, h, c] + 1.96`\ meta[Int, h2o, m] + 
                0.02`\ meta[Int, o2Dash, m]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        RightVector[ 
          Plus[ 
            meta[ Int, atp, c], 
            meta[ Int, glcDashD, c]], 
          Plus[ 
            meta[ Int, adp, c], 
            meta[ Int, g6p, c], 
            meta[ Int, h, c]]], 
        Equilibrium[ 
          meta[ Int, NuM2pg, c], 
          meta[ Int, NuM3pg, c]], 
        Equilibrium[ 
          Plus[ 
            meta[ Int, fum, m], 
            meta[ Int, h2o, m]], 
          meta[ Int, malDashL, m]], 
        RightVector[ 
          Plus[ 
            Times[ 4, 
              meta[ Int, focytC, m]], 
            Times[ 7.9199999999999999, 
              meta[ Int, h, m]], 
            meta[ Int, o2, m]], 
          Plus[ 
            Times[ 4, 
              meta[ Int, ficytC, m]], 
            Times[ 4, 
              meta[ Int, h, c]], 
            Times[ 1.96, 
              meta[ Int, h2o, m]], 
            Times[ 0.02, 
              meta[ Int, o2Dash, m]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This is already quite good, since the reaction syntax is now what we want. \
However, the metabolite syntax needs some more work,  because the compounds \
and compartments are now symbols and not strings.\nSo we transform them back \
to strings and, while we are at it, we might as well do something about the \
fact that  beautified compound names such as ",
  StyleBox["glcDashD ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "are less than beautiful."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(reps\  = \ {\[IndentingNewLine]"\<NuM\>"\  \[Rule] \ "\<\>", \
\[IndentingNewLine]"\<Dash\>"\  \[Rule] \ "\<-\>", \
\[IndentingNewLine]"\<Sub\>"\  -> \ "\<_\>", \[IndentingNewLine]"\<Prime\>"\  \
\[Rule] \ "\<'\>"};\)\), "\n", 
    \(\(sym2string[sym_]\  := \ 
        Fold[StringReplace, ToString[sym], reps];\)\), "\n", 
    \(\(reacs2\  = \ 
        reacs1\  /. \ 
          meta[a_, b_, c_]\  :> \ 
            meta[a, sym2string@b, sym2string@c];\)\), "\[IndentingNewLine]", 
    \(reacs2[\([indexes]\)]\ \  // TableForm\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(reps\\)\\\" is similar to existing symbols \
\\!\\({rep, res}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\("atp"\^"c" + "glc-D"\^"c"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("adp"\^"c" + "g6p"\^"c" + "h"\^"c"\)}]},
          {
            RowBox[{\("2pg"\^"c"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("3pg"\^"c"\)}]},
          {
            RowBox[{\("fum"\^"m" + "h2o"\^"m"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("mal-L"\^"m"\)}]},
          {
            RowBox[{\(4\ "focytC"\^"m" + 7.92`\ "h"\^"m" + "o2"\^"m"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \(4\ "ficytC"\^"m" + 4\ "h"\^"c" + 
                1.96`\ "h2o"\^"m" + 0.02`\ "o2-"\^"m"\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        RightVector[ 
          Plus[ 
            meta[ Int, "atp", "c"], 
            meta[ Int, "glc-D", "c"]], 
          Plus[ 
            meta[ Int, "adp", "c"], 
            meta[ Int, "g6p", "c"], 
            meta[ Int, "h", "c"]]], 
        Equilibrium[ 
          meta[ Int, "2pg", "c"], 
          meta[ Int, "3pg", "c"]], 
        Equilibrium[ 
          Plus[ 
            meta[ Int, "fum", "m"], 
            meta[ Int, "h2o", "m"]], 
          meta[ Int, "mal-L", "m"]], 
        RightVector[ 
          Plus[ 
            Times[ 4, 
              meta[ Int, "focytC", "m"]], 
            Times[ 7.9199999999999999, 
              meta[ Int, "h", "m"]], 
            meta[ Int, "o2", "m"]], 
          Plus[ 
            Times[ 4, 
              meta[ Int, "ficytC", "m"]], 
            Times[ 4, 
              meta[ Int, "h", "c"]], 
            Times[ 1.96, 
              meta[ Int, "h2o", "m"]], 
            Times[ 0.02, 
              meta[ Int, "o2-", "m"]]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
We are nearly done with the reactions. The last thing is to \
transform any real stoichiometric factors to rartionals.  \
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(reacs3\  = \ 
        reacs2 /. \ a_\ \ meta[x_, y_, z_]\  :> \ 
            real2rat[a]\ meta[x, y, z];\)\), "\n", 
    \(reacs3[\([indexes]\)]\ \  // TableForm\)}], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\("atp"\^"c" + "glc-D"\^"c"\), 
              StyleBox["\[RightVector]",
                FontSize->18], \("adp"\^"c" + "g6p"\^"c" + "h"\^"c"\)}]},
          {
            RowBox[{\("2pg"\^"c"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("3pg"\^"c"\)}]},
          {
            RowBox[{\("fum"\^"m" + "h2o"\^"m"\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], \("mal-L"\^"m"\)}]},
          {
            
            RowBox[{\(4\ "focytC"\^"m" + \(198\ "h"\^"m"\)\/25 + "o2"\^"m"\), 
              
              StyleBox["\[RightVector]",
                FontSize->18], \(4\ "ficytC"\^"m" + 
                4\ "h"\^"c" + \(49\ "h2o"\^"m"\)\/25 + "o2-"\^"m"\/50\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        RightVector[ 
          Plus[ 
            meta[ Int, "atp", "c"], 
            meta[ Int, "glc-D", "c"]], 
          Plus[ 
            meta[ Int, "adp", "c"], 
            meta[ Int, "g6p", "c"], 
            meta[ Int, "h", "c"]]], 
        Equilibrium[ 
          meta[ Int, "2pg", "c"], 
          meta[ Int, "3pg", "c"]], 
        Equilibrium[ 
          Plus[ 
            meta[ Int, "fum", "m"], 
            meta[ Int, "h2o", "m"]], 
          meta[ Int, "mal-L", "m"]], 
        RightVector[ 
          Plus[ 
            Times[ 4, 
              meta[ Int, "focytC", "m"]], 
            Times[ 
              Rational[ 198, 25], 
              meta[ Int, "h", "m"]], 
            meta[ Int, "o2", "m"]], 
          Plus[ 
            Times[ 4, 
              meta[ Int, "ficytC", "m"]], 
            Times[ 4, 
              meta[ Int, "h", "c"]], 
            Times[ 
              Rational[ 49, 25], 
              meta[ Int, "h2o", "m"]], 
            Times[ 
              Rational[ 1, 50], 
              meta[ Int, "o2-", "m"]]]]}]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now we are truly done with the reactions. And it seems that all we \
still need  is to get the reaction names\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rnames\  = 
      Map[\[IndentingNewLine]Composition[sym2string, First, Rest], 
        text]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rnames\\)\\\" is similar to existing symbol \
\\\"\\!\\(names\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \({"HEX1", "G6PI", "G6PI2", "PGI", "PFK", "FBA", "TPI", "GAPD", "PGK", 
      "PGM", "ENO", "PYK", "PDHm", "CSm", "ACONTm", "ICDHxm", "ICDHym", 
      "AKGDm", "SUCOASm", "SUCD1m", "FUMm", "MDHm", "NADH2-u10m", 
      "SUCD3-u10m", "CYOR-u10m", "CYOOm3", "ATPS4m", "GLUCYS", "GTHDHm", 
      "GTHOm", "GTHPm", "GTHRDt", "GTHS", "SPODMm", "THD1m", "CATm", 
      "ASPGLUm", "ASPTA", "MDH", "AKGMALtm", "ASPTAm", "ALASm", "5AOPtm", 
      "PPBNGS", "HMBS", "UPP3S", "UPPDC1", "CPPPGO", "PPPG9tm", "PPPGOm", 
      "FCLTm", "FAOXC160", "FAOXC180", "FAOXC181", "FAOXC182", "FAOXC204", 
      "FAOXC226", "C160", "C160CPT1", "C160CPT2", "C160CRN", "C180", 
      "C180CPT1", "C180CPT2", "C180CRN", "C181", "C181CRN1", "C181CRN2", 
      "C181CRN3", "C182", "C182CRN1", "C182CRN2", "C182CRN3", "C204", 
      "C204CRN1", "C204CRN2", "C204CRN3", "C226", "C226CRN1", "C226CRN2", 
      "C226CRN3", "CRNtim", "CHLPCTD", "DAGCPTm", "PCtm", "PSDm", "PStm", 
      "G3PDm", "CLPNSm", "PAPAm", "DAGKm", "ETHAPTm", "HMGLm", "OCOAT1m", 
      "ACACT1m", "MMSAD1m", "PPCOACm", "HACDm", "GLYKm", "FASYNm", "G3PATm", 
      "AGATm", "DASYNm", "PCHOLPm", "PGSAm", "PGPPm", "NH4tm", "UREAt", 
      "CBMKm", "OCBTm", "ARGSS", "ARGSL", "ARGN", "ORNt4m", "GLYAMDTR", 
      "GACMTR", "CK", "ADK1", "ADK1m", "ADK4m", "DGNSKm", "DHORDm", 
      "DUTPDPm", "NDPK1", "TMDK1m", "GLUDx", "GLUDy", "TYRTAm", "LDH_L", 
      "ME2m", "PCm", "PEPCKm", "FTHFLm", "GHMT2rm", "HMGCOASm", "THFATm", 
      "H2CO3Dm", "H2OD", "HCO3Em", "PPA", "PPAm", "ARGtm", "ATPtm", "CITRtm", 
      "CITtam", "CITtbm", "CO2tm", "COAtm", "DNC1C", "DNC1G", "DNC1U", 
      "FE2tm", "FRDcm", "GLUt2m", "GLYC3Ptm", "GLYCtm", "GLYtm", "GTPtm", 
      "H2Otm", "Htm", "LYStm", "MALtm", "O2tm", "ORNt3m", "PIt2m", "PYRt2m", 
      "SUCCt2m", "12DGRt1", "C204t", "C226t", "CO2t", "COAt", "CYSt2r", 
      "FE2t1", "GLCt1", "GLUt2r", "GLYC3Pt1", "GLYCt1", "GLYt2r", "H2Ot", 
      "HDCAt", "Ht", "L-LACt2r", "O2t", "OCDCAt", "OCDCEAt", "OCDCYAt", 
      "PIt2r", "PSt"}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "and use ",
  StyleBox["constructmnet ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "to build the network. \nUnfortunately some reactions, which are necessary \
for the proper functioning of the network , are not listed in the reactions \
sheet of the original .xls file, but on the constraint sheet.\nSo we add \
these by hand and then call ",
  StyleBox["constructmnet ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " ."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"more", "=", "\[IndentingNewLine]", 
        RowBox[{"{", " ", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"\"\<DMatp\>\"", ",", "   ", 
                
                RowBox[{\("\<h2o\>"\^"\<c\>"\  + \ "\<atp\>"\^"\<c\>"\), " ", 
                  
                  StyleBox["\[RightVector]",
                    
                    FontSize->
                      18], \("\<adp\>"\^"\<c\>"\  + "\<h\>"\^"\<c\>"\ \  + \
"\<pi\>"\^"\<c\>"\)}]}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
              RowBox[{"\"\<DMheme\>\"", ",", "  ", 
                RowBox[{\("\<pheme\>"\^"\<m\>"\), " ", 
                  StyleBox["\[RightVector]",
                    FontSize->18], " ", \("\<pheme\>"\^"\<e\>"\)}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
              RowBox[{"\"\<DMPL\>\"", ",", "       ", 
                
                RowBox[{\(18\ \ "\<clpn_m\>"\^"\<m\>" + 
                    43\ "\<pc_m\>"\^"\<m\>"\  + \ 34\ \ "\<pe_m\>"\^"\<m\>"\),
                   "  ", 
                  StyleBox["\[RightVector]",
                    FontSize->18], \(100\ "\<PL\>"\^"\<e\>"\)}]}], "}"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"{", 
              RowBox[{"\"\<Satpctp\>\"", ",", " ", 
                
                RowBox[{\("\<atp\>"\^"\<m\>"\ \  + \ "\<cmp\>"\^"\<m\>"\), 
                  " ", 
                  StyleBox["\[RightVector]",
                    FontSize->18], 
                  " ", \("\<amp\>"\^"\<m\>"\  + \ "\<ctp\>"\^"\<m\>"\)}]}], 
              "}"}]}], "}"}]}], 
      ";"}], "\n", \(reacs3\  = 
        Join[reacs3, Last[Transpose[more]]];\), "\n", \(rnames\  = \ 
        Join[rnames, First[Transpose[more]]];\), "\n", \(humitall\  = \ 
        constructmnet[reacs3, rnames];\)}], "Input"],

Cell[TextData[{
  "\nFor Tutorial 4, we do not want all of the reactions but only those  \
involving at least one mitochondrial metabolite.\n ",
  StyleBox["submnetwith ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " extracts the appropriate subnetwork and, finally, we change the role of \
all non-mitochondrial metabolites to ",
  StyleBox["Xt",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ". "
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[{
    \(\(mithumit\  = \ 
        submnetwith[\ with["\<m\>", metabolites@humitall], 
          humitall];\)\), "\n", 
    \(\(mithumit1\  = \ 
        setrole[mithumit\ , \ \ \ with[{"\<c\>", "\<e\>"}, 
            metabolites@mithumit\ ], Xt];\)\)}], "Input"],

Cell["\<\

Now mithumit1 should be the network used in Tutorial 4. Let's check\
\>", \
"Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({name, humit}\  = \ << HumanMitochondria.m;\)\), "\n", 
    \(mithumit1\  === \ humit\)}], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{811, 755},
WindowMargins->{{232, Automatic}, {Automatic, 45}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 106, 2, 35, "Title"],
Cell[1863, 55, 381, 15, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2269, 74, 67, 1, 31, "Input"],
Cell[2339, 77, 89, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2465, 83, 323, 12, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2813, 99, 103, 2, 31, "Input"],
Cell[2919, 103, 1237, 27, 257, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4193, 135, 179, 4, 47, "Input"],
Cell[4375, 141, 188, 4, 89, "Output"]
}, Open  ]],
Cell[4578, 148, 396, 13, 57, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4999, 165, 196, 3, 63, "Input"],
Cell[5198, 170, 692, 15, 113, "Output"]
}, Open  ]],
Cell[5905, 188, 434, 12, 87, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6376, 205, 1063, 31, 181, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7464, 240, 195, 4, 47, "Input"],
Cell[7662, 246, 354, 5, 39, "Message"],
Cell[8019, 253, 191, 5, 74, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8247, 263, 123, 2, 31, "Input"],
Cell[8373, 267, 688, 15, 113, "Output"]
}, Open  ]],
Cell[9076, 285, 326, 10, 57, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9427, 299, 88, 1, 31, "Input"],
Cell[9518, 302, 2225, 70, 113, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11792, 378, 506, 15, 89, "Subsubsection",
  Evaluatable->False],
Cell[12301, 395, 775, 15, 127, "Input"],
Cell[13079, 412, 447, 17, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13551, 433, 139, 2, 47, "Input"],
Cell[13693, 437, 2067, 60, 113, "Output"]
}, Open  ]],
Cell[15775, 500, 645, 16, 87, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16445, 520, 562, 11, 143, "Input"],
Cell[17010, 533, 353, 5, 39, "Message"],
Cell[17366, 540, 1922, 56, 117, "Output"]
}, Open  ]],
Cell[19303, 599, 251, 8, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19579, 611, 198, 4, 47, "Input"],
Cell[19780, 617, 2028, 61, 123, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21857, 684, 317, 10, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22199, 698, 126, 3, 47, "Input"],
Cell[22328, 703, 359, 5, 39, "Message"],
Cell[22690, 710, 2042, 28, 286, "Output"]
}, Open  ]],
Cell[24747, 741, 666, 20, 99, "Text",
  Evaluatable->False],
Cell[25416, 763, 1886, 42, 147, "Input"],
Cell[27305, 807, 622, 19, 99, "Text",
  Evaluatable->False],
Cell[27930, 828, 274, 6, 47, "Input"],
Cell[28207, 836, 201, 9, 57, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28433, 849, 122, 2, 47, "Input"],
Cell[28558, 853, 38, 1, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

