(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    132735,       3120]*)
(*NotebookOutlinePosition[    133396,       3143]*)
(*  CellTagsIndexPosition[    133352,       3139]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Flux Balance Analysis",
    FontSize->18,
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\n",
    FontSize->18,
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(<< "\<../mathcode/SNAsym.m\>";\)\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We shall look at  the yeast  network and consider the same scenario \
as in Tutorial 8 .\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({name, yeast}\  = \ << yeast.m;\)\), "\[IndentingNewLine]", 
    \(name\)}], "Input"],

Cell[BoxData[
    \("S.cerevisiae iND750\n\nDuarte, N.C., Herrgard, M.J., and Palsson, B.O.\
\nGenome Research, 14: 1298-1309,(2004)"\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(\(yeast1\  = \ 
        constructmnet[\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ reactions@yeast\ \  /. \ "\<h2o\>"\^"\<e\>"\  \[Rule] \ 
              0, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
tags@yeast\  /. \ R[x_]\  \[Rule] \ x];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(Xts\  = \ {"\<ac\>"\^"\<e\>", "\<acald\>"\^"\<e\>", \
"\<ala-L\>"\^"\<e\>", "\<Biomass\>"\^"\<e\>", "\<co2\>"\^"\<e\>", \
"\<csn\>"\^"\<e\>", "\<ergst\>"\^"\<e\>", "\<etoh\>"\^"\<e\>", "\<gam6p\>"\^"\
\<e\>", "\<glc-D\>"\^"\<e\>", "\<hdcea\>"\^"\<e\>", "\<ocdcea\>"\^"\<e\>", \
"\<ocdcya\>"\^"\<e\>", "\<so4\>"\^"\<e\>", "\<xylt\>"\^"\<e\>", \
"\<zymst\>"\^"\<e\>", "\<nh4\>"\^"\<e\>", "\<asp-L\>"\^"\<e\>", \
"\<ser-L\>"\^"\<e\>", "\<fum\>"\^"\<e\>", "\<gly\>"\^"\<e\>", \
"\<thr-L\>"\^"\<e\>"};\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(yeast2\  = \ setrole[yeast1, Xts, Xt];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The first thing is, to prepare the network for flux balance \
analysis by\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[BoxData[
    \(\(fbayeast2\  = \ FBAprep[yeast2];\)\)], "Input"],

Cell["\<\
We next set up a list of constraints on the flows through some of \
the reactions:\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(constr\  = \ {\[IndentingNewLine]{\ 
            exch["\<csn\>"\_Xt\%\("\<e\>"\)], \ {\(-1\), \(-1\)/
                2}\ }, \[IndentingNewLine]{R["\<ORNt3m\>"], \ {0, 
              1}}\[IndentingNewLine]};\)\), "\[IndentingNewLine]", 
    \(constr\  // MatrixForm\)}], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"Rx", "[", 
                RowBox[{\("csn"\_Xt\%\("e"\)\), 
                  StyleBox["\[Equilibrium]",
                    FontSize->18], "0"}], 
                "]"}], \({\(-1\), \(-\(1\/2\)\)}\)},
            {\(R["ORNt3m"]\), \({0, 1}\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Each constraint  is  a list consisting of a reaction tag and a pair of \
numbers.  The first number of the pair gives the lower and the second one the \
upper bound for the allowed flow through the reaction. The numbers in the \
bounds should be integers, rationals or \[PlusMinus]\[Infinity] unless the \
option ",
  StyleBox["numeric",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" (see below) is used. Then reals may be also occur in the \
bounds.",
    FontVariations->{"CompatibilityType"->0}],
  "\nThe default admissible range for reactions not specified in the \
constraints is",
  StyleBox[" {-\[Infinity],\[Infinity]}",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " for reversible and  ",
  StyleBox["{0,\[Infinity]}",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " for irreversible reactions."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[TextData[{
  "Now we are ready to call ",
  StyleBox["FBA",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontWeight->"Bold"],
  ", passing  as the first argument the structure returned by ",
  StyleBox["FBAprep",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" , ",
    FontWeight->"Bold"],
  "specifying which flow should be maximized by the tag of the corresponding \
reaction passed as  the second argument,  and giving the constraints in the \
third argument."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({opt, flux}\  = \ 
        FBA[fbayeast2\ , exch["\<Biomass\>"\_Xt\%\("\<e\>"\)], 
          constr];\)\), "\n", 
    \(opt\)}], "Input"],

Cell[BoxData[
    \(10000\/1607\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["opt ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " gives the maximal flow through ",
  Cell[BoxData[
      StyleBox[
        RowBox[{"Rx", "[", 
          RowBox[{\("Biomass"\_Xt\%\("e"\)\), 
            StyleBox["\[Equilibrium]",
              FontSize->18], "0"}], "]"}],
        FontWeight->"Bold",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontVariations->{"Underline"->False,
        "Outline"->False,
        "Shadow"->False,
        "StrikeThrough"->False,
        "Masked"->False,
        "CompatibilityType"->0,
        "RotationAngle"->0}]]],
  " given the constraints ",
  StyleBox["constr",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "; \n",
  StyleBox["flux ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "is one (of often many) flux vectors realizing  ",
  StyleBox["opt ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ". \nThe symbolic form familiar from e.g. ",
  StyleBox["symfluxelvs",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " is used for ",
  StyleBox["flux",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ". "
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(flux\)], "Input"],

Cell[BoxData[
    RowBox[{\(\(11348\ R["13GS"]\)\/1607\), 
      "+", \(\(2862\ R["2OXOADPtim"]\)\/1607\), 
      "-", \(\(5610\ R["3MOBtm"]\)\/1607\), 
      "-", \(\(1927\ R["3MOPtm"]\)\/1607\), 
      "+", \(\(2862\ R["AASAD2"]\)\/1607\), 
      "+", \(\(2862\ R["AATA"]\)\/1607\), 
      "+", \(\(8288419\ R["ACALDt"]\)\/8035\), 
      "+", \(\(9156\ R["ACCOACr"]\)\/8035\), "+", \(R["ACGKm"]\), 
      "+", \(\(1927\ R["ACHBSm"]\)\/1607\), 
      "+", \(\(5610\ R["ACLSm"]\)\/1607\), 
      "+", \(\(93491\ R["ACOAH"]\)\/8035\), 
      "+", \(\(10188\ R["ACONTm"]\)\/1607\), "+", \(R["ACOTAim"]\), 
      "+", \(\(13050\ R["ACRNtim"]\)\/1607\), 
      "+", \(\(90626\ R["ACt2r"]\)\/8035\), 
      "+", \(\(247\ R["ADHAPR_SC"]\)\/1607\), 
      "+", \(\(9689\ R["ADK1"]\)\/1607\), "+", \(\(240\ R["ADNK1"]\)\/1607\), 
      "+", \(\(573\ R["ADSK"]\)\/1607\), "+", \(\(1159\ R["ADSL1r"]\)\/1607\),
       "+", \(\(980\ R["ADSL2r"]\)\/1607\), 
      "+", \(\(1159\ R["ADSS"]\)\/1607\), 
      "+", \(\(247\ R["AGAT_SC"]\)\/1607\), "+", \(R["AGPRim"]\), 
      "+", \(\(180\ R["AHCi"]\)\/1607\), "+", \(\(507\ R["AHSERL2"]\)\/1607\),
       "+", \(\(1643\ R["AICART"]\)\/1607\), 
      "+", \(\(980\ R["AIRCr"]\)\/1607\), 
      "+", \(\(228126\ R["ALAt2r"]\)\/8035\), 
      "+", \(\(205186\ R["ALATA_L"]\)\/8035\), 
      "-", \(\(8288419\ R["ALCD2x"]\)\/8035\), 
      "+", \(\(284\ R["ANPRT"]\)\/1607\), "+", \(\(284\ R["ANS"]\)\/1607\), 
      "+", \(R["ARGSL"]\), "+", \(R["ARGSSr"]\), 
      "+", \(\(507\ R["ASADi"]\)\/1607\), "+", \(\(1017\ R["ASNS1"]\)\/1607\),
       "+", \(\(507\ R["ASPKi"]\)\/1607\), 
      "+", \(\(8933\ R["ASPt2m"]\)\/1607\), 
      "-", \(\(3989292\ R["ASPt2r"]\)\/8035\), 
      "-", \(\(4075182\ R["ASPTA"]\)\/8035\), 
      "+", \(\(8933\ R["ASPTAm"]\)\/1607\), 
      "+", \(\(663\ R["ATPPRT"]\)\/1607\), 
      "+", \(\(307101\ R["ATPS"]\)\/8035\), 
      "+", \(\(7537\ R["ATPtm-H"]\)\/1607\), 
      "+", \(\(10000\ R["BioM"]\)\/1607\), "+", \(\(573\ R["BPNT"]\)\/1607\), 
      "+", \(R["CBPS"]\), "+", \(\(2359\ R["CHORM"]\)\/1607\), 
      "+", \(\(2643\ R["CHORS"]\)\/1607\), 
      "-", \(\(4035222\ R["CO2t"]\)\/8035\), 
      "-", \(\(49274\ R["CO2tm"]\)\/1607\), 
      "+", \(\(13050\ R["CRNtim"]\)\/1607\), 
      "+", \(\(10188\ R["CSm"]\)\/1607\), 
      "+", \(\(13050\ R["CSNAT"]\)\/1607\), 
      "+", \(\(13050\ R["CSNATifm"]\)\/1607\), 
      "+", \(\(1106\ R["CSND"]\)\/1607\), "+", \(\(1106\ R["CSNt2"]\)\/1607\),
       "+", \(\(447\ R["CTPS1"]\)\/1607\), "+", \(\(66\ R["CYSS"]\)\/1607\), 
      "-", \(\(272\ R["CYTK1"]\)\/1607\), "-", \(\(96\ R["DADK"]\)\/1607\), 
      "+", \(\(66\ R["DAGPYP_SC"]\)\/1607\), 
      "+", \(\(175\ R["DASYN_SC"]\)\/1607\), 
      "-", \(\(24\ R["DCMPDA"]\)\/1607\), "+", \(\(2643\ R["DDPA"]\)\/1607\), 
      "-", \(\(24\ R["DGK1"]\)\/1607\), "+", \(\(5610\ R["DHAD1m"]\)\/1607\), 
      "+", \(\(1927\ R["DHAD2m"]\)\/1607\), "+", \(\(36\ R["DHFRi"]\)\/1607\),
       "+", \(\(2643\ R["DHQS"]\)\/1607\), 
      "+", \(\(2643\ R["DHQTi"]\)\/1607\), 
      "+", \(\(8079\ R["DOLPMMer"]\)\/1607\), 
      "+", \(\(8079\ R["DOLPMTcer"]\)\/1607\), 
      "-", \(\(8079\ R["DOLPt2er"]\)\/1607\), 
      "+", \(\(60\ R["DURIK1"]\)\/1607\), "-", \(\(60\ R["DURIPP"]\)\/1607\), 
      "+", \(\(5286\ R["ENO"]\)\/1607\), "+", \(\(7\ R["ERGSTt"]\)\/1607\), 
      "-", \(\(8288419\ R["ETOHt"]\)\/8035\), 
      "-", \(\(896\ R["FACOAL140"]\)\/8035\), 
      "+", \(\(756\ R["FACOAL160"]\)\/8035\), 
      "+", \(\(476\ R["FACOAL161"]\)\/8035\), 
      "+", \(\(28\ R["FACOAL180"]\)\/1607\), 
      "+", \(\(672\ R["FACOAL181"]\)\/8035\), 
      "+", \(\(252\ R["FACOAL182"]\)\/8035\), 
      "+", \(\(280\ R["FAS100COA"]\)\/1607\), 
      "+", \(\(1344\ R["FAS120COA"]\)\/8035\), 
      "+", \(\(1176\ R["FAS140COA"]\)\/8035\), 
      "+", \(\(896\ R["FAS160"]\)\/8035\), "+", \(\(28\ R["FAS180"]\)\/1607\),
       "+", \(\(280\ R["FAS80COA_L"]\)\/1607\), 
      "-", \(\(2003\ R["FBA"]\)\/1607\), "+", \(\(2003\ R["FBP"]\)\/1607\), 
      "+", \(\(4057533\ R["FDH"]\)\/8035\), 
      "+", \(\(9144\ R["FORtm"]\)\/1607\), 
      "-", \(\(4011813\ R["FTHFL"]\)\/8035\), 
      "-", \(\(9144\ R["FTHFLm"]\)\/1607\), 
      "+", \(\(3940586\ R["FUM"]\)\/8035\), 
      "+", \(\(3921856\ R["FUMt2r"]\)\/8035\), 
      "+", \(\(1647\ R["G5SADr"]\)\/1607\), 
      "+", \(\(1647\ R["G5SD2"]\)\/1607\), 
      "+", \(\(1977\ R["G6PDA"]\)\/1607\), 
      "+", \(\(16767\ R["GALU"]\)\/1607\), 
      "+", \(\(1977\ R["GAM6Pt"]\)\/1607\), 
      "+", \(\(5286\ R["GAPD"]\)\/1607\), "+", \(\(980\ R["GARFTi"]\)\/1607\),
       "+", \(\(247\ R["GAT2_SC"]\)\/1607\), 
      "+", \(\(5185\ R["GBEZ"]\)\/1607\), 
      "+", \(\(4074263\ R["GHMT2r"]\)\/8035\), 
      "+", \(\(24\ R["GK1"]\)\/1607\), "+", \(\(7069\ R["GLNS"]\)\/1607\), 
      "+", \(\(1647\ R["GLU5K"]\)\/1607\), 
      "-", \(\(3951411\ R["GLUDy"]\)\/8035\), 
      "+", \(\(980\ R["GLUPRT"]\)\/1607\), 
      "-", \(\(5719\ R["GLUt2m"]\)\/1607\), 
      "+", \(\(5185\ R["GLYGS"]\)\/1607\), 
      "-", \(\(4054843\ R["GLYt2r"]\)\/8035\), 
      "+", \(\(484\ R["GMPS2"]\)\/1607\), 
      "+", \(\(3675511\ R["H2Ot"]\)\/8035\), 
      "+", \(\(14657\ R["H2Otm"]\)\/1607\), 
      "+", \(\(2862\ R["HACNHm"]\)\/1607\), 
      "+", \(\(2862\ R["HCITSm"]\)\/1607\), 
      "+", \(\(300972\ R["HCO3E"]\)\/8035\), 
      "+", \(\(476\ R["HDCEAt"]\)\/8035\), 
      "+", \(\(2862\ R["HICITDm"]\)\/1607\), 
      "+", \(\(663\ R["HISTD"]\)\/1607\), "+", \(\(663\ R["HISTP"]\)\/1607\), 
      "+", \(\(507\ R["HSDxi"]\)\/1607\), "+", \(\(507\ R["HSERTA"]\)\/1607\),
       "+", \(\(663\ R["HSTPT"]\)\/1607\), 
      "+", \(\(10188\ R["ICDHxm"]\)\/1607\), 
      "+", \(\(663\ R["IG3PS"]\)\/1607\), "+", \(\(663\ R["IGPDH"]\)\/1607\), 
      "+", \(\(284\ R["IGPS"]\)\/1607\), "-", \(\(1927\ R["ILETA"]\)\/1607\), 
      "-", \(\(1643\ R["IMPC"]\)\/1607\), "+", \(\(484\ R["IMPD"]\)\/1607\), 
      "+", \(\(2964\ R["IPMD"]\)\/1607\), 
      "-", \(\(2964\ R["IPPMIa"]\)\/1607\), 
      "-", \(\(2964\ R["IPPMIb"]\)\/1607\), 
      "+", \(\(2964\ R["IPPS"]\)\/1607\), 
      "+", \(\(5610\ R["KARA1im"]\)\/1607\), 
      "+", \(\(1927\ R["KARA2im"]\)\/1607\), 
      "-", \(\(2964\ R["LEUTA"]\)\/1607\), 
      "-", \(\(13050\ R["MALtm"]\)\/1607\), 
      "+", \(\(8079\ R["MAN1PT"]\)\/1607\), 
      "-", \(\(8079\ R["MAN6PI"]\)\/1607\), 
      "-", \(\(8079\ R["MANNANter"]\)\/1607\), 
      "+", \(\(2862\ R["MCITDm"]\)\/1607\), 
      "+", \(\(4005836\ R["MDH"]\)\/8035\), 
      "-", \(\(41632\ R["MDHm"]\)\/1607\), 
      "+", \(\(28582\ R["ME1m"]\)\/1607\), "+", \(\(180\ R["METAT"]\)\/1607\),
       "+", \(\(687\ R["METS"]\)\/1607\), 
      "+", \(\(60\ R["MFAPS_SC"]\)\/1607\), "+", \(\(53\ R["MI1PP"]\)\/1607\),
       "+", \(\(53\ R["MI1PS"]\)\/1607\), 
      "+", \(\(9144\ R["MLTHFtm"]\)\/1607\), 
      "+", \(\(4024928\ R["MTHFC"]\)\/8035\), 
      "+", \(\(9144\ R["MTHFCm"]\)\/1607\), 
      "+", \(\(4024928\ R["MTHFD"]\)\/8035\), 
      "+", \(\(9144\ R["MTHFDm"]\)\/1607\), 
      "+", \(\(687\ R["MTHFR3"]\)\/1607\), 
      "+", \(\(10308\ R["NDPK1"]\)\/1607\), 
      "+", \(\(17214\ R["NDPK2"]\)\/1607\), 
      "-", \(\(272\ R["NDPK3"]\)\/1607\), "-", \(\(24\ R["NDPK5"]\)\/1607\), 
      "+", \(\(3964061\ R["NH4t"]\)\/8035\), 
      "-", \(\(1927\ R["NH4tm"]\)\/1607\), "+", \(\(60\ R["NTD6"]\)\/1607\), 
      "+", \(\(42887\ R["OAAt2m"]\)\/1607\), "+", \(R["OCBTi"]\), 
      "+", \(\(672\ R["OCDCEAt"]\)\/8035\), 
      "+", \(\(252\ R["OCDCYAt"]\)\/8035\), 
      "+", \(\(2964\ R["OMCDC"]\)\/1607\), "+", \(R["ORNt3m"]\), 
      "+", \(R["ORNTACim"]\), "+", \(\(2862\ R["OXAGm"]\)\/1607\), 
      "+", \(\(1647\ R["P5CR"]\)\/1607\), "+", \(\(573\ R["PAPSR"]\)\/1607\), 
      "+", \(\(283781\ R["PC"]\)\/8035\), 
      "-", \(\(21\ R["PEtm_SC"]\)\/32140\), 
      "+", \(\(60\ R["PETOHM_SC"]\)\/1607\), 
      "-", \(\(17054\ R["PGI"]\)\/1607\), "-", \(\(5286\ R["PGK"]\)\/1607\), 
      "-", \(\(5286\ R["PGM"]\)\/1607\), "-", \(\(16767\ R["PGMT"]\)\/1607\), 
      "-", \(\(1339\ R["PHETA1"]\)\/1607\), 
      "+", \(\(53\ R["PINOS_SC"]\)\/1607\), 
      "-", \(\(5513\ R["PIt2m"]\)\/1607\), 
      "-", \(\(8079\ R["PMANM"]\)\/1607\), 
      "+", \(\(60\ R["PMETM_SC"]\)\/1607\), 
      "+", \(\(34041\ R["PPA"]\)\/1607\), "-", \(\(1106\ R["PPM"]\)\/1607\), 
      "+", \(\(1020\ R["PPND"]\)\/1607\), "+", \(\(1339\ R["PPNDH"]\)\/1607\),
       "+", \(\(980\ R["PRAGSr"]\)\/1607\), 
      "+", \(\(284\ R["PRAIi"]\)\/1607\), "+", \(\(980\ R["PRAIS"]\)\/1607\), 
      "+", \(\(663\ R["PRAMPC"]\)\/1607\), 
      "+", \(\(980\ R["PRASCS"]\)\/1607\), 
      "+", \(\(663\ R["PRATPP"]\)\/1607\), "+", \(\(980\ R["PRFGS"]\)\/1607\),
       "+", \(\(663\ R["PRMICIi"]\)\/1607\), 
      "+", \(\(1927\ R["PRPPS"]\)\/1607\), 
      "+", \(\(2643\ R["PSCVTi"]\)\/1607\), 
      "+", \(\(105\ R["PSERDm_SC"]\)\/1607\), 
      "+", \(\(122\ R["PSERS_SC"]\)\/1607\), 
      "+", \(\(21\ R["PStm_SC"]\)\/32140\), "-", \(\(60\ R["PUNP1"]\)\/1607\),
       "+", \(\(60\ R["PUNP2"]\)\/1607\), 
      "-", \(\(1046\ R["PYNP2r"]\)\/1607\), 
      "-", \(\(15435\ R["PYRt2m"]\)\/1607\), 
      "+", \(\(96\ R["RNDR1"]\)\/1607\), "+", \(\(24\ R["RNTR2"]\)\/1607\), 
      "-", \(\(14931\ R["RPE"]\)\/1607\), "-", \(\(14931\ R["RPI"]\)\/1607\), 
      "+", \(\(2862\ R["SACCD1"]\)\/1607\), 
      "+", \(\(2862\ R["SACCD2"]\)\/1607\), 
      "+", \(\(66\ R["SERATi"]\)\/1607\), 
      "+", \(\(4085893\ R["SERt2r"]\)\/8035\), 
      "+", \(\(2643\ R["SHK3D"]\)\/1607\), "+", \(\(2643\ R["SHKK"]\)\/1607\),
       "+", \(\(573\ R["SLFAT"]\)\/1607\), "+", \(\(773\ R["SO4ti"]\)\/1607\),
       "-", \(\(573\ R["SULR"]\)\/1607\), "+", \(\(11898\ R["TALA"]\)\/1607\),
       "-", \(\(9144\ R["THFtm"]\)\/1607\), 
      "+", \(\(1927\ R["THRD_Lm"]\)\/1607\), 
      "+", \(\(1927\ R["THRt2m"]\)\/1607\), 
      "+", \(\(3841\ R["THRt2r"]\)\/1607\), 
      "+", \(\(11898\ R["TKT1"]\)\/1607\), "+", \(\(9255\ R["TKT2"]\)\/1607\),
       "+", \(\(36\ R["TMDS"]\)\/1607\), "-", \(\(2250\ R["TPI"]\)\/1607\), 
      "+", \(\(693\ R["TRDR"]\)\/1607\), "+", \(\(234\ R["TRE6PP"]\)\/1607\), 
      "+", \(\(234\ R["TRE6PS"]\)\/1607\), 
      "+", \(\(66\ R["TRIGS_SC"]\)\/1607\), 
      "+", \(\(284\ R["TRPS1"]\)\/1607\), "-", \(\(1020\ R["TYRTA"]\)\/1607\),
       "+", \(\(447\ R["UMPK"]\)\/1607\), "+", \(\(1046\ R["URIK2"]\)\/1607\),
       "-", \(\(2646\ R["VALTA"]\)\/1607\), 
      "+", \(\(36084\ R["XYLK"]\)\/1607\), 
      "+", \(\(36084\ R["XYLTD_D"]\)\/1607\), 
      "+", \(\(36084\ R["XYLTt"]\)\/1607\), 
      "+", \(\(15\ R["ZYMSTt"]\)\/1607\), "-", 
      FractionBox[
        RowBox[{"90626", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ac"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"8288419", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("acald"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"228126", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ala-L"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "+", 
      FractionBox[
        RowBox[{"3989292", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("asp-L"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "+", 
      FractionBox[
        RowBox[{"10000", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("Biomass"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "+", 
      FractionBox[
        RowBox[{"4035222", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("co2"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"1106", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("csn"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "-", 
      FractionBox[
        RowBox[{"7", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ergst"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "+", 
      FractionBox[
        RowBox[{"8288419", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("etoh"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"3921856", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("fum"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"1977", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("gam6p"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "+", 
      FractionBox[
        RowBox[{"4054843", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("gly"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"476", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("hdcea"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"3964061", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("nh4"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"672", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ocdcea"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"252", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ocdcya"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"4085893", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("ser-L"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "8035"], "-", 
      FractionBox[
        RowBox[{"773", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("so4"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "-", 
      FractionBox[
        RowBox[{"3841", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("thr-L"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "-", 
      FractionBox[
        RowBox[{"36084", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("xylt"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"], "-", 
      FractionBox[
        RowBox[{"15", " ", 
          RowBox[{"Rx", "[", 
            RowBox[{\("zymst"\_Xt\%\("e"\)\), 
              StyleBox["\[Equilibrium]",
                FontSize->18], "0"}], "]"}]}], "1607"]}]], "Output"]
}, Open  ]],

Cell["To optimize Biomass production one could also have used :", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({opt, flux}\  = \ 
        FBA[fbayeast2\ , R["\<BioM\>"], constr];\)\), "\n", 
    \(opt\)}], "Input"],

Cell[BoxData[
    \(10000\/1607\)], "Output"]
}, Open  ]],

Cell["\<\
To minimize  the flow through a reaction precede its tag with a \
minus sign. \
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({opt, flux}\  = \ 
        FBA[fbayeast2\ , \(-R["\<BioM\>"]\), constr];\)\), "\n", 
    \(opt\)}], "Input"],

Cell[BoxData[
    \(2500\/553\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "For solving thousands of FBA problems, ",
  StyleBox["FBA",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["  ",
    FontWeight->"Bold"],
  "is a bit slow.  Hence ",
  StyleBox["FBAprep",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontWeight->"Bold"],
  " has some options to speed up subsequent calls to ",
  StyleBox["FBA",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" .",
    FontWeight->"Bold"]
}], "Section",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[FBAprep]\)], "Input"],

Cell[BoxData[
    \({simplification \[Rule] 1, exchonly \[Rule] False, 
      numeric \[Rule] False}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The most straightforward option is ",
  StyleBox["numeric",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ", which instructs ",
  StyleBox["FBA",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontWeight->"Bold"],
  " to do the linear programming numerically: "
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(nfbayeast2\  = \ FBAprep[yeast2, numeric \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nfbayeast2\\)\\\" is similar to existing \
symbol \\\"\\!\\(fbayeast2\\)\\\". \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({opt, flux}\  = \ 
        FBA[nfbayeast2\ , exch["\<Biomass\>"\_Xt\%\("\<e\>"\)], 
          constr];\)\), "\n", 
    \(opt\)}], "Input"],

Cell[BoxData[
    \(6.222775357719385`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The option",
  StyleBox[" simplification",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "  takes values 0,1,2 or 3; it controls how much effort  ",
  StyleBox["FBAprep ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " puts into simplifying the network when preparing it for ",
  StyleBox["FBA.  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "Using ",
  StyleBox["simplification \[Rule] 0 ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "means no simplification, while ",
  StyleBox["FBAprep",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " will itself use linear programming if you specify a value greater than 1. \
 While speeding up ",
  StyleBox["FBA,  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "this may substantially increase the execution time of ",
  StyleBox["FBAprep",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sfbayeast2\  = \ 
        FBAprep[yeast2, simplification \[Rule] 2];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(sfbayeast2\\)\\\" is similar to existing \
symbols \\!\\({fbayeast2, nfbayeast2}\\). \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({opt, flux}\  = \ 
        FBA[sfbayeast2\ , exch["\<Biomass\>"\_Xt\%\("\<e\>"\)], 
          constr];\)\), "\n", 
    \(opt\)}], "Input"],

Cell[BoxData[
    \(10000\/1607\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "If you only need to specify constraints for exchange reactions and the \
optimization target is an exchange reaction as well, you are in fact asking a \
question about the conversion cone. You should then use ",
  StyleBox["exchonly \[Rule] True, ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " since this will allow  ",
  StyleBox["FBAprep",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " to simplify the network to a much greater extent. Then FBA becomes fast \
enough to be used in 3D-plots if you are a little patient. "
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(cnbayeast2\  = \ 
        FBAprep[yeast2, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ exchonly \[Rule] True, simplification \[Rule] 3, 
          numeric\  \[Rule] \ True];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(ppconstr[csn_, 
          ergst_]\  = \ \[IndentingNewLine]{\[IndentingNewLine]{\ 
            exch["\<csn\>"\_Xt\%\("\<e\>"\)], \ {\(-csn\), 
              0}\ }, \[IndentingNewLine]{\ 
            exch["\<ergst\>"\_Xt\%\("\<e\>"\)], \ {\(-ergst\), 
              0}\ }, \[IndentingNewLine]{exch["\<zymst\>"\_Xt\%\("\<e\>"\)], \
{\(-0.007\), 0}}\[IndentingNewLine]};\)\), "\n", 
    \(ppconstr[csn, ergst] // MatrixForm\)}], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"Rx", "[", 
                RowBox[{\("csn"\_Xt\%\("e"\)\), 
                  StyleBox["\[Equilibrium]",
                    FontSize->18], "0"}], "]"}], \({\(-csn\), 0}\)},
            {
              RowBox[{"Rx", "[", 
                RowBox[{\("ergst"\_Xt\%\("e"\)\), 
                  StyleBox["\[Equilibrium]",
                    FontSize->18], "0"}], "]"}], \({\(-ergst\), 0}\)},
            {
              RowBox[{"Rx", "[", 
                RowBox[{\("zymst"\_Xt\%\("e"\)\), 
                  StyleBox["\[Equilibrium]",
                    FontSize->18], "0"}], "]"}], \({\(-0.007`\), 0}\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      FBA[cnbayeast2\ , exch["\<Biomass\>"\_Xt\%\("\<e\>"\)], 
          ppconstr[csn, ergst]] // First, \[IndentingNewLine]{csn, 0, 
        1}, {ergst, 0, 0.005}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.25514e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -17.886 -9 ]
[.14598 .19958 .11404 0 ]
[.27013 .15073 -17.1354 -9 ]
[.27013 .15073 .86461 0 ]
[.40046 .09948 -16.3848 -9 ]
[.40046 .09948 1.61518 0 ]
[.53743 .04564 -15.6342 -9 ]
[.53743 .04564 2.36575 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.76745 .09703 0 -6.16187 ]
[.76745 .09703 30 2.83813 ]
[.82812 .18993 0 -6.07246 ]
[.82812 .18993 30 2.92754 ]
[.88369 .27502 0 -5.99218 ]
[.88369 .27502 30 3.00782 ]
[.93478 .35327 0 -5.9197 ]
[.93478 .35327 30 3.0803 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 30 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.0169 .31029 -6 -2.78051 ]
[.0169 .31029 0 6.21949 ]
[.00948 .35682 -6 -2.81995 ]
[.00948 .35682 0 6.18005 ]
[.00183 .40475 -6 -2.86071 ]
[.00183 .40475 0 6.13929 ]
[-0.00605 .45416 -6 -2.90286 ]
[-0.00605 .45416 0 6.09714 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.75514 .10158 m
.74899 .10385 L
s
[(0.001)] .76745 .09703 -1 .3693 Mshowa
.81573 .19425 m
.80953 .19642 L
s
[(0.002)] .82812 .18993 -1 .34944 Mshowa
.87123 .27915 m
.865 .28122 L
s
[(0.003)] .88369 .27502 -1 .3316 Mshowa
.92227 .35722 m
.91601 .35919 L
s
[(0.004)] .93478 .35327 -1 .31549 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(0.005)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70252 .02109 m
.69885 .02251 L
s
.71605 .04178 m
.71237 .04318 L
s
.72932 .06208 m
.72564 .06347 L
s
.74235 .08201 m
.73866 .08339 L
s
.7677 .12078 m
.764 .12213 L
s
.78003 .13965 m
.77633 .14098 L
s
.79214 .15817 m
.78843 .1595 L
s
.80404 .17637 m
.80033 .17768 L
s
.82721 .21182 m
.82349 .21311 L
s
.8385 .22909 m
.83478 .23037 L
s
.8496 .24606 m
.84587 .24733 L
s
.86051 .26275 m
.85677 .264 L
s
.88178 .29529 m
.87804 .29651 L
s
.89215 .31115 m
.88841 .31237 L
s
.90235 .32676 m
.89861 .32797 L
s
.91239 .34211 m
.90864 .34331 L
s
.93198 .37208 m
.92823 .37326 L
s
.94155 .38671 m
.93779 .38788 L
s
.95096 .40111 m
.9472 .40226 L
s
.96022 .41528 m
.95646 .41643 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02916 .30561 m
.03529 .30326 L
s
[(1)] .0169 .31029 1 -0.38211 Mshowa
.02177 .35223 m
.02792 .34993 L
s
[(2)] .00948 .35682 1 -0.37334 Mshowa
.01416 .40026 m
.02033 .39802 L
s
[(3)] .00183 .40475 1 -0.36429 Mshowa
.00632 .44977 m
.0125 .44758 L
s
[(4)] -0.00605 .45416 1 -0.35492 Mshowa
.125 Mabswid
.03492 .26928 m
.03859 .26786 L
s
.03349 .27828 m
.03716 .27686 L
s
.03206 .28734 m
.03573 .28592 L
s
.03061 .29645 m
.03429 .29504 L
s
.0277 .31482 m
.03138 .31342 L
s
.02623 .32409 m
.02991 .3227 L
s
.02476 .33341 m
.02844 .33203 L
s
.02327 .34279 m
.02695 .34141 L
s
.02027 .36172 m
.02396 .36035 L
s
.01876 .37127 m
.02245 .3699 L
s
.01723 .38088 m
.02093 .37952 L
s
.0157 .39054 m
.0194 .38919 L
s
.01261 .41004 m
.01631 .4087 L
s
.01105 .41989 m
.01476 .41855 L
s
.00948 .42979 m
.01319 .42846 L
s
.0079 .43975 m
.01161 .43843 L
s
.00472 .45986 m
.00843 .45855 L
s
.00311 .47 m
.00682 .4687 L
s
.00149 .48021 m
.00521 .47892 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.102 .478 .896 r
.39236 .59183 .40512 .60371 .42606 .6128 .41334 .60088 Metetra
.102 .478 .896 r
.41334 .60088 .42606 .6128 .44736 .62205 .43469 .6101 Metetra
.102 .478 .896 r
.43469 .6101 .44736 .62205 .46903 .63146 .45642 .61947 Metetra
.102 .478 .896 r
.45642 .61947 .46903 .63146 .49108 .64103 .47852 .62901 Metetra
.102 .478 .896 r
.47852 .62901 .49108 .64103 .51352 .65077 .50102 .63872 Metetra
.102 .478 .896 r
.50102 .63872 .51352 .65077 .53636 .66068 .52392 .6486 Metetra
.102 .478 .896 r
.52392 .6486 .53636 .66068 .5596 .67078 .54724 .65866 Metetra
.102 .478 .896 r
.54724 .65866 .5596 .67078 .58327 .68105 .57099 .66891 Metetra
.102 .478 .896 r
.57099 .66891 .58327 .68105 .60738 .69152 .59517 .67935 Metetra
.102 .478 .896 r
.59517 .67935 .60738 .69152 .63193 .70217 .6198 .68998 Metetra
.102 .478 .896 r
.6198 .68998 .63193 .70217 .65693 .71303 .6449 .70081 Metetra
.102 .478 .896 r
.6449 .70081 .65693 .71303 .68241 .72409 .67047 .71184 Metetra
.493 .701 .962 r
.67047 .71184 .68241 .72409 .7078 .72438 .69599 .71206 Metetra
.646 .762 .934 r
.69599 .71206 .7078 .72438 .73312 .71773 .72146 .70529 Metetra
.646 .762 .934 r
.72146 .70529 .73312 .71773 .75866 .71102 .74716 .69847 Metetra
.646 .762 .934 r
.74716 .69847 .75866 .71102 .78442 .70425 .77309 .69158 Metetra
.646 .762 .934 r
.77309 .69158 .78442 .70425 .81043 .69741 .79926 .68464 Metetra
.646 .762 .934 r
.79926 .68464 .81043 .69741 .83666 .69052 .82567 .67763 Metetra
.646 .762 .934 r
.82567 .67763 .83666 .69052 .86314 .68356 .85232 .67055 Metetra
.646 .762 .934 r
.85232 .67055 .86314 .68356 .88986 .67654 .87922 .66341 Metetra
.646 .762 .934 r
.87922 .66341 .88986 .67654 .91682 .66946 .90636 .6562 Metetra
.646 .762 .934 r
.90636 .6562 .91682 .66946 .94403 .6623 .93376 .64893 Metetra
.646 .762 .934 r
.93376 .64893 .94403 .6623 .9715 .65509 .96142 .64158 Metetra
.646 .762 .934 r
.96142 .64158 .9715 .65509 .99922 .6478 .98933 .63417 Metetra
.102 .478 .896 r
.37941 .57977 .39236 .59183 .41334 .60088 .40044 .58879 Metetra
.102 .478 .896 r
.40044 .58879 .41334 .60088 .43469 .6101 .42183 .59796 Metetra
.102 .478 .896 r
.42183 .59796 .43469 .6101 .45642 .61947 .44361 .6073 Metetra
.102 .478 .896 r
.44361 .6073 .45642 .61947 .47852 .62901 .46577 .61681 Metetra
.102 .478 .896 r
.46577 .61681 .47852 .62901 .50102 .63872 .48833 .62648 Metetra
.102 .478 .896 r
.48833 .62648 .50102 .63872 .52392 .6486 .5113 .63633 Metetra
.102 .478 .896 r
.5113 .63633 .52392 .6486 .54724 .65866 .53468 .64636 Metetra
.102 .478 .896 r
.53468 .64636 .54724 .65866 .57099 .66891 .5585 .65658 Metetra
.102 .478 .896 r
.5585 .65658 .57099 .66891 .59517 .67935 .58276 .66698 Metetra
.102 .478 .896 r
.58276 .66698 .59517 .67935 .6198 .68998 .60748 .67758 Metetra
.102 .478 .896 r
.60748 .67758 .6198 .68998 .6449 .70081 .63266 .68838 Metetra
.102 .478 .896 r
.63266 .68838 .6449 .70081 .67047 .71184 .65833 .69939 Metetra
.493 .701 .962 r
.65833 .69939 .67047 .71184 .69599 .71206 .68399 .69952 Metetra
.646 .762 .934 r
.68399 .69952 .69599 .71206 .72146 .70529 .70962 .69265 Metetra
.646 .762 .934 r
.70962 .69265 .72146 .70529 .74716 .69847 .73548 .68571 Metetra
.646 .762 .934 r
.73548 .68571 .74716 .69847 .77309 .69158 .76157 .67871 Metetra
.646 .762 .934 r
.76157 .67871 .77309 .69158 .79926 .68464 .78791 .67164 Metetra
.646 .762 .934 r
.78791 .67164 .79926 .68464 .82567 .67763 .81449 .66451 Metetra
.646 .762 .934 r
.81449 .66451 .82567 .67763 .85232 .67055 .84132 .65731 Metetra
.646 .762 .934 r
.84132 .65731 .85232 .67055 .87922 .66341 .86839 .65005 Metetra
.646 .762 .934 r
.86839 .65005 .87922 .66341 .90636 .6562 .89572 .64272 Metetra
.646 .762 .934 r
.89572 .64272 .90636 .6562 .93376 .64893 .92331 .63532 Metetra
.646 .762 .934 r
.92331 .63532 .93376 .64893 .96142 .64158 .95116 .62785 Metetra
.646 .762 .934 r
.95116 .62785 .96142 .64158 .98933 .63417 .97927 .62031 Metetra
.102 .478 .896 r
.36626 .56753 .37941 .57977 .40044 .58879 .38733 .57651 Metetra
.102 .478 .896 r
.38733 .57651 .40044 .58879 .42183 .59796 .40878 .58565 Metetra
.102 .478 .896 r
.40878 .58565 .42183 .59796 .44361 .6073 .4306 .59495 Metetra
.102 .478 .896 r
.4306 .59495 .44361 .6073 .46577 .61681 .45282 .60441 Metetra
.102 .478 .896 r
.45282 .60441 .46577 .61681 .48833 .62648 .47544 .61405 Metetra
.102 .478 .896 r
.47544 .61405 .48833 .62648 .5113 .63633 .49847 .62387 Metetra
.102 .478 .896 r
.49847 .62387 .5113 .63633 .53468 .64636 .52192 .63386 Metetra
.102 .478 .896 r
.52192 .63386 .53468 .64636 .5585 .65658 .54581 .64404 Metetra
.102 .478 .896 r
.54581 .64404 .5585 .65658 .58276 .66698 .57015 .65441 Metetra
.102 .478 .896 r
.57015 .65441 .58276 .66698 .60748 .67758 .59495 .66498 Metetra
.102 .478 .896 r
.59495 .66498 .60748 .67758 .63266 .68838 .62022 .67575 Metetra
.102 .478 .896 r
.62022 .67575 .63266 .68838 .65833 .69939 .64598 .68673 Metetra
.493 .701 .962 r
.64598 .68673 .65833 .69939 .68399 .69952 .67178 .68678 Metetra
.646 .762 .934 r
.67178 .68678 .68399 .69952 .70962 .69265 .69757 .67979 Metetra
.646 .762 .934 r
.69757 .67979 .70962 .69265 .73548 .68571 .72359 .67273 Metetra
.646 .762 .934 r
.72359 .67273 .73548 .68571 .76157 .67871 .74986 .66561 Metetra
.646 .762 .934 r
.74986 .66561 .76157 .67871 .78791 .67164 .77637 .65843 Metetra
.646 .762 .934 r
.77637 .65843 .78791 .67164 .81449 .66451 .80312 .65117 Metetra
.646 .762 .934 r
.80312 .65117 .81449 .66451 .84132 .65731 .83012 .64385 Metetra
.646 .762 .934 r
.83012 .64385 .84132 .65731 .86839 .65005 .85738 .63646 Metetra
.646 .762 .934 r
.85738 .63646 .86839 .65005 .89572 .64272 .8849 .629 Metetra
.646 .762 .934 r
.8849 .629 .89572 .64272 .92331 .63532 .91267 .62147 Metetra
.646 .762 .934 r
.91267 .62147 .92331 .63532 .95116 .62785 .94071 .61387 Metetra
.646 .762 .934 r
.94071 .61387 .95116 .62785 .97927 .62031 .96902 .60619 Metetra
.102 .478 .896 r
.35291 .5551 .36626 .56753 .38733 .57651 .37403 .56404 Metetra
.102 .478 .896 r
.37403 .56404 .38733 .57651 .40878 .58565 .39552 .57314 Metetra
.102 .478 .896 r
.39552 .57314 .40878 .58565 .4306 .59495 .4174 .5824 Metetra
.102 .478 .896 r
.4174 .5824 .4306 .59495 .45282 .60441 .43967 .59183 Metetra
.102 .478 .896 r
.43967 .59183 .45282 .60441 .47544 .61405 .46235 .60143 Metetra
.102 .478 .896 r
.46235 .60143 .47544 .61405 .49847 .62387 .48544 .6112 Metetra
.102 .478 .896 r
.48544 .6112 .49847 .62387 .52192 .63386 .50896 .62116 Metetra
.102 .478 .896 r
.50896 .62116 .52192 .63386 .54581 .64404 .53292 .6313 Metetra
.102 .478 .896 r
.53292 .6313 .54581 .64404 .57015 .65441 .55734 .64164 Metetra
.102 .478 .896 r
.55734 .64164 .57015 .65441 .59495 .66498 .58222 .65217 Metetra
.102 .478 .896 r
.58222 .65217 .59495 .66498 .62022 .67575 .60758 .66291 Metetra
.102 .478 .896 r
.60758 .66291 .62022 .67575 .64598 .68673 .63343 .67385 Metetra
.493 .701 .962 r
.63343 .67385 .64598 .68673 .67178 .68678 .65937 .67382 Metetra
.646 .762 .934 r
.65937 .67382 .67178 .68678 .69757 .67979 .68532 .66671 Metetra
.646 .762 .934 r
.68532 .66671 .69757 .67979 .72359 .67273 .71151 .65954 Metetra
.646 .762 .934 r
.71151 .65954 .72359 .67273 .74986 .66561 .73794 .65229 Metetra
.646 .762 .934 r
.73794 .65229 .74986 .66561 .77637 .65843 .76462 .64498 Metetra
.646 .762 .934 r
.76462 .64498 .77637 .65843 .80312 .65117 .79155 .6376 Metetra
.646 .762 .934 r
.79155 .6376 .80312 .65117 .83012 .64385 .81874 .63015 Metetra
.646 .762 .934 r
.81874 .63015 .83012 .64385 .85738 .63646 .84618 .62263 Metetra
.646 .762 .934 r
.84618 .62263 .85738 .63646 .8849 .629 .87388 .61504 Metetra
.646 .762 .934 r
.87388 .61504 .8849 .629 .91267 .62147 .90185 .60738 Metetra
.646 .762 .934 r
.90185 .60738 .91267 .62147 .94071 .61387 .93009 .59964 Metetra
.646 .762 .934 r
.93009 .59964 .94071 .61387 .96902 .60619 .9586 .59183 Metetra
.102 .478 .896 r
.33937 .54249 .35291 .5551 .37403 .56404 .36053 .55138 Metetra
.102 .478 .896 r
.36053 .55138 .37403 .56404 .39552 .57314 .38206 .56044 Metetra
.102 .478 .896 r
.38206 .56044 .39552 .57314 .4174 .5824 .40399 .56966 Metetra
.102 .478 .896 r
.40399 .56966 .4174 .5824 .43967 .59183 .42631 .57904 Metetra
.102 .478 .896 r
.42631 .57904 .43967 .59183 .46235 .60143 .44905 .5886 Metetra
.102 .478 .896 r
.44905 .5886 .46235 .60143 .48544 .6112 .4722 .59834 Metetra
.102 .478 .896 r
.4722 .59834 .48544 .6112 .50896 .62116 .49579 .60826 Metetra
.102 .478 .896 r
.49579 .60826 .50896 .62116 .53292 .6313 .51982 .61836 Metetra
.102 .478 .896 r
.51982 .61836 .53292 .6313 .55734 .64164 .54431 .62866 Metetra
.102 .478 .896 r
.54431 .62866 .55734 .64164 .58222 .65217 .56928 .63915 Metetra
.102 .478 .896 r
.56928 .63915 .58222 .65217 .60758 .66291 .59472 .64985 Metetra
.102 .478 .896 r
.59472 .64985 .60758 .66291 .63343 .67385 .62067 .66076 Metetra
.493 .701 .962 r
.62067 .66076 .63343 .67385 .65937 .67382 .64674 .66064 Metetra
.646 .762 .934 r
.64674 .66064 .65937 .67382 .68532 .66671 .67285 .65341 Metetra
.646 .762 .934 r
.67285 .65341 .68532 .66671 .71151 .65954 .69921 .64611 Metetra
.646 .762 .934 r
.69921 .64611 .71151 .65954 .73794 .65229 .72582 .63874 Metetra
.646 .762 .934 r
.72582 .63874 .73794 .65229 .76462 .64498 .75267 .6313 Metetra
.646 .762 .934 r
.75267 .6313 .76462 .64498 .79155 .6376 .77978 .62379 Metetra
.646 .762 .934 r
.77978 .62379 .79155 .6376 .81874 .63015 .80715 .61621 Metetra
.646 .762 .934 r
.80715 .61621 .81874 .63015 .84618 .62263 .83478 .60856 Metetra
.646 .762 .934 r
.83478 .60856 .84618 .62263 .87388 .61504 .86267 .60084 Metetra
.646 .762 .934 r
.86267 .60084 .87388 .61504 .90185 .60738 .89084 .59304 Metetra
.646 .762 .934 r
.89084 .59304 .90185 .60738 .93009 .59964 .91927 .58516 Metetra
.646 .762 .934 r
.91927 .58516 .93009 .59964 .9586 .59183 .94799 .57721 Metetra
.102 .478 .896 r
.32561 .52968 .33937 .54249 .36053 .55138 .34681 .53853 Metetra
.102 .478 .896 r
.34681 .53853 .36053 .55138 .38206 .56044 .36839 .54754 Metetra
.102 .478 .896 r
.36839 .54754 .38206 .56044 .40399 .56966 .39037 .55672 Metetra
.102 .478 .896 r
.39037 .55672 .40399 .56966 .42631 .57904 .41274 .56606 Metetra
.102 .478 .896 r
.41274 .56606 .42631 .57904 .44905 .5886 .43553 .57557 Metetra
.102 .478 .896 r
.43553 .57557 .44905 .5886 .4722 .59834 .45875 .58526 Metetra
.102 .478 .896 r
.45875 .58526 .4722 .59834 .49579 .60826 .4824 .59514 Metetra
.102 .478 .896 r
.4824 .59514 .49579 .60826 .51982 .61836 .50651 .6052 Metetra
.102 .478 .896 r
.50651 .6052 .51982 .61836 .54431 .62866 .53107 .61546 Metetra
.102 .478 .896 r
.53107 .61546 .54431 .62866 .56928 .63915 .55612 .62592 Metetra
.102 .478 .896 r
.55612 .62592 .56928 .63915 .59472 .64985 .58165 .63658 Metetra
.102 .478 .896 r
.58165 .63658 .59472 .64985 .62067 .66076 .60769 .64745 Metetra
.493 .701 .962 r
.60769 .64745 .62067 .66076 .64674 .66064 .63389 .64724 Metetra
.646 .762 .934 r
.63389 .64724 .64674 .66064 .67285 .65341 .66017 .63988 Metetra
.646 .762 .934 r
.66017 .63988 .67285 .65341 .69921 .64611 .6867 .63245 Metetra
.646 .762 .934 r
.6867 .63245 .69921 .64611 .72582 .63874 .71348 .62495 Metetra
.646 .762 .934 r
.71348 .62495 .72582 .63874 .75267 .6313 .74051 .61739 Metetra
.646 .762 .934 r
.74051 .61739 .75267 .6313 .77978 .62379 .7678 .60974 Metetra
.646 .762 .934 r
.7678 .60974 .77978 .62379 .80715 .61621 .79536 .60203 Metetra
.646 .762 .934 r
.79536 .60203 .80715 .61621 .83478 .60856 .82317 .59424 Metetra
.646 .762 .934 r
.82317 .59424 .83478 .60856 .86267 .60084 .85126 .58638 Metetra
.646 .762 .934 r
.85126 .58638 .86267 .60084 .89084 .59304 .87962 .57843 Metetra
.646 .762 .934 r
.87962 .57843 .89084 .59304 .91927 .58516 .90826 .57042 Metetra
.646 .762 .934 r
.90826 .57042 .91927 .58516 .94799 .57721 .93718 .56232 Metetra
.102 .478 .896 r
.31165 .51668 .32561 .52968 .34681 .53853 .33288 .52548 Metetra
.102 .478 .896 r
.33288 .52548 .34681 .53853 .36839 .54754 .35451 .53444 Metetra
.102 .478 .896 r
.35451 .53444 .36839 .54754 .39037 .55672 .37653 .54357 Metetra
.102 .478 .896 r
.37653 .54357 .39037 .55672 .41274 .56606 .39896 .55286 Metetra
.102 .478 .896 r
.39896 .55286 .41274 .56606 .43553 .57557 .4218 .56233 Metetra
.102 .478 .896 r
.4218 .56233 .43553 .57557 .45875 .58526 .44508 .57198 Metetra
.102 .478 .896 r
.44508 .57198 .45875 .58526 .4824 .59514 .46879 .58181 Metetra
.102 .478 .896 r
.46879 .58181 .4824 .59514 .50651 .6052 .49297 .59183 Metetra
.102 .478 .896 r
.49297 .59183 .50651 .6052 .53107 .61546 .51761 .60204 Metetra
.102 .478 .896 r
.51761 .60204 .53107 .61546 .55612 .62592 .54273 .61245 Metetra
.102 .478 .896 r
.54273 .61245 .55612 .62592 .58165 .63658 .56835 .62307 Metetra
.102 .478 .896 r
.56835 .62307 .58165 .63658 .60769 .64745 .59448 .6339 Metetra
.493 .701 .962 r
.59448 .6339 .60769 .64745 .63389 .64724 .62083 .6336 Metetra
.646 .762 .934 r
.62083 .6336 .63389 .64724 .66017 .63988 .64727 .62611 Metetra
.646 .762 .934 r
.64727 .62611 .66017 .63988 .6867 .63245 .67397 .61855 Metetra
.646 .762 .934 r
.67397 .61855 .6867 .63245 .71348 .62495 .70093 .61092 Metetra
.646 .762 .934 r
.70093 .61092 .71348 .62495 .74051 .61739 .72814 .60322 Metetra
.646 .762 .934 r
.72814 .60322 .74051 .61739 .7678 .60974 .75561 .59544 Metetra
.646 .762 .934 r
.75561 .59544 .7678 .60974 .79536 .60203 .78335 .58759 Metetra
.646 .762 .934 r
.78335 .58759 .79536 .60203 .82317 .59424 .81136 .57966 Metetra
.646 .762 .934 r
.81136 .57966 .82317 .59424 .85126 .58638 .83965 .57165 Metetra
.646 .762 .934 r
.83965 .57165 .85126 .58638 .87962 .57843 .86821 .56357 Metetra
.646 .762 .934 r
.86821 .56357 .87962 .57843 .90826 .57042 .89705 .5554 Metetra
.646 .762 .934 r
.89705 .5554 .90826 .57042 .93718 .56232 .92618 .54716 Metetra
.102 .478 .896 r
.29746 .50347 .31165 .51668 .33288 .52548 .31874 .51222 Metetra
.102 .478 .896 r
.31874 .51222 .33288 .52548 .35451 .53444 .34041 .52113 Metetra
.102 .478 .896 r
.34041 .52113 .35451 .53444 .37653 .54357 .36247 .53021 Metetra
.102 .478 .896 r
.36247 .53021 .37653 .54357 .39896 .55286 .38495 .53946 Metetra
.102 .478 .896 r
.38495 .53946 .39896 .55286 .4218 .56233 .40785 .54888 Metetra
.102 .478 .896 r
.40785 .54888 .4218 .56233 .44508 .57198 .43118 .55847 Metetra
.102 .478 .896 r
.43118 .55847 .44508 .57198 .46879 .58181 .45496 .56826 Metetra
.102 .478 .896 r
.45496 .56826 .46879 .58181 .49297 .59183 .4792 .57823 Metetra
.102 .478 .896 r
.4792 .57823 .49297 .59183 .51761 .60204 .50392 .58839 Metetra
.102 .478 .896 r
.50392 .58839 .51761 .60204 .54273 .61245 .52912 .59876 Metetra
.102 .478 .896 r
.52912 .59876 .54273 .61245 .56835 .62307 .55483 .60933 Metetra
.102 .478 .896 r
.55483 .60933 .56835 .62307 .59448 .6339 .58105 .62012 Metetra
.493 .701 .962 r
.58105 .62012 .59448 .6339 .62083 .6336 .60753 .61972 Metetra
.646 .762 .934 r
.60753 .61972 .62083 .6336 .64727 .62611 .63415 .6121 Metetra
.646 .762 .934 r
.63415 .6121 .64727 .62611 .67397 .61855 .66102 .60441 Metetra
.646 .762 .934 r
.66102 .60441 .67397 .61855 .70093 .61092 .68815 .59664 Metetra
.646 .762 .934 r
.68815 .59664 .70093 .61092 .72814 .60322 .71554 .5888 Metetra
.646 .762 .934 r
.71554 .5888 .72814 .60322 .75561 .59544 .7432 .58089 Metetra
.646 .762 .934 r
.7432 .58089 .75561 .59544 .78335 .58759 .77113 .57289 Metetra
.646 .762 .934 r
.77113 .57289 .78335 .58759 .81136 .57966 .79934 .56482 Metetra
.646 .762 .934 r
.79934 .56482 .81136 .57966 .83965 .57165 .82782 .55666 Metetra
.646 .762 .934 r
.82782 .55666 .83965 .57165 .86821 .56357 .85658 .54843 Metetra
.646 .762 .934 r
.85658 .54843 .86821 .56357 .89705 .5554 .88563 .54011 Metetra
.646 .762 .934 r
.88563 .54011 .89705 .5554 .92618 .54716 .91497 .53172 Metetra
.102 .478 .896 r
.28306 .49006 .29746 .50347 .31874 .51222 .30437 .49876 Metetra
.102 .478 .896 r
.30437 .49876 .31874 .51222 .34041 .52113 .32608 .50762 Metetra
.102 .478 .896 r
.32608 .50762 .34041 .52113 .36247 .53021 .34819 .51664 Metetra
.102 .478 .896 r
.34819 .51664 .36247 .53021 .38495 .53946 .37071 .52583 Metetra
.102 .478 .896 r
.37071 .52583 .38495 .53946 .40785 .54888 .39366 .5352 Metetra
.102 .478 .896 r
.39366 .5352 .40785 .54888 .43118 .55847 .41706 .54475 Metetra
.102 .478 .896 r
.41706 .54475 .43118 .55847 .45496 .56826 .4409 .55448 Metetra
.102 .478 .896 r
.4409 .55448 .45496 .56826 .4792 .57823 .46521 .5644 Metetra
.102 .478 .896 r
.46521 .5644 .4792 .57823 .50392 .58839 .49 .57452 Metetra
.102 .478 .896 r
.49 .57452 .50392 .58839 .52912 .59876 .51528 .58483 Metetra
.102 .478 .896 r
.51528 .58483 .52912 .59876 .55483 .60933 .54107 .59536 Metetra
.214 .55 .931 r
.54107 .59536 .55483 .60933 .58105 .62012 .56734 .60332 Metetra
.649 .724 .903 r
.56734 .60332 .58105 .62012 .60753 .61972 .5938 .59562 Metetra
.644 .646 .837 r
.5938 .59562 .60753 .61972 .63415 .6121 .62051 .58784 Metetra
.644 .646 .837 r
.62051 .58784 .63415 .6121 .66102 .60441 .64747 .57998 Metetra
.644 .646 .837 r
.64747 .57998 .66102 .60441 .68815 .59664 .6747 .57205 Metetra
.644 .646 .837 r
.6747 .57205 .68815 .59664 .71554 .5888 .70219 .56404 Metetra
.644 .646 .837 r
.70219 .56404 .71554 .5888 .7432 .58089 .72995 .55596 Metetra
.644 .646 .837 r
.72995 .55596 .7432 .58089 .77113 .57289 .75799 .54779 Metetra
.644 .646 .837 r
.75799 .54779 .77113 .57289 .79934 .56482 .7863 .53954 Metetra
.644 .646 .837 r
.7863 .53954 .79934 .56482 .82782 .55666 .81489 .53122 Metetra
.644 .646 .837 r
.81489 .53122 .82782 .55666 .85658 .54843 .84377 .5228 Metetra
.644 .646 .837 r
.84377 .5228 .85658 .54843 .88563 .54011 .87294 .51431 Metetra
.644 .646 .837 r
.87294 .51431 .88563 .54011 .91497 .53172 .9024 .50573 Metetra
.102 .478 .896 r
.26843 .47643 .28306 .49006 .30437 .49876 .28977 .48508 Metetra
.102 .478 .896 r
.28977 .48508 .30437 .49876 .32608 .50762 .31152 .49388 Metetra
.102 .478 .896 r
.31152 .49388 .32608 .50762 .34819 .51664 .33367 .50285 Metetra
.102 .478 .896 r
.33367 .50285 .34819 .51664 .37071 .52583 .35624 .51198 Metetra
.102 .478 .896 r
.35624 .51198 .37071 .52583 .39366 .5352 .37925 .5213 Metetra
.102 .478 .896 r
.37925 .5213 .39366 .5352 .41706 .54475 .40269 .53079 Metetra
.102 .478 .896 r
.40269 .53079 .41706 .54475 .4409 .55448 .4266 .54047 Metetra
.102 .478 .896 r
.4266 .54047 .4409 .55448 .46521 .5644 .45097 .55033 Metetra
.102 .478 .896 r
.45097 .55033 .46521 .5644 .49 .57452 .47583 .5604 Metetra
.102 .478 .896 r
.47583 .5604 .49 .57452 .51528 .58483 .50119 .57066 Metetra
.102 .478 .896 r
.50119 .57066 .51528 .58483 .54107 .59536 .52706 .58114 Metetra
.629 .754 .937 r
.52706 .58114 .54107 .59536 .56734 .60332 .55332 .57443 Metetra
.638 .608 .803 r
.55332 .57443 .56734 .60332 .5938 .59562 .57983 .56655 Metetra
.638 .608 .803 r
.57983 .56655 .5938 .59562 .62051 .58784 .60659 .5586 Metetra
.638 .608 .803 r
.60659 .5586 .62051 .58784 .64747 .57998 .63361 .55057 Metetra
.638 .608 .803 r
.63361 .55057 .64747 .57998 .6747 .57205 .6609 .54246 Metetra
.638 .608 .803 r
.6609 .54246 .6747 .57205 .70219 .56404 .68845 .53427 Metetra
.638 .608 .803 r
.68845 .53427 .70219 .56404 .72995 .55596 .71628 .526 Metetra
.638 .608 .803 r
.71628 .526 .72995 .55596 .75799 .54779 .74437 .51764 Metetra
.638 .608 .803 r
.74437 .51764 .75799 .54779 .7863 .53954 .77275 .50921 Metetra
.638 .608 .803 r
.77275 .50921 .7863 .53954 .81489 .53122 .80141 .50069 Metetra
.638 .608 .803 r
.80141 .50069 .81489 .53122 .84377 .5228 .83036 .49208 Metetra
.638 .608 .803 r
.83036 .49208 .84377 .5228 .87294 .51431 .85959 .48339 Metetra
.638 .608 .803 r
.85959 .48339 .87294 .51431 .9024 .50573 .88913 .47461 Metetra
.102 .478 .896 r
.25356 .46259 .26843 .47643 .28977 .48508 .27494 .47118 Metetra
.102 .478 .896 r
.27494 .47118 .28977 .48508 .31152 .49388 .29672 .47992 Metetra
.102 .478 .896 r
.29672 .47992 .31152 .49388 .33367 .50285 .31892 .48883 Metetra
.102 .478 .896 r
.31892 .48883 .33367 .50285 .35624 .51198 .34154 .49791 Metetra
.102 .478 .896 r
.34154 .49791 .35624 .51198 .37925 .5213 .36459 .50716 Metetra
.102 .478 .896 r
.36459 .50716 .37925 .5213 .40269 .53079 .38809 .5166 Metetra
.102 .478 .896 r
.38809 .5166 .40269 .53079 .4266 .54047 .41205 .52622 Metetra
.102 .478 .896 r
.41205 .52622 .4266 .54047 .45097 .55033 .43649 .53603 Metetra
.102 .478 .896 r
.43649 .53603 .45097 .55033 .47583 .5604 .46142 .54604 Metetra
.102 .478 .896 r
.46142 .54604 .47583 .5604 .50119 .57066 .48686 .55625 Metetra
.553 .723 .953 r
.48686 .55625 .50119 .57066 .52706 .58114 .51286 .55326 Metetra
.64 .616 .81 r
.51286 .55326 .52706 .58114 .55332 .57443 .53917 .54528 Metetra
.638 .608 .803 r
.53917 .54528 .55332 .57443 .57983 .56655 .56573 .53723 Metetra
.638 .608 .803 r
.56573 .53723 .57983 .56655 .60659 .5586 .59255 .52909 Metetra
.638 .608 .803 r
.59255 .52909 .60659 .5586 .63361 .55057 .61963 .52088 Metetra
.638 .608 .803 r
.61963 .52088 .63361 .55057 .6609 .54246 .64697 .51259 Metetra
.638 .608 .803 r
.64697 .51259 .6609 .54246 .68845 .53427 .67458 .50421 Metetra
.638 .608 .803 r
.67458 .50421 .68845 .53427 .71628 .526 .70247 .49575 Metetra
.638 .608 .803 r
.70247 .49575 .71628 .526 .74437 .51764 .73063 .48721 Metetra
.638 .608 .803 r
.73063 .48721 .74437 .51764 .77275 .50921 .75907 .47859 Metetra
.638 .608 .803 r
.75907 .47859 .77275 .50921 .80141 .50069 .7878 .46987 Metetra
.638 .608 .803 r
.7878 .46987 .80141 .50069 .83036 .49208 .81682 .46107 Metetra
.638 .608 .803 r
.81682 .46107 .83036 .49208 .85959 .48339 .84613 .45218 Metetra
.638 .608 .803 r
.84613 .45218 .85959 .48339 .88913 .47461 .87573 .4432 Metetra
.102 .478 .896 r
.23846 .44853 .25356 .46259 .27494 .47118 .25987 .45705 Metetra
.102 .478 .896 r
.25987 .45705 .27494 .47118 .29672 .47992 .28169 .46573 Metetra
.102 .478 .896 r
.28169 .46573 .29672 .47992 .31892 .48883 .30392 .47458 Metetra
.102 .478 .896 r
.30392 .47458 .31892 .48883 .34154 .49791 .32658 .4836 Metetra
.102 .478 .896 r
.32658 .4836 .34154 .49791 .36459 .50716 .34968 .49279 Metetra
.102 .478 .896 r
.34968 .49279 .36459 .50716 .38809 .5166 .37324 .50217 Metetra
.102 .478 .896 r
.37324 .50217 .38809 .5166 .41205 .52622 .39726 .51172 Metetra
.102 .478 .896 r
.39726 .51172 .41205 .52622 .43649 .53603 .42176 .52148 Metetra
.102 .478 .896 r
.42176 .52148 .43649 .53603 .46142 .54604 .44676 .53142 Metetra
.455 .679 .961 r
.44676 .53142 .46142 .54604 .48686 .55625 .47242 .5321 Metetra
.645 .648 .838 r
.47242 .5321 .48686 .55625 .51286 .55326 .49853 .52402 Metetra
.638 .608 .803 r
.49853 .52402 .51286 .55326 .53917 .54528 .52489 .51586 Metetra
.638 .608 .803 r
.52489 .51586 .53917 .54528 .56573 .53723 .5515 .50763 Metetra
.638 .608 .803 r
.5515 .50763 .56573 .53723 .59255 .52909 .57837 .49931 Metetra
.638 .608 .803 r
.57837 .49931 .59255 .52909 .61963 .52088 .60551 .49092 Metetra
.638 .608 .803 r
.60551 .49092 .61963 .52088 .64697 .51259 .63291 .48244 Metetra
.638 .608 .803 r
.63291 .48244 .64697 .51259 .67458 .50421 .66058 .47388 Metetra
.638 .608 .803 r
.66058 .47388 .67458 .50421 .70247 .49575 .68853 .46523 Metetra
.638 .608 .803 r
.68853 .46523 .70247 .49575 .73063 .48721 .71676 .45649 Metetra
.638 .608 .803 r
.71676 .45649 .73063 .48721 .75907 .47859 .74526 .44767 Metetra
.638 .608 .803 r
.74526 .44767 .75907 .47859 .7878 .46987 .77406 .43876 Metetra
.638 .608 .803 r
.77406 .43876 .7878 .46987 .81682 .46107 .80315 .42976 Metetra
.638 .608 .803 r
.80315 .42976 .81682 .46107 .84613 .45218 .83253 .42067 Metetra
.638 .608 .803 r
.83253 .42067 .84613 .45218 .87573 .4432 .86221 .41148 Metetra
.102 .478 .896 r
.22311 .43424 .23846 .44853 .25987 .45705 .24455 .4427 Metetra
.102 .478 .896 r
.24455 .4427 .25987 .45705 .28169 .46573 .2664 .45131 Metetra
.102 .478 .896 r
.2664 .45131 .28169 .46573 .30392 .47458 .28868 .4601 Metetra
.102 .478 .896 r
.28868 .4601 .30392 .47458 .32658 .4836 .31138 .46905 Metetra
.102 .478 .896 r
.31138 .46905 .32658 .4836 .34968 .49279 .33453 .47818 Metetra
.102 .478 .896 r
.33453 .47818 .34968 .49279 .37324 .50217 .35813 .48749 Metetra
.102 .478 .896 r
.35813 .48749 .37324 .50217 .39726 .51172 .38221 .49698 Metetra
.102 .478 .896 r
.38221 .49698 .39726 .51172 .42176 .52148 .40678 .50667 Metetra
.333 .616 .953 r
.40678 .50667 .42176 .52148 .44676 .53142 .432 .51095 Metetra
.65 .686 .87 r
.432 .51095 .44676 .53142 .47242 .5321 .45791 .50277 Metetra
.638 .608 .803 r
.45791 .50277 .47242 .5321 .49853 .52402 .48406 .49451 Metetra
.638 .608 .803 r
.48406 .49451 .49853 .52402 .52489 .51586 .51047 .48618 Metetra
.638 .608 .803 r
.51047 .48618 .52489 .51586 .5515 .50763 .53714 .47776 Metetra
.638 .608 .803 r
.53714 .47776 .5515 .50763 .57837 .49931 .56407 .46926 Metetra
.638 .608 .803 r
.56407 .46926 .57837 .49931 .60551 .49092 .59126 .46068 Metetra
.638 .608 .803 r
.59126 .46068 .60551 .49092 .63291 .48244 .61872 .45201 Metetra
.638 .608 .803 r
.61872 .45201 .63291 .48244 .66058 .47388 .64645 .44325 Metetra
.638 .608 .803 r
.64645 .44325 .66058 .47388 .68853 .46523 .67446 .43441 Metetra
.638 .608 .803 r
.67446 .43441 .68853 .46523 .71676 .45649 .70275 .42548 Metetra
.638 .608 .803 r
.70275 .42548 .71676 .45649 .74526 .44767 .73132 .41646 Metetra
.638 .608 .803 r
.73132 .41646 .74526 .44767 .77406 .43876 .76019 .40735 Metetra
.638 .608 .803 r
.76019 .40735 .77406 .43876 .80315 .42976 .78934 .39815 Metetra
.638 .608 .803 r
.78934 .39815 .80315 .42976 .83253 .42067 .8188 .38885 Metetra
.638 .608 .803 r
.8188 .38885 .83253 .42067 .86221 .41148 .84855 .37946 Metetra
.102 .478 .896 r
.20751 .41972 .22311 .43424 .24455 .4427 .22898 .42811 Metetra
.102 .478 .896 r
.22898 .42811 .24455 .4427 .2664 .45131 .25087 .43665 Metetra
.102 .478 .896 r
.25087 .43665 .2664 .45131 .28868 .4601 .27317 .44537 Metetra
.102 .478 .896 r
.27317 .44537 .28868 .4601 .31138 .46905 .29592 .45425 Metetra
.102 .478 .896 r
.29592 .45425 .31138 .46905 .33453 .47818 .31911 .46331 Metetra
.102 .478 .896 r
.31911 .46331 .33453 .47818 .35813 .48749 .34277 .47255 Metetra
.102 .478 .896 r
.34277 .47255 .35813 .48749 .38221 .49698 .3669 .48198 Metetra
.182 .529 .922 r
.3669 .48198 .38221 .49698 .40678 .50667 .3916 .48981 Metetra
.654 .73 .906 r
.3916 .48981 .40678 .50667 .432 .51095 .41731 .48153 Metetra
.638 .608 .803 r
.41731 .48153 .432 .51095 .45791 .50277 .44326 .47317 Metetra
.638 .608 .803 r
.44326 .47317 .45791 .50277 .48406 .49451 .46947 .46473 Metetra
.638 .608 .803 r
.46947 .46473 .48406 .49451 .51047 .48618 .49593 .45621 Metetra
.638 .608 .803 r
.49593 .45621 .51047 .48618 .53714 .47776 .52265 .44761 Metetra
.638 .608 .803 r
.52265 .44761 .53714 .47776 .56407 .46926 .54963 .43892 Metetra
.638 .608 .803 r
.54963 .43892 .56407 .46926 .59126 .46068 .57688 .43015 Metetra
.638 .608 .803 r
.57688 .43015 .59126 .46068 .61872 .45201 .6044 .42129 Metetra
.638 .608 .803 r
.6044 .42129 .61872 .45201 .64645 .44325 .63219 .41234 Metetra
.638 .608 .803 r
.63219 .41234 .64645 .44325 .67446 .43441 .66026 .4033 Metetra
.638 .608 .803 r
.66026 .4033 .67446 .43441 .70275 .42548 .68861 .39417 Metetra
.638 .608 .803 r
.68861 .39417 .70275 .42548 .73132 .41646 .71725 .38495 Metetra
.638 .608 .803 r
.71725 .38495 .73132 .41646 .76019 .40735 .74618 .37564 Metetra
.638 .608 .803 r
.74618 .37564 .76019 .40735 .78934 .39815 .77541 .36623 Metetra
.638 .608 .803 r
.77541 .36623 .78934 .39815 .8188 .38885 .80493 .35672 Metetra
.638 .608 .803 r
.80493 .35672 .8188 .38885 .84855 .37946 .83476 .34712 Metetra
.102 .478 .896 r
.19166 .40496 .20751 .41972 .22898 .42811 .21316 .41327 Metetra
.102 .478 .896 r
.21316 .41327 .22898 .42811 .25087 .43665 .23507 .42175 Metetra
.102 .478 .896 r
.23507 .42175 .25087 .43665 .27317 .44537 .25741 .43039 Metetra
.102 .478 .896 r
.25741 .43039 .27317 .44537 .29592 .45425 .28019 .4392 Metetra
.102 .478 .896 r
.28019 .4392 .29592 .45425 .31911 .46331 .30343 .44819 Metetra
.102 .478 .896 r
.30343 .44819 .31911 .46331 .34277 .47255 .32714 .45736 Metetra
.102 .478 .896 r
.32714 .45736 .34277 .47255 .3669 .48198 .35132 .46672 Metetra
.62 .742 .934 r
.35132 .46672 .3669 .48198 .3916 .48981 .37673 .4603 Metetra
.638 .608 .803 r
.37673 .4603 .3916 .48981 .41731 .48153 .40248 .45184 Metetra
.638 .608 .803 r
.40248 .45184 .41731 .48153 .44326 .47317 .42848 .4433 Metetra
.638 .608 .803 r
.42848 .4433 .44326 .47317 .46947 .46473 .45474 .43468 Metetra
.638 .608 .803 r
.45474 .43468 .46947 .46473 .49593 .45621 .48125 .42597 Metetra
.638 .608 .803 r
.48125 .42597 .49593 .45621 .52265 .44761 .50802 .41718 Metetra
.638 .608 .803 r
.50802 .41718 .52265 .44761 .54963 .43892 .53506 .4083 Metetra
.638 .608 .803 r
.53506 .4083 .54963 .43892 .57688 .43015 .56236 .39934 Metetra
.638 .608 .803 r
.56236 .39934 .57688 .43015 .6044 .42129 .58994 .39028 Metetra
.638 .608 .803 r
.58994 .39028 .6044 .42129 .63219 .41234 .61779 .38114 Metetra
.638 .608 .803 r
.61779 .38114 .63219 .41234 .66026 .4033 .64592 .3719 Metetra
.638 .608 .803 r
.64592 .3719 .66026 .4033 .68861 .39417 .67434 .36257 Metetra
.638 .608 .803 r
.67434 .36257 .68861 .39417 .71725 .38495 .70304 .35314 Metetra
.638 .608 .803 r
.70304 .35314 .71725 .38495 .74618 .37564 .73204 .34362 Metetra
.638 .608 .803 r
.73204 .34362 .74618 .37564 .77541 .36623 .76133 .334 Metetra
.638 .608 .803 r
.76133 .334 .77541 .36623 .80493 .35672 .79093 .32428 Metetra
.638 .608 .803 r
.79093 .32428 .80493 .35672 .83476 .34712 .82084 .31446 Metetra
.102 .478 .896 r
.17555 .38995 .19166 .40496 .21316 .41327 .19707 .39819 Metetra
.102 .478 .896 r
.19707 .39819 .21316 .41327 .23507 .42175 .21901 .40659 Metetra
.102 .478 .896 r
.21901 .40659 .23507 .42175 .25741 .43039 .24138 .41516 Metetra
.102 .478 .896 r
.24138 .41516 .25741 .43039 .28019 .4392 .2642 .4239 Metetra
.102 .478 .896 r
.2642 .4239 .28019 .4392 .30343 .44819 .28748 .43281 Metetra
.102 .478 .896 r
.28748 .43281 .30343 .44819 .32714 .45736 .31123 .4419 Metetra
.542 .712 .951 r
.31123 .4419 .32714 .45736 .35132 .46672 .33617 .43908 Metetra
.641 .623 .816 r
.33617 .43908 .35132 .46672 .37673 .4603 .36172 .43052 Metetra
.638 .608 .803 r
.36172 .43052 .37673 .4603 .40248 .45184 .38752 .42188 Metetra
.638 .608 .803 r
.38752 .42188 .40248 .45184 .42848 .4433 .41357 .41316 Metetra
.638 .608 .803 r
.41357 .41316 .42848 .4433 .45474 .43468 .43987 .40435 Metetra
.638 .608 .803 r
.43987 .40435 .45474 .43468 .48125 .42597 .46643 .39545 Metetra
.638 .608 .803 r
.46643 .39545 .48125 .42597 .50802 .41718 .49326 .38647 Metetra
.638 .608 .803 r
.49326 .38647 .50802 .41718 .53506 .4083 .52035 .3774 Metetra
.638 .608 .803 r
.52035 .3774 .53506 .4083 .56236 .39934 .54771 .36824 Metetra
.638 .608 .803 r
.54771 .36824 .56236 .39934 .58994 .39028 .57534 .35898 Metetra
.638 .608 .803 r
.57534 .35898 .58994 .39028 .61779 .38114 .60325 .34963 Metetra
.638 .608 .803 r
.60325 .34963 .61779 .38114 .64592 .3719 .63144 .34019 Metetra
.638 .608 .803 r
.63144 .34019 .64592 .3719 .67434 .36257 .65992 .33065 Metetra
.638 .608 .803 r
.65992 .33065 .67434 .36257 .70304 .35314 .68869 .32102 Metetra
.638 .608 .803 r
.68869 .32102 .70304 .35314 .73204 .34362 .71776 .31129 Metetra
.638 .608 .803 r
.71776 .31129 .73204 .34362 .76133 .334 .74712 .30145 Metetra
.638 .608 .803 r
.74712 .30145 .76133 .334 .79093 .32428 .77679 .29152 Metetra
.638 .608 .803 r
.77679 .29152 .79093 .32428 .82084 .31446 .80677 .28148 Metetra
.102 .478 .896 r
.15916 .3747 .17555 .38995 .19707 .39819 .1807 .38286 Metetra
.102 .478 .896 r
.1807 .38286 .19707 .39819 .21901 .40659 .20267 .39118 Metetra
.102 .478 .896 r
.20267 .39118 .21901 .40659 .24138 .41516 .22507 .39966 Metetra
.102 .478 .896 r
.22507 .39966 .24138 .41516 .2642 .4239 .24793 .40832 Metetra
.102 .478 .896 r
.24793 .40832 .2642 .4239 .28748 .43281 .27124 .41715 Metetra
.44 .667 .958 r
.27124 .41715 .28748 .43281 .31123 .4419 .29562 .41787 Metetra
.648 .656 .844 r
.29562 .41787 .31123 .4419 .33617 .43908 .32098 .40921 Metetra
.638 .608 .803 r
.32098 .40921 .33617 .43908 .36172 .43052 .34657 .40047 Metetra
.638 .608 .803 r
.34657 .40047 .36172 .43052 .38752 .42188 .37242 .39164 Metetra
.638 .608 .803 r
.37242 .39164 .38752 .42188 .41357 .41316 .39851 .38273 Metetra
.638 .608 .803 r
.39851 .38273 .41357 .41316 .43987 .40435 .42486 .37373 Metetra
.638 .608 .803 r
.42486 .37373 .43987 .40435 .46643 .39545 .45148 .36465 Metetra
.638 .608 .803 r
.45148 .36465 .46643 .39545 .49326 .38647 .47835 .35547 Metetra
.638 .608 .803 r
.47835 .35547 .49326 .38647 .52035 .3774 .5055 .3462 Metetra
.638 .608 .803 r
.5055 .3462 .52035 .3774 .54771 .36824 .53291 .33684 Metetra
.638 .608 .803 r
.53291 .33684 .54771 .36824 .57534 .35898 .5606 .32738 Metetra
.638 .608 .803 r
.5606 .32738 .57534 .35898 .60325 .34963 .58857 .31783 Metetra
.638 .608 .803 r
.58857 .31783 .60325 .34963 .63144 .34019 .61683 .30818 Metetra
.638 .608 .803 r
.61683 .30818 .63144 .34019 .65992 .33065 .64537 .29843 Metetra
.638 .608 .803 r
.64537 .29843 .65992 .33065 .68869 .32102 .67421 .28859 Metetra
.638 .608 .803 r
.67421 .28859 .68869 .32102 .71776 .31129 .70334 .27864 Metetra
.638 .608 .803 r
.70334 .27864 .71776 .31129 .74712 .30145 .73277 .26858 Metetra
.638 .608 .803 r
.73277 .26858 .74712 .30145 .77679 .29152 .76252 .25843 Metetra
.638 .608 .803 r
.76252 .25843 .77679 .29152 .80677 .28148 .79257 .24817 Metetra
.102 .478 .896 r
.1425 .35918 .15916 .3747 .1807 .38286 .16406 .36726 Metetra
.102 .478 .896 r
.16406 .36726 .1807 .38286 .20267 .39118 .18605 .3755 Metetra
.102 .478 .896 r
.18605 .3755 .20267 .39118 .22507 .39966 .20848 .3839 Metetra
.102 .478 .896 r
.20848 .3839 .22507 .39966 .24793 .40832 .23137 .39247 Metetra
.309 .6 .949 r
.23137 .39247 .24793 .40832 .27124 .41715 .2551 .39667 Metetra
.654 .693 .874 r
.2551 .39667 .27124 .41715 .29562 .41787 .28025 .38791 Metetra
.638 .608 .803 r
.28025 .38791 .29562 .41787 .32098 .40921 .30565 .37907 Metetra
.638 .608 .803 r
.30565 .37907 .32098 .40921 .34657 .40047 .33128 .37014 Metetra
.638 .608 .803 r
.33128 .37014 .34657 .40047 .37242 .39164 .35717 .36113 Metetra
.638 .608 .803 r
.35717 .36113 .37242 .39164 .39851 .38273 .38332 .35203 Metetra
.638 .608 .803 r
.38332 .35203 .39851 .38273 .42486 .37373 .40972 .34283 Metetra
.638 .608 .803 r
.40972 .34283 .42486 .37373 .45148 .36465 .43638 .33355 Metetra
.638 .608 .803 r
.43638 .33355 .45148 .36465 .47835 .35547 .46331 .32417 Metetra
.638 .608 .803 r
.46331 .32417 .47835 .35547 .5055 .3462 .49051 .3147 Metetra
.638 .608 .803 r
.49051 .3147 .5055 .3462 .53291 .33684 .51798 .30514 Metetra
.638 .608 .803 r
.51798 .30514 .53291 .33684 .5606 .32738 .54572 .29548 Metetra
.638 .608 .803 r
.54572 .29548 .5606 .32738 .58857 .31783 .57375 .28572 Metetra
.638 .608 .803 r
.57375 .28572 .58857 .31783 .61683 .30818 .60207 .27586 Metetra
.638 .608 .803 r
.60207 .27586 .61683 .30818 .64537 .29843 .63068 .2659 Metetra
.638 .608 .803 r
.63068 .2659 .64537 .29843 .67421 .28859 .65958 .25583 Metetra
.638 .608 .803 r
.65958 .25583 .67421 .28859 .70334 .27864 .68878 .24567 Metetra
.638 .608 .803 r
.68878 .24567 .70334 .27864 .73277 .26858 .71828 .23539 Metetra
.638 .608 .803 r
.71828 .23539 .73277 .26858 .76252 .25843 .7481 .22501 Metetra
.638 .608 .803 r
.7481 .22501 .76252 .25843 .79257 .24817 .77823 .21452 Metetra
.102 .478 .896 r
.12556 .34341 .1425 .35918 .16406 .36726 .14714 .3514 Metetra
.102 .478 .896 r
.14714 .3514 .16406 .36726 .18605 .3755 .16915 .35955 Metetra
.102 .478 .896 r
.16915 .35955 .18605 .3755 .20848 .3839 .1916 .36786 Metetra
.145 .506 .91 r
.1916 .36786 .20848 .3839 .23137 .39247 .2146 .37548 Metetra
.658 .736 .907 r
.2146 .37548 .23137 .39247 .2551 .39667 .23955 .36662 Metetra
.638 .608 .803 r
.23955 .36662 .2551 .39667 .28025 .38791 .26474 .35768 Metetra
.638 .608 .803 r
.26474 .35768 .28025 .38791 .30565 .37907 .29017 .34865 Metetra
.638 .608 .803 r
.29017 .34865 .30565 .37907 .33128 .37014 .31586 .33953 Metetra
.638 .608 .803 r
.31586 .33953 .33128 .37014 .35717 .36113 .34179 .33033 Metetra
.638 .608 .803 r
.34179 .33033 .35717 .36113 .38332 .35203 .36798 .32103 Metetra
.638 .608 .803 r
.36798 .32103 .38332 .35203 .40972 .34283 .39443 .31164 Metetra
.638 .608 .803 r
.39443 .31164 .40972 .34283 .43638 .33355 .42114 .30216 Metetra
.638 .608 .803 r
.42114 .30216 .43638 .33355 .46331 .32417 .44812 .29258 Metetra
.638 .608 .803 r
.44812 .29258 .46331 .32417 .49051 .3147 .47537 .28291 Metetra
.638 .608 .803 r
.47537 .28291 .49051 .3147 .51798 .30514 .5029 .27314 Metetra
.638 .608 .803 r
.5029 .27314 .51798 .30514 .54572 .29548 .5307 .26327 Metetra
.638 .608 .803 r
.5307 .26327 .54572 .29548 .57375 .28572 .55879 .25329 Metetra
.638 .608 .803 r
.55879 .25329 .57375 .28572 .60207 .27586 .58717 .24322 Metetra
.638 .608 .803 r
.58717 .24322 .60207 .27586 .63068 .2659 .61584 .23304 Metetra
.638 .608 .803 r
.61584 .23304 .63068 .2659 .65958 .25583 .6448 .22276 Metetra
.638 .608 .803 r
.6448 .22276 .65958 .25583 .68878 .24567 .67407 .21237 Metetra
.638 .608 .803 r
.67407 .21237 .68878 .24567 .71828 .23539 .70365 .20187 Metetra
.638 .608 .803 r
.70365 .20187 .71828 .23539 .7481 .22501 .73353 .19126 Metetra
.638 .608 .803 r
.73353 .19126 .7481 .22501 .77823 .21452 .76374 .18054 Metetra
.102 .478 .896 r
.10832 .32736 .12556 .34341 .14714 .3514 .12992 .33526 Metetra
.102 .478 .896 r
.12992 .33526 .14714 .3514 .16915 .35955 .15195 .34332 Metetra
.102 .478 .896 r
.15195 .34332 .16915 .35955 .1916 .36786 .17442 .35154 Metetra
.611 .732 .931 r
.17442 .35154 .1916 .36786 .2146 .37548 .19887 .34534 Metetra
.638 .608 .803 r
.19887 .34534 .2146 .37548 .23955 .36662 .22386 .3363 Metetra
.638 .608 .803 r
.22386 .3363 .23955 .36662 .26474 .35768 .24908 .32717 Metetra
.638 .608 .803 r
.24908 .32717 .26474 .35768 .29017 .34865 .27456 .31795 Metetra
.638 .608 .803 r
.27456 .31795 .29017 .34865 .31586 .33953 .30029 .30864 Metetra
.638 .608 .803 r
.30029 .30864 .31586 .33953 .34179 .33033 .32626 .29924 Metetra
.638 .608 .803 r
.32626 .29924 .34179 .33033 .36798 .32103 .3525 .28975 Metetra
.638 .608 .803 r
.3525 .28975 .36798 .32103 .39443 .31164 .379 .28016 Metetra
.638 .608 .803 r
.379 .28016 .39443 .31164 .42114 .30216 .40576 .27047 Metetra
.638 .608 .803 r
.40576 .27047 .42114 .30216 .44812 .29258 .43279 .26069 Metetra
.638 .608 .803 r
.43279 .26069 .44812 .29258 .47537 .28291 .46009 .25081 Metetra
.638 .608 .803 r
.46009 .25081 .47537 .28291 .5029 .27314 .48767 .24083 Metetra
.638 .608 .803 r
.48767 .24083 .5029 .27314 .5307 .26327 .51554 .23074 Metetra
.638 .608 .803 r
.51554 .23074 .5307 .26327 .55879 .25329 .54368 .22056 Metetra
.638 .608 .803 r
.54368 .22056 .55879 .25329 .58717 .24322 .57212 .21027 Metetra
.638 .608 .803 r
.57212 .21027 .58717 .24322 .61584 .23304 .60085 .19987 Metetra
.638 .608 .803 r
.60085 .19987 .61584 .23304 .6448 .22276 .62989 .18936 Metetra
.638 .608 .803 r
.62989 .18936 .6448 .22276 .67407 .21237 .65922 .17874 Metetra
.638 .608 .803 r
.65922 .17874 .67407 .21237 .70365 .20187 .68887 .16802 Metetra
.638 .608 .803 r
.68887 .16802 .70365 .20187 .73353 .19126 .71882 .15717 Metetra
.638 .608 .803 r
.71882 .15717 .73353 .19126 .76374 .18054 .7491 .14622 Metetra
.102 .478 .896 r
.09079 .31104 .10832 .32736 .12992 .33526 .1124 .31884 Metetra
.102 .478 .896 r
.1124 .31884 .12992 .33526 .15195 .34332 .13444 .3268 Metetra
.53 .701 .949 r
.13444 .3268 .15195 .34332 .17442 .35154 .15821 .32408 Metetra
.643 .63 .822 r
.15821 .32408 .17442 .35154 .19887 .34534 .18299 .31493 Metetra
.638 .608 .803 r
.18299 .31493 .19887 .34534 .22386 .3363 .20802 .3057 Metetra
.638 .608 .803 r
.20802 .3057 .22386 .3363 .24908 .32717 .23328 .29638 Metetra
.638 .608 .803 r
.23328 .29638 .24908 .32717 .27456 .31795 .2588 .28697 Metetra
.638 .608 .803 r
.2588 .28697 .27456 .31795 .30029 .30864 .28457 .27746 Metetra
.638 .608 .803 r
.28457 .27746 .30029 .30864 .32626 .29924 .31059 .26786 Metetra
.638 .608 .803 r
.31059 .26786 .32626 .29924 .3525 .28975 .33687 .25816 Metetra
.638 .608 .803 r
.33687 .25816 .3525 .28975 .379 .28016 .36342 .24837 Metetra
.638 .608 .803 r
.36342 .24837 .379 .28016 .40576 .27047 .39023 .23848 Metetra
.638 .608 .803 r
.39023 .23848 .40576 .27047 .43279 .26069 .41731 .22849 Metetra
.638 .608 .803 r
.41731 .22849 .43279 .26069 .46009 .25081 .44467 .2184 Metetra
.638 .608 .803 r
.44467 .2184 .46009 .25081 .48767 .24083 .4723 .2082 Metetra
.638 .608 .803 r
.4723 .2082 .48767 .24083 .51554 .23074 .50022 .1979 Metetra
.638 .608 .803 r
.50022 .1979 .51554 .23074 .54368 .22056 .52843 .1875 Metetra
.638 .608 .803 r
.52843 .1875 .54368 .22056 .57212 .21027 .55693 .17699 Metetra
.638 .608 .803 r
.55693 .17699 .57212 .21027 .60085 .19987 .58572 .16636 Metetra
.638 .608 .803 r
.58572 .16636 .60085 .19987 .62989 .18936 .61482 .15563 Metetra
.638 .608 .803 r
.61482 .15563 .62989 .18936 .65922 .17874 .64422 .14478 Metetra
.638 .608 .803 r
.64422 .14478 .65922 .17874 .68887 .16802 .67394 .13382 Metetra
.638 .608 .803 r
.67394 .13382 .68887 .16802 .71882 .15717 .70397 .12274 Metetra
.638 .608 .803 r
.70397 .12274 .71882 .15717 .7491 .14622 .73432 .11155 Metetra
.102 .478 .896 r
.07296 .29443 .09079 .31104 .1124 .31884 .09457 .30213 Metetra
.422 .655 .956 r
.09457 .30213 .1124 .31884 .13444 .3268 .11756 .30282 Metetra
.651 .663 .849 r
.11756 .30282 .13444 .3268 .15821 .32408 .14214 .29357 Metetra
.638 .608 .803 r
.14214 .29357 .15821 .32408 .18299 .31493 .16697 .28424 Metetra
.638 .608 .803 r
.16697 .28424 .18299 .31493 .20802 .3057 .19203 .27482 Metetra
.638 .608 .803 r
.19203 .27482 .20802 .3057 .23328 .29638 .21734 .2653 Metetra
.638 .608 .803 r
.21734 .2653 .23328 .29638 .2588 .28697 .24289 .25569 Metetra
.638 .608 .803 r
.24289 .25569 .2588 .28697 .28457 .27746 .2687 .24599 Metetra
.638 .608 .803 r
.2687 .24599 .28457 .27746 .31059 .26786 .29477 .23618 Metetra
.638 .608 .803 r
.29477 .23618 .31059 .26786 .33687 .25816 .3211 .22628 Metetra
.638 .608 .803 r
.3211 .22628 .33687 .25816 .36342 .24837 .34769 .21628 Metetra
.638 .608 .803 r
.34769 .21628 .36342 .24837 .39023 .23848 .37455 .20618 Metetra
.638 .608 .803 r
.37455 .20618 .39023 .23848 .41731 .22849 .40168 .19598 Metetra
.638 .608 .803 r
.40168 .19598 .41731 .22849 .44467 .2184 .42909 .18568 Metetra
.638 .608 .803 r
.42909 .18568 .44467 .2184 .4723 .2082 .45678 .17526 Metetra
.638 .608 .803 r
.45678 .17526 .4723 .2082 .50022 .1979 .48476 .16474 Metetra
.638 .608 .803 r
.48476 .16474 .50022 .1979 .52843 .1875 .51302 .15412 Metetra
.638 .608 .803 r
.51302 .15412 .52843 .1875 .55693 .17699 .54158 .14338 Metetra
.638 .608 .803 r
.54158 .14338 .55693 .17699 .58572 .16636 .57044 .13253 Metetra
.638 .608 .803 r
.57044 .13253 .58572 .16636 .61482 .15563 .5996 .12156 Metetra
.638 .608 .803 r
.5996 .12156 .61482 .15563 .64422 .14478 .62907 .11048 Metetra
.638 .608 .803 r
.62907 .11048 .64422 .14478 .67394 .13382 .65885 .09928 Metetra
.638 .608 .803 r
.65885 .09928 .67394 .13382 .70397 .12274 .68896 .08796 Metetra
.638 .608 .803 r
.68896 .08796 .70397 .12274 .73432 .11155 .71938 .07652 Metetra
.281 .583 .943 r
.05481 .27753 .07296 .29443 .09457 .30213 .07694 .28157 Metetra
.658 .7 .878 r
.07694 .28157 .09457 .30213 .11756 .30282 .10132 .27223 Metetra
.638 .608 .803 r
.10132 .27223 .11756 .30282 .14214 .29357 .12594 .26279 Metetra
.638 .608 .803 r
.12594 .26279 .14214 .29357 .16697 .28424 .15079 .25327 Metetra
.638 .608 .803 r
.15079 .25327 .16697 .28424 .19203 .27482 .17589 .24365 Metetra
.638 .608 .803 r
.17589 .24365 .19203 .27482 .21734 .2653 .20124 .23393 Metetra
.638 .608 .803 r
.20124 .23393 .21734 .2653 .24289 .25569 .22684 .22412 Metetra
.638 .608 .803 r
.22684 .22412 .24289 .25569 .2687 .24599 .25269 .21421 Metetra
.638 .608 .803 r
.25269 .21421 .2687 .24599 .29477 .23618 .2788 .20421 Metetra
.638 .608 .803 r
.2788 .20421 .29477 .23618 .3211 .22628 .30517 .1941 Metetra
.638 .608 .803 r
.30517 .1941 .3211 .22628 .34769 .21628 .33181 .18389 Metetra
.638 .608 .803 r
.33181 .18389 .34769 .21628 .37455 .20618 .35872 .17358 Metetra
.638 .608 .803 r
.35872 .17358 .37455 .20618 .40168 .19598 .3859 .16316 Metetra
.638 .608 .803 r
.3859 .16316 .40168 .19598 .42909 .18568 .41337 .15263 Metetra
.638 .608 .803 r
.41337 .15263 .42909 .18568 .45678 .17526 .44111 .142 Metetra
.638 .608 .803 r
.44111 .142 .45678 .17526 .48476 .16474 .46914 .13126 Metetra
.638 .608 .803 r
.46914 .13126 .48476 .16474 .51302 .15412 .49747 .1204 Metetra
.638 .608 .803 r
.49747 .1204 .51302 .15412 .54158 .14338 .52609 .10943 Metetra
.638 .608 .803 r
.52609 .10943 .54158 .14338 .57044 .13253 .55501 .09835 Metetra
.638 .608 .803 r
.55501 .09835 .57044 .13253 .5996 .12156 .58423 .08715 Metetra
.638 .608 .803 r
.58423 .08715 .5996 .12156 .62907 .11048 .61377 .07583 Metetra
.638 .608 .803 r
.61377 .07583 .62907 .11048 .65885 .09928 .64362 .06439 Metetra
.638 .608 .803 r
.64362 .06439 .65885 .09928 .68896 .08796 .67379 .05282 Metetra
.638 .608 .803 r
.67379 .05282 .68896 .08796 .71938 .07652 .70429 .04114 Metetra
.664 .741 .908 r
.03634 .26033 .05481 .27753 .07694 .28157 .06052 .25089 Metetra
.638 .608 .803 r
.06052 .25089 .07694 .28157 .10132 .27223 .08493 .24135 Metetra
.638 .608 .803 r
.08493 .24135 .10132 .27223 .12594 .26279 .10958 .23173 Metetra
.638 .608 .803 r
.10958 .23173 .12594 .26279 .15079 .25327 .13447 .222 Metetra
.638 .608 .803 r
.13447 .222 .15079 .25327 .17589 .24365 .15961 .21218 Metetra
.638 .608 .803 r
.15961 .21218 .17589 .24365 .20124 .23393 .18499 .20227 Metetra
.638 .608 .803 r
.18499 .20227 .20124 .23393 .22684 .22412 .21063 .19226 Metetra
.638 .608 .803 r
.21063 .19226 .22684 .22412 .25269 .21421 .23652 .18214 Metetra
.638 .608 .803 r
.23652 .18214 .25269 .21421 .2788 .20421 .26268 .17193 Metetra
.638 .608 .803 r
.26268 .17193 .2788 .20421 .30517 .1941 .2891 .16161 Metetra
.638 .608 .803 r
.2891 .16161 .30517 .1941 .33181 .18389 .31578 .15118 Metetra
.638 .608 .803 r
.31578 .15118 .33181 .18389 .35872 .17358 .34274 .14065 Metetra
.638 .608 .803 r
.34274 .14065 .35872 .17358 .3859 .16316 .36997 .13002 Metetra
.638 .608 .803 r
.36997 .13002 .3859 .16316 .41337 .15263 .39749 .11927 Metetra
.638 .608 .803 r
.39749 .11927 .41337 .15263 .44111 .142 .42528 .10841 Metetra
.638 .608 .803 r
.42528 .10841 .44111 .142 .46914 .13126 .45337 .09744 Metetra
.638 .608 .803 r
.45337 .09744 .46914 .13126 .49747 .1204 .48175 .08636 Metetra
.638 .608 .803 r
.48175 .08636 .49747 .1204 .52609 .10943 .51043 .07515 Metetra
.638 .608 .803 r
.51043 .07515 .52609 .10943 .55501 .09835 .53942 .06383 Metetra
.638 .608 .803 r
.53942 .06383 .55501 .09835 .58423 .08715 .56871 .05239 Metetra
.638 .608 .803 r
.56871 .05239 .58423 .08715 .61377 .07583 .59831 .04083 Metetra
.638 .608 .803 r
.59831 .04083 .61377 .07583 .64362 .06439 .62823 .02914 Metetra
.638 .608 .803 r
.62823 .02914 .64362 .06439 .67379 .05282 .65848 .01733 Metetra
.638 .608 .803 r
.65848 .01733 .67379 .05282 .70429 .04114 .68905 .00539 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250, 202.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j0000bQ000`40n007h00On_ll003joc`00?[o
?000n_ll003joc`00?[o?000n_ll003joc`00?[o?000n_ll002Foc`4001Poc`009So?003003o??ll
05oo?000V?ll00<00?lloc`0Goll002Hoc`00`00occo?01Ooc`009So?003003o??ll00Go?08005So
?000U_ll0`001_ll00@00?lloc`005Oo?000V?ll00<00?lloc`01?ll00@00?lloc`005Oo?000Woll
00@00?lloc`005Oo?000Woll00@00?lloc`005Oo?000V_ll0P000oll00@00?lloc`005Oo?000V?ll
1@000oll0P00F?ll002Eoc`500000jCI0000001Moc`006go?08000Co?003003o??ll00?o?08001So
?0800003oc`0000000>Tf@<005co?000K?ll00@00?lloc`000So?004003o??ll000Doc`300000oll
00000005Y=T200000oll003o?01Joc`006co?004003o??ll0008oc`01000occo?0004Oll1`0000>T
f@00Y=T01:CI00@00:CI000005_o?000K?ll00@00?lloc`000Wo?080013o?0D000JTf@03002TfJCI
00:Tf@05002Tf@00oc`0001Joc`006co?004003o??ll0008oc`01000occo?0003?ll1@0000>Tf@00
Y=T01ZCI00<00:CIY=T00ZCI00H00:CIY=T00?ll001Ioc`006co?004003o??ll0008oc`01000occo
?0002_ll0P0000?o?00000001:CI00<00:CIY=T01JCI00D00:CIY=VTf@0000:Tf@03003o?00005Wo
?000KOll0P002_ll0P002?ll0`0000?o?00000001ZCI00<00:CIY=T01JCI00<00:CIY=T00ZCI00<0
0:CI00000`00F?ll0021oc`600000jCI002Tf@06Y=T00`00Y=VTf@05Y=T00`00Y=T0000300001JCI
003o??ll0000Eoll001noc`50006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T30002Y=T01`00Y=VT
fJCI003o?00005Oo?000O?ll100000>Tf@00Y=T01ZCI00<00:CIY=T01JCI00@00:CIY=VTf@800003
Y=T00:CI00:Tf@05002TfJCIY=T00002oc`00`00occo?01Doc`007Wo?0D000BTf@03002TfJCI00FT
f@03002TfJCI00BTf@04002Tf@000004Y=T01000Y=VTf@001:CI00@00?lloc`005Go?000Coll0P00
1?ll00<00?lloc`00oll0P006_ll0P0000?o?00000001ZCI00<00:CIY=T01JCI00<00:CIY=T01:CI
0P001ZCI00@00:CIY=T000BTf@04003o?000001Eoc`004ko?004003o??ll0008oc`01000occo?000
5_ll1P0000>Tf@00Y=T01ZCI00<00:CIY=T01JCI00<00:CI00000`0000>Tf@00Y=T01JCI00@00:CI
Y=T000FTf@04003o??ll001Doc`004ko?004003o??ll0008oc`01000occo?0004oll1P001JCI00<0
0:CIY=T01:CI00<00:CIY=T01:CI0`001ZCI00<00:CIY=T01:CI00<00:CI00001:CI0P000oll00<0
0?lloc`0DOll001>oc`01000occo?0002?ll0`004_ll1@0000>Tf@00Y=T01JCI00<00:CIY=T01JCI
00@00:CIY=VTf@800003Y=T00:CI00JTf@03002TfJCI00BTf@03002Tf@0000:Tf@800003Y=T00?ll
00;o?003003o??ll00Go?08000Co?003003o??ll00?o?08000Co?08000?o?0@0037o?000C_ll00@0
0?lloc`000So?003003o??ll00oo?0D000FTf@03002TfJCI00BTf@03002TfJCI00BTf@04002Tf@00
0004Y=T00`00Y=VTf@05Y=T00`00Y=VTf@04Y=T40004Y=T00`00occo?0020005oc`01000occo?000
2?ll00@00?lloc`000;o?004003o??ll0004oc`00`00occo?00`oc`004ko?004003o??ll0008oc`0
0`00occo?00=oc`400000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T20006Y=T00`00
Y=VTf@05Y=T00`00Y=VTf@03Y=T30006Y=T00`00occo?002oc`00`00occo?002oc`01000occo?000
2?ll00@00?lloc`000;o?004003o??ll0004oc`00`00occo?00`oc`004oo?08000[o?0<000Wo?0D0
00BTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000<00003Y=T00:CI00FTf@03002TfJCI
00JTf@03002Tf@00008000:Tf@03002TfJCI00BTf@03003o??ll00;o?003003o??ll00;o?004003o
??ll0008oc`01000occo?0000_ll00@00?lloc`000Co?003003o??ll033o?000IOll1@001ZCI00<0
0:CIY=T01:CI00<00:CIY=T00jCI0`001ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI00<0
0:CIY=T01JCI00<00?lloc`00_ll00D00?llocco?00000;o?003003o??ll00Ko?004003o??ll0002
oc`01000occo?0001?ll00<00?lloc`0<?ll001Roc`600000jCI002Tf@05Y=T00`00Y=VTf@05Y=T0
0`00Y=T000020002Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T200000jCI002T
f@05Y=T20006Y=T01000occo??ll0`000_ll00@00?lloc`000So?004003o??ll0002oc`01000occo
?0000_ll0`00<_ll001Poc`40006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VT
f@05Y=T00`00Y=VTf@04Y=T01000Y=T000001:CI00<00:CIY=T00jCI0P001jCI00<00?lloc`00_ll
00@00?llocco?08000[o?08000Co?08000Go?003003o??ll033o?000GOll1@0000>Tf@00Y=T01JCI
00<00:CIY=T01:CI00@00:CIY=VTf@800003Y=T00:CI00JTf@03002TfJCI00BTf@03002TfJCI00>T
f@<000JTf@03002TfJCI00>Tf@03002Tf@0000FTf@8000Go?003003o??ll04co?000<_ll0P001?ll
00<00?lloc`01?ll00<00?lloc`06Oll0P0000Co?000000000:Tf@03002TfJCI00FTf@03002TfJCI
00BTf@<000BTf@03002TfJCI00BTf@03002TfJCI00FTf@03002Tf@00008000:Tf@03002TfJCI00BT
f@03002TfJCI00>Tf@03002Tf@0000:Tf@<00003Y=T00?ll00Go?003003o??ll04_o?000<Oll00@0
0?lloc`000[o?003003o??ll01Ko?0<00003oc`0000000JTf@03002TfJCI00BTf@03002TfJCI00>T
f@8000JTf@03002TfJCI00FTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00FTf@03002TfJCI00:T
f@03002Tf@00008000FTf@03003o??ll00?o?003003o??ll04_o?000<Oll00@00?lloc`000Oo?0D0
01Co?0L00003Y=T00:CI00FTf@03002TfJCI00FTf@03002Tf@0000800003Y=T00:CI00JTf@03002T
fJCI00BTf@03002TfJCI00<00003Y=T00:CI00JTf@03002TfJCI00BTf@03002TfJCI00:Tf@800003
Y=T00:CI00FTf@03003o??ll00Co?003003o??ll04[o?000<Oll00@00?lloc`000Oo?004003o??ll
000Coc`200001?ll000000001JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01JCI00H00:CI00000:CI0002
Y=T00`00Y=VTf@04Y=T00`00occo?004oc`00`00occo?019oc`0037o?004003o??ll0008oc`00`00
oc`0000@oc`600000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T0
0`00Y=VTf@05Y=T01000Y=VTfJCI0P0000>Tf@00Y=T01JCI00<00:CIY=T01JCI00<00:CIY=T00jCI
0`000jCI00@00:CIY=T000JTf@03003o??ll00Co?003003o??ll04Wo?000<Oll00@00?lloc`000Wo
?08000ko?0D000FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002T
fJCI00BTf@04002Tf@000004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI
002Tf@03Y=T01000Y=VTf@001jCI00<00?lloc`00oll0P00B_ll000boc`2000;oc`00`00occo?009
oc`500000jCI002Tf@05Y=T00`00Y=VTf@04Y=T01000Y=VTfJCI0P0000>Tf@00Y=T01JCI00<00:CI
Y=T01:CI00<00:CIY=T01:CI0P001ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI00D00:CI
Y=VTf@0000>Tf@03002TfJCI00>Tf@8000Oo?003003o??ll04Oo?000BOll10001JCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI0`001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000`0000>T
f@00Y=T01JCI00<00:CIY=T01JCI00<00:CI00000`0000>Tf@00Y=T01JCI00D00:CIY=VTf@0000>T
f@04002TfJCIY=T200000jCI003o?006oc`00`00occo?017oc`004Ko?0@00003Y=T00:CI00FTf@03
002TfJCI00BTf@03002TfJCI00>Tf@8000JTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000JTf@03
002TfJCI00BTf@03002TfJCI00>Tf@<000JTf@03002TfJCI00BTf@04002TfJCI0004Y=T30004Y=T0
0`00occo?005oc`00`00occo?016oc`004?o?0D000BTf@03002TfJCI00BTf@03002TfJCI00BTf@03
002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00FTf@03002Tf@00008000:Tf@03002TfJCI00BT
f@03002TfJCI00BTf@04002TfJCIY=T200000jCI002Tf@06Y=T00`00Y=VTf@04Y=T01000Y=VTf@00
0jCI0P001ZCI00<00?lloc`01Oll0P00Aoll0011oc`50006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03
Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@05Y=T00`00Y=VTf@04
Y=T30004Y=T00`00Y=VTf@05Y=T00`00Y=VTf@04Y=T00`00Y=T0000300000jCI002Tf@05Y=T00`00
occo?006oc`00`00occo?015oc`001Ko?08000Co?003003o??ll00;o?0@001[o?0H00003Y=T00:CI
00BTf@03002TfJCI00FTf@03002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00BTf@04002TfJCI
Y=T200000jCI002Tf@06Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T20006Y=T00`00Y=VTf@05Y=T0
0`00Y=VTf@03Y=T40005Y=T00`00Y=VTf@04Y=T00`00occo?006oc`00`00occo?014oc`001Go?004
003o??ll0008oc`00`00occo?00Hoc`50005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T0
0`00Y=VTf@04Y=T00`00Y=VTf@04Y=T30004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@05Y=T00`00Y=T0
000200000jCI002Tf@06Y=T00`00Y=VTf@05Y=T00`00Y=T000020002Y=T20005Y=T00`00Y=VTf@04
Y=T00`00occo?007oc`00`00occo?004oc`20004oc`00`00occo?003oc`20004oc`20003oc`4000T
oc`001Go?004003o??ll0009oc`00`00occo?00Doc`50002Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03
Y=T01000Y=VTfJCI0P000ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00jCI0P001ZCI
00<00:CIY=T01JCI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI
0P001ZCI00<00:CIY=T01:CI00<00?lloc`01Oll0P001Oll00@00?lloc`000So?004003o??ll0002
oc`01000occo?0000_ll00<00?lloc`09Oll000Eoc`01000occo?0002_ll00<00?lloc`04Oll1@00
1:CI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<0
0:CI00000P000ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CIY=T00`0000>Tf@00Y=T01JCI
00<00:CIY=T01JCI00@00:CIY=VTf@800003Y=T00:CI00JTf@03002TfJCI00BTf@03002TfJCI00>T
f@8000Wo?003003o??ll00;o?004003o??ll0008oc`01000occo?0000_ll00@00?lloc`000?o?003
003o??ll02Co?0005Oll00@00?lloc`000_o?003003o??ll00go?0D00003Y=T00:CI00FTf@03002T
fJCI00BTf@03002TfJCI00:Tf@8000NTf@03002TfJCI00>Tf@03002TfJCI00>Tf@<000FTf@03002T
fJCI00BTf@03002TfJCI00BTf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@04002Tf@000004
Y=T00`00Y=VTf@04Y=T00`00Y=VTf@05Y=T00`00Y=T000020002Y=T00`00occo?007oc`01@00occo
??ll00000_ll00<00?lloc`01_ll00@00?lloc`000;o?004003o??ll0004oc`00`00occo?00Soc`0
01Go?004003o??ll0008oc`01000occo?0003Oll10001JCI00<00:CIY=T00jCI00<00:CIY=T01:CI
00<00:CIY=T00P000ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P000ZCI00<00:CI
Y=T01:CI00<00:CIY=T01:CI00@00:CIY=VTf@800003Y=T00:CI00FTf@03002TfJCI00BTf@03002T
fJCI00BTf@8000JTf@03002TfJCI00BTf@8000FTf@<000FTf@03003o??ll00Oo?005003o??lloc`0
0002oc`00`00occo?006oc`01000occo?0000_ll00@00?lloc`000Go?003003o??ll02;o?0005_ll
0P002_ll0P002oll10000ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001:CI
00<00:CIY=T01JCI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00@00:CI
000000BTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000<00003Y=T00:CI00FTf@03002T
fJCI00BTf@8000:Tf@<00003Y=T00:CI00JTf@03003o??ll00Go?0<000;o?004003o??ll0008oc`0
1000occo?0000_ll00@00?lloc`000;o?004003o??ll000Toc`002go?0@000BTf@03002TfJCI00BT
f@03002TfJCI00>Tf@03002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI0080
00:Tf@03002TfJCI00BTf@03002TfJCI00BTf@03002TfJCI00>Tf@8000JTf@03002TfJCI00BTf@03
002TfJCI00>Tf@<000JTf@03002TfJCI00BTf@03002TfJCI00>Tf@@000FTf@03002TfJCI00BTf@03
003o??ll00So?003003o??ll008000[o?08000Co?08000Co?08002Go?000:_ll100000>Tf@00Y=T0
1JCI00<00:CIY=T00jCI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`00
1:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CIY=T00`0000>Tf@00Y=T01ZCI00<00:CIY=T0
1:CI00<00:CI00000P000ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CIY=T00ZCI0P0000>T
f@00Y=T01JCI00<00:CIY=T01JCI00<00?lloc`01oll00<00?lloc`0?oll000Xoc`40004Y=T00`00
Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00
Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04
Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@05Y=T00`00Y=VTf@04Y=T01000Y=T000000ZCI00<0
0:CI00001ZCI00<00:CIY=T01:CI00<00?lloc`02?ll00<00?lloc`0?_ll0009oc`2000Joc`50006
Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005
Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@05
Y=T00`00Y=T0000200000jCI002Tf@06Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30004Y=T00`00
Y=T00006Y=T00`00Y=VTf@04Y=T20008oc`20010oc`000So?004003o??ll000Foc`300000oll0000
0002Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VTf@020002Y=T00`00Y=VTf@03Y=T00`00
Y=VTf@04Y=T01000Y=VTfJCI0P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`00
1JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01JCI00<0
0:CI00000P0000>Tf@00Y=T01:CI00<00:CI00001jCI00<00:CI00000`0000>Tf@00oc`02Oll00<0
0?lloc`0?Oll0008oc`01000occo?0005?ll1P001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI0`00
1:CI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI00<0
0:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00@00:CIY=VTf@800003Y=T00:CI00FTf@03
002TfJCI00FTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00:Tf@04002TfJCI0005Y=T30006Y=T0
0`00occo?008oc`00`00occo?00loc`000So?004003o??ll000Aoc`600000jCI002Tf@05Y=T00`00
Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03Y=T20006
Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T30004
Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@02
Y=T01000Y=VTf@000jCI0P0000>Tf@00Y=T01ZCI00<00?lloc`02?ll0P00?Oll0008oc`01000occo
?0003oll1@001JCI00<00:CIY=T01:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T00jCI00<00:CI
Y=T01:CI00<00:CI00000P0000>Tf@00Y=T01ZCI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00
Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0P001ZCI00<00:CIY=T01:CI00<00:CIY=T01:CI
0`001JCI00<00:CIY=T01:CI00D00:CIY=VTf@0000>Tf@<000BTf@03002TfJCI00FTf@03003o??ll
00Oo?08003go?0002?ll00@00?lloc`000co?0D000:Tf@03002TfJCI00>Tf@03002TfJCI00BTf@03
002TfJCI008000:Tf@03002TfJCI00>Tf@03002TfJCI00BTf@03002TfJCI00:Tf@<000FTf@03002T
fJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@000080
0003Y=T00:CI00JTf@03002TfJCI00BTf@03002Tf@0000<00003Y=T00:CI00FTf@03002TfJCI00BT
f@05002TfJCIY=T00002Y=T20006Y=T00`00Y=VTf@05Y=T00`00occo?009oc`00`00occo?00joc`0
00Wo?08000[o?0H000BTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000BTf@03002TfJCI00BTf@03
002TfJCI00>Tf@03002TfJCI008000:Tf@03002TfJCI00>Tf@03002TfJCI00FTf@03002Tf@000080
0003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002T
fJCI00>Tf@<000JTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000<00003Y=T00:CI00FT
f@03002TfJCI00JTf@03003o??ll00So?003003o??ll03[o?0004oll1@000ZCI00<00:CIY=T00jCI
00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T00jCI
0`001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI
00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01JCI00<00:CI00000P000ZCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI00<00:CIY=T00jCI1@001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI0P00
2_ll0P00>oll000Aoc`50004Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T20005Y=T00`00Y=VTf@03
Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T01000Y=VTfJCI
0P000ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI
00<00:CIY=T00jCI0`001JCI00<00:CIY=T01JCI00<00:CIY=T01:CI00<00:CI00001@000ZCI00D0
0:CIY=VTf@0000JTf@03002TfJCI00:Tf@800003Y=T00?ll00_o?003003o??ll03So?0003oll1000
00>]o@00Y=T01JCI00<00:CIY=T00jCI00@00:CIY=VTf@800003Y=T00:CI00BTf@03002TfJCI00BT
f@03002TfJCI00:Tf@<000FTf@03002TfJCI00>Tf@03002TfJCI00BTf@<000BTf@03002TfJCI00BT
f@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00BTf@04002TfJCIY=T2
0002Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T60002Y=T01000Y=VTf@001:CI
00<00:CIY=T01:CI00@00:CI000000BTf@03003o??ll00Wo?003003o??ll03So?0003oll0P001:gm
00<00:CIY=T00jCI00<00:CIY=T00jCI00@00:CI000000>Tf@03002TfJCI00BTf@03002TfJCI00>T
f@03002TfJCI008000:Tf@03002TfJCI00>Tf@03002TfJCI00BTf@03002TfJCI00:Tf@8000NTf@03
002TfJCI00>Tf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@<000BTf@03
002TfJCI00BTf@03002TfJCI00FTf@03002Tf@0000D000FTf@05002TfJCIY=T00003Y=T00`00Y=VT
f@03Y=T30006Y=T00`00occo?00:oc`00`00occo?004oc`20004oc`00`00occo?003oc`20004oc`2
0004oc`2000Ioc`000So?08000Go?08000B]o@03002TfJCI00BTf@03002TfJCI00:Tf@8000JTf@03
002TfJCI00>Tf@03002TfJCI00>Tf@<000BTf@03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI
008000:Tf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI00FTf@03002T
fJCI00BTf@03002TfJCI00>Tf@8000NTf@03002TfJCI00BTf@03002TfJCI00>Tf@H000:Tf@03002T
fJCI00BTf@05002TfJCIY=T00003Y=T00`00Y=T0000200000jCI002Tf@06Y=T00`00occo?00;oc`0
0`00occo?002oc`01000occo?0002?ll00@00?lloc`000;o?004003o??ll0002oc`01000occo?000
6?ll0007oc`01000occo?0000oll0P0000?o?000[Od00jgm00<00:CIY=T00jCI00<00:CIY=T00P00
00>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T00jCI
00<00:CIY=T00jCI0`001:CI00<00:CIY=T01JCI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI
00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01ZCI00<00:CIY=T01:CI00<00:CIY=T00`00
00>Tf@0000001JCI00<00:CIY=T01:CI00<00:CIY=T00ZCI00<00:CI00000P001JCI00<00:CIY=T0
1JCI00<00?lloc`02_ll00<00?lloc`00_ll00@00?lloc`000So?004003o??ll0002oc`01000occo
?0001Oll00<00?lloc`05_ll0007oc`01000occo?0000oll00D00?llocco?00000>]o@03002TfJCI
00>Tf@<000BTf@03002TfJCI00BTf@03002TfJCI00:Tf@<000FTf@03002TfJCI00>Tf@03002TfJCI
00BTf@03002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI008000:Tf@03002T
fJCI00>Tf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00FTf@03002TfJCI00>T
f@<00006Y=T00000002Tf@001ZCI00<00:CIY=T01:CI00<00:CI00000`0000>Tf@00Y=T01JCI00<0
0:CIY=T01JCI00<00?lloc`02oll00D00?llocco?00000;o?003003o??ll00Ko?004003o??ll0002
oc`01000occo?0000oll0P006Oll0007oc`01000occo?0000oll0P000oll0P000Zgm00<00:CI0000
0P0000>]W000Y=T01:CI00<00:CIY=T01:CI00<00:CIY=T00P000ZCI00<00:CIY=T00jCI00<00:CI
Y=T01:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001:CI00<00:CI
Y=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01JCI00<00:CI
Y=T00`0000BTf@00000000BTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000>Tf@04002TfJCI0006
Y=T00`00Y=VTf@05Y=T00`00occo?009oc`30002oc`01000occo?0002?ll00@00?lloc`000;o?004
003o??ll0005oc`00`00occo?00Foc`000Oo?004003o??ll0003oc`00`00occo?003oc`50005[I`0
0`00Y=VTf@03Y=T00`00Y=VTf@03Y=T30004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VT
f@020002Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00
Y=VTf@03Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T300001ZCI0000
0000Y=T000JTf@03002TfJCI00BTf@03002Tf@00008000:Tf@03002TfJCI00:Tf@03002Tf@0000JT
f@03002TfJCI00BTf@8000go?004003o??ll0002oc`00`00occo?006oc`01000occo?0000_ll00@0
0?lloc`000;o?004003o??ll000Hoc`000Oo?004003o??ll0003oc`20005oc`200000dBn002]W004
[I`00`00Y=VTf@03Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03
Y=T30004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04
Y=T00`00Y=T000020002Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T200001:CI
000000001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T00jCI00<00:CI0000
1ZCI00<00:CI00000`0000>Tf@00oc`03Oll00<00?lloc`00P002_ll0P001?ll0P001?ll0P006Oll
0008oc`20004oc`00`00occo?006oc`00`00A;h00005[I`00`00Y=VTf@02Y=T30005Y=T00`00Y=VT
f@03Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VT
f@0300000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@04Y=T00`00Y=T0000400000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=T000020000
0jCI002Tf@06Y=T00`00Y=VTf@02Y=T00`00Y=T00005Y=T30006Y=T00`00occo?00<oc`00`00occo
?00boc`000go?08000Wo?0<000B]W003002TfJCI008000:UF`03002TfJCI00>Tf@03002TfJCI00BT
f@03002TfJCI00:Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00:Tf@<000FTf@03002TfJCI00BT
f@03002TfJCI00>Tf@03002TfJCI008000:Tf@03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI
00>Tf@D000BTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI
00>Tf@04002Tf@00Y=T300000jCI002Tf@06Y=T00`00occo?00;oc`2000doc`000go?08000Wo?003
000Kg00000L000BUF`03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI008000:Tf@03002TfJCI
00>Tf@03002TfJCI00BTf@03002TfJCI00800003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI
00>Tf@<000BTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000D000NTf@03002TfJCI00BT
f@03002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00FTf@03002TfJCI00>Tf@<000FTf@03002T
fJCI00FTf@03003o??ll00co?003003o??ll037o?0003Oll00<00?lloc`02Oll00@001_L6m`000A]
?P03002UFjEK00>UF`03002TfJCI00>Tf@03002TfJCI00>Tf@<000BTf@03002TfJCI00BTf@03002T
fJCI00>Tf@<000BTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI00FT
f@03002TfJCI00BTf@03002TfJCI00:Tf@D000>Tf@03002TfJCI00FTf@03002TfJCI00>Tf@<000FT
f@03002TfJCI00BTf@03002TfJCI00BTf@03002TfJCI00D000JTf@03002TfJCI00FTf@03003o??ll
00go?003003o??ll033o?0001Oll10001?ll0P002oll0P0000<Kg000KCh00fdn00<00:EKYE/00ZEK
00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T00`00
00>Tf@00Y=T01:CI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T00jCI00<00:CI
Y=T01:CI00<00:CIY=T01@001ZCI00<00:CIY=T01JCI00<00:CI00000P0000>Tf@00Y=T01JCI00<0
0:CIY=T01:CI00<00:CIY=T01:CI0`001:CI0P001ZCI00<00:CIY=T01JCI00<00?lloc`02oll0P00
<_ll0007oc`00`00occo?003oc`00`00occo?00;oc`40003KCh00`00YE^UF`03YE/00`00Y=VTf@02
Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04
Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T40003Y=T00`00
Y=VTf@05Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T00003
00000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T2000?oc`00`00occo?00_oc`000Oo
?003003o??ll00?o?003003o??ll00co?0H00003KCh00:EK00>UF`03002TfJCI008000:U6P03002T
fJCI00>Tf@03002TfJCI00BTf@03002TfJCI00800003Y=T00:CI00FTf@03002TfJCI00>Tf@03002T
fJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI00D000JTf@03002TfJCI
00BTf@03002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000JTf@03
002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000<00003Y=T00?ll00oo?003003o??ll02ko?000
1oll00<00?lloc`00_ll0P004?ll0`0000<Kg00000001`001:DJ00<00:CIY=T01:CI00<00:CIY=T0
0jCI0`001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI00<00:CI00000P0000>Tf@00Y=T01JCI00<0
0:CIY=T01:CI00<00:CIY=T00jCI1@000jCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<0
0:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01ZCI00<00:CIY=T01:CI00<0
0:CIY=T00jCI0`001ZCI00<00?lloc`03Oll00<00?lloc`0;_ll0007oc`00`00occo?002oc`2000A
oc`400026m`01@00QIj5WXFN00001ZDJ00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01:CI
00<00:CIY=T01:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI
000010001ZCI00<00:CIY=T01:CI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<0
0:CIY=T00jCI0`001JCI00<00:CIY=T01JCI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T0
1ZCI00<00?lloc`03Oll0P00;oll0005oc`30004oc`00`00occo?00Aoc`00`006m`0000200000a_L
0025WP02QIh00`00YAZU6P04YAX00`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04
Y=T01000Y=T000000ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00jCI1@000jCI00<0
0:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI0000
0P0000>Tf@00Y=T01JCI00<00:CIY=T01JCI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01JCI00<0
0?lloc`03_ll00<00?lloc`01?ll0P001?ll00<00?lloc`00oll0P001?ll0P001Oll00<00?lloc`0
3?ll0007oc`00`00occo?002oc`2000Coc`00`006m`Kg0040002QIh00`00YAZU6P04YAX00`00Y=VT
f@0200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03Y=T30004Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@04Y=T00`00Y=T000040006Y=T00`00Y=VTf@04Y=T01000Y=VTfJCI0P0000>Tf@00Y=T0
1JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01JCI00<0
0:CI00000P0000BTf@00Y=T000BTf@03002TfJCI00FTf@03003o??ll00ko?003003o??ll00?o?004
003o??ll0008oc`01000occo?0000_ll00@00?lloc`000Co?003003o??ll00co?0003?ll00<00?ll
oc`04oll0P0000<Kg0006m`00P000XFN00<00:DJYAX00jDJ0`001:CI00<00:CIY=T01:CI00<00:CI
Y=T00jCI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T00jCI1@000jCI
00<00:CIY=T01:CI00<00:CIY=T01:CI0`001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI
00000P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI0P001JCI00<00:CI
Y=T01JCI00<00?lloc`03Oll0P001?ll00@00?lloc`000So?004003o??ll0002oc`01@00occo?000
oc`01@003Oll000<oc`2000Eoc`400026m`30002YAX300000igM002Tf@04Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=T000040006Y=T00`00
Y=VTf@04Y=T00`00Y=VTf@03Y=T20006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00
Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000300000jCI002Tf@05Y=T00`00Y=T00004Y=T00`00
Y=VTf@04Y=T2000Aoc`01@00occo??ll00000_ll00<00?lloc`01_ll00@00?lloc`000;o?006003o
??ll003o?0000_ll00<00?lloc`03?ll000<oc`00`00occo?00Eoc`500000a_L000000020005WMd0
0`00Y=VTf@03Y=T00`00Y=VTf@04Y=T01000Y=T000000ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI
00<00:CIY=T00ZCI1@000jCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00
Y=T01ZCI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CI
Y=T00jCI0`001ZCI00<00:CIY=T01:CI00<00:CI00001:CI00<00:CI00000`0000>Tf@00oc`04?ll
00D00?llocco?00000;o?003003o??ll00Ko?004003o??ll0002oc`01000occo?0000_ll00<00?ll
00003_ll0004oc`40003oc`00`00occo?00Hoc`00`006m`000050005WMd00`00Y=VTf@03Y=T00`00
Y=VTf@03Y=T30004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VTf@050005Y=T00`00Y=VT
f@04Y=T01000Y=VTfJCI1@001JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01ZCI00<00:CIY=T01:CI00<00:CI0000
0jCI0`001ZCI00<00?lloc`03Oll0`000_ll00@00?lloc`000So?004003o??ll0002oc`01000occo
?0000oll0P003_ll0004oc`00`00occo?004oc`2000Joc`300026m`40004WMd00`00Y=VTf@03Y=T0
0`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03Y=T40003Y=T00`00Y=VT
f@04Y=T00`00Y=VTf@03Y=T40003Y=T00`00Y=VTf@04Y=T00`00Y=VTf@05Y=T00`00Y=T000020000
0jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@05Y=T00`00Y=VT
f@04Y=T00`00Y=T0000200000jCI002Tf@06Y=T00`00occo?00@oc`00`00occo?002000:oc`20004
oc`20005oc`00`00occo?00<oc`000Go?003003o??ll00?o?003003o??ll01Wo?003000Kg0000080
00036m`001_L00<000:Mg@03002TfJCI00:Tf@<000FTf@03002TfJCI00>Tf@03002TfJCI00BTf@03
002Tf@0000@000JTf@03002TfJCI00>Tf@03002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI00BT
f@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T0
0:CI00FTf@03002TfJCI00FTf@03002TfJCI00>Tf@<00003Y=T00:CI00:Tf@03002TfJCI00FTf@03
003o??ll00oo?003003o??ll02So?0001_ll00<00?lloc`00_ll0P006oll00<001_L6m`010000Q_L
0`0000>Mg@00Y=T00P000Zgm00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00ZCI1@000jCI
00<00:CIY=T01:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T00jCI00<00:CIY=T01:CI00<00:CI
Y=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI
00<00:CIY=T01JCI00<00:CI00000P0000>Tf@00Y=T00ZCI00@00:CIY=T000NTf@03003o??ll00oo
?08002Wo?0001oll00D00?llocco?00001go?0P000036m`002@M00<000B]o@03002TfJCI00BTf@03
002TfJCI00>Tf@03002TfJCI00D000FTf@03002TfJCI00BTf@03002TfJCI008000:Tf@03002TfJCI
00>Tf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@03
002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI00BTf@<000FTf@04002TfJCI
0003Y=T00`00Y=VTf@05Y=T00`00occo?00@oc`00`00occo?00Voc`000Co?004003o??ll0003oc`0
0`00occo?00Loc`00`006m`00007000291d00`00[Of]o@03[Od00`00Y=VTf@03Y=T01000Y=VTfJCI
1P000jCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI
00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CI
Y=T01:CI00<00:CIY=T01:CI00<00:CI00000`0000>Tf@00Y=T01JCI00D00:CIY=VTf@0000:Tf@03
002TfJCI00BTf@8001;o?003003o??ll02Ko?0001Oll0P001?ll00<00?lloc`07Oll0P000Q_L2P00
1:gm00<00:CIY=T00ZCI20001ZCI00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<0
0:CIY=T00jCI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI0000
0P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001ZCI00<00:CIY=T01:CI00D0
0:CIY=VTf@0000:Tf@03002Tf@0000<00003Y=T00?ll017o?08002Oo?0002_ll0P008Oll00<001_L
00000Q_L0P0000<Kg0006m`01@0000B]o@00Y=VTf@800004YI/000000004Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@02Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002T
f@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T0
0`00Y=T0000200000jCI002Tf@06Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T40006Y=T00`00occo
?00Aoc`00`00occo?00Toc`000[o?003003o??ll027o?0<000<Kg0<000<Kg003001<gP0000H00003
YI/00:CI00BTf@03002TfJCI00BTf@03002TfJCI00800003Y=T00:CI00FTf@03002TfJCI00BTf@03
002TfJCI00:Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI
00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00FTf@03002TfJCI00BTf@03
002Tf@0000800003Y=T00:CI00JTf@03003o??ll017o?003003o??ll02Co?0002_ll0P008oll1000
00<Kg0006m`00`0000@Kg000C=i<gP<000FUV`03002TfJCI00>Tf@03002TfJCI00>Tf@<000BTf@03
002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI008000:Tf@03002TfJCI00>Tf@03002TfJCI00BT
f@03002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T0
0:CI00FTf@03002TfJCI00FTf@03002TfJCI00>Tf@<000>Tf@03002Tf@0000NTf@03003o??ll017o
?003003o??ll02?o?0000oll0P001Oll00<00?lloc`08oll1P000Q_L1@000TcN00<00:FKYI/00jFK
00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01:CI00<00:CIY=T01:CI00<00:CIY=T00jCI
0`001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CI
Y=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01JCI00<00:CI00000P00
00>Tf@00Y=T01:CI0P001jCI00<00?lloc`04?ll00<00?ll00009?ll0002oc`01000occo?0001?ll
00<00?lloc`09?ll3@000TcN00<00:FKYI/00jFK00<00:CIY=T00ZCI0`001JCI00<00:CIY=T00jCI
00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T00jCI
0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CI
Y=T01:CI00<00:CIY=T01:CI0`001JCI00<00:CIY=T00ZCI00<00:CI00001jCI00<00?lloc`04Oll
00<00?lloc`01Oll0P001?ll00<00?lloc`00oll0P001?ll0P000oll0`000oll0005oc`00`00occo
?002oc`00`00occo?00Uoc`600000a_L000000060005YI/00`00Y=VTf@0200000jDk002Tf@05Y=T0
0`00Y=VTf@03Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=T0
000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@04Y=T00`00Y=T0000300000jCI002Tf@05Y=T00`00Y=VTf@03Y=T20006Y=T2000Doc`0
0`00occo?003oc`01000occo?0002?ll00@00?lloc`000;o?004003o??ll0005oc`10001oc`1oc`0
00?o?08000Co?08002Oo?0<000046m`0000000036m`=0004YC/00`00Y=VTf@04Y=T00`00Y=VTf@03
Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T00`00
Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00
Y=VTf@03Y=T30006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T200000jCI0000000200000jCI003o
?00Boc`00`00oc`00004oc`01000occo?0002?ll00@00?lloc`000;o?004003o??ll0005oc`10001
oc`1oc`000Go?005003o??lloc`0000Uoc`30003oc`6000011_L000Kg1_L10001GEN00<00:DkYC/0
0ZDk00<00:CIY=T01:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T00jCI00<0
0:CIY=T00P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01ZCI00<00:CIY=T01:CI00<00:CIY=T0
0jCI0`001ZCI00<00?lloc`04_ll00<00?lloc`00_ll00@00?lloc`000So?004003o??ll0002oc`0
1000occo?0000_ll0`000oll0002oc`01000occo?0000oll0P008Oll0`001oll20000a_L10000gEN
00<00:DkYC/00jDk00<00:CIY=T01:CI00@00:CI000000:Tf@03002TfJCI00>Tf@03002TfJCI00BT
f@03002TfJCI00>Tf@<000BTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T0
0:CI00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00FTf@03002TfJCI00BT
f@03002Tf@0000800003Y=T00:CI00JTf@03003o??ll01;o?08000?o?004003o??ll0008oc`01000
occo?0000_ll00@00?lloc`000;o?003003o??ll00?o?0000oll0P001?ll00<00?lloc`07Oll0`00
2oll2@0000@Kg0006m`Kg0<0009eGP03002U>jDk00:U>`03002TfJCI00>Tf@<000BTf@03002TfJCI
00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI00BTf@03002TfJCI00BTf@04002TfJCI
Y=T50005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00
Y=VTf@05Y=T01000Y=VTfJCI1@001JCI00<00:CIY=T01JCI00<00?lloc`03_ll0`0000?o?000oc`0
0_ll00@00?lloc`000So?004003o??ll0002oc`01000occo?0000_ll00<00?lloc`00oll0009oc`0
0`00occo?00Joc`3000?oc`;00036m`40005YC/00`00Y=T0000200000jCj002Tf@05Y=T00`00Y=VT
f@03Y=T01000Y=VTfJCI1@001JCI00<00:CIY=T00jCI00<00:CIY=T00jCI10000jCI00<00:CIY=T0
1:CI00<00:CIY=T01:CI00@00:CIY=VTf@D000FTf@03002TfJCI00BTf@03002TfJCI00BTf@@000>T
f@03002TfJCI00BTf@8000JTf@03003o??ll00[o?0@000Co?003003o??ll00;o?08000[o?08000Co
?08000?o?0@000;o?0002Oll00<00?lloc`05oll0`004_ll00<001_L6m`00P0000<Kg00000001P00
00<Kg0006m`020001JCj00<00:CIY=T01:CI00<00:CIY=T00ZCI10000jCI00<00:CIY=T01:CI00<0
0:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI1000
0jCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CIY=T0100000>Tf@00Y=T01JCI00<00:CIY=T0
1:CI0P001JCI0P002?ll0`002?ll00<00?lloc`07oll0008oc`3000Eoc`3000Foc`010006m`Kg1_L
0`0000<Kg00000000P0000<Kg00000000P0000<Kg000SKh00hfn00<00:CjY?X00jCj00<00:CIY=T0
1:CI00<00:CIY=T00P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00ZCI0`001JCI00<0
0:CIY=T00jCI00<00:CIY=T01:CI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<0
0:CIY=T00jCI0`001ZCI00<00:CIY=T00jCI00<00:CIY=T01:CI0P0000>Tf@0000000P0000>Tf@00
oc`01?ll0`002oll00<00?lloc`07oll0008oc`00`00occo?00Boc`3000Joc`300000a_L00000002
00000a_L0000000200026m`40004SKh00`00Y?ZTnP03Y?X00`00Y=VTf@03Y=T30004Y=T00`00Y=VT
f@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@020002Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00
Y=VTf@03Y=T30005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@06
Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30006Y=T5000?oc`00`00occo?00Noc`000?o?003003o
??ll00;o?003003o??ll00oo?0<001ko?003000Kg00000L000076m`00000000Kg0006m`00`000Xfn
00<00:CjY?X00jCj00<00:CIY=T00`0000>Tf@00Y=T01:CI00<00:CIY=T01:CI00<00:CIY=T00jCI
0`001:CI00<00:CIY=T01:CI00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CI
Y=T01:CI00<00:CIY=T00jCI0`001JCI00<00:CIY=T01JCI00<00:CIY=T00jCI00<00:CIY=T00`00
00BTf@00Y=T000FTf@03003o??ll017o?003003o??ll01ko?0000oll00<00?lloc`00_ll0P003Oll
0`008_ll00@001_L6m`Kg0L000036m`000000080008Kg0D000>TnP@000FTf@03002TfJCI00>Tf@03
002TfJCI00>Tf@03002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI00>Tf@03002TfJCI00>Tf@<0
00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI
00FTf@03002TfJCI00>Tf@<000FTf@8000FTf@03003o??ll017o?003003o??ll01ko?0001@000oll
00<00?lloc`02_ll0P009_ll0`0000<Kg0006m`00P0000<Kg00000000P0000HKg000000001_L0002
6m`40002WOd00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@03
Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03
Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@05Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00
Y=T00004Y=T00`00occo?00Aoc`00`00occo?00Noc`00004003o??ll0003oc`20009oc`3000Yoc`0
0`006m`0000300001A_L000000006m`00`0000<Kg00000000P000a_L00<009gmWOd00Ygm00<00:CI
Y=T01:CI00<00:CIY=T00jCI00<00:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CI
Y=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>Tf@00Y=T01JCI
00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI00<00:CIY=T01:CI00<00:CI00001:CI00<00?ll
oc`04?ll00<00?lloc`07_ll00001?ll003o?0000oll00<00?lloc`01Oll0`00;Oll0P000Q_L1`00
00<Kg00000000P0000HKg000000001_L0004WOd00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T0
0`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VTf@020002Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04
Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000300000jCI
002Tf@05Y=T00`00Y=VTf@04Y=T01000Y=VTf@000ZCI0P004_ll00<00?lloc`07_ll0002oc`20003
oc`20003oc`3000boc`200000a_L000Kg00700001A_L000000006m`0100019gm00<00:CIY=T01:CI
00@00:CI000000:Tf@03002TfJCI00>Tf@03002TfJCI00BTf@03002TfJCI00>Tf@<000BTf@03002T
fJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00:CI00FTf@03002TfJCI00BTf@03002T
fJCI00>Tf@<000JTf@03002TfJCI00BTf@03002TfJCI00BTf@03002Tf@0000800003Y=T00?ll017o
?003003o??ll01ko?0000oll00H00?llocco?000oc`3000foc`500000a_L0000000500000a_L0000
000200000a_L0000000200000igm002Tf@02Y=T50004Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T0
0`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@03Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VT
f@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@06Y=T00`00Y=VTf@04Y=T00`00Y=VT
f@03Y=T300000jCI002Tf@02Y=T00`00occo?00?oc`00`00occo?00Noc`000Oo?08003[o?003000K
g1_L00@000046m`000006m`400001a_L000000006m`002`m00D000>Ug003002TfJCI00BTf@03002T
fJCI00>Tf@04002TfJCIY=T50005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=T000020000
0jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@05Y=T00`00Y=VT
f@04Y=T00`00Y=T0000200000jCI002Tf@02Y=T01000Y=VTf@004_ll00<00?lloc`07Oll0008oc`0
0`00occo?00ioc`200000a_L000Kg00300001A_L000000006m`00`0000<Kg00000000P000b`m00<0
0:GLYM`00jGL00<00:CIY=T01:CI00<00:CIY=T00ZCI10000jCI00<00:CIY=T01:CI00<00:CIY=T0
1:CI00<00:CIY=T00ZCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>T
f@00Y=T01JCI00<00:CIY=T01JCI00<00:CIY=T00jCI0`001JCI00D00:CIY=VTf@0000:Tf@03003o
??ll00oo?003003o??ll01go?0002Oll0P00>_ll1@0000<Kg00000001@0000<Kg00000000P0000@K
g0000000008/?@03002Ug:GL00:Ug003002TfJCI00BTf@03002TfJCI00800003Y=T00:CI00FTf@03
002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI00800003Y=T00:CI00FTf@03002TfJCI00BTf@03
002TfJCI00>Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00FTf@03002Tf@0000800003Y=T00:CI
00FTf@05002TfJCIY=T00002Y=T00`00occo?00?oc`00`00occo?00Moc`000_o?003003o??ll03Wo
?0H000036m`0000000D000056m`00000000Kg0050004YM`00`00Y=VTf@03Y=T30004Y=T00`00Y=VT
f@03Y=T00`00Y=VTf@04Y=T01000Y=VTfJCI1@001:CI00<00:CIY=T01:CI00<00:CIY=T01:CI00<0
0:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T01:CI0`001JCI00<00:CIY=T0
1:CI00D00:CIY=VTf@0000:Tf@03003o??ll00ko?003003o??ll01go?0003?ll00<00?lloc`0>Oll
1`0000<Kg00000001@0000<Kg00000000P000Q_L100000BUg000Y=VTf@<00003YG/00:CI00BTf@03
002TfJCI00BTf@03002TfJCI00>Tf@@000>Tf@03002TfJCI00>Tf@03002TfJCI00BTf@04002TfJCI
Y=T50005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000300000jCI002Tf@05Y=T00`00
Y=VTf@04Y=T00`00Y=VTf@02Y=T3000@oc`00`00occo?00Moc`000go?003003o??ll03Wo?005000K
g000000Kg00400000a_L00000005000011_L000000000Q_L00<005Cn00000`001JEk00<00:CIY=T0
0jCI00<00:CIY=T00jCI00<00:CIY=T00`0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T0
0jCI10000jCI00<00:CIY=T01:CI00<00:CIY=T01:CI00@00:CIY=VTf@D000JTf@03002TfJCI00BT
f@03002TfJCI00BTf@03002Tf@0000800003YCX00?ll00oo?003003o??ll01go?0003_ll00<00?ll
oc`0>Oll0P0000DKg000000001_L00<000036m`0000000D000036m`0000000<000=DoP03002UNjEk
00>UN`03002TfJCI00>Tf@03002TfJCI00>Tf@<000FTf@03002TfJCI00>Tf@03002TfJCI00>Tf@03
002TfJCI00<00003Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@@000>Tf@03002TfJCI
00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000>U>P03002U>P0000oo?003003o??ll01go?000
3oll0P00>_ll1`0000<Kg00000000P0000<Kg00000001P0000HKg000000005Cn0006YG/00`00Y=VT
f@03Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@02Y=T30005Y=T0
0`00Y=VTf@03Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@04Y=T0
0`00Y=VTf@05Y=T00`00Y=T000020002YCX00`00YCZU>P02YCX2000?oc`00`00occo?00Moc`0017o
?003003o??ll03So?005000Kg000000Kg00400001A_L000000006m`0100000DKg000000001_L00@0
00FUN`03002TfJCI00:Tf@<000FTf@03002TfJCI00BTf@03002TfJCI00>Tf@03002TfJCI00800003
Y=T00:CI00FTf@03002TfJCI00BTf@03002TfJCI00>Tf@<000FTf@03002TfJCI00>Tf@03002TfJCI
00FTf@04002TfJCIY=T50005YCX00`00YCZU>P03YCX2000?oc`00`00occo?00Loc`001;o?003003o
??ll03So?08000056m`00000000Kg00300000a_L0000000200001A_L000000006m`0100000<Kg000
00000P000jEk00H00:CI00000:Dj0006Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30004Y=T00`00
Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VTf@0300000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00
Y=VTf@03Y=T50003YCX00`00YCZU>P05YCX00`00YCZU>P02YCX2000?oc`00`00occo?00Loc`001?o
?003003o??ll03So?0L000036m`00000008000056m`00000000Kg00400000a_L000000026m`00`00
MGh000040004YCX00`00Y=VTf@04Y=T00`00Y=VTf@04Y=T00`00Y=T0000200000jCI002Tf@04Y=T0
0`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T00`00Y=VT
f@0300000jDj002U>P06YCX00`00YCZU>P04YCX01000YCZU>ZDj10003_ll00<00?lloc`07?ll000D
oc`2000ioc`01@006m`000006m`0100000DKg000000001_L00@000036m`00000008Kg0<000EeOP03
002U>ZDj00:U>P03002TfJCI00BTf@04002TfJCIY=T50005Y=T00`00Y=VTf@03Y=T00`00Y=VTf@04
Y=T00`00Y=T0000200000jCI002Tf@05Y=T00`00Y=VTf@04Y=T00`00Y=VTf@03Y=T30005YCX00`00
YCZU>P04YCX00`00YCZU>P04YCX40003YQd2000=oc`00`00occo?00Loc`001Ko?003003o??ll03Oo
?08000056m`00000000Kg00300000a_L0000000200001A_L000000006m`00`0000<Kg000000017En
00<00:DjYCX00jDj00<00:CIY=T00jCI10000jCI00<00:CIY=T01:CI00<00:CIY=T00jCI00<00:CI
Y=T00jCI0`001JCI00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CI00000P0000>U>P00YCX01JDj
00<00:DjYCX01JDj00<00:Dj00000`0000>V7@00YQd01JHM00<00?lloc`02oll00<00?lloc`07?ll
000Goc`00`00occo?00goc`700000a_L0000000200001A_L000000006m`01P000Q_L0P000gEn00<0
0:DjYCX00ZDj00<00:CIY=T00`0000>Tn@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI00<0
0:CI00000P0000>Tf@00Y=T01JCI00<00:CIY=T01:CI00<00:CIY=T00jCI0`001JDj00<00:DjYCX0
1:Dj00<00:DjYCX00jDj0`001ZHM00<00:HMYQd00jHM0P003?ll00<00?lloc`07?ll000Hoc`00`00
occo?00goc`01@006m`000006m`0100000DKg000000001_L00@000046m`000006m`200000a_L0000
00030003YCX40005Y?T00`00Y=VTf@03Y=T00`00Y=VTf@04Y=T01000Y=VTfJCI10001JCI00<00:CI
Y=T01:CI00<00:CIY=T01:CI00<00:CI00000P000ZDj00<00:DjYCX00jDj00<00:DjYCX01:Dj00<0
0:DjYCX00`000ZHM00<00:HMYQd01:HM00<00:HMYQd00`0000>V7@0000002oll00<00?lloc`07?ll
000Ioc`2000hoc`200001A_L000000006m`00`0000<Kg00000000P0000DKg000000001_L00H0008K
g0@000:=gP03002TnJCi00BTn@03002TfJCI00BTf@03002TfJCI00>Tf@@000:Tf@03002TfJCI00BT
f@03002TfJCI00BTf@04002TfJCIY=T50005YCX00`00YCZU>P04YCX00`00YCZU>P03YCX30006YQd0
1000YQfV7JHM1@001JHM0P002_ll00<00?lloc`07?ll000Koc`00`00occo?00foc`700000a_L0000
000200001A_L000000006m`01P0000@Kg0000000008Kg003002=gXgN00:=gP03002TnJCi00BTn@03
002TfJCI00>Tf@03002TfJCI00<00003Y=T00:CI00BTf@03002TfJCI00BTf@03002TfJCI00>Tf@@0
00BU>P03002U>ZDj00BU>P03002U>ZDj00>U>P03002U>ZDj00<000:V7@03002V7JHM00BV7@@000BV
7@03002V7JHM00>V7@<000[o?003003o??ll01_o?0007?ll00<00?lloc`0=oll00<001_L00001@00
00DKg000000001_L00@000046m`000006m`200000a_L000000030003SMh00`00Y?VTn@04Y?T00`00
Y=VTf@03Y=T30005Y=T00`00Y=VTf@02Y=T00`00Y=VTf@04Y=T00`00Y=VTf@0300000jDj002U>P05
YCX00`00YCZU>P04YCX01000YCZU>ZDj1@001ZHM00<00:HMYQd00`0000>V7@00YQd01ZHM00<00:HM
YQd0100000>V7@00oc`02?ll00<00?lloc`06oll000Moc`00`00occo?00goc`300000a_L00000003
00000a_L0000000200001A_L000000006m`01P000Q_L0`000XgN00<00:CiY?T01:Ci00<00:CI0000
0P0000>Tf@00Y=T01JCI00<00:CIY=T00jCI00<00:CIY=T00jCI0`001JDj00<00:DjYCX01:Dj00<0
0:DjYCX00jDj10001:HM00<00:HMYQd01:HM0`001JHM00<00:HMYQd01:HM0`001:HM0P002Oll00<0
0?lloc`06oll000Noc`00`00occo?00goc`400000a_L0000000400001A_L000000006m`01P0000@K
g0000000008Kg0@000>Tn@D000FTf@03002TfJCI00BTf@03002TfJCI00:Tf@03002TfJCI00<00003
YCX00:Dj00FU>P03002U>ZDj00BU>P03002U>ZDj00<000:V7@03002V7JHM00BV7@03002V7JHM00<0
00:V7@03002V7JHM00>V7@03002V7JHM00@000:V7@03002V7JHM00>V7@8000So?003003o??ll01_o
?0007oll0P00>?ll00<001_L00000`0000<Kg00000000`0000<Kg00000000P0000<Kg00000000`00
00<Kg00000000`0000<Kg00000000P000jHM00<00:CIY=T01:CI00<00:CIY=T01:CI00<00:CIY=T0
0ZCI0`001JDj00<00:DjYCX01:Dj00<00:DjYCX00jDj0`001JHM00<00:HMYQd01:HM0`001JHM00@0
0:HMYQfV7@D000JV7@03002V7JHM00@00003YQd00?ll00Ko?003003o??ll01_o?0008Oll00<00?ll
oc`0=_ll0`0000DKg000000001_L00H000056m`00000000Kg00600026m`300000a_L002V7@04YQd0
0`00Y=VTf@04Y=T00`00Y=VTf@04Y=T01000Y=T000000ZDj00<00:DjYCX00jDj00<00:DjYCX01:Dj
00<00:DjYCX00`000ZHM00<00:HMYQd01:HM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM10001:HM
00<00:HMYQd01:HM0`001:HM0P001oll00<00?lloc`06oll000Roc`00`00occo?00foc`400000a_L
0000000200000a_L0000000300000a_L0000000200000a_L0000000300026m`40004YQd00`00Y=VT
f@04Y=T01000Y=VTfJCI1@001:Dj00<00:DjYCX01:Dj00<00:DjYCX00jDj0`001ZHM00@00:HMYQfV
7@D000FV7@03002V7JHM00<000:V7@03002V7JHM00BV7@03002V7JHM00<000:V7@03002V7JHM00>V
7@8000Ko?003003o??ll01_o?0008oll00<00?lloc`0=_ll1P0000<Kg00000000Q_L00<001_L0000
0`0000DKg000000001_L00L000046m`000000003YQd00`00Y=VTf@03Y=T40004YCX00`00YCZU>P03
YCX00`00YCZU>P03YCX00`00YCZU>P030002YQd00`00YQfV7@04YQd40004YQd00`00YQfV7@03YQd3
0006YQd01000YQfV7JHM1@001JHM00<00:HMYQd00`0000>V7@0000001Oll00<00?lloc`06oll000T
oc`2000goc`00`006m`0000300026m`500026m`300000a_L0000000400026m`300000a_L00000003
0002Y=T30002YM`00`00YCZU>P03YCX00`00YCZU>P03YCX01000YCZU>ZDj1@001ZHM00<00:HMYQd0
0`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`000ZHM00<00:HMYQd01:HM10001:HM00<00:HMYQd0
0jHM0`001:HM0P001_ll00<00?lloc`06_ll000Voc`00`00occo?00eoc`200000a_L000000030000
0a_L0000000300026m`4000011_L000001_L0P000Q_L10000SAm0`001JGL00<00:DjYCX01:Dj00<0
0:DjYCX00ZDj10001:HM00<00:HMYQd01:HM0`001JHM00@00:HMYQfV7@D000JV7@03002V7JHM00<0
00:V7@03002V7JHM00>V7@03002V7JHM00<000:V7@03002V7JHM00>V7@8000Go?003003o??ll01[o
?0009oll00<00?lloc`0=?ll00<00?ll00000P0000<Kg00000000P0000<Kg000000010000Q_L0`00
00<Kg00000001@0000<Kg00000000cAm00<00:GLYM`01:GL00<00:DjYCX00jDj00<00:DjYCX00P00
0ZHM00<00:HMYQd01:HM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM10001:HM00<00:HMYQd01:HM
0`001JHM00@00:HMYQfV7@D000JV7@04002V7JHMYQd40004oc`00`00occo?00Joc`002So?003003o
??ll03?o?004003o??lloc`200026m`500000a_L0000000300026m`600026m`300001A_L000003Am
00001ZGL00@00:DjYCZU>PD000FV7@04002V7JHMYQd50005YQd00`00YQfV7@030002YQd00`00YQfV
7@04YQd00`00YQfV7@030002YQd00`00YQfV7@03YQd40004YQd00`00YQfV7@04YQd40002YQd00`00
YQd00003oc`00`00occo?00Joc`002Wo?08003?o?003003o??ll00?o?0<000036m`0000000<00003
6m`0000000D000036m`0000000<0008Kg0L000>Ug0H000BV7@03002V7JHM00>V7@@000BV7@03002V
7JHM00>V7@<000JV7@04002V7JHMYQd50005YQd00`00YQfV7@030002YQd00`00YQfV7@04YQd00`00
YQfV7@030002YQd00`00YQfV7@02YQd20003oc`00`00occo?00Joc`002_o?003003o??ll033o?003
003o??ll00Go?0<000036m`0000000@000046m`000006m`300000a_L00000005000011_L000001_L
100017fN00<00:HMYQd00jHM00<00:HMYQd00`000ZHM00<00:HMYQd01:HM00<00:HMYQd00P000ZHM
00<00:HMYQd01:HM10001:HM00<00:HMYQd00jHM0`001ZHM00@00:HMYQfV7@D000FV7@04002V7JHM
YQd40002oc`00`00occo?00Joc`002co?003003o??ll02oo?003003o??ll00So?0<000036m`00000
00<000046m`000006m`4000011_L000001_L0`0000DKg000000Kg00000ImWP04002V7JHMYQd40006
YQd01000YQfV7JHM1@001JHM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`000ZHM
00<00:HMYQd01:HM10001:HM00<00:HMYQd00jHM10000jHM0P0000?o?000oc`06oll000]oc`00`00
occo?00^oc`00`00occo?00:oc`300000a_L0000000600026m`3000011_L000001_L1`000gfN1P00
0jHM00<00:HMYQd01:HM10001:HM00<00:HMYQd00jHM0`001JHM00@00:HMYQfV7@D000JV7@03002V
7JHM00<000:V7@03002V7JHM00>V7@03002V7JHM00<000:V7@03002V7JHM00:V7@800003oc`00?ll
01_o?000;_ll00<00?lloc`0;Oll00<00?lloc`03Oll1@0000<Kg00000000`000Q_L1`0000<Kg000
00001@0017fN00<00:HMYQd00jHM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`00
0ZHM00<00:HMYQd00jHM10001:HM00<00:HMYQd01:HM0`001JHM00@00:HMYQfV7@D000FV7@04002V
7JHMYQd400000oll003o?00Joc`002oo?08002go?003003o??ll00oo?0D000036m`0000000@0008K
g0H000036m`0000000<000AmWP04002V7JHMYQd50006YQd01000YQfV7JHM10001ZHM00<00:HMYQd0
0P000ZHM00<00:HMYQd01:HM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM10001:HM00<00:HMYQd0
0jHM10000jHM0`006oll000aoc`00`00occo?00Zoc`00`00occo?00Boc`500000a_L000000030002
6m`700026m`90004YQd00`00YQfV7@04YQd40003YQd20003YQd50005YQd01000YQfV7JHM1@001JHM
00<00:HMYQd00`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM0P006oll
000boc`00`00occo?00Yoc`00`00occo?00Doc`500000a_L00000005000011_L000001_L0`000Q_L
00<007fNOIh00WfN00<00:HMYQd01:HM00<00:HMYQd00`000ZHM00<00:HMYQd00jHM10001:HM00<0
0:HMYQd00jHM10001:HM00<00:HMYQd00jHM0`001JHM00@00:HMYQfV7@D000FV7@04002V7JHMYQd4
000Koc`003?o?003003o??ll02So?003003o??ll01Ko?0H000046m`000006m`3000011_L000001_L
1@0017fN00@00:HMYQfV7@D000FV7@03002V7JHM00<000:V7@03002V7JHM00>V7@03002V7JHM00<0
00:V7@03002V7JHM00>V7@03002V7JHM00<000:V7@03002V7JHM00>V7@@000BV7@03002V7JHM00>V
7@@000;o?08001_o?000=?ll0P00:?ll00<00?lloc`06?ll1P0000@Kg000000Kg0L0008Kg0T000BV
7@03002V7JHM00>V7@<000FV7@04002V7JHMYQd50005YQd01000YQfV7JHM1@001JHM00<00:HMYQd0
0`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`000_ll10007Oll000foc`00`00occo?00Uoc`00`00
occo?00Koc`800026m`2000011_L000000000Q_L00<007fNOIh00WfN00<00:HMYQd01:HM00<00:HM
YQd00P000ZHM00<00:HMYQd00jHM10001:HM00<00:HMYQd00jHM10001:HM0P000jHM10001JHM00@0
0:HMYQfV7@D00003oc`000000080027o?000=oll00<00?lloc`09?ll00<00?lloc`07Oll0P0000<K
g00000000`000Q_L0P0000<Kg00000000P001GfN00@00:HMYQfV7@D000FV7@03002V7JHM008000:V
7@03002V7JHM00BV7@03002V7JHM008000:V7@03002V7JHM00BV7@@000>V7@03002V7JHM00>V7@@0
00;o?0@002Go?000>?ll00<00?lloc`08oll00<00?lloc`07oll0P0000<Kg0000000200000<Kg000
000020001:HM00@00:HMYQfV7@D000FV7@04002V7JHMYQd50005YQd00`00YQfV7@030002YQd00`00
YQfV7@03YQd00`00YQfV7@020002oc`4000Yoc`003Wo?003003o??ll02;o?003003o??ll027o?0<0
00046m`000006m`600000a_L001mWP04OIh00`00YQfV7@03YQd40004YQd00`00YQfV7@03YQd40004
YQd01000YQfV7JHM1@001JHM00@00:HMYQfV7@D00004oc`00000000]oc`003[o?08002;o?003003o
??ll02?o?0<000046m`000006m`70005OIh00`00YQfV7@020002YQd00`00YQfV7@03YQd00`00YQfV
7@030002YQd00`00YQfV7@03YQd40004YQd00`00YQfV7@03YQd40002oc`4000`oc`003co?003003o
??ll01oo?003003o??ll02Ko?0D0008Kg08000036m`0000000L000FV7@04002V7JHMYQd40005YQd0
0`00YQfV7@030002YQd00`00YQfV7@03YQd00`00YQfV7@030002oc`4000doc`003go?003003o??ll
01ko?003003o??ll02So?0D0008Kg08000036m`007fN00AmWP03002V7JHM00>V7@@000>V7@8000>V
7@@000JV7@04002V7JHMYQd400000oll00000002000hoc`003ko?003003o??ll01go?003003o??ll
02_o?0T000AmWP03002V7JHM00<000:V7@03002V7JHM00>V7@@000>V7@03002V7JHM00BV7@@00003
oc`00000008003co?000?oll0P007Oll00<00?lloc`0;Oll0P0000<Kg00000002@001JHM00<00:HM
YQd00`000ZHM00<00:HMYQd00jHM00<00:HMYQd00`000_ll0`00@?ll0011oc`00`00occo?00Joc`0
0`00occo?00_oc`200000a_L000000020004OIh20003YQd40005YQd01000YQfV7JHM1@0000?o?000
00000P00@oll0012oc`00`00occo?00Hoc`00`00occo?00boc`200026m`:0003YQd00`00YQfV7@03
YQd40002oc`40017oc`004?o?003003o??ll01Oo?003003o??ll03Co?080008Kg003001mWWfN00=m
WP03002V7JHM00>V7@03002V7JHM008000;o?0@004_o?000A?ll0P005oll00<00?lloc`0=_ll1000
17fN00@00:HMYQfV7@T004oo?000A_ll00<00?lloc`05?ll00<00?lloc`0>Oll2@000_ll0`00Doll
0017oc`00`00occo?00Coc`00`00occo?010oc`4001Foc`004So?003003o??ll01;o?003003o??ll
03co?0@005[o?000BOll00<00?lloc`04Oll00<00?lloc`0>?ll1000G_ll001:oc`2000Aoc`00`00
occo?00eoc`3001Roc`004co?003003o??ll00ko?003003o??ll037o?0@006Go?000COll00<00?ll
oc`03Oll00<00?lloc`0;Oll1000JOll001>oc`00`00occo?00<oc`00`00occo?00Yoc`4001]oc`0
04oo?08000co?003003o??ll02Go?0@0077o?000DOll00<00?lloc`02Oll00<00?lloc`08_ll0`00
MOll001Boc`00`00occo?008oc`00`00occo?00Noc`4001hoc`005?o?003003o??ll00Oo?003003o
??ll01[o?0@007co?000E?ll0P001oll00<00?lloc`05_ll1000P?ll001Foc`00`00occo?004oc`0
0`00occo?00Boc`40024oc`005Oo?003003o??ll00?o?003003o??ll00oo?0<008So?000F?ll00<0
0?lloc`00_ll00<00?lloc`02oll1000Roll001Ioc`01@00occo??ll00002Oll1000Soll001Joc`2
00000oll003o?004oc`4002Coc`005co?0800003oc`00000008009Oo?000GOll0P00Voll003joc`0
0?[o?000n_ll003joc`00?[o?000n_ll003joc`00001\
\>"],
  ImageRangeCache->{{{0, 249}, {201.75, 0}} -> {-0.0322786, -0.0197454, \
0.00441845, 0.00441845}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{683, 700},
WindowMargins->{{37, Automatic}, {Automatic, 66}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 235, 8, 65, "Title"],

Cell[CellGroupData[{
Cell[2014, 63, 67, 1, 31, "Input"],
Cell[2084, 66, 89, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2210, 72, 296, 10, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2531, 86, 108, 2, 47, "Input"],
Cell[2642, 90, 147, 2, 94, "Output"]
}, Open  ]],
Cell[2804, 95, 954, 16, 180, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3795, 116, 281, 10, 43, "Subsubsection",
  Evaluatable->False],
Cell[4079, 128, 69, 1, 31, "Input"],
Cell[4151, 131, 213, 8, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4389, 143, 302, 5, 96, "Input"],
Cell[4694, 150, 460, 12, 82, "Output"]
}, Open  ]],
Cell[5169, 165, 1061, 28, 117, "Text",
  Evaluatable->False],
Cell[6233, 195, 718, 23, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6976, 222, 160, 4, 48, "Input"],
Cell[7139, 228, 45, 1, 62, "Output"]
}, Open  ]],
Cell[7199, 232, 1524, 53, 85, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8748, 289, 37, 1, 31, "Input"],
Cell[8788, 292, 15426, 323, 2299, "Output"]
}, Open  ]],
Cell[24229, 618, 180, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24434, 627, 126, 3, 47, "Input"],
Cell[24563, 632, 45, 1, 62, "Output"]
}, Open  ]],
Cell[24623, 636, 209, 8, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24857, 648, 131, 3, 47, "Input"],
Cell[24991, 653, 43, 1, 62, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25083, 660, 733, 27, 100, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[25841, 691, 49, 1, 31, "Input"],
Cell[25893, 694, 114, 2, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26044, 701, 595, 21, 66, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[26664, 726, 92, 1, 31, "Input"],
Cell[26759, 729, 369, 6, 39, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27165, 740, 161, 4, 48, "Input"],
Cell[27329, 746, 52, 1, 46, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27430, 753, 1321, 43, 112, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28776, 800, 105, 2, 31, "Input"],
Cell[28884, 804, 372, 5, 55, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29293, 814, 161, 4, 48, "Input"],
Cell[29457, 820, 45, 1, 62, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29551, 827, 799, 21, 112, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[30375, 852, 711, 13, 181, "Input"],
Cell[31089, 867, 821, 20, 99, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31947, 892, 205, 4, 48, "Input"],
Cell[32155, 898, 100400, 2212, 219, 52645, 1618, "GraphicsData", \
"PostScript", "Graphics"],
Cell[132558, 3112, 137, 3, 46, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

