(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     55096,       1130]*)
(*NotebookOutlinePosition[     55726,       1152]*)
(*  CellTagsIndexPosition[     55682,       1148]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(rgcd[a_, b_]\  = \ 
        Max[2\^\(-5\), Abs[a]];\)\), "\[IndentingNewLine]", 
    \(rgcd[a_Integer, b_Integer]\  = \ Abs[GCD[a, b]]; 
    rgcd[a_Rational, b_Rational]\  = \ Abs[GCD[a, b]];\)}], "Input"],

Cell[BoxData[{
    \(\(eltswith[rlist_, met_]\  := \ 
        Cases[rlist, \ 
          x_ /; \ \(({}\  \[NotEqual] \ 
                Cases[x, met, \[Infinity]])\)];\)\), "\[IndentingNewLine]", 
    \(\(eltswith[rr_, set_List]\  := \ Fold[eltswith, rr, set];\)\)}], "Input"],

Cell[BoxData[
    \(\(droprc[rr_, mt_]\  := \ 
        Module[\ {li}, \[IndentingNewLine]li\  = 
            Position[rr[\([1]\)], 
              x_ /; \ \(({}\  \[NotEqual] \ 
                    Cases[x, xt[mt], {\(-2\)}])\), {1}, 
              Heads \[Rule] False]; \[IndentingNewLine]{Delete[rr[\([1]\)], 
              li], Delete[rr[\([2]\)], li]}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(reac2stoich[rrs_]\  := \ 
        Block[\ {cyl, mil, xtl, rrl, intsl, ints, revs, nrev, enzs, d1, d2, 
            rr, loc, locxt}, \[IndentingNewLine]rr\  = \ 
            rrs[\([1]\)]; \[IndentingNewLine]nrev\  = \(({0} \[Union] 
                  Position[rr, x_\ \[DoubleLongLeftRightArrow]\ y_])\) // 
              Max; \[IndentingNewLine]enzs\  = \ \(\(rr\  /. \ \((x_\ \
\[DoubleLongLeftRightArrow]\ 
                        y_\ )\) :> \ \((x + d1 + 
                          d2)\)\  \[Intersection] \ \((y + d1 + 
                          d2)\)\)\  /. \ \ \((x_\ \[DoubleLongRightArrow]\ 
                      y_\ )\) :> \ \ \((x + d1 + 
                        d2)\)\  \[Intersection] \ \((y + d1 + d2)\)\) /. \ 
              d1 + d2\  \[Rule] 0\ ; \[IndentingNewLine]intsl = 
            Union[Cases[rr, 
                a_[x_], {1, \[Infinity]}]]; \[IndentingNewLine]rrl\  = \ \(rr \
/. \ \ \((x_\ \[DoubleLongLeftRightArrow]\ y_\ )\) \[Rule] \ \ y - x\  + \ 
                    locxt\ intsl[\([1]\)]\)\  /. \ \((x_\ \
\[DoubleLongRightArrow]\ y_\ )\) \[Rule] \ \ y - x\  + 
                  locxt\ intsl[\([1]\)]\ ; \[IndentingNewLine]rrl\  = \ 
            Replace[rrl\ , \ 
              a_[b_]\  \[Rule] \ 
                loc[a[b]], {\(-2\)}]; \[IndentingNewLine]Evaluate[
              Map[loc, intsl]\ ] = \ 
            IdentityMatrix[Length[intsl]]; \[IndentingNewLine]rrl\  = \ 
            rrl\  /. locxt\ \  \[Rule] \ \ 0; \[IndentingNewLine]{Transpose[
              rrl], intsl\ , enzs, \ nrev}\ ];\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(ints\\)\\\" is similar to existing symbol \\\
\"\\!\\(intsl\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[
    \(\(\(stoich2reac[mm_, ints_, enzs_, \ nr_]\  := \ 
        Module[\ {rr, arr, 
            arrsimp}, \[IndentingNewLine]arrsimp[\ arr[a_, b_]]\  := \ 
            Module[\ {ins}, \[IndentingNewLine]ins\  = 
                Plus @@ Cases[b, \ 
                    x_\ \ y_ /; \ x < \ 0, {\(-3\)}]; \[IndentingNewLine]arr[
                a - ins, 
                Chop[b - 
                    ins]]\[IndentingNewLine]]; \[IndentingNewLine]rr\  = \ 
            Transpose[mm] . ints; \[IndentingNewLine]rr\  = \ 
            MapThread[\ 
              arr[#2, #1 + #2] &, {rr, enzs}]; \[IndentingNewLine]rr\  = \ 
            Map[arrsimp, rr]\ ; \[IndentingNewLine]rr = 
            rr\ \  /. \ arr[x_, 
                  y_]\  \[Rule] \ \((x\ \[DoubleLongRightArrow]\ 
                    y)\); \[IndentingNewLine]MapIndexed[\ 
            If[#2[\([1]\)]\  > \ 
                  nr, #1, \ #1\  /. \ \((x_\ \[DoubleLongRightArrow]\ 
                        y_)\)\  \[Rule] \ \((x\ \[DoubleLongLeftRightArrow]\ 
                        y)\)] &, 
            rr]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[{
    \(\(Group[l_]\  := \ 
        Module[\ {ord, eqs}, \[IndentingNewLine]ord\  = \ 
            Ordering[l]; \[IndentingNewLine]Split[
            ord, \((l[\([#1]\)]\  \[Equal] 
                  l[\([#2]\)]\ )\) &]];\)\), "\[IndentingNewLine]", 
    \(\(Trp[a_]\  := \ Transpose[a];\)\), "\[IndentingNewLine]", 
    \(\(Trp[{}]\  := \ {};\)\), "\[IndentingNewLine]", 
    \(simp0[rr_]\  := \ 
      Module[\ {rrl, gr, duds, duds1, dudreacs, mr, mrt, posm, negm\ , pmm, 
          nrev}, \[IndentingNewLine]\ 
        gr\  = \ Group[rr[\([1]\)]]; \[IndentingNewLine]\ 
        rrl\  = {Map[rr[\([1, #[\([1]\)]]\)] &, gr], 
            Map[rr[\([2, #]\)] &, gr]}; \[IndentingNewLine]rrl[\([2]\)]\  = \ 
          Replace[rrl[\([2]\)]\ , \ {\ {a_}\  \[Rule] \ 
                a\ , \ {a__}\  \[Rule] \ 
                ALT[a]}, {1}]; \[IndentingNewLine]{mr, 
            nrev}\  = \ \(reac2stoich[rrl]\)[\([{1, 4}]\)]; \ 
        Print[{"\<Simp0 mrdim\>", Dimensions[mr]}]; \[IndentingNewLine]Print[
          nrev]; \[IndentingNewLine]duds\  = \ 
          Position[\ 
              Map[\((Plus @@ #)\) &, Abs[Sign[mr]]], \ \ y_ /; \ 
                y\  \[Equal] 1] // Flatten; \ \ \[IndentingNewLine]mrt\  = \ 
          Transpose[mr]; \[IndentingNewLine]posm\  = \ 
          Position[
              Map[\((Or @@ #)\) &, 
                Map[\((# > 0)\) &, Trp[Drop[mrt, nrev]], {2}]], True] // 
            Flatten; \[IndentingNewLine]negm\  = \ 
          Position[
              Map[\((Or @@ #)\) &, 
                Map[\((# < 0)\) &, Trp[Drop[mrt, nrev]], {2}]], True] // 
            Flatten; \[IndentingNewLine]pmm\ \ \  = \ \ Position[
              Map[\((Or @@ #)\) &, 
                Map[\((# \[NotEqual] 0)\) &, Trp[Take[mrt, nrev]], {2}]], 
              True] // Flatten; \[IndentingNewLine]pmm\  = \ 
          pmm \[Union] \((posm\  \[Intersection] 
                negm\ )\); \[IndentingNewLine]duds1\  = \ 
          Complement[posm \[Union] negm, pmm]; \[IndentingNewLine]duds\  = \ 
          duds \[Union] duds1; \[IndentingNewLine]dudreacs\  = \ 
          Map[\(Position[\ mr[\([#]\)], \ 
                  y_ /; \ y\  \[NotEqual] \ 0]\)[\([1]\)] &, 
            duds]; \[IndentingNewLine]dudreacs1\  = \ 
          Position[\ 
            Map[\((Plus @@ #)\) &, Abs[Sign[Transpose[mr]]]], \ \ y_ /; \ 
              y\  \[Equal] \ 0]; \[IndentingNewLine]dudreacs\  = \ 
          dudreacs \[Union] dudreacs1; \[IndentingNewLine]\ 
        Print[dudreacs]; \[IndentingNewLine]Map[Delete[#, dudreacs] &, 
          rrl]]\), "\[IndentingNewLine]", 
    \( (*\(\(\(\(Transpose[
                rrl]\)[\([Complement[Range[Length[rr[\([1]\)]]], 
                  Flatten[dudreacs]]]\)]\)\(]\)\) // 
          Transpose;\)*) \)}], "Input"],

Cell[BoxData[{
    \(\(simp[rr_, allrev_]\  := \ 
        Module[\ {m, ints, enzs, nrev, rrnew, i, 
            combs}, \[IndentingNewLine]{m, ints, enzs, nrev}\  = \ 
            reac2stoich[rr]; \ \[IndentingNewLine]Print[{"\<simp a\>", 
              Dimensions[m], 
              Dimensions[rr[\([2]\)]]}]; \[IndentingNewLine]m\  = \ 
            Join[m, {rr[\([2]\)]}]; 
          Print[{"\<simp b\>", 
              Dimensions[
                m]}]; \[IndentingNewLine]If[\ \[Not] allrev, \
\[IndentingNewLine]\ 
            For[i\  = 1, 
              i\  \[LessEqual] \ \(Dimensions[m]\)[\([1]\)] - 
                  1, \(i++\), \(m\  = \ simp[m, i, nrev];\)], 
            m = \ revsimp[m, nrev]]; \[IndentingNewLine]rrnew\  = \ 
            stoich2reac[Drop[m, \(-1\)], ints, enzs, 
              nrev]; \ \[IndentingNewLine]combs\  = \ 
            Expand[Last[m]]\ ; \[IndentingNewLine]FixedPoint[
            simp0, {rrnew, 
              combs}]\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(\(simp[m_, i_, nrev_]\  := \ 
        Module[\ {nz1, nz2, j, vl, vk, l, k, mmT, vli, 
            vki}, \[IndentingNewLine]nzr\  = \ 
            Position[Take[m[\([i]\)], nrev], \ x_ /; \ x\  \[NotEqual] 0] // 
              Flatten; \[IndentingNewLine]If[Length[nzr]\  > \ 1, \ 
            Return[m], \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  (*\ \(! \(! \(! \
\(! \(! \ \(\(\(1\ !!\)!!\)!\)\)\)\)\)\)\ *) \[IndentingNewLine]nz1\  = \ 
              nrev + Position[Drop[m[\([i]\)], nrev], \ x_ /; \ x\  > 0] // 
                Flatten; \[IndentingNewLine]nz2\  = \ 
              nrev + Position[Drop[m[\([i]\)], nrev], \ x_ /; \ x\  < 0] // 
                Flatten; \[IndentingNewLine]If[
              Length[nzr]\  \[Equal] 
                2\ , \[IndentingNewLine]\ \ If[\((Length[nz1]\  + 
                      Length[nz2])\)\  > \ 
                  0, \[IndentingNewLine]\ \ \ \ Return[
                  m], \ \[IndentingNewLine]\ \ \ \ nz1\  = \ {nzr[\([1]\)]}; 
                nz2\  = \ \ {nzr[\([2]\)]};], \[IndentingNewLine]\ \(If[
                  Length[nz1]\ *Length[nz2]*Length[nzr]\  > \ 
                    0, \[IndentingNewLine]\ \ Return[
                    m], \[IndentingNewLine]\ \ If[
                    Length[nz1]\ \  > \ 
                      Length[nz2]\ , \ {nz1, nz2}\  = \ {nz2, 
                        nz1}]; \[IndentingNewLine]\ \ \ nz1 = 
                    Join[nzr, 
                      nz1]];\)\[IndentingNewLine]]; \[IndentingNewLine]If[
              Length[nz1]\ \  \[NotEqual] \ 
                1, \ {nz1, nz2}\  = \ {nz2, nz1}]; \[IndentingNewLine]If[\ 
              Length[nz1]\ \  \[NotEqual] \ 1, \ \ \ \ Return[
                m], \ \ \ \[IndentingNewLine]l\  = \ 
                nz1[\([1]\)]; \[IndentingNewLine]mmT\  = \ 
                Transpose[m]; \[IndentingNewLine]vl\  = \ 
                mmT[\([l]\)]; \[IndentingNewLine]Do[\[IndentingNewLine]k\ \  \
= \ nz2[\([j]\)]; \[IndentingNewLine]vk\  = \ 
                  mmT[\([k]\)]; \[IndentingNewLine]{vli, 
                    vki}\  = \ {vl[\([i]\)], vk[\([i]\)]\ }/
                    rgcd[vl[\([i]\)], 
                      vk[\([i]\)]]; \[IndentingNewLine]mmT[\([k]\)]\  = 
                  Sign[\(-vki\)\ vli] Abs[vki]\ vl\  + 
                    Abs[vli] vk\ , \[IndentingNewLine]{j, 
                  Length[nz2]}]; \[IndentingNewLine]Transpose[
                mmT]\[IndentingNewLine]]\[IndentingNewLine]]];\)\), "\
\[IndentingNewLine]", 
    \(revsimp[m_, nrev_]\  := \ 
      Module[\ {mmT, l, k, piv, i, vli, vki}, \ 
        Print["\<hi\>"]; \[IndentingNewLine]mmT\  = \ 
          Transpose[m]; \[IndentingNewLine]For[\ l\  = 1, \ 
          l\  \[LessEqual] \ nrev, \ \(l++\), \[IndentingNewLine]piv\  = \ 
            Map[#[\([1]\)] &, 
              Position[mmT[\([l]\)], \ x_\  /; x\  \[NotEqual] 0, {1}]]; \ 
          Print[{l, nrev, piv}]\[IndentingNewLine]If[\ 
              Length[piv]\  > \ 1, \[IndentingNewLine]i\  = \ 
                First[piv]; \[IndentingNewLine]vl\  = \ 
                mmT[\([l]\)]; \[IndentingNewLine]For[k\  = \ l + 1, \ 
                k \[LessEqual] \ 
                  Length[mmT], \ \(k++\), \[IndentingNewLine]vk\  = \ 
                  mmT[\([k]\)]; \ \[IndentingNewLine]If[
                  vk[\([i]\)]\  \[NotEqual] \ 
                    0, \[IndentingNewLine]{vli, 
                      vki}\  = \ {vl[\([i]\)], vk[\([i]\)]\ }/
                      rgcd[vl[\([i]\)], 
                        vk[\([i]\)]]; \[IndentingNewLine]mmT[\([k]\)]\  = 
                    Sign[\(-vki\)\ vli] Abs[vki]\ vl\  + 
                      Abs[vli] 
                        vk\ ]\ \ ]]]; \[IndentingNewLine]Print["\<ho\>"]; \
\[IndentingNewLine]Transpose[mmT]]\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(kersimp0[rr_]\  := \ 
        Module[\ {mm, ints, enzs, nrev, K, Kir, box, cc, constr, v, vv, 
            drops, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ keep, 
            rrnew, l, m}, \[IndentingNewLine]{mm, ints, enzs, nrev}\  = \ 
            reac2stoich[rr]; \ \[IndentingNewLine]K\  = 
            NullSpace[mm]; \[IndentingNewLine]Kir\  = \ 
            Drop[Transpose[K], nrev] // 
              Transpose; \[IndentingNewLine]l = \(Dimensions[
                Kir]\)[\([2]\)]; \[IndentingNewLine]m\  = \ \(Dimensions[
                Kir]\)[\([1]\)]; \[IndentingNewLine]cc\  = \ 
            Table[1, {i, l}]; \[IndentingNewLine]constr\  = \ 
            Table[{0, 0}, {i, m}]; \[IndentingNewLine]box\  = \ \ Table[{0, 
                1}, {i, l}]; 
          vv = LinearProgramming[\(-cc\), Kir, constr, 
              box\  (*\(,\)\(Tolerance\  \[Rule] \ 
                  1.0\ *10\^\(-7\)\)\(,\)\(Method -> \
"\<RevisedSimplex\>"\)*) ]; \[IndentingNewLine]v\  = \ 
            Chop[vv, 10\^\(-7\)]; \[IndentingNewLine]Print[v]; \ 
          Print[Norm[Kir . v]]; \[IndentingNewLine]drops\  = \ 
            nrev + Position[v, \ x_\  /; \ x > 0]\  // Flatten; 
          keep\  = \ 
            Complement[Range[l + nrev], 
              drops]; \[IndentingNewLine] (*\(Print[drops, 
                Map[FeasibleR[reacs, #] &, 
                  drops]];\)*) \[IndentingNewLine]rrnew = \ \(Transpose[
                  rr]\)[\([keep]\)] // Transpose];\)\), "\n", 
    \(\(kersimp[rr_]\  := \ 
        FixedPoint[simp[#, False] &, kersimp0[rr]];\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(box\\)\\\" is similar to existing symbol \
\\\"\\!\\(Box\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(elm2reacs[rr_, elm_]\  := \ 
      Module[\ {elmr, efr}, \[IndentingNewLine]efr[co_]\  := \ 
          Module[{er}, \[IndentingNewLine]er = 
              rr[\([1, co[\([2]\)]]\)]; \[IndentingNewLine]If[\ 
              elm[\([Delete[co, 0]]\)]\  > \ 0, \[IndentingNewLine]er\  /. \ 
                a_\ \[DoubleLongLeftRightArrow]\ b_\  \[Rule] \ 
                  a\ \[DoubleLongRightArrow]\ 
                    b, \[IndentingNewLine]er\  /. \ \ a_\ \
\[DoubleLongLeftRightArrow]\ b_\  \[Rule] \ 
                  b\ \[DoubleLongRightArrow]\ 
                    a]\[IndentingNewLine]]; \[IndentingNewLine]elmr\  = \ 
          Position[elm, \ 
            x_\  /; x\  \[NotEqual] \ 0]; \[IndentingNewLine]elmr\  = 
          Split[elmr, \ \((#1[\([1]\)]\  \[Equal] \ #2[\([1]\)])\) &]; \
\[IndentingNewLine]Map[efr, 
          elmr, {2}]\[IndentingNewLine]]\), "\[IndentingNewLine]", 
    \(\ \ \)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(elmr\\)\\\" is similar to existing symbol \\\
\"\\!\\(elm\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(elm2basereacs[rbase_, rr_, 
        el_]\  := \ \ Module[\ {vec, locR}, \[IndentingNewLine]vec\  = 
          rr[\([2]\)]\ ; \[IndentingNewLine]vec\  = \((MapThread[
                  Times, {el, vec}] // Expand)\) /. \ 
            Plus\  \[Rule] \ VerticalSeparator; \[IndentingNewLine]vec = 
          vec[\([Flatten[
                Position[el, \ x_ /; \ x\  \[NotEqual] \ 0, {1}, 
                  Heads \[Rule] False]]]\)]; \[IndentingNewLine]th[set_, 
            rep_]\  := \ 
          Map[\ \((# \[Rule] \ RR[rep])\) &, 
            set]; \[IndentingNewLine]reprule\  = \ 
          MapThread[\ th\ , {rbase[\([2]\)], rbase[\([1]\)]}] // 
            Flatten\ ; \[IndentingNewLine]vec\ \  = \ \((vec\  /. \ 
                reprule)\)\  /. \ 
            RR[a_]\  \[Rule] \ 
              R[a]\ \ ; \[IndentingNewLine]vec = \ \ \ vec\  /. \ 
            a_\ R[\ x_\ \[DoubleLongLeftRightArrow]\ y_] /; \ 
                a\  < \ 0\  \[Rule] \ \(-a\)\ R[
                  y\ \[DoubleLongRightArrow]\ 
                    x]; \[IndentingNewLine]vec\  = \ \ vec\  /. \ 
            a_. \ R[\ x_\ \[DoubleLongLeftRightArrow]\ y_] /; \ 
                a\  > \ 0\  \[Rule] \ 
              a\ R[x\ \[DoubleLongRightArrow]\ 
                    y]; \[IndentingNewLine]vec\  = \ 
          vec\  /. \ a_\ R[x_]\  \[Rule] \ x; \[IndentingNewLine]vec\  = \ 
          Replace[vec, 
            x_List\  :> Sort[x], {0, 1}]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(locR\\)\\\" is similar to existing symbol \\\
\"\\!\\(loc\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[
    \(\(elm2base[rr_, 
          el_]\  := \ \ Module[\ {vec, locR}, \[IndentingNewLine]vec\  = 
            rr[\([2]\)]\ ; \[IndentingNewLine]vec\  = \((el\ *vec // 
                Expand)\); \[IndentingNewLine]vec = 
            vec[\([Flatten[
                  Position[el, \ x_ /; \ x\  \[NotEqual] \ 0, {1}, 
                    Heads \[Rule] False]]]\)]];\)\)], "Input"],

Cell[BoxData[
    \(basereaco[br_]\  := 
      Module[{vec}, 
        vec = Replace[br\ , 
            x_List /; \ Length[x]\  > \ 1\  \[Rule] \ 
              RowBox[{"\<(\>", 
                  TableForm[x]}], {1}]; \[IndentingNewLine]\(\((\(vec\  /. \ 
                  xt[a_, b_]\  \[Rule] \ 0\)\ \  /. \ 
                a_\ \[DoubleLongRightArrow]\ b_\  \[Rule] \ \(a \[Rule] 
                    b\))\) // TableForm\) // DisplayForm]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Feasiblext[reacs_, Inputs_, Outputs_, 
        Target_]\  := \[IndentingNewLine]Module[\ {m, n, cc, constr, box, 
          mreac, ints, enzs, nrev, exreacs\ , exreacn\ , inp, Targetr, 
          reac}, \[IndentingNewLine]\ 
        inp\  = \ Complement[Inputs, {Target}]; \[IndentingNewLine]\ 
        exreacs\  = 
          Join[Map[\((0\ \[DoubleLongRightArrow]xt[#])\) &, inp], 
            Map[\((xt[#]\ \[DoubleLongRightArrow]\ 0)\) &, 
              Outputs]]; \[IndentingNewLine]\ 
        exreacn\  = \ 
          Map[{Rx[#]} &, 
            exreacs]; \[IndentingNewLine]reac\  = \ {Join[reacs[\([1]\)], 
              exreacs], \ 
            Join[reacs[\([2]\)], exreacn]}; \[IndentingNewLine]\ {mreac, 
            ints, enzs, nrev}\  = \ \ \ reac2stoich[
            reac]; \[IndentingNewLine]Targetr\  = \(Position[reac[\([1]\)], 
              xt[Target]\ \[DoubleLongRightArrow]0, \[Infinity]]\)[\([1, 
              1]\)]; \[IndentingNewLine]m\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \[IndentingNewLine]n\  = \ \ \(Dimensions[
              mreac]\)[\([2]\)]; \[IndentingNewLine]cc\  = \ 
          Table[0, {i, n}]; \ 
        cc[\([Targetr]\)]\  = \ 1; \[IndentingNewLine]constr\  = \ 
          Table[{0, 0}, {i, 
              m}]; \n\ \ \ \ \ box\  = \ \ Table[{If[i\  > \ nrev, 
                0, \(-1\)], 1}, {i, 
              n}]; \[IndentingNewLine]\(LinearProgramming[\(-cc\), mreac, 
              constr, box]\)[\([Targetr]\)] // Chop]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(exreacn\\)\\\" is similar to existing symbol \
\\\"\\!\\(exreacs\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Targetr\\)\\\" is similar to existing symbol \
\\\"\\!\\(Target\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(reac\\)\\\" is similar to existing symbols \
\\!\\({mreac, reacs}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FeasibleR[reacs_, 
        target_]\  := \[IndentingNewLine]Module[\ {m, n, cc, constr, box, 
          mreac, ints, enzs, nrev, exreacs\ , exreacn\ , inp, Targetr, res, 
          check}, \[IndentingNewLine]\ {mreac, ints, enzs, 
            nrev}\  = \ \ \ reac2stoich[
            reacs]; \[IndentingNewLine]m\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \[IndentingNewLine]n\  = \ \ \(Dimensions[
              mreac]\)[\([2]\)]; \[IndentingNewLine]constr\  = \ 
          Table[{0, 0}, {i, 
              m}]; \n\ \ \ \ \ box\  = \ \ Table[{If[i\  > \ nrev, 
                0\ , \(-1\)], 1}, {i, n}]; \[IndentingNewLine]check[
            targt_]\  := \ \((\[IndentingNewLine]cc\  = \ Table[0, {i, n}]; \ 
            cc[\([targt]\)]\  = \ 
              1; \ \[IndentingNewLine]res\  = \(LinearProgramming[\(-cc\), 
                  mreac, constr, box]\)[\([targt]\)]; \[IndentingNewLine]If[
              targt\  \[LessEqual] \ 
                nrev, \[IndentingNewLine]{res, \(LinearProgramming[cc, mreac, 
                    constr, 
                    box]\)[\([targt]\)]}, \[IndentingNewLine]res])\); \
\[IndentingNewLine]Map[check, 
          If[AtomQ[target], {target}, target]]\ ]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(check\\)\\\" is similar to existing symbol \
\\\"\\!\\(Check\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FeasibleRsloppy[reacs_, 
        target_]\  := \[IndentingNewLine]Module[\ {m, n, cc, constr, box, 
          mreac, ints, enzs, nrev, exreacs\ , exreacn\ , inp, Targetr, res, 
          tol\ }, \[IndentingNewLine]\ {mreac, ints, enzs, 
            nrev}\  = \ \ \ reac2stoich[
            reacs]; \[IndentingNewLine]mm\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \[IndentingNewLine]mmreac\  = \ 
          mreac; \[IndentingNewLine]mreac\  = \ 
          Join[mreac, 
            mreac]; \ \[IndentingNewLine]m\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \ 
        Print[m]; \[IndentingNewLine]n\  = \ \ \(Dimensions[
              mreac]\)[\([2]\)]; \[IndentingNewLine]cc\  = \ 
          Table[0, {i, n}]; \ 
        cc[\([target]\)]\  = \ 1; \[IndentingNewLine]tol\  = \ 
          10^\((\(-6\))\); \[IndentingNewLine]constr\  = \ 
          Table[If\ [
              i\  \[LessEqual] \ mm, {\(-tol\), 1}, {tol, \(-1\)}], {i, 
              m}]; \n\ \ \ \ \ box\  = \ \ Table[{If[i\  > \ nrev, 
                0, \(-1\)], 1}, {i, n}]; 
        res\  = \ 
          LinearProgramming[\(-cc\), mreac, constr, box, 
            Method\  \[Rule] \ RevisedSimplex]; \[IndentingNewLine]{mmreac, 
          res, res[\([target]\)]}\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(mmreac\\)\\\" is similar to existing symbol \
\\\"\\!\\(mreac\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RevFix[reacs_]\  := \ 
      Module[{nrev, checks, keep, ir1, ir2, 
          treacs}, \[IndentingNewLine]nrev\  = \(({0} \[Union] 
                Position[reacs[\([1]\)], 
                  x_\ \[DoubleLongLeftRightArrow]\ y_])\) // 
            Max; \[IndentingNewLine]checks\  = \ 
          FeasibleR[reacs, Range[nrev]]; \[IndentingNewLine]Print[
          checks // N]; \[IndentingNewLine]keep\  = \ 
          Position[checks, \ x_\  /; \ x\  \[NotEqual] \ {0, 0}, {1}] // 
            Flatten; \[IndentingNewLine]ir1\  = \ \ Position[checks, \ 
              x_List\  /; \ x[\([2]\)]\  \[Equal] \ \ 0, {1}] // Flatten; 
        ir2\  = \ \ Position[checks, \ 
              x_List\  /; \ x[\([1]\)]\  \[Equal] \ \ 0, {1}] // 
            Flatten; \[IndentingNewLine]treacs\  = \ 
          Transpose[reacs]; \[IndentingNewLine]Print[{keep, ir1, 
            ir2}]; \[IndentingNewLine]treacs[\([ir1]\)]\  = \ 
          treacs[\([ir1]\)]\  /. \ {x_\ \[DoubleLongLeftRightArrow]\ y_, \ 
                z_}\  \[Rule] \ {x\ \[DoubleLongRightArrow]y, z}; 
        treacs[\([ir2]\)]\  = \ 
          treacs[\([ir2]\)]\  /. \ {x_\ \[DoubleLongLeftRightArrow]\ y_, \ 
                z_}\  \[Rule] \ {y\ \[DoubleLongRightArrow]x, 
                z}; \[IndentingNewLine]\(treacs[\([keep \[Union] 
                  Range[nrev + 1, Length[treacs]]\ ]\)]\  // Sort\)\  // 
          Transpose\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(checks\\)\\\" is similar to existing symbol \
\\\"\\!\\(check\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(treacs\\)\\\" is similar to existing symbol \
\\\"\\!\\(reacs\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Convcheck[vecl_, nrev_, 
        target_]\  := \[IndentingNewLine]Module[\ {m, n, cc, constr, box, 
          mreac, inp, res, vecln}, \[IndentingNewLine]vecln\  = \ 
          Map[\((#/Norm[#])\) &, vecl]; \[IndentingNewLine]mreac\  = \ 
          Join[vecln, {\(-target\)/Norm[target\  + \ 10^\((\(-10\))\)\ ]}]\  // 
            Transpose; \[IndentingNewLine]mm\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \[IndentingNewLine]mreac\  = \ 
          Join[mreac, 
            mreac]; \ \[IndentingNewLine]m\  = \ \(Dimensions[
              mreac]\)[\([1]\)]; \[IndentingNewLine]n\  = \ \ \(Dimensions[
              mreac]\)[\([2]\)]; \[IndentingNewLine]cc\  = \ 
          Table[0, {i, n}]; \ 
        cc[\([Length[vecl] + 1]\)]\  = \ 1; \[IndentingNewLine]tol\  = \ 
          10^\((\(-6\))\); \[IndentingNewLine]constr\  = \ 
          Table[If\ [
              i\  \[LessEqual] \ mm, {\(-tol\), 1}, {tol, \(-1\)}], {i, 
              m}]; \n\ \ \ \ \ box\  = \ 
          10*\ Table[{If[i\  > \ nrev, 0, \(-1\)], 1}, {i, 
                n}]; \[IndentingNewLine]res\  = \ 
          LinearProgramming[\(-cc\), mreac, constr, 
            box]; \[IndentingNewLine]Last[res]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(vecln\\)\\\" is similar to existing symbol \
\\\"\\!\\(vecl\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[
    \(\(belmexp[belm_]\  := \ 
        Module[{t, p}, \[IndentingNewLine]t = 
            Map[If[\ Length[#]\  \[Equal] \ 1, \ #[\([1]\)], #] &, 
              belm]; \[IndentingNewLine]t\  = \ \(\(t /. \ \ HoldPattern[
                      Plus[a__]]\  \[Rule] \ 
                    s[a]\)\  //. \ \ a_Real\ b_ \[Rule] \ b\)\  //. \ 
              a_Integer\ b_\  \[Rule] \ 
                b; \[IndentingNewLine]t = \(\((\(\(p @@ t /. \ 
                          List\  \[RuleDelayed] \ \ Plus\)\  /. \ 
                        p\  \[Rule] \ Times\) /. \ s\  \[Rule] \ Times // 
                    Expand\ )\) /. \ a_^b_\  \[Rule] \ a\) /. \ 
              HoldPattern[Plus[a__]]\  \[Rule] \ 
                List[a]; \[IndentingNewLine]\ \ \ \ \ \ \ \
Flatten[{t}]];\)\)], "Input"],

Cell[BoxData[
    \(\(msg[
          s_]\  := \ \ NotebookWrite[\(Notebooks["\<Messages\>"]\)[\([1]\)], 
          s];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nonredl[vecl_, nrev_]\ \  := \ 
      Module[\ {keep, K, off, i, j, opt, Kkk, l, m, box, constr, Kkkc, v, sc, 
          zer, nnrev}, \[IndentingNewLine]keep\  = \ 
          Range[Length[vecl]]; \[IndentingNewLine]K\  = \ 
          NullSpace[Transpose[vecl[\([keep]\)]]] // 
            Transpose; \[IndentingNewLine]off\  = \ 0; \ 
        nnrev\  = \ nrev; \[IndentingNewLine]For[j\  = \ nrev + 1, \ 
          j\  \[LessEqual] \ 
            Length[vecl], \ \(j++\), \[IndentingNewLine]opt\  = \ 
            K[\([j - off]\)]; \[IndentingNewLine]Kkk\  = \ 
            K; \[IndentingNewLine]l = \(Dimensions[
                Kkk]\)[\([2]\)]; \[IndentingNewLine]m\  = \ \(Dimensions[
                Kkk]\)[\([1]\)]; \ \[IndentingNewLine]box\  = \ \ Table[{\(-1\
\), 1}, {i, l}]; \[IndentingNewLine]constr\  = \ 
            Table[{0, 1}, {i, 
                m}]; \[IndentingNewLine]constr[\([j - 
                  off]\)]\  = \ {0, \(-1\)}; \[IndentingNewLine]\ 
          Kkkc = \ Drop[Kkk, nnrev]; \[IndentingNewLine]\ 
          constr\ \  = \ Drop[constr, nnrev]; \[IndentingNewLine]\ 
          v = LinearProgramming[opt, Kkkc // N, constr, box\ , 
              Method \[Rule] InteriorPoint]; \ \[IndentingNewLine]\ 
          If[\[Not] VectorQ[\ v, NumericQ]\ , \ msg["\<x\>"]; 
            v\  = \ \(-opt\)]; \[IndentingNewLine]\ 
          If[\ opt . v \[LessEqual] \ \(-0.0003\), \[IndentingNewLine]\ 
            msg["\<?\>"]; \[IndentingNewLine]\ 
            v = LinearProgramming[opt, Kkkc, constr, box\ , 
                Method \[Rule] RevisedSimplex]; 
            If[\[Not] VectorQ[\ v, NumericQ], \ 
              v\  = \ Table[0, {i, l}]]; \[IndentingNewLine]vv = \ 
              Kkk . v; \[IndentingNewLine]cv\  = \ 
              vv . vecl[\([keep]\)]; \[IndentingNewLine]vv[\([j - 
                    off]\)] = \(-vv[\([j - 
                      off]\)]\); \[IndentingNewLine]red\  = \ \((vv[\([j - 
                          off]\)]\ \  > \ 0)\)\  && \ \((cv\  \[Equal] \ 
                    0\ cv)\)\  && \((Min[
                      vv[\([Range[nnrev + 1, m]]\)]]\  \[GreaterEqual] \ 
                    0)\); \[IndentingNewLine]If[red, \[IndentingNewLine]\ 
              keep\  = Drop[keep, {j - off}]; \[IndentingNewLine]\ 
              off\  = \ off + 1; \[IndentingNewLine]\ 
              K\  = \ NullSpace[Transpose[vecl[\([keep]\)]]] // 
                  Transpose; \[IndentingNewLine]\ 
              If[\ j\  \[LessEqual] \ nnrev, \ 
                nnrev = nnrev - 1]]]; \[IndentingNewLine]msg[
            ToString[{j, 
                  Length[keep]}] <> "\<\n\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]{keep, nnrev}]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(off\\)\\\" is similar to existing symbol \
\\\"\\!\\(Off\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Kkkc\\)\\\" is similar to existing symbol \\\
\"\\!\\(Kkk\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nnrev\\)\\\" is similar to existing symbol \
\\\"\\!\\(nrev\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(nonred[vecl_, nrev_]\ \  := \ 
        Module[\ {keep, nnrev}, \[IndentingNewLine]{keep, nnrev}\  = \ 
            nonredl[vecl, nrev]; \ \[IndentingNewLine]{vecl[\([keep]\)], 
            nnrev}];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nonred\\)\\\" is similar to existing symbol \
\\\"\\!\\(nonredl\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\n\)\(nonredr[reacs_]\  := \ 
        Module[\ {mreac, ints, enzs, nrev, r, 
            nnrev}, \[IndentingNewLine]{mreac, ints, enzs, nrev}\  = \ 
            reac2stoich[reacs]; \[IndentingNewLine]{r, nnrev}\  = \ 
            nonred[Trp[mreac], nrev]; \[IndentingNewLine]r\  = \ 
            Trp[r]; \[IndentingNewLine]r\  = \ 
            stoich2reac[r, ints, 0*r[\([1]\)], nnrev]; \[IndentingNewLine]{r, 
            Map[exfr, Range[Length[r]]]}];\)\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nonredr\\)\\\" is similar to existing \
symbols \\!\\({nonred, nonredl}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(exfr\\)\\\" is similar to existing symbol \\\
\"\\!\\(efr\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fold[reacs_, fints_, \ 
        Cache_]\  := \ \[IndentingNewLine]Module[{mreac, ints, enzs, nrev, 
          fintsp, Nyy, ryy, rr, rest, internal, mreacint, res, nnrev, a, b, 
          g, c}, \[IndentingNewLine]{mreac, ints, enzs, nrev}\  = \ 
          reac2stoich[reacs]; \[IndentingNewLine]fintsp\  = 
          Map[Position[ints, #] &, fints]\  // Flatten; \[IndentingNewLine]\ 
        Nyy\  = mreac[\([fintsp]\)]; \ 
        ryy = {stoich2reac[Nyy, fints, enzs, nrev], 
              Map[{rr[#]} &, Range[\(Dimensions[Nyy]\)[\([2]\)]]]} // 
            Transpose; \ \[IndentingNewLine]rest = \((Position[
                  ryy, {0\[DoubleLongLeftRightArrow]0, _}] \[Union] 
                Position[ryy, {0\[DoubleLongRightArrow]0, _}])\) // 
            Flatten; \[IndentingNewLine]rest\  = \ {}; \
\[IndentingNewLine]internal\  = 
          Complement[Range[Length[ryy]], rest]; \[IndentingNewLine]\ 
        mreacint = \ \(Transpose[mreac]\)[\([internal]\)]\  // 
            Transpose; \[IndentingNewLine]\ 
        Nyy = \ mreacint[\([fintsp]\)]; \[IndentingNewLine]\ 
        nnrev\  = \ 
          Count[internal, \ 
            x_\  /; \ x\  \[LessEqual] \ 
                nrev]; \[IndentingNewLine]Print[{"\<doing\>", 
            Dimensions[Nyy], nnrev}]; \[IndentingNewLine]res\  = \ 
          Reverse[Cache[gset[Nyy, nnrev]]]; \[IndentingNewLine]irrevcnt\  = 
          Map[Plus @@ Sign[Abs[Drop[#, nnrev]]] &, 
            res]; \[IndentingNewLine]res\  = \ 
          res[\([Ordering[irrevcnt]]\)]; \ 
        resrev\  = \ Count[irrevcnt, 0]; \[IndentingNewLine]\ 
        Nxy\  = \ 
          mreacint[\([Complement[Range[Length[ints]], 
                fintsp]]\)]; \[IndentingNewLine]exfunc\  = \ 
          res . Transpose[Nxy]; \[IndentingNewLine]exfunc = \ 
          Map[\((#/Max[2^\((\(-10\))\), \((GCD @@ #)\)])\) &, 
            exfunc]; \[IndentingNewLine]{exfunc, resrev} = \ 
          Cache[nonred[exfunc, resrev]]; \[IndentingNewLine]exfuncs\  = \ 
          exfunc . 
            ints[\([Complement[Range[Length[ints]], 
                  fintsp]]\)]; \[IndentingNewLine]exfuncs\ \  = 
          Map[\ \((0\ \ \ \ \[DoubleLongRightArrow]\ \ #)\) &, 
            exfuncs]; \[IndentingNewLine]exfuncs[\([Range[resrev]]\)]\  = \ 
          exfuncs\ [\([Range[resrev]]\)]\ \  /. \ 
            a_\ \ \[DoubleLongRightArrow]\ b_\  :> \ 
              a\ \[DoubleLongLeftRightArrow]
                b; \[IndentingNewLine]exfuncs\  = \ \(exfuncs\  //. \ 
              a_\ \[DoubleLongLeftRightArrow]\ \((\ 
                      g_\ \ b_\  + \ c_. )\) /; \ 
                  g\  < \ 
                    0\  :> \ \((a + \(-g\)\ b)\)\ \[DoubleLongLeftRightArrow]\
\ c\)\  //. a_\ \ \[DoubleLongRightArrow]\ \((\ g_\ \ b_\  + \ c_. )\) /; \ 
                g\  < \ 
                  0\  :> \ \((a + \(-g\)\ b)\)\ \[DoubleLongRightArrow]\ 
                c; \[IndentingNewLine]\ 
        exfuncr\  = \ {exfuncs\ , 
            Map[{exfr[#]} &, 
              Range[Length[exfuncs]]]}; \[IndentingNewLine]\ \((\(Transpose[
                  reacs]\)[\([rest]\)] \[Union] Transpose[exfuncr])\)\  // 
          Transpose]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(fold\\)\\\" is similar to existing symbol \\\
\"\\!\\(Fold\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(fintsp\\)\\\" is similar to existing symbol \
\\\"\\!\\(fints\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rest\\)\\\" is similar to existing symbols \
\\!\\({res, Rest}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(gset\\)\\\" is similar to existing symbol \\\
\"\\!\\(set\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(exfuncr\\)\\\" is similar to existing \
symbols \\!\\({exfunc, exfuncs}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(simpint[rr_]\  := \ 
      Block[\ {m, ints, enzs, nrev, rrnew, i, combs, maxint, drop, 
          keep}, \[IndentingNewLine]{m, ints, enzs, nrev}\  = \ 
          reac2stoich[rr]; \ \[IndentingNewLine]m\  = \ 
          Join[m, {rr[\([2]\)]}]; \[IndentingNewLine]maxint\  = \ 
          Min[Position[ints, xt[_], {\(-2\)}]] - 1; \[IndentingNewLine]{m, 
            drop} = \ 
          revsimpint[m, nrev, maxint, ints]; \[IndentingNewLine]rrnew\  = \ 
          stoich2reac[Drop[m, \(-1\)], ints, enzs, 
            nrev]; \ \[IndentingNewLine]combs\  = \ 
          Expand[Last[m]]\  //. \ 
            a_\ tt[b_]\  \[Rule] \ 
              tt[a\ b]; \ \[IndentingNewLine]combs\  = \ \(combs\  //. \ 
              tt[a_]\  + \ tt[b_]\  \[RuleDelayed] \ 
                Outer[Plus, a, b]\)\  //. \ 
            tt[a_]\  \[RuleDelayed] \ a; \[IndentingNewLine]combs\  = \ 
          Map[Flatten, combs]; \[IndentingNewLine]keep\  = \ 
          Complement[Range[Length[rrnew]], drop]; \ 
        Print[keep]; \[IndentingNewLine]{rrnew[\([keep]\)], 
          combs[\([keep]\)]}]\), "\[IndentingNewLine]", 
    \(revsimpint[m_, nrev_, maxpiv_, ints_]\  := \ 
      Block[\ {mmT, l, k, piv, i, vli, vki, drop, 
          nrm}, \ \[IndentingNewLine]Print["\<hi\>"]; \[IndentingNewLine]mmT\ \
 = \ Transpose[m]; \[IndentingNewLine]drop\  = \ {}; \[IndentingNewLine]Print[
          maxpiv]; \[IndentingNewLine]For[\ l\  = 1, \ 
          l\  \[LessEqual] \ nrev, \ \(l++\), \[IndentingNewLine]piv\  = \ 
            Map[#[\([1]\)] &, 
              Position[mmT[\([l]\)], \ 
                x_\  /; x\  \[NotEqual] 
                    0, {1}]]; \ \[IndentingNewLine]piv\  = \ 
            Cases[piv, 
              x_\  /; \ x\  \[LessEqual] \ maxpiv]; \[IndentingNewLine]If[\ 
            Length[piv]\ \  > \ \ 0, \[IndentingNewLine]drop\  = \ 
              Append[drop, l]; \[IndentingNewLine]i\  = \ 
              First[piv]; \[IndentingNewLine]Print[{l, 
                ints[\([i]\)]}]; \[IndentingNewLine]vl\  = \ 
              mmT[\([l]\)]; \[IndentingNewLine]For[k\  = \ l + 1, \ 
              k \[LessEqual] \ 
                Length[mmT], \ \(k++\), \ \[IndentingNewLine]vk\  = \ 
                mmT[\([k]\)]; \ \[IndentingNewLine]If[
                vk[\([i]\)]\  \[NotEqual] \ 
                  0, \ \[IndentingNewLine]{vli, 
                    vki}\  = \ {vl[\([i]\)], vk[\([i]\)]\ }/
                    rgcd[vl[\([i]\)], 
                      vk[\([i]\)]]; \[IndentingNewLine]mmT[\([k]\)]\  = 
                  Expand[Sign[\(-vki\)\ vli] Abs[vki]\ vl\  + 
                      Abs[vli] vk\ ]; \ \[IndentingNewLine]nrm\  = \ 
                  GCD @@ Drop[mmT[\([k]\)], \(-1\)]; \[IndentingNewLine]If[\ 
                  nrm\  \[NotEqual] \ 0, 
                  mmT[\([k]\)]\  = \ 
                    mmT[\([k]\)]\ /
                      nrm];\[IndentingNewLine]\ \ \ \ \ \ \ \ ]]]]; \
\[IndentingNewLine]Print[
          drop]; \[IndentingNewLine]Print["\<ho\>"]; \
\[IndentingNewLine]{Transpose[mmT], drop}]\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(drop\\)\\\" is similar to existing symbols \
\\!\\({Drop, drops}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(foldprep[reacs_, 
        fints_]\  := \ \[IndentingNewLine]Block[{mreac, ints, enzs, nrev, 
          fintsp, Nyy, Nyyt, do, rest, res, 
          nnrev}, \[IndentingNewLine]{mreac, ints, enzs, nrev}\  = \ 
          reac2stoich[reacs]; \[IndentingNewLine]fintsp\  = 
          Map[Position[ints, #] &, fints]\  // Flatten; \[IndentingNewLine]\ 
        Nyy\  = mreac[\([fintsp]\)]; \ Print[fints]; \[IndentingNewLine]\ 
        Nyyt\  = \ Transpose[Nyy]; \[IndentingNewLine]\ 
        rest\  = \ 
          Position[Nyyt, 0*Nyyt[\([1]\)]] // 
            Flatten; \[IndentingNewLine]do\  = 
          Complement[Range[Length[reacs[\([1]\)]]], 
            rest]; \[IndentingNewLine]rest\  = \ {reacs[\([1, rest]\)], 
            reacs[\([2, rest]\)]}; \[IndentingNewLine]do\  = \ {reacs[\([1, 
                do]\)], reacs[\([2, do]\)]}; \[IndentingNewLine]{mreac, ints, 
            enzs, nrev}\  = \ reac2stoich[do]; 
        fintsp\  = Map[Position[ints, #] &, fints]\  // Flatten; 
        fexp\  = \ 
          Complement[Range[Length[ints]], 
            fintsp]; \[IndentingNewLine]perm\  = \ 
          Join[fintsp, fexp]; \[IndentingNewLine]{rest, \ {mreac[\([perm]\)], 
            ints[\([perm]\)], enzs, 
            nrev}}\[IndentingNewLine]\ \ \ \ ]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Nyyt\\)\\\" is similar to existing symbol \\\
\"\\!\\(Nyy\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< \ "\<~/SNA/mathcode/SNAmat.m\>"\)], "Input"],

Cell[BoxData[
    \(LinkObject["/home/robert/SNA/mathcode/../pairelvs/pairelvsIFsh", 2, 
      2]\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(\(\(exfunc[Nt_, nrev_, intnum_]\  := \ 
      Module[\ {NN, res, resrev}, \[IndentingNewLine]NN\ \  = \ 
          Join[\(-Nt[\([Range[nrev]]\)]\), Nt]; \ \[IndentingNewLine]{res, 
            resrev}\  = \ half[NN]; \[IndentingNewLine]Print[
          resrev]; \[IndentingNewLine]res\  = \ 
          Map[Drop[#, intnum] &, res]; \[IndentingNewLine]res\  = \ 
          Join[\(-res[\([Range[resrev]]\)]\), res]; \[IndentingNewLine]half[
          res]]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(fold1[reacs_, fints_]\  := \ 
        Module[\ {a, bm, bi, be, bnr, res, 
            resrev}, \n\ \ \ \ \ \ \ {a, {bm, bi, be, bnr}}\  = 
            foldprep[reacs, fints]; \[IndentingNewLine]{res, resrev}\  = \ 
            exfunc[Transpose[bm], bnr, 
              Length[fints]]; \ \[IndentingNewLine]res\  = \ 
            Map[\((#/\((GCD @@ #)\))\) &, res]; \[IndentingNewLine]res\  = \ 
            Transpose[res]; \[IndentingNewLine]b\  = \ 
            stoich2reac[res, Drop[bi, Length[fints]], 0*res[\([1]\)], 
              resrev]; \[IndentingNewLine]{a[\([1]\)], b}];\)\), "\n", 
    \(foldn[reacs_, fints_, Cache_]\  := \ 
      Module[\ {a, 
          b}, \[IndentingNewLine]{a, b}\  = \ \ Cache[\ 
            fold1[reacs, fints]\ ]; \[IndentingNewLine]a\  = \ 
          a \[Union] b; \[IndentingNewLine]{a\ , 
          Map[{exfr[#]} &, Range[Length[a]]]}]\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(foldn\\)\\\" is similar to existing symbol \
\\\"\\!\\(fold\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(dot[a_, b_]\  := \ a . b;\)\), "\[IndentingNewLine]", 
    \(\(dot[{}, b_]\  := \ {};\)\), "\[IndentingNewLine]", 
    \(\(dot[a_, {}]\  := \ {};\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(dot\\)\\\" is similar to existing symbol \
\\\"\\!\\(Dot\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[{
    \(\(fcut1old[N_, nrev_, intnum_, cuts_]\  := \ 
        Module[\ {NN, res, resrev, resr, 
            oprun}, \[IndentingNewLine]NN\ \  = \ 
            Join[\(-N[\([Range[nrev]]\)]\), N]; \[IndentingNewLine]{res, 
              resrev}\  = \ half[NN]; \[IndentingNewLine]Print[
            resrev]; \[IndentingNewLine]res\  = \ 
            Join[res, cuts]; \[IndentingNewLine]res\  = \ 
            Map[Drop[#, intnum] &, 
              res]; \[IndentingNewLine] (*\(res\  = \ 
                Map[\((#/\((GCD @@ #)\))\) &, 
                  res];\)*) \[IndentingNewLine]resr\  = \ 
            Take[res, resrev]; \[IndentingNewLine]res\  = \ 
            Drop[res, resrev]; \[IndentingNewLine]If[
            resr\  \[NotEqual] \ {}, \ \ res\  = \ 
              dot[res, Trp[NullSpace[resr]]]]; \[IndentingNewLine]oprun\  = \ 
            pruning; \ 
          pruning\  = \ True; \[IndentingNewLine]res\  = \ 
            If[res\  \[NotEqual] \ {}, \ \ half[res], \ \ \ \ {{}, 
                0}]; \[IndentingNewLine]pruning\  = \ 
            oprun; \[IndentingNewLine]If[\((resr\  \[NotEqual] \ {})\) && \
\((res[\([1]\)]\  \[NotEqual] \ {})\), \ \ res\ [\([1]\)] = \ 
              res[\([1]\)] . 
                NullSpace[
                  resr]]; \[IndentingNewLine]res]\ ;\)\), \
"\[IndentingNewLine]", 
    \(\ fcut1[N_, nrev_, intnum_, cuts_]\  := \ 
      Block[\ {NN, res, resrev, resr, resi, \ 
          oprun}, \[IndentingNewLine]NN\ \  = \ 
          Join[\(-N[\([Range[nrev]]\)]\), N]; \[IndentingNewLine]{res, 
            resrev}\  = \ 
          ZH2gset[{}, NN]; \[IndentingNewLine]Print["\<resrev \>", \ 
          resrev]; \[IndentingNewLine]res\  = \ 
          Join[res, cuts]; \[IndentingNewLine]res\  = \ 
          Map[Drop[#, intnum] &, 
            res]; \[IndentingNewLine] (*\(res\  = \ 
              Map[\((#/\((GCD @@ #)\))\) &, 
                res];\)*) \[IndentingNewLine]resr\  = \ 
          Take[res, resrev]; \[IndentingNewLine]resi\  = \ 
          Drop[res, resrev]; \[IndentingNewLine]oprun\  = \ pruning; \ 
        pruning\  = \ True; \[IndentingNewLine]res\  = \ 
          If[res\  \[NotEqual] \ {}, \ \ ZH2gset\ [resr, resi], \ \ \ \ {{}, 
              0}]; \[IndentingNewLine]pruning\  = \ 
          oprun; \[IndentingNewLine]res]\ \ \[IndentingNewLine] (*BUG : \ 
        Use\  ** either ** \ folds, uns, \ 
      or\ outs\ *) \), "\[IndentingNewLine]", 
    \(fcut[reacs_, folds_, ins_, outs_, Cache_]\  := \ 
      Module[\ \ {a, b, bm, bi, be, bnr, res, resrev, insv, 
          outsv}, \ \[IndentingNewLine]{a, {bm, bi, be, bnr}}\  = 
          foldprep[reacs, 
            ins \[Union] outs \[Union] 
              folds]; \[IndentingNewLine]insv\ \ \ \  = \ 
          Map[\ \((\(#\ bi\  /. \ x_\ y_\  \[Rule] \ 0\)\  /. \ 
                  x_^2\  \[Rule] \ \(-1\))\) &, 
            ins]; \ \[IndentingNewLine]outsv\ \  = \ 
          Map[\ \((\(#\ bi\  /. \ x_\ y_\  \[Rule] \ 0\)\  /. \ 
                  x_^2\  \[Rule] \ 1)\) &, outs]; \ \[IndentingNewLine]{res, 
            resrev}\  = 
          Cache[fcut1[Transpose[bm], bnr, Length[folds], 
              Join[insv, outsv]]]; \[IndentingNewLine]res\  = \ 
          Map[\((#/\((GCD @@ #)\))\) &, res]; \[IndentingNewLine]res\  = \ 
          Trp[res]; \[IndentingNewLine]\ 
        b\  = \ If[res\  \[Equal] \ {}, {}, 
            stoich2reac[res, Drop[bi, Length[folds]], 0*res[\([1]\)], 
              resrev]]; \[IndentingNewLine]\ 
        a\  = \ a[\([1]\)] \[Union] b; \[IndentingNewLine]{a\ , 
          Map[exfr, Range[Length[a]]]}]\)}], "Input"],

Cell[BoxData[
    \(\(splitset[reacs_, mets_, excludemets_]\  := \ 
        Module[{mr, nmr}, \[IndentingNewLine]mr\ \  = \ 
            Union @@ Map[eltswith[reacs[\([1]\)], #] &, 
                mets]; \[IndentingNewLine]nmr\  = \ 
            Complement[reacs[\([1]\)], mr]; \[IndentingNewLine]{Complement[\ 
              Cases[mr, a_[b_], {\(-2\)}], 
              excludemets\ \  \[Union] Cases[nmr, a_[b_], {\(-2\)}]], 
            Length[mr]}];\)\)], "Input"],

Cell[BoxData[
    \(extsplit[reacs_, mets_, excludemets_]\  := \ 
      Module[\ {allm, cur, dum, exts}, \[IndentingNewLine]allm\  = \ 
          Complement[Cases[reacs[\([1]\)], a_[b_], {\(-2\)}], 
            excludemets]; \[IndentingNewLine]{cur, dum}\  = \ 
          splitset[reacs, mets, excludemets]; \[IndentingNewLine]allm\  = \ 
          Complement[allm, cur]; \[IndentingNewLine]exts\  = \ 
          Map[splitset[reacs, mets \[Union] {#}, excludemets] &, 
            allm]; \[IndentingNewLine]exts\  = \ 
          Map[\ {\((Length[#[\([1]\)]]/#[\([2]\)])\) // N, #[\([2]\)]} &, 
            exts]; \[IndentingNewLine]{exts, allm} // Transpose]\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(gset2elv[reacs_]\  := \ 
      Module[{mreac, ints, enzs, nrev, N, NN, res, 
          resrev}, \n\ \ \ {mreac, ints, enzs, nrev} = 
          reac2stoich[reacs]; \[IndentingNewLine]N\  = \ 
          Transpose[mreac]; \[IndentingNewLine]NN\ \  = \ 
          Join[\(-N[\([Range[nrev]]\)]\), N]; \[IndentingNewLine]{res, 
            resrev}\  = \ ZH2gset\ [{}, NN]; \[IndentingNewLine]Print[
          resrev]; \[IndentingNewLine]{res, resrev}\  = \ 
          ZH2elvs[Take[res, resrev], 
            Drop[res, resrev]]; \[IndentingNewLine]res\  = \ 
          Map[\((#/\((GCD @@ #)\))\) &, res]; \[IndentingNewLine]res\  = \ 
          Trp[res]; \[IndentingNewLine]res\  = \ 
          stoich2reac[res, ints, 0*res[\([1]\)], 
            resrev]; \[IndentingNewLine]{res\ , 
          Map[elvnum, Range[Length[res]]]}\[IndentingNewLine]]\)], "Input"]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{847, 861},
WindowMargins->{{Automatic, 38}, {Automatic, 27}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 228, 4, 64, "Input"],
Cell[1985, 57, 275, 5, 43, "Input"],
Cell[2263, 64, 371, 7, 59, "Input"],

Cell[CellGroupData[{
Cell[2659, 75, 1599, 27, 203, "Input"],
Cell[4261, 104, 357, 5, 20, "Message"]
}, Open  ]],
Cell[4633, 112, 1145, 22, 203, "Input"],
Cell[5781, 136, 2777, 51, 411, "Input"],
Cell[8561, 189, 4806, 86, 859, "Input"],

Cell[CellGroupData[{
Cell[13392, 279, 1602, 28, 296, "Input"],
Cell[14997, 309, 354, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15388, 319, 936, 17, 203, "Input"],
Cell[16327, 338, 355, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16719, 348, 1479, 27, 203, "Input"],
Cell[18201, 377, 355, 5, 20, "Message"]
}, Open  ]],
Cell[18571, 385, 392, 7, 75, "Input"],
Cell[18966, 394, 454, 9, 59, "Input"],

Cell[CellGroupData[{
Cell[19445, 407, 1512, 27, 235, "Input"],
Cell[20960, 436, 362, 5, 20, "Message"],
Cell[21325, 443, 361, 5, 20, "Message"],
Cell[21689, 450, 357, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22083, 460, 1239, 21, 235, "Input"],
Cell[23325, 483, 358, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23720, 493, 1300, 24, 251, "Input"],
Cell[25023, 519, 359, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25419, 529, 1445, 24, 219, "Input"],
Cell[26867, 555, 359, 5, 20, "Message"],
Cell[27229, 562, 359, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27625, 572, 1239, 21, 251, "Input"],
Cell[28867, 595, 357, 5, 20, "Message"]
}, Open  ]],
Cell[29239, 603, 802, 14, 107, "Input"],
Cell[30044, 619, 133, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[30202, 626, 2709, 46, 523, "Input"],
Cell[32914, 674, 354, 5, 20, "Message"],
Cell[33271, 681, 355, 5, 20, "Message"],
Cell[33629, 688, 357, 5, 20, "Message"],
Cell[33989, 695, 333, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34359, 705, 234, 4, 59, "Input"],
Cell[34596, 711, 361, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34994, 721, 494, 8, 123, "Input"],
Cell[35491, 731, 365, 6, 33, "Message"],
Cell[35859, 739, 355, 5, 20, "Message"]
}, Open  ]],
Cell[36229, 747, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[36280, 751, 3186, 57, 443, "Input"],
Cell[39469, 810, 356, 5, 20, "Message"],
Cell[39828, 817, 359, 5, 20, "Message"],
Cell[40190, 824, 354, 5, 20, "Message"],
Cell[40547, 831, 355, 5, 20, "Message"],
Cell[40905, 838, 333, 5, 20, "Message"],
Cell[41241, 845, 365, 6, 33, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41643, 856, 3106, 56, 587, "Input"],
Cell[44752, 914, 356, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45145, 924, 1299, 23, 251, "Input"],
Cell[46447, 949, 355, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46839, 959, 67, 1, 27, "Input"],
Cell[46909, 962, 110, 2, 23, "Print"]
}, Open  ]],
Cell[47034, 967, 518, 9, 139, "Input"],

Cell[CellGroupData[{
Cell[47577, 980, 912, 16, 187, "Input"],
Cell[48492, 998, 357, 5, 20, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48886, 1008, 184, 3, 59, "Input"],
Cell[49073, 1013, 354, 5, 20, "Message"]
}, Open  ]],
Cell[49442, 1021, 3601, 66, 651, "Input"],
Cell[53046, 1089, 468, 8, 75, "Input"],
Cell[53517, 1099, 671, 10, 123, "Input"],
Cell[54191, 1111, 26, 0, 27, "Input"],
Cell[54220, 1113, 872, 15, 203, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

