/***************************************************************************

Author: Robert  Urbanczik
Call:  C = andvecmat(A,B)
       A   : m by 1 uint32-Array
       B   : m by n uint32-Array
       C   : m by n uint32-Array
Does:  C(:,i) = bitand(A,B(:,i)) for i = 1,...,n. 

***************************************************************************/
#include <math.h>
#include "mex.h"

#define	A_IN	prhs[0]
#define	B_IN	prhs[1]
#define	C_OUT	plhs[0]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned long int  *A,*B,*a,*b,*C,*c;
    unsigned int d1A,d2B; 
    unsigned int i,j;
    const int *dimp;
    int dd[2];
    
    /* Check for proper number of arguments */
    
    if (nrhs != 2) { 
	mexErrMsgTxt("Two input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
    } 
    dimp =  mxGetDimensions(A_IN);
    d1A = dimp[0];
    dimp =  mxGetDimensions(B_IN);
    d2B = dimp[1]; 

    dd[0] = d1A; dd[1] = d2B;
    C_OUT = mxCreateNumericArray(2, dd, mxUINT32_CLASS, mxREAL);
    
    A = mxGetData(A_IN); 
    B = mxGetData(B_IN);
    C = mxGetData(C_OUT);
        
    c = C; b = B; a = A;
    for (j=0; j < d2B; j++) {
      a = A;
      for (i = 0; i < d1A; i++) {
 	*c = (*a) & (*b); 
        a++; b++; c++;}}
}


