/***************************************************************************

Author: Robert  Urbanczik
Call:  C = nosuperset(A,B)
       A   : np by m uint32-Array
       B   : np by l uint32-Array
       C   : l by 1 logical array
Does:  C(i) is true iff no bitmap A(:,j) is a superset of B(:,i),
       i.e. iff  bitand(A(:,j), B(:,i)) ~=  B(:,i) holds for all
                 j = 1,...,m

***************************************************************************/
#include <math.h>
#include "mex.h"

#define	A_IN	prhs[0]
#define	B_IN	prhs[1]
#define	C_OUT	plhs[0]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned long int  *A,*Al,*B,*a,*b,*a_next,*bb;
    unsigned char *C,*c,nomatch;
    unsigned int d1A,d2A,d2B; 
    unsigned int i;
    const int *dimp;
    int dd[2];
    
    /* Check for proper number of arguments */
 
   if (nrhs != 2) { 
	mexErrMsgTxt("Two input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
	} 

    dimp =  mxGetDimensions(A_IN);
    d1A = dimp[0];
    d2A = dimp[1];
    dimp =  mxGetDimensions(B_IN);
    d2B = dimp[1]; 

    dd[0] = d2B;
    C_OUT = mxCreateNumericArray(1, dd, mxLOGICAL_CLASS, mxREAL);
    
    A = mxGetData(A_IN); 
    B = mxGetData(B_IN);
    C = mxGetData(C_OUT);
        
    c = C; b = B; Al = A+d1A*d2A; 
    for (i = 0; i < d2B; i++) {
      nomatch = 1;
      a= A;
      while (a < Al) {
	bb  = b; a_next = a+d1A;
        nomatch = 0; 
        while (a  < a_next) {
 	  if ((~(*a))&(*bb) ) {  nomatch =1; break; }
          bb++;  a++;
        }
        if (nomatch == 0) break;
        a =  a_next;
      } 
      *c = nomatch; 
      c++;  b = b+d1A; 
    }
}


