/***************************************************************************

Author: Robert  Urbanczik
Call:  [C,Z] = packbituint8(A,Zer)
       A   : m  by n uint8-Array
       Zer : 1  by 1 uint8-Array
       C   : np by m uint32-Array
       Zer : m by  1 uint32-Array
Does:  Z(i) counts the number of cases with A(i,:) == Zer
       C(:,i) is the bitmap of the comaprisons  A(i,:) == Zer 
       np = ceil(n/32)

***************************************************************************/

#include <math.h>
#include "mex.h"

/* Input Arguments */

#define	A_IN	prhs[0]
#define	Zer_IN	prhs[1]


/* Output Arguments */

#define	C_OUT	plhs[0]
#define	Zs_OUT	plhs[1]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned char  *A,*a,*aa,*Zer,zer;
    unsigned int *C,*c,*Zs;
    unsigned int d1A,d2A,d1B; 
    unsigned int i,j,k,bb;
    const int *dimp;
    int dd[2];
    
    /* Check for proper number of arguments */
    
    if (nrhs != 2) { 
	mexErrMsgTxt("Two input arguments required."); 
    } else if (nlhs != 2) {
	mexErrMsgTxt("wrong number of  output arguments."); 
    } 
    dimp =  mxGetDimensions(A_IN);
    d1A = dimp[0];
    d2A = dimp[1];;


   d1B = (d2A + 31)/32;    dd[0] = d1B; dd[1] = d1A,
   C_OUT  = mxCreateNumericArray(2, dd,   mxUINT32_CLASS, mxREAL); 
   Zs_OUT = mxCreateNumericArray(1, dd+1, mxUINT32_CLASS, mxREAL);
    
    /* Assign pointers to the various parameters */ 
    A =   mxGetData(A_IN); 
    Zer = mxGetData(Zer_IN);
    C =   mxGetData(C_OUT);    
    Zs =  mxGetData(Zs_OUT);
            
    zer = *Zer;  
    c = C;  a = A;
    for (i = 0; i < d1A; i++) { 
      aa = a; k = 0; bb = 1; 
      for (j=0; j < d2A; j++) { 
        if (*aa == zer)  { *c += bb; *Zs +=1;}
        if (k == 31)
          {k = 0; bb = 1; c++;}
         else {bb = 2*bb; k++;}
        aa  += d1A;}
      if (k != 0) {c++;} 
      a++; Zs++;} 
    
}


