function [res, Sres, MsgString] = pairelvs(covS,irrevfluxes,minzeroes)
%
% Author:     R.Urbanczik
%
% Inputs:  covS,  n by k uint8-array.
%                 covS(i, 1:k-1) encodes the signs of K\beta(i), where
%                 K is the old constraint matrix and the \beta(i) are
%                 the old elementary vectors. covS(i,k) gives the sign
%                 for the new constraint.
%          irrevfluxes, variable length indexvector such that covS(i,:)
%                       is reversible if covS(i,irrevfluxes) == Zer.
%          minzeroes, minimal number of zeroes for an elementary vector
%
% Outputs: res,  m by 2 index array,
%                a pair [i,j] of res give the indexes such that the old
%                \beta(i,:) and \beta(j,:) can be combined to form an
%                elementary vector of the new system.
%                res lists these pairs for all vectors which are elementary
%                in the new system, but which where not elementary in the
%                old one.
%          Sres, m by k uint8-array.
%                Sres(l,:) encodes the signs of the new elementary vector
%                obtained from the pair res(i,:).
%          MsgString, string with some statistics.
%                  
%
global fid

%  fid = fopen('~/SNA/pairelvs/debug','a+');
%  fprintf(fid,'hi %s\n ',mat2str(size(covS)));
   
  Neg = uint8('a'); Zer= uint8('b'); Pos = uint8('c');
  k = size(covS,2);
  
  [dum,is] = find( covS == Neg); dum = [];
  if length(is) > 0
    nirrev = min(is)-1;
  else
    nirrev = k-1;
  end;
  is = [];

  pnum = sum(covS(:,k) ==  Pos);
  nnum = sum(covS(:,k) ==  Neg);
  FLIP = false;
  if pnum > nnum
    tmp= Pos; Pos=Neg; Neg =tmp; FLIP = true;
  end;
  
  revb = find(sum(+(covS(:,irrevfluxes) ~= Zer),2) == 0);
  revn = revb(find((covS(revb,k) == Neg)));
  buf = covS(revn,:);
  flip1 = (buf == Neg); flip2 =  (buf == Pos);
  buf(flip1) = Pos;     buf(flip2) = Neg;
  covS(revn,:) = buf;
 
  [covzp, zcount] = packbituint8(covS(:,1:(k-1)),Zer);
  [covnp,ncount] = packbituint8(covS(:,1:(k-1)),Neg); 
  [covpp,dum] = packbituint8(covS(:,1:(k-1)),Pos);
  zs = find(covS(:,k) == Zer);
  zerzp = covzp(:,zs); 
  zerzp =sortrows(zerzp')';

  ps = find(covS(:,k) ==  Pos);
  ns = find(covS(:,k) ==  Neg);
  revp = revb((covS(revb,k) ~= Zer));
  nsr = [ns; revp];
  negzp  = covzp(:,nsr);
  negnp = [covnp(:,ns), covpp(:,revp)]; 
  negpp = [covpp(:,ns), covnp(:,revp)];
 % negsign = [negnp;negpp]; 

  covS = [];   
  covbmp  = zerzp;  covcmb = zeros(2,size(zerzp,2));
  candbuf = cell(0,1); cmbbuf =cell(0,1); buflen = 0;
  if length(ps) > 0
     lastm = ps(length(ps));
  end;
  bufmaxlen = max(3*length(nsr),1000);
     
 
%  disp(size(ps,1)*size(nsr,1));
  numgcands = 0; numcands = 0;
  keeps = uint32((1:length(nsr))');
  cancelcheck = nirrev < k-1;
  if cancelcheck
    negsignp = packs(negnp,negpp, (nirrev+1):(k-1) );
    negorz =  bitor(covzp(:,ps),covnp(:,ps));
    posorz =  bitor(covzp(:,ps),covpp(:,ps));
    possignp = packs(negorz,posorz, (nirrev+1):(k-1) );
    negorz = []; posorz = [];
  end;
  
  for i = 1:length(ps)
    m=ps(i);
    if cancelcheck
%      negorz =  bitor(covzp(:,m),covnp(:,m));
%      posorz =  bitor(covzp(:,m),covpp(:,m));
%      possign = [negorz;posorz];
%      keepsb = ~nosuperset(possign,negsign);
%      keeps = find(keepsb);
%      [keepsb,keeps] = superset(possign,negsign);
      [keepsb,keeps] = superset(possignp(:,i), negsignp);
      keepsb = [];
    end;
    numcands =  numcands+length(keeps);
    candszp = negzp(:,keeps);  
    candszp = andvecmat(covzp(:,m), candszp); 
    gcands = tcountbits(candszp) >= minzeroes-1;

    
    tmp = candszp(:,gcands);  buflen = buflen+length(tmp);
    candbuf{length(candbuf)+1} = tmp;
    tmp =  uint32(keeps(gcands))'; tmp = [repmat(uint32(m),1,length(tmp));tmp];
    cmbbuf{length(cmbbuf)+1} = tmp;
    numgcands = numgcands + length(tmp);
  
    if (m == lastm) || (buflen > bufmaxlen)  
      ncandszp = horzcat(candbuf{1:length(candbuf)});
      ncombs = horzcat(cmbbuf{1:length(cmbbuf)});
      if length(ncandszp) == 0
         ncandszp = covzp(:,[]); ncombs = zeros(2,0);
      end;
      candbuf = cell(0,1); cmbbuf =cell(0,1); buflen = 0;
       
      [ncandszp,ind] = sortrows(ncandszp');
      ncandszp = ncandszp';
      cmp = ssuperset(covbmp,ncandszp,k-1);
      keep1 = find(cmp <= 0);
      ncandszp = ncandszp(:,keep1);
      ncombs = ncombs(:,ind(keep1));
      cmp = cmp(keep1,:);
      if (length(revp) > 0)&&(length(ncombs) > 0)
        revchk = ncombs(1,:) ~= nsr( ncombs(2,:),:)'; 
        ncandszp = ncandszp(:,revchk);
        ncombs = ncombs(:,revchk);
        cmp = cmp(revchk,:);
      end;
      cmp2 = ssuperset(ncandszp,ncandszp,k-1);
      keep2 = find( (cmp2 <=0) | ( cmp2 == (1:length(cmp2))' ) );
      ncandszp = ncandszp(:,keep2);
      cmp = cmp(keep2,:);
      rem = ssuperset(ncandszp,covbmp,k-1) > 0;
      [ico,ica] = mergeinds(rem,-double(cmp));  
      covn  = uint32(false(size(covbmp,1), length(ico) + length(ica)));
      covc = zeros(2,length(ico) + length(ica));
      ncombs = ncombs(:,keep2);
      if length(ico) ~= 0
       covn(:,ico) = covbmp(:,~rem);
       covc(:,ico) = covcmb(:,~rem);
      end;
      if length(ica) ~= 0
        covn(:,ica) = ncandszp;  
        covc(:,ica) = ncombs;
      end;
%    if min(min( covn == sortrows( [covbmp(:,~rem),  ncandszp]')' )) == 0
%      disp('bad')
%      keyboard
%    end

      covbmp = covn; covn = [];
      covcmb = covc; covc = [];
      ncandszp = []; ncombs =[];
    end;
  end; 
  negsignp = [];  posignp  = []; ico = []; ica = [];  
  keeps = []; keep1 =[]; keep2 = []; ind = [];   
  if size(covbmp,2) == 0 
    covbmp = covzp(:,[]);  covcmb = zeros(2,0);
  else
    keep = covcmb(1,:) > 0;  
    if max(keep) == false
      keep = [];
    end;
    covcmb = covcmb(:,keep);  covbmp = covbmp(:,keep);
   end;
  
  MsgString = ...
        num2str([size(zerzp,2), numcands, ...
                 numgcands, size(covbmp,2)]);
  
  res = covcmb;
  ind = unpackbit(covbmp);
  ind = ind(:,1:(k-1));
  Sres= uint8(ind);
  Sres( ind) = Zer;
  Sres(~ind) = Pos;
  resneg = bitor(covnp(:,res(1,:)),negnp(:,res(2,:)));
  ind = unpackbit(resneg);
  ind = ind(:,1:(k-1));
  Sres(ind) = Neg;
  Sres = [Sres, repmat(Zer,size(Sres,1),1)];
 
  res = res';
  nsr = uint32(nsr);
  if FLIP
    res = [nsr(res(:,2)), res(:,1)];
  else 
    res = [res(:,1), nsr(res(:,2))];
  end;
%  res = int32(res);


function [xind,yind]  = mergeinds(xrem,ins)

global fid

  xlen = length(xrem);
  xind = (1:xlen)';
  inslen = length(ins);
  insind = (1:inslen)';
  
  off = zeros(xlen+inslen+2,1);
  mask = true(size(off));
  uins = ins + insind +1;
  off(uins) = 1;
  off = cumsum(off);
  mask(uins) = false;
  mask(1) = false;   mask(xlen+inslen+2) = false;
  off = off(mask);
  if size(off,1) == 0
    off = zeros(0,1);
  end;

  cxrem = cumsum(xrem);
  if size(cxrem,1) == 0
    cxrem = zeros(0,1);
  end;
  xind = xind +off - cxrem;
  xind = xind(~xrem);
  cxrem = [0;cxrem];
  yind = ins+ insind - cxrem(ins+1);

function res = packs(A,B,keep)

  Au = unpackbit(A);   Bu = unpackbit(B);
  AB = [Au(:,keep),Bu(:,keep)];
  [res,dum] = packbituint8( uint8(AB), uint8(true));