/***************************************************************************

Author: Robert  Urbanczik
Call:  C = superset(A,B)   or   [C,D] = superset(A,B)
       A   : np by m uint32-Array
       B   : np by l uint32-Array
       C   : l by 1 logical array
Does:  C(i) is true iff a  bitmap A(:,j) is a superset of B(:,i),
       i.e. iff  bitand(A(:,j), B(:,i)) ~=  B(:,i) holds for all
                 j = 1,...,m
       D = uint32(find(C))

***************************************************************************/
#include <math.h>
#include <stdio.h>
#include "mex.h"

#define	A_IN	prhs[0]
#define	B_IN	prhs[1]
#define	C_OUT	plhs[0]
#define	D_OUT	plhs[1]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned long int  *A,*Al,*B,*Bl,*a,*aa,*b,*b_next,*bb,*D;
    unsigned char *C,*c,nomatch;
    unsigned int d1A,d2A,d2B,cnt; 
    unsigned int i;
    const int *dimp;
    int dd[2];
    
    /* Check for proper number of arguments */
 
   if (nrhs != 2) { 
	mexErrMsgTxt("Two input arguments required."); 
    } else if (nlhs > 2) {
	mexErrMsgTxt("Too many output arguments."); 
	} 

    dimp =  mxGetDimensions(A_IN);
    d1A = dimp[0];
    d2A = dimp[1];
    dimp =  mxGetDimensions(B_IN);
    d2B = dimp[1]; 

    dd[0] = d2B;
    C_OUT = mxCreateNumericArray(1, dd, mxLOGICAL_CLASS, mxREAL);

    if (d1A == 0) return;
    
    A = mxGetData(A_IN); 
    B = mxGetData(B_IN);
    C = mxGetData(C_OUT);
        
    c = C; b = B; Al = A+d1A*d2A;  Bl = B+d1A*d2B; cnt = 0;

    while( b < Bl) {
	a = A; b_next = b+d1A; 
     do {
	nomatch = 0;  bb  = b;  aa = a;
        do {
	  if ((~(*a))&(*bb) )  {nomatch =1; a = aa+d1A;  break; };
          bb++;  a++;
        } while (bb < b_next);
	if (nomatch == 0)  {*c = 1; cnt++; break;}
       } while (a < Al );
     c++;  b = b_next;  };

    if (nlhs == 2) {
      dd[0] = cnt;
      D_OUT = mxCreateNumericArray(1, dd, mxUINT32_CLASS, mxREAL);
      D = mxGetData(D_OUT);
      for (cnt = 1; cnt <= d2B; cnt++) {
        if (*C) {*D = cnt; D++;};
        C++;}
    };
}


