(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10296,        409]*)
(*NotebookOutlinePosition[     11141,        439]*)
(*  CellTagsIndexPosition[     11053,        433]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Computing elementary fluxes given the stoichiometry matrix
\
\>", "Title",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->16,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[TextData[{
  "HINT:  Evaluating the tutorial will be a much more lively experience, if \
you now choose \"",
  StyleBox["Delete all output",
    FontSlant->"Plain"],
  "\" in the ",
  StyleBox["Kernel ",
    FontSlant->"Plain"],
  "menu. "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell["\<\
Since we shall need to read in some data, first check that you are \
in the SNA tutorials directory. Executing the command\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \("/home/robert/SNA/tutorials"\)], "Output"]
}, Open  ]],

Cell["\<\
should give above a line with a path ending with \"SNA/tutorials\".\
\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}]
}, Open  ]],

Cell[CellGroupData[{

Cell["If this is ok, we can now load the SNAmat package using", \
"Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< "\<../mathcode/SNAmat.m\>"\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "If the package is correctly loaded the above line should look similar to\n\
",
  StyleBox["LinkObject[../mathcode/../pairelvs/pairelvsIFsh, ... ]",
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We now read in a stoichiometry matrix, but first the source of the \
matrix is acknowledged:\
\>", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<!cat succinate.dat | grep @\>", "\<Lines\>"]\  // 
      TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"@ Stoichiometry matrix of the Succinate metabolism of the E. \
Coli network, \"\>"},
          {"\<\"@ taken from:\"\>"},
          {"\<\"@            S.Klamt, J. Stelling, Mol. Biol. Rep, 29, 2002, \
233-236\"\>"},
          {"\<\"@\"\>"},
          {"\<\"@ The first 18 columns are reversible.\"\>"},
          {"\<\"@\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        "@ Stoichiometry matrix of the Succinate metabolism of the E. Coli \
network, ", "@ taken from:", 
        "@            S.Klamt, J. Stelling, Mol. Biol. Rep, 29, 2002, \
233-236", "@", "@ The first 18 columns are reversible.", "@"}]]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(stoichreal\  = 
        Import["\<!cat succinate.dat | grep -v @\>", "\<Table\>"];\)\)], \
"Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["This is  a 30 by 45 matrix,", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stoichreal // Dimensions\)], "Input"],

Cell[BoxData[
    \({30, 45}\)], "Output"]
}, Open  ]],

Cell["with the second row :", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stoichreal[\([2]\)]\)], "Input"],

Cell[BoxData[
    \({0.`, 0.`, \(-1.`\), 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, \(-1.`\), 
      1.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 
      0.`, 0.`, 0.`, 0.`, 0.`}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The numbers in the matrix are reals, notice the decimal point.  This is \
unsuitable for SNAmat, so we convert ",
  StyleBox["stoichreal",
    FontWeight->"Bold"],
  " to rational numbers using:"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->0,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(stoich\  = \ real2rat[stoichreal];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stoich[\([2]\)]\)], "Input"],

Cell[BoxData[
    \({0, 0, \(-1\), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, \(-1\), 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "We can now calculate the elementary fluxes using the following command \
(the second argument states that the first 18 columns of ",
  StyleBox["stoich",
    FontWeight->"Bold"],
  " are reversible):"
}], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\({elfluxs, \ rev}\  = \ fluxelvs[stoich, 18];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The list ",
  StyleBox["elfluxs",
    FontWeight->"Bold"],
  " consists of the 4250 elementary fluxes"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[elfluxs]\)], "Input"],

Cell[BoxData[
    \({4250, 45}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The first ", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rev\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell["\<\
of these are reversible. (So in this case none are \
reversible.)\
\>", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell["The second elementary flux, for example, is", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(elfluxs[\([2]\)]\)], "Input"],

Cell[BoxData[
    \({8, 0, 0, 0, 0, 0, 0, 0, 4, 6, 0, 0, 0, 0, \(-4\), 6, 0, 40\/3, 0, 7, 
      2, 0, 0, 0, 0, 0, 0, 4, 0, 0, 2, 0, 4, 0, 2, 0, 4, 0, 28\/3, 0, 0, 0, 
      0, 4, 0}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
If you don't need all elementary fluxes, but just a minimal \
generating set of the flux cone use:\
\>", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({gsfluxs, \ rev}\  = \ fluxgset[stoich, 18];\)\), "\n", 
    \(Dimensions[gsfluxs]\)}], "Input"],

Cell[BoxData[
    \({230, 45}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "In the course of computation the SNA routines can generate quite a lot of \
informative messages. If you want to look at the messages generated so far, \
open the Messages notebook from the Window menu. However,to find out what all \
the numbers mean, you'll have to peruse the source code in SNAmat.nb. The \
output of informative messages can be controlled by setting the variable ",
  StyleBox["chatter",
    FontWeight->"Bold"],
  "."
}], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?chatter\)\)], "Input"],

Cell[BoxData[
    \("With default setting, chatter = 1, the SNA routines print out all \
kinds of intermediate stuff to the Messages notebook. chatter = 0: shut  up, \
chatter = -1: output goes to the evaluation notebook."\)], "Print",
  CellTags->"Info3340453871-1510696"]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
CellGrouping->Manual,
WindowSize->{670, 644},
WindowMargins->{{106, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3340453871-1510696"->{
    Cell[10007, 402, 273, 4, 55, "Print",
      CellTags->"Info3340453871-1510696"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3340453871-1510696", 10942, 426}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 259, 10, 65, "Title",
  Evaluatable->False],
Cell[2016, 63, 431, 16, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2472, 83, 330, 10, 66, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2827, 97, 44, 1, 31, "Input"],
Cell[2874, 100, 62, 1, 46, "Output"]
}, Open  ]],
Cell[2951, 104, 268, 10, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3256, 119, 257, 8, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3538, 131, 62, 1, 31, "Input"],
Cell[3603, 134, 89, 1, 23, "Print"]
}, Open  ]],
Cell[3707, 138, 377, 12, 57, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[4121, 155, 232, 8, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4378, 167, 109, 2, 31, "Input"],
Cell[4490, 171, 794, 19, 149, "Output"]
}, Open  ]],
Cell[5299, 193, 121, 3, 31, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5457, 201, 159, 5, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5641, 210, 57, 1, 31, "Input"],
Cell[5701, 213, 42, 1, 46, "Output"]
}, Open  ]],
Cell[5758, 217, 144, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5927, 226, 52, 1, 31, "Input"],
Cell[5982, 229, 290, 4, 78, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6321, 239, 366, 12, 66, "Subsubsection",
  Evaluatable->False],
Cell[6690, 253, 71, 1, 31, "Input"],

Cell[CellGroupData[{
Cell[6786, 258, 48, 1, 31, "Input"],
Cell[6837, 261, 193, 3, 62, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7079, 270, 347, 11, 66, "Subsubsection",
  Evaluatable->False],
Cell[7429, 283, 81, 1, 31, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7547, 289, 240, 10, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7812, 303, 52, 1, 31, "Input"],
Cell[7867, 306, 44, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7948, 312, 133, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8106, 321, 36, 1, 31, "Input"],
Cell[8145, 324, 35, 1, 46, "Output"]
}, Open  ]],
Cell[8195, 328, 196, 8, 30, "Text",
  Evaluatable->False],
Cell[8394, 338, 166, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8585, 347, 49, 1, 31, "Input"],
Cell[8637, 350, 196, 3, 98, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8894, 360, 238, 8, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9157, 372, 119, 2, 47, "Input"],
Cell[9279, 376, 43, 1, 46, "Output"]
}, Open  ]]
}, Open  ]],
Cell[9349, 381, 585, 14, 112, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9959, 399, 45, 1, 31, "Input"],
Cell[10007, 402, 273, 4, 55, "Print",
  CellTags->"Info3340453871-1510696"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

