#include <iostream>
#include "graph.h"
#include "mytypes.h"
#include "algostuff.hpp"
#include "util.h"

/////////////////////////////////////////////
Graph::Graph() { }

/////////////////////////////////////////////
Graph::Graph(const Graph & gIn) {
 vNodes = gIn.vNodes;
 iV = gIn.vNodes.size();
}

/////////////////////////////////////////////
Graph::Graph( std::vector<Node> vNodes_in ) {
 vNodes = vNodes_in;
 iV = vNodes.size();
 //cout << "Graph( vNodes) Contructor, iv =" << iV << endl;
}

/////////////////////////////////////////////
Graph::~Graph() { }


/////////////////////////////////////////////
// i am here. These three functions are not verified yet!!!
void Graph::_set_pairs_in_by_mliiEdges( ) {

 pairs_in.clear();

 MLMAP_ii_t::iterator itr; 
 for ( itr=mliiEdges.begin(); itr!=mliiEdges.end(); ++itr ) { 
   int pos1= itr->first; 
   int pos2= itr->second;
   string id1 =  v_ordered_ids[ pos1 ];
   string id2 =  v_ordered_ids[ pos2 ];
   if ( isDirected ) {
     pairs_in.push_back( make_pair( id1, id2 ) );   
   } else {
     small2big_swap( id1, id2);  
     pairs_in.push_back( make_pair( id1, id2 ) ); 
   }
 }
 
 sort( pairs_in.begin(), pairs_in.end() );
}

void Graph::_set_int2NodePtr_lookup_table_by_vNodes( ) {
 v_int2NodePtr.clear();
 v_int2NodePtr.reserve( vNodes.size() );
 
 for ( int i=0; i<vNodes.size(); ++i ) {
     int idx = vNodes[i].iRank;
     Node * ptr = & vNodes[i];
     v_int2NodePtr[ idx ]  = ptr;
 }
}

void Graph::_set_mlmap_pos2pos_edges_by_mliiEdges() {
 int debug=1;
 MLMAP_ii_t::iterator itr;

 ml_pos2pos_edges.clear();

 for ( itr= mliiEdges.begin(); itr!= mliiEdges.end(); ++itr ) {
   int pos1 = itr->first;
   int pos2 = itr->second;
 
   ml_pos2pos_edges.insert( make_pair(pos1, pos2)  );
   if ( ! isDirected ) { ml_pos2pos_edges.insert( make_pair(pos2, pos1) ); }
 }
 
 if (debug) {
   std::multimap<int, int>::iterator itr;
   for (itr=ml_pos2pos_edges.begin(); itr!= ml_pos2pos_edges.end(); ++itr) {
       cout<< itr->first << " : " << itr->second << endl;
   }
 }
}

int Graph:: reassign_neighbours_by_mliiEdges(  MLMAP_ii_t & mliiIn  ){ // i am here 102903Wed night
 int debug = 1;
 MLMAP_ii_t::iterator itr;

 clear_neighbours();
 clear_temporary_buffers( ); 

 set_mliiEdge( mliiIn );

 _set_pairs_in_by_mliiEdges( );
 _set_int2NodePtr_lookup_table_by_vNodes( );   	
 _set_mlmap_pos2pos_edges_by_mliiEdges();

 for ( int i=0; i<vNodes.size(); ++i ) {
    int iKey_from = vNodes[i].iRank;
    if (debug) { cout << "iKey_from =" << iKey_from << " " ;}
    for ( itr  = ml_pos2pos_edges.lower_bound(iKey_from);
          itr != ml_pos2pos_edges.upper_bound(iKey_from); ++itr ) {
        if (debug) {
           cout <<  vNodes[itr->first].pId << " : " <<  vNodes[itr->second].pId << endl;
        }
        vNodes[itr->first].vpNeighbors.push_back( v_int2NodePtr[itr->second] );
    }
    if (debug) { cout << endl; }
 }

 return 0;
}   


/////////////////////////////////////////////
void Graph::clear_neighbours(  ) {
 for ( int i=0; i<vNodes.size(); ++i ) {
     vNodes[i].vpNeighbors.clear();
 } 
}

void Graph::clear_temporary_buffers( ) {
 clear_pairs_in( );
 clear_m_id2pos( );
}

void Graph::clear_pairs_in( ) {
 pairs_in.clear();
}

void Graph::clear_m_id2pos( ) { 
 m_id2pos.clear();
}

//i am here 102903Wed

/////////////////////////////////////////////

int Graph::set_pairs_in( vector<PAIR_str_t> & pairs_in ) {
 for ( int i=0; i<pairs_in.size(); ++i ) {
   this->pairs_in.push_back( make_pair( pairs_in[i].first, pairs_in[i].second ) );
 } // i am here
 return 0;
}
        
int Graph::set_nr_ids( SET_str_t & st_nr_ids ) {
 SET_str_t::iterator itr;
 for ( itr= st_nr_ids.begin(); itr != st_nr_ids.end(); ++itr ) {
   this->st_nr_ids.insert( * itr );
 }
 return 0; // i am here
}
        
int Graph::set_ordered_ids( VECTOR_str_t & ordered_ids ) {
 for ( int i=0; i< ordered_ids.size(); ++i ) {
   this->v_ordered_ids.push_back( ordered_ids[i] );
 }
 return 0; // i am here
}
        
int Graph::set_id2pos( std::map<string, int> & m_id2pos ) {
 std::map<string, int>::iterator itr;
 for ( itr=m_id2pos.begin(); itr!= m_id2pos.end(); ++itr ) {
  this->m_id2pos.insert( make_pair( itr->first, itr->second  ) );
 }
 return 0; // i am here
}

int Graph::set_mliiEdge( MLMAP_ii_t & mliiIn ) { 
 int debug=1;

 mliiEdges.clear();

 MLMAP_ii_t::iterator itr;
 for (itr=mliiIn.begin(); itr!=mliiIn.end(); ++itr) {
   mliiEdges.insert( make_pair(itr->first, itr->second) ); //i am here 101703Mon ???
 }
 if (debug) { 
  cout<<"Graph::set_mliiEdge():: mliiIn.size()=" << mliiIn.size() <<endl;
  cout<<"Graph::set_mliiEdge():: mliiEdges.size()=" << mliiEdges.size() <<endl;  
 }
 return 0;
}

/////////////////////////////////////////////
/*
Graph Graph::generate_MS02_null_no_self_pairing() {
 Graph gMS02 = Graph( vNodes );

 return gMS02;
}
*/

/////////////////////////////////////////////
int Graph::print_graph_in_adj_list( ostream& os ) {
 int debug=1;
 for ( int i=0; i<vNodes.size(); ++i ) {
    os << vNodes[i].pId << "\t";
    if (debug) { cout << "neighbours " << vNodes[i].vpNeighbors.size() << " "; }
    for ( int j=0; j<vNodes[i].vpNeighbors.size(); ++j ) {
       os << vNodes[i].vpNeighbors[j]->pId << "\t";
    }
    os << endl;
 }
 return 0;
}

int Graph::print_graph_in_adj_list(  ) {  
 print_graph_in_adj_list( cout );
 return 0;
}

int Graph::print() {
 cout << "\n\t----graph " << this << "\t----\n";
 print_graph_in_adj_list( cout ); 
 PRINT_ELEMENTS( st_nr_ids,  "\nSET_str_t  st_nr_ids :\n");
 PRINT_ELEMENTS( v_ordered_ids,  "\nv_ordered_ids :\n");
 cout <<endl;
 if ( pairs_in.size() > 0 ) {
  cout << "pairwise edges:\n";
  print_pairs_in( cout );
 }
 return 0; 
}

int Graph::print_pairs_in( ostream& os, char* header ) {  
 os << header;
 print_pairs_in( os );
 return 0;
}

int Graph::print_pairs_in( ostream& os ) {  
  for ( int i=0; i <pairs_in.size(); ++i ) {
    os << pairs_in[i].first << "\t" << pairs_in[i].second << "\n";
  }
 return 0;
}
