/*
 Generate a MS02 null graph;
to do: noise introdution
*/
#include <string>
#include <iostream>
#include <map>
//#include <iomanip>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>

using namespace std;        

typedef struct {
 int    verbose;
 int 	debug;
 char   input_pairwise_tab[1024];
 char   input_id2category_tab[1024];
 char   output_pairwise_tab[1024];
} OPTION_PARA;
 
static OPTION_PARA myoption;


int main(int argc, char *argv[]){
 myoption.verbose=0;
 myoption.debug  =0;
// strcpy (myoption.input_pairwise_tab, "_none_");

/* char* ctest= "hello world";
 char ctmp2[100];
 char* ctmp3= new char[100];
 strcpy( ctmp2, ctest );
 strcpy( myoption.input_pairwise_tab, ctest );
 cout << ctmp2 <<endl;
 cout << myoption.input_pairwise_tab <<endl; */

 int c;

 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",       required_argument, 0, 'i'},
          {"name2category_tab_in",  optional_argument, 0, 'c'},
          {"output_pairwise_tab",   optional_argument, 0, 'o'},
          {"debug",  		    optional_argument, 0, 'd'},
          {"verbose", 		    no_argument,  &myoption.verbose, 1},
          {"brief",   		    no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:c:o:d:", long_options, &option_index);
 
      if (c == -1)        break;
 
      switch (c)   {
        case 0 :	break;

        case 'd':
          cout<< "option -d\n" << optarg << endl;
          break;

        case 'v':
          cout<< "option -vn" << optarg << endl;
          break;
 
        case 'i':
	  cout << "option i, optarg is " << optarg << endl;
	  strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'c':
	  cout << "case c, optarg is " << optarg << endl;
	  strcpy( myoption.input_id2category_tab, optarg );
          break;
 
        case 'o':
          strcpy( myoption.output_pairwise_tab, optarg );  
          break;
 
        case '?':
          break;
 
        default:
          abort ();
        }
 } //while loop

 if (myoption.verbose) {
  cout << "myoption:" << endl  << "\tverbos\t" << myoption.verbose << endl;
  cout << "\tdebug\t" << myoption.debug<<endl;
  if ( myoption.input_pairwise_tab ) {
  cout << "\tinput_pairwise_tab\t"  << myoption.input_pairwise_tab << endl; }
  if ( myoption.output_pairwise_tab ) {
  cout << "\toutput_pairwise_tab\t" << myoption.output_pairwise_tab << endl; }
 }
 
 cout << "---------------------------";

 if ( myoption.input_pairwise_tab[0] == '\0' ) {
  cout << "\n\tOptions\n\t{\"in_pairwise_tab\",       required_argument, 0, 'i'},
          {name2category_tab_in,  optional_argument, 0, 'c'},
          {\"output_pairwise_tab\",   optional_argument, 0, 'o'},
          {\"debug\",                 optional_argument, 0, 'd'},
          {\"verbose\",               no_argument,  &myoption.verbose, 1},
          {\"brief\",                 no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        }	\n";
  return 1;
 }

 CPairs_Parser parser1;
 string file2 = "data/states.tab";
 Graph g, g2; 

 string file =  myoption.input_pairwise_tab;
// cout << "\nfile is " << file << endl;
 string file_name;

 set_shortfile_name(  file, file_name );
 cout 	<< "set_shortfile_name( file, file_name )\n" << "filename is now:\"" <<file_name<< "\""<<endl;

 long tp;
 time (&tp);
 srand (tp);
 MyRandom rd;

///////test util::find_a_new_position_for_the_first_redundant_pair_position()
 //	       0  1  2  3   4 5   6 7  8 9  0 1  2  3
 int  ar[] = { 2, 3, 2, 3,  2,5,  6,7, 3,9, 0,2, 12,13  };
 VI vi;
 VI viPairs, viNew;

 array_to_vector_int( ar, vi, 14 );      

 find_positions_of_first_redundant_pairs( vi, viPairs );
 find_a_new_position_for_the_first_redundant_pair_position( vi, viPairs, viNew );
 swap_positions_in_vector( vi, viPairs, viNew );  

 return 0;
}
