/*
 Single source dijkstra shortest path of randomly selected nodes.
 Return shortest-path for each group of randomly selected nodes.
 The number of random nodes is decided by a input reference file of nodes.
 (c) Hogn Qin Dec 13, 2005 hong_man@yahoo.com
*/
#include <stdlib.h>
#include <string>
#include <iostream>
#include <map>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>
#include "mapdictionary.h"

#include <fstream>
#include "dijkstra.h"
#include "node_parser.h"
using namespace std;        

typedef struct {
 int    verbose;
 int 	debug;
 int    num_itr;		   // num of indepdent runs 
 char   input_pairwise_tab[1024];  //input network
 char   input_node_tab[1024];      //input node file as reference
 char   output_path_file[1024];    // output prefix
} OPTION_PARA;
 
static OPTION_PARA myoption;

int main(int argc, char *argv[]){
 myoption.verbose  =0;
 myoption.debug    =1;
 myoption.num_itr  =2;   //change this

 int c;

 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",           required_argument, 0, 'i'},
          {"node_tab_reference", 	optional_argument, 0, 'r'},
          {"output_path_prefix",   	optional_argument, 0, 'o'},
          {"num of runs",  		optional_argument, 0, 'n'},
          {"debug",  		    	optional_argument, 0, 'd'},
          {"verbose", 		    	no_argument,  &myoption.verbose, 1},
          {"brief",   		    	no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:r:o:n:d", long_options, &option_index);
 
      if (c == -1) break;
 
      switch (c)   {
        case 0 :	break;

        case 'd':
          cout<< "option -d\n" << optarg << endl;
	  myoption.debug = atoi( optarg );
          break;
 
        case 'i':
	    cout << "option i, optarg is " << optarg << endl;
	    strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'r':
	    cout << "case n, optarg is " << optarg << endl;
	    strcpy( myoption.input_node_tab, optarg );
          break;
 
        case 'o':
          strcpy( myoption.output_path_file, optarg );  
          break;
 
        case 'n':
          cout<< "option -n " << optarg << endl;
	  myoption.num_itr = atoi( optarg );
          break;

        case '?':
          break;
 
        default:
          abort ();
        }
 } //while loop

 int debug = myoption.debug;

 long tp;     time (&tp);    srand (tp);

 Graph g, g2, g1;
 CPairs_Parser parser1;
 Dijkstra dk1;
 CNode_Parser np1;
 MyRandom  rd;

 if (debug) { 
  cout<< "input_pairwise_tab =" << myoption.input_pairwise_tab<<endl;
  cout<< "input_node_tab=" << myoption.input_node_tab<<endl;
 } 

 string longfile =  myoption.input_pairwise_tab;
 string node_file = myoption.input_node_tab;     
 
 np1.set_vsIds_frm_fl( node_file );

 parser1.generate_undirected_graph_without_self_pairing(longfile, g1 );
 if (debug) {  cout<<"The graph is "; 
   g1.print(); 
 }

 std::vector<Node*> vpPath;
 std::vector<Node*> vpNodes;  //the random nodes for dijk-path
 std::vector< std::vector<Node*> * > vpvpReturnPaths; 
 char buffer[10];

 std::vector<unsigned> vnPos; // for random shuffling;
 for (unsigned i=0; i<g1.vNodes.size(); ++i) {
   vnPos.push_back(i);
 }

for ( int kk=0; kk< myoption.num_itr; kk ++ ) {
 vpNodes.clear();

 //generate random nodes
 std::random_shuffle( vnPos.begin(), vnPos.end(), rd);
 for ( unsigned i=0; i<np1.vsIds.size(); ++i ) {  
     vpNodes.push_back( & g1.vNodes[ vnPos[i] ] );  
 } 

 /* std::random_shuffle( g1.vNodes.begin(), g1.vNodes.end(), rd);
 for ( unsigned i=0; i<np1.vsIds.size(); ++i ) {
       vpNodes.push_back( & g1.vNodes[i] );   // This somehow alters g1?!
 } */

 itoa( kk, buffer );
 string sBuffer1 = (string) buffer;
 string sBuffer2 = (string) myoption.output_path_file;
 string sTmp = sBuffer2 + "." + sBuffer1 + ".txt";
 ofstream outfile( sTmp.c_str() );

 for( unsigned k=0; k < (vpNodes.size() -1); ++k) { 
  vpvpReturnPaths.clear();
  cout <<">source is "<< vpNodes[k]->pId <<"\n";
  outfile <<">source is "<< vpNodes[k]->pId <<"\n";
  dk1.dijkstra_noweight( & g1, vpNodes[k] );
      g1.print(); 
  dk1.multiple_trace_back( vpNodes, vpvpReturnPaths );
  for( unsigned i=k; i<vpvpReturnPaths.size(); ++i) {
    std::vector<Node*> vpTmpPath = * vpvpReturnPaths[i];
    // outfile <<"#Path " <<i << " is:\n";
    for( unsigned j=0; j<(vpTmpPath.size() -1); ++j ) {
     outfile<< vpTmpPath[j]->pId<<"<-";
    }
   outfile << vpTmpPath[ vpTmpPath.size()-1 ]->pId <<endl;
  }//i
  outfile<<"\n";
 }//k

 outfile.close();

}//kk

 return 0;
}
