#include "dijkstra.h"
#include <iostream>

using namespace std;

const float dMAX=999999; //maximal distance

Dijkstra::Dijkstra () {};

Dijkstra::~Dijkstra () {};



/*****************The temporary functions*****************************/

void _print_predecessor( Node * pX ) {
 if ( pX->pPredecessor ) {
   cout << pX->pPredecessor->pId;
 } else {
   cout << pX->pPredecessor;
 }
}


int _check_convergence( std::vector< std::vector<Node*> *> & vpvpPaths ) {
    for( unsigned i=0; i< vpvpPaths.size(); ++i ) {
        std::vector<Node*> * pvPathOne =  vpvpPaths[i];
        for( unsigned j=i; j<vpvpPaths.size(); ++j ) {
            std::vector<Node*> * pvPathTwo =  vpvpPaths[j];
            Node * pEndOne = (* pvPathOne)[pvPathOne->size()-1];
            Node * pEndTwo = (* pvPathTwo)[pvPathTwo->size()-1];
            if ( (string) pEndOne->pId != (string) pEndTwo->pId) {
                return 0;  //return no
            }
        }
    }
    return 1; //return yes
}


float _find_weight_bw_nodes( Node * pOne, Node * pTwo ) {
    for( unsigned i=0; i< pOne->vpNeighbors.size(); ++i) {
        if( (string) pOne->vpNeighbors[i]->pId == (string) pTwo->pId ) {
            return pOne->vnWeights[i];
        }
    }
    return dMAX;
}

void _print_path( std::vector<Node*> * pvCurrentPath ) {
   for (unsigned i=0; i< pvCurrentPath->size(); ++i ) {
       cout << (* pvCurrentPath)[i]->pId << "<-";
   }
   cout << endl;
}

int _is_there( Node * pNode1, std::vector<Node*> * pvpNodes ) {
 for( unsigned i=0; i< pvpNodes->size(); ++i ) {
     if ( (string) pNode1->pId == (string) (* pvpNodes)[i]->pId ) {
         return 1;  //yes
     }
 }
 return 0; // node1 is not in vNode
}


/************ end of temporary funcitons ***************/





/****************************************************
// non-directional graph, weighted edges
*****************************************************/
int Dijkstra::dijkstra_weight( Graph* pGIn, Node* pS ) {
 int debug=0;
 initialize_single_source ( pGIn, pS ) ;
 set_vpS();
 set_vpQ(); //contain all the nodes in random order
 while( vpQ.size() ) {
   Node* pU;

   pU = extract_min( vpQ );  //do I have change here???
   if (debug) { cout << "extracted pU is " << pU->pId << endl; }
   vpS.push_back( pU );     // insert pU

   std::vector<Node*> vpN = pU->vpNeighbors;
   std::vector<float> vnW = pU->vnWeights;

 //   std::random_shuffle( vpN.begin(), vpN.end() );

     for ( unsigned i=0; i< vpN.size(); ++i ) {
//   for ( itr= vpN.begin(); itr != vpN.end(); ++itr ) {
     Node * pV = vpN[i];
     if (debug) {
        cout << "Now try to relax " << pV->pId << "(" << vnW[i];
        cout << ")" << endl;
     }
     relax ( pU, pV, vnW[i] );   // Relaxation of pU's neighbours change here?! 020106
   }//for
 } //while
 return 1;
}


/****************************************************
 Find all shortest-paths from pV to pSource
 "threshold" influences the number of alternative pathways
Precondition:  weighted, un-directional graph
Postcondition:  0 means no path
                1 means successful
Problems:   memory leak?
*****************************************************/
int Dijkstra::find_all_shortest_paths_w( Node* pV,
    std::vector< std::vector<Node*> *> & vpvpReturnPaths, float threshold) {
  int debug =1;
  unsigned isConverged = 0;

  if (debug) {cout <<"(w) pV->pId="<<pV->pId<< " vpvpReturnPaths.size()="<< vpvpReturnPaths.size()<<endl; }

  if ( pV->nD == dMAX ) {
      if (debug) { cout <<"Target is "<<pV->pId<<".  There is no path. Bye "<<endl; }
      return 0;
  }

  // initiate vpvpReturnPaths with pV
  std::vector<Node*> * pvpTMP = new std::vector<Node*> ;
  pvpTMP->push_back( pV );  //this is the end point for trace back
  vpvpReturnPaths.push_back( pvpTMP );

  if ( pV->nD == 0) { return 1; }

  if (debug) { cout <<"(w) vpvpReturnPaths.size()="<< vpvpReturnPaths.size()<<endl; }

  while ( isConverged == 0 ) {
    std::vector< std::vector<Node*> * > vpvpNewPaths = vpvpReturnPaths;
    // cout << "(in w) while loop" <<endl;
    for (unsigned i=0; i< vpvpReturnPaths.size(); ++i) { //enumerate all paths
        // cout << "(in w) i loop" << endl;
	    std::vector<Node*> * pvCurrentPath =  vpvpNewPaths[i];
        Node * pCurrentNode = (* pvCurrentPath)[ pvCurrentPath->size() - 1]; //this is current leaf node

        //find out next available moves
        std::deque< Node* > dpNextNodes;
        if( pCurrentNode->nD >0 ) {
            for( unsigned j=0; j< pCurrentNode->vpNeighbors.size(); ++j) {
                if ( _is_there( pCurrentNode->vpNeighbors[j], pvCurrentPath ) == 0 ) {
                    //float delta = pCurrentNode->nD - pCurrentNode->vnWeights[j];  //!!!!!!!!
                    if ( pCurrentNode->vpNeighbors[j]->nD <= ( pCurrentNode->nD + threshold) ) { //potential loop? cannot deal with zero distance.
                        dpNextNodes.push_back( pCurrentNode->vpNeighbors[j] );
                        cout <<"(w) next:"<< pCurrentNode->vpNeighbors[j]->pId << endl;
                    }
                }
            }//j
        }

        cout << "(in w) after finding dpNextNodes" <<endl;
        //update the paths
        if ( dpNextNodes.size() > 1 ) {
			//the number of path is increased here.
            for( unsigned k=1; k<dpNextNodes.size(); ++k) {
                std::vector<Node*> * pvpTMP2 = new std::vector<Node*>;  // a new path
                (*pvpTMP2) = ( * pvCurrentPath );       // copy the known steps
                pvpTMP2->push_back( dpNextNodes[k] );  // add the new step
                vpvpNewPaths.push_back( pvpTMP2 );     // I cannot insert after i-th path, because it destroys iteration sequence.
                // how free pvpTMP2?
            }
            pvCurrentPath->push_back( dpNextNodes[0] );  // the old path,
        } else {
			// only one addition
			pvCurrentPath->push_back( dpNextNodes[0] );
        }//fi
    }//i

    cout <<"(w) vpvpNewPaths.size()="<< vpvpNewPaths.size()<<endl;

    cout << "(w) before check vnSumPathWeights"<<endl;

    /** check the total length of each path, remove if they wildly exceed pV->nD **/
    std::vector<float> vnSumPathWeights;
    vnSumPathWeights.reserve( vpvpNewPaths.size() );
    for( unsigned i=0; i<vpvpNewPaths.size(); ++i) {
        std::vector<Node*> * pvCurrentPath =  vpvpNewPaths[i];
        float sum = 0;
        cout <<"(w)pvCurrentPath->size() ="<< pvCurrentPath->size() <<endl;
        _print_path( pvCurrentPath );
        for( unsigned j=1; j<pvCurrentPath->size(); ++j) {
            sum = sum + _find_weight_bw_nodes( (*pvCurrentPath)[j-1], (*pvCurrentPath)[j] ); //??
            //cout <<"(w)sum=" << sum << endl;
        }
        vnSumPathWeights.push_back(sum);
    }

	/** check and update isCoverged; **/
    //isConverged = _check_convergence( & vpvpReturnPaths );
    isConverged=1;  // initialization
    if( vpvpNewPaths.size() > 1 ) {

        /** pick out the good paths**/
        vpvpReturnPaths.clear();
        for( unsigned i=0; i<vpvpNewPaths.size(); ++i) {
            if ( vnSumPathWeights[i] < ( pV->nD + threshold )) {
                cout << "vnSumPathWeights[i]=" << vnSumPathWeights[i];
                cout << " ( pV->nD + threshold )=" << ( pV->nD + threshold )<<endl;
                vpvpReturnPaths.push_back( vpvpNewPaths[i] );
            }
        }

        cout <<"(w) vpvpReturnPaths.size()="<< vpvpReturnPaths.size()<<endl;
        cout <<"(w) before update isConverged"<<endl;

        for( unsigned i=0; i< (vpvpReturnPaths.size()-1); ++i ) {
            std::vector<Node*> * pvPathOne =  vpvpReturnPaths[i];
            for( unsigned j=i; j<vpvpReturnPaths.size(); ++j ) {
                std::vector<Node*> * pvPathTwo =  vpvpReturnPaths[j];
                Node * pEndOne = (* pvPathOne)[pvPathOne->size()-1];
                Node * pEndTwo = (* pvPathTwo)[pvPathTwo->size()-1];
                if ( (string) pEndOne->pId != (string) pEndTwo->pId) { // is this necessary?
                    isConverged=0;  // no
                }
            }
            //compare end with target
            if ( (*pvPathOne)[pvPathOne->size()-1]->nD != 0 ) {
                isConverged = 0;
            }

        }//for
    } else { //only one path, compare with target
        std::vector<Node*> * pvPathOne =  vpvpReturnPaths[0];
        if ( (*pvPathOne)[pvPathOne->size()-1]->nD != 0 ) {
            isConverged = 0;
        }
    }
    cout <<"(w) isConverged=" <<isConverged <<endl;
  }//while

  return 1;
}



/****************************************************
Find all shortest-paths from pV to pSource
Precondition:  unweighted, un-directional graph
Postcondition:
*****************************************************/
int Dijkstra::find_all_shortest_paths( Node* pV,
    std::vector< std::vector<Node*> *> & vpvpReturnPaths) {
  int debug =0;

  if ( pV->nD == dMAX ) {
      if (debug) { cout <<"Target is "<<pV->pId<<".  There is no path. Bye "<<endl; }
      return 0;
  }

  float nCurrentDistance = pV->nD;

  // initiate vpvpReturnPaths with pV
  std::vector<Node*> * pvpTMP = new std::vector<Node*> ;
  pvpTMP->push_back( pV );
  vpvpReturnPaths.push_back( pvpTMP );
	// delete pvpTMP;  ////??????????????

	while ( nCurrentDistance > 0 ) {
    std::vector< std::vector<Node*> * > vpvpNewPaths = vpvpReturnPaths;
    for (unsigned i=0; i< vpvpReturnPaths.size(); ++i) {
	    std::vector<Node*> * pvCurrentPath =  vpvpNewPaths[i];
        Node * pCurrentNode = (* pvCurrentPath)[ pvCurrentPath->size() - 1];
        //cout << "pCurrentNode->pId=" << pCurrentNode->pId << endl;
			//find next moves
        std::deque< Node* > dpNextNodes;
		for( unsigned j=0; j< pCurrentNode->vpNeighbors.size(); ++j) {
		   if ( pCurrentNode->vpNeighbors[j]->nD == (nCurrentDistance-1) ) {
				    dpNextNodes.push_back( pCurrentNode->vpNeighbors[j] );
				 }
			}//j

        //update the paths
        if ( dpNextNodes.size() > 1 ) {
			  //the number of path is increased here.
            for ( unsigned k=1; k<dpNextNodes.size(); ++k ) {
                std::vector<Node*> * pvpTMP2 = new std::vector<Node*>;  // a new path
                (*pvpTMP2) = ( * pvCurrentPath);        // copy the known steps
                pvpTMP2->push_back( dpNextNodes[k] );   // add the new step
                vpvpNewPaths.push_back( pvpTMP2 );      // store
            }
				pvCurrentPath->push_back( dpNextNodes[0] );  // the old path
        } else {
			  // only one addition
			  pvCurrentPath->push_back( dpNextNodes[0] );
			}//fi
		}//i

		-- nCurrentDistance;
		vpvpReturnPaths = vpvpNewPaths; //Will this work?
	}//while

	return 1;
}


/****************************************************
Precondition: single source dijkstra has to be called first.
Call:
 int Dijkstra::trace_back(Node* pV, std::vector<Node*> & vpMyPath )

Problem: memory leak?
Postcondition:
 Return the greedy shortest-paths for a list of nodes vpNodes
*****************************************************/
int Dijkstra::multiple_trace_back( std::vector<Node*> vpInNodes,
		std::vector< std::vector<Node*> * > & vpvpReturnPaths) {
 int debug=0;
 int nTmp;
 for ( unsigned i=0; i<vpInNodes.size(); ++i) {
   std::vector<Node*>  * pvTmpPath = new std::vector<Node*>; //memory leak?
   nTmp = trace_back( vpInNodes[i], * pvTmpPath );
   vpvpReturnPaths.push_back( pvTmpPath );
   if (debug ) { cout<<"vvpReturnPaths.size()="<<vpvpReturnPaths.size()<<endl; }
 }
 return 1;
}


/****************************************************
//trace back of a single version of shortest path
*****************************************************/
int Dijkstra::trace_back(Node* pV, std::vector<Node*> & vpMyPath ) {
 int debug=0;

 vpMyPath.clear();

 if(debug) {
    cout << "(trace) " << pV->pId << "'s predecessor is ";
    _print_predecessor( pV );
    cout << " source is " << pSource->pId<<endl;
  }

 if ( pV->pPredecessor == NULL ) {
   vpMyPath.push_back( pV );
   return 1;
 }

 while ( pV != pSource ) {
   if(debug) {
     cout << "trace_back to ";
     _print_predecessor( pV->pPredecessor );
     cout <<endl;
   }
   vpMyPath.push_back( pV );
   pV = pV->pPredecessor;
 }
 //now add the last one;
 vpMyPath.push_back( pSource );

 if (debug) {
  for(unsigned i=0; i<vpMyPath.size(); i++ ){
    cout<< vpMyPath[i]->pId << "<-" ;
  }
  cout<<endl;
  Node * pT = vpMyPath.back();
  cout<<"Last node is "<< pT->pId<<endl;
 }

 return 0;
}


/*
std::vector<Node*> Dijkstra::trace_back(Node* pV) {
 std::vector<Node*> vpMyPath, results;
 while ( pV->pPredecessor != pSource ) {
   vpMyPath.push_back( pV );
   pV = pV->pPredecessor;
 }
 results = new
 results = vpMyPath;
 return results;    	//can this return work?
}
*/

/****************************************************
   nondirected graph, no weight
*****************************************************/
int Dijkstra::dijkstra_noweight( Graph* pGIn, Node* pS ) {
 int debug=0;
 initialize_single_source ( pGIn, pS ) ;
 set_vpS();
 set_vpQ(); //contain all the nodes in random order
 while( vpQ.size() ) {
   Node* pU;

   pU = extract_min( vpQ );
   if (debug) { cout << "extracted pU is " << pU->pId << endl; }
   vpS.push_back( pU );     // insert pU

   std::vector<Node*>::iterator itr;
   std::vector<Node*> vpN = pU->vpNeighbors; //121205

 //   std::random_shuffle( vpN.begin(), vpN.end() );

   for ( itr= vpN.begin(); itr != vpN.end(); ++itr ) {
     Node * pV = (Node *) ( * itr) ;
     if (debug) { cout << "Now try to relax " << pV->pId << endl;  }
     relax ( pU, pV, 1 );     // Relaxation of pU's neighbours
   }//for
 } //while
 return 1;
}


int Dijkstra::initialize_single_source ( Graph * pGIn, Node * pS ) {
 pSource = pS;
 pG = pGIn;
 std::vector<Node>::iterator itr;

 for ( itr=pG->vNodes.begin(); itr != pG->vNodes.end(); ++itr ) {
   itr->nD = dMAX;
   itr->pPredecessor = NULL;
   itr->iTmp = 0;
 }

 pS->nD = 0;    // source
 pS->iTmp = 1;  // mark the source
 return 1;
}

void Dijkstra::test () {

}

/*************************************************
  protected functions
****************************************************/

void Dijkstra::set_vpS(){
  vpS.resize(0);
}

void Dijkstra::set_vpQ(){
 //int debug=0;
 vpQ.clear();
  for ( unsigned int i =0; i < pG->vNodes.size(); ++i ) {
    vpQ.push_back( & pG->vNodes[ i ] );
  }

 MyRandom rd;
 std::random_shuffle( vpQ.begin(), vpQ.end(), rd ); // ? 121205????

}


Node *  Dijkstra::extract_min( std::vector <Node*>  & vpQ ) {
 float nMin = dMAX;
 int debug=0;
 std::vector<Node*>::iterator itr;

 if (debug) { cout<<"(extract_min)Before shuffle vpQ are " ;
  for (unsigned i=0; i<vpQ.size(); ++i) { cout<< vpQ[i]->pId << " "; }
  cout <<endl;
 }

 // MyRandom rd;
 // std::random_shuffle( vpQ.begin(), vpQ.end(), rd ); // ? 121205????

 if (debug) { cout<<"(extract_min)After shuffle vpQ are " ;
  for (unsigned i=0; i<vpQ.size(); ++i) { cout<< vpQ[i]->pId << " "; }
  cout <<endl;
 }

 // first set nMin
 for ( itr=vpQ.begin(); itr != vpQ.end(); ++itr ) {
   Node * pN = (Node *) (* itr );
   if (debug) { cout << "pId " << pN->pId << " nD=" << pN->nD << endl; }
   if ( pN->nD < nMin ) { nMin = pN->nD ;}
 }

 // now, find and return the Node with nMin distance
  for ( itr=vpQ.begin(); itr != vpQ.end(); ++itr ) {
   Node * pN = (Node *) (* itr );
   if ( pN->nD == nMin ) {
     if (debug) { cout << "Now: pId " << pN->pId << " nD=" << pN->nD << endl; }
     vpQ.erase( itr );
     // vpQ.resize( vpQ.size() -1 );
     if (debug) { cout << "vpQ.size()=" << vpQ.size() << endl; }
     return pN ;
   }
 }
 return NULL;  // return failure
}


// u->v, distance is w
int Dijkstra::relax ( Node * pU, Node * pV, float w ) {
  int debug=0;

  if (debug) {
    cout << "(relax()) pU=" << pU->pId << " pV=" << pV->pId;
    cout << " w =" << w << endl;
  }

  if ( pV->iTmp != 1 ) {
    //Then this node has not been searched
    if ( pV->nD > ( pU->nD + w ) ) {
      pV->nD = pU->nD + w;
      pV->pPredecessor = pU;
      pV->iTmp = 1;
      if (debug ) {
        cout<< "(relax()) update pId " << pV->pId << " nD=" << pV->nD << " ";
        cout<< " pPredecessor is " << pV->pPredecessor->pId;
      }
    }
    if (debug) { cout << endl; cout << "out of relax()"<<endl; }
  }
 return 1;
}

/**************************  print functions ***************************/
void Dijkstra::print_input () {
 std::vector<Node>::iterator itr;

 cout << "\nThe source node is " << pSource->pId << endl;
 cout << "\n#######\nThe graph is " << endl;
 pG->print();

 cout << "\n the status" <<endl;
 for ( itr=pG->vNodes.begin(); itr != pG->vNodes.end(); ++itr ) {
   cout<< "Id  " << itr->pId << " distance " << itr->nD;
   if ( itr->pPredecessor ) {
     cout<< "  predecessor " << itr->pPredecessor->pId << endl;
   } else {
     cout<< "  predecessor " << itr->pPredecessor << endl;
   }
 }
 cout << "--------end of Dijkstra::print_input()"<<endl;
}










/*********** deleted ones
int Dijkstra::set_source_node ( Node* pSourceIn ){
  pSource = pSourceIn;
  return 1;
};

int Dijkstra::set_graph ( Graph * pGIn ) {
  pG = pGIn;
  return 1;
};
***************/
