/***************************************************************************
                          dijkstra.h  -  description
                             -------------------
    begin                : December 8, 2005
    copyright            : (C) 2005 Hong Qin
    email                : hong_man@yahoo.com
 ***************************************************************************/
#ifndef _DIJKSTRA_H
#define _DIJKSTRA_H

#include <vector>
#include "node.h"
#include "edge.h"
#include "mytypes.h"
#include "graph.h"
#include <iostream>
#include "util.h"

class Dijkstra {
public:
	Dijkstra () ;
	~Dijkstra () ;
	//initialiation should always be called first.
    int initialize_single_source ( Graph * pGIn, Node * pSourceIn);

	//for non-directinal graph, edge weight is 1
	// distance and predecessor will be stored in pGIn
	int dijkstra_noweight( Graph* pGIn, Node* pSourceIn);

    //non-directional graph, weighted edges
	int dijkstra_weight( Graph* pGIn, Node* pSourceIn);  //020106

	//trace-back for path from pSource to pV;
	int trace_back( Node* pV, std::vector<Node*> & vpReturnPath);

  //trace-back for vpInNodes
	int multiple_trace_back( std::vector<Node*> vpInNodes,
				std::vector< std::vector<Node*> * > & vpvpReturnPaths);

	//Find all shortest-paths from pV to pSource
	int find_all_shortest_paths  ( Node* pV, std::vector< std::vector<Node*> *> & vpvpReturnPaths);
	int find_all_shortest_paths_w( Node* pV, std::vector< std::vector<Node*> *> & vpvpReturnPaths, float threshold);

protected:
	//no-modifiers
	void print_input();
	void test();  // for debug

	//modifiers
    void   set_vpS();
    void   set_vpQ();
	Node * extract_min( std::vector <Node*>  & vpQ ); //
	int    relax ( Node * pU, Node * pV, float pW );  // u->v, distance is w

   // Node *  extract_min_weighted( std::vector <Node*>  & vpQ ) ; unnecessary
   //	int set_source_node ( Node* pSource );
   //	int set_graph ( Graph * pG ) ;


private:
	//input variables
	Node * 			pSource; // current source node
	Graph * 		pG;  //the current Graph

	//temporary variables
	std::vector <Node*>	    vpS; //solved nodes
	std::vector <Node*> 	vpQ; //queue for nodes to be solved


};


#endif
