/***************************************************************************
                          graph.h  -  description
                             -------------------
    begin                : Monday Oct 20, 2003
    copyright            : (C) 2003 Hong Qin
    email                : hongqin@uchicago.edu
 ***************************************************************************/
#ifndef _GRAPH_H
#define _GRAPH_H

#include <vector>
#include "node.h"
#include "edge.h"
#include "mytypes.h"
#include <iostream>

class Graph {
public:
	std::vector <Node> 		vNodes;
	bool				isDirected;

	Graph();
	Graph( const Graph& gIn ); 	// not sure how to implement this yet.
	Graph( const std::vector<Node> vNodes );
//	Graph( std::vector<Node> vNodes, std::vector <Edge> vEdges );
	~Graph();

 	// non-modifiers
	int print();
	int print_graph_in_adj_list( );
	int print_graph_in_adj_list( std::ostream& os );
	int print_pairs_in( std::ostream& os );
	int print_pairs_in( std::ostream& os, char* header );

	// modifiers
 	int set_pairs_in( std::vector<PAIR_str_t> & pairs_in );
	int set_nr_ids( SET_str_t & set_ids );
	int set_ordered_ids( VECTOR_str_t & ordered_ids );
	int set_id2pos( std::map<std::string, int> & m_id2pos );
	int set_mliiEdge( MLMAP_ii_t & mliiIn );
	void clear_neighbours() ;
	void Graph::clear_temporary_buffers( );
	void Graph::clear_pairs_in( );
	void Graph::clear_m_id2pos( );

	// accessors
	inline std::vector<PAIR_str_t> & return_pairs_in() { return pairs_in; }
	inline MLMAP_ii_t & return_mliiEdges() { return mliiEdges ; }

	int reassign_neighbours_by_mliiEdges(  MLMAP_ii_t & miiIn  );

//	int set_mliiEdge(); 		  //set by vNodes

protected:
private:
	MLMAP_ii_t			            mliiEdges;
 	SET_str_t                      	st_nr_ids;
 	VECTOR_str_t                   	v_ordered_ids;
 	std::map<std::string, int>      m_id2pos;
   	std::vector<PAIR_str_t>         pairs_in;
	int 				            iV, iE;
	bool				            isVerified;

	MLMAP_ii_t   			        ml_pos2pos_edges;
 	std::vector<Node*>   		    v_int2NodePtr;
	std::vector< int >  		    vTmp;

	void _set_int2NodePtr_lookup_table_by_vNodes( );
 	void _set_mlmap_pos2pos_edges_by_mliiEdges();
	void _set_pairs_in_by_mliiEdges( ) ;

};

#endif
