/*
 Single source dijkstra shortest path, 
 Return shortest-path of a list of input nodes
 (c) Hogn Qin Dec 11, 2005 hong_man@yahoo.com
*/
#include <string>
#include <iostream>
#include <map>
//#include <iomanip>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>
#include "mapdictionary.h"

#include <fstream>
#include "dijkstra.h"
#include "node_parser.h"
using namespace std;        

typedef struct {
 int    verbose;
 int 	debug;
 char   input_pairwise_tab[1024];
 char   input_node_tab[1024];
 char   output_path_file[1024];
} OPTION_PARA;
 
static OPTION_PARA myoption;

int main(int argc, char *argv[]){
 myoption.verbose=0;
 myoption.debug  =1;

 int c;

 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",       required_argument, 0, 'i'},
          {"node_tab_in",   		optional_argument, 0, 'n'},
          {"output_path_fiel",   	optional_argument, 0, 'o'},
          {"debug",  		    	optional_argument, 0, 'd'},
          {"verbose", 		    	no_argument,  &myoption.verbose, 1},
          {"brief",   		    	no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:n:o:d", long_options, &option_index);
 
      if (c == -1) break;
 
      switch (c)   {
        case 0 :	break;

        case 'd':
          cout<< "option -d\n" << optarg << endl;
	  myoption.debug = atoi( optarg );
          break;
 
        case 'i':
	    cout << "option i, optarg is " << optarg << endl;
	    strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'n':
	    cout << "case n, optarg is " << optarg << endl;
	    strcpy( myoption.input_node_tab, optarg );
          break;
 
        case 'o':
          strcpy( myoption.output_path_file, optarg );  
          break;
 
        case '?':
          break;
 
        default:
          abort ();
        }
 } //while loop

 int debug = myoption.debug;

 long tp;
 time (&tp);
 srand (tp);

 Graph g, g2, g1;
 CPairs_Parser parser1;
 Dijkstra dk1;
 CNode_Parser np1;

 
 string longfile =  myoption.input_pairwise_tab;
 string node_file = myoption.input_node_tab;     
 
 np1.set_vsIds_frm_fl( node_file );

 parser1.generate_undirected_graph_without_self_pairing(longfile, g1 );
 if (debug) {  cout<<"The graph is "; 
   g1.print(); 
 }

 std::vector<Node*> vpPath;

 cout <<"\n---------multiple-------------\n";
 std::vector<Node*> vpNodes;  //the input Nodes

 //pick nodes for shortest_path return
 for ( unsigned i=0; i<np1.vsIds.size(); ++i ) {
   //cout<<"Looking for "<< np1.vsIds[i] << " among ";
   for ( unsigned j=0; j<g1.vNodes.size(); ++j ) {
     //cout << g1.vNodes[j].pId << " ";
     if ( np1.vsIds[i] == (string) g1.vNodes[j].pId ) {
       vpNodes.push_back( & g1.vNodes[j] );
     }
   }
   //cout<<endl;
 }

string sTmp = myoption.output_path_file;
ofstream outfile( sTmp.c_str() );

std::vector< std::vector<Node*> *> vpvpReturnPaths;
std::vector<Node*> vpReturnPath;

dk1.dijkstra_noweight( & g1, & g1.vNodes[10] );

dk1.trace_back( & g1.vNodes[11],  vpReturnPath); 
for( unsigned i=0; i<vpReturnPath.size(); ++i) {
 cout << vpReturnPath[i]->pId << "<-"; 
}
cout<<endl<<endl;


dk1.find_all_shortest_paths( & g1.vNodes[11], vpvpReturnPaths);
cout<<"vpvpReturnPaths.size()=" << vpvpReturnPaths.size() <<endl;

for( unsigned i=0; i<vpvpReturnPaths.size(); ++i) {
   std::vector<Node*> vpTmpPath =  * vpvpReturnPaths[i];
   // outfile <<"#Path " <<i << " is:\n";
   for( unsigned j=0; j<(vpTmpPath.size() -1); ++j ) {
     cout<< vpTmpPath[j]->pId<<"<-";
   }
   cout << vpTmpPath[ vpTmpPath.size()-1 ]->pId <<endl;
	 
}
	 
//enumerate through a list of nodes
for( unsigned k=0; k < (vpNodes.size() -1); ++k) {  // k is the source
  //g1.print();
  cout <<"\n>source is "<< vpNodes[k]->pId <<"\n";
  outfile <<">source is "<< vpNodes[k]->pId <<"\n";
  dk1.dijkstra_noweight( & g1, vpNodes[k] );

  for( unsigned i=k; i<vpNodes.size(); ++i) {  //i is the target node
	  cout    << "target is " << vpNodes[i]->pId << endl; 
		outfile << "target is " << vpNodes[i]->pId << endl; 
    vpvpReturnPaths.clear();
    dk1.find_all_shortest_paths( vpNodes[i], vpvpReturnPaths);
    cout << "vpvpReturnPaths.size()=" << vpvpReturnPaths.size() << endl; 
    for( unsigned j=0; j<vpvpReturnPaths.size(); ++j ) { //print out all paths
      std::vector<Node*> vpTmpPath = * vpvpReturnPaths[j];
      for( unsigned m=0; m< (vpTmpPath.size()-1); ++m ) { //print out all the nodes in the path		
		    outfile<< vpTmpPath[m]->pId<<"<-";
			}//m
      outfile << vpTmpPath[ vpTmpPath.size()-1 ]->pId <<endl;
    }//j
  }//i
  outfile<<"\n";
}//k

 return 0;
}
