#include "mapdictionary.h"
#include "pairs_parser.h"
#include "util.h"
#include "algostuff.hpp"

//////////////////////////////////////////////////////
void CMapDictionary::print() {
 print( cout );
}

void CMapDictionary::print( ostream & os ) {
 MAP_strstr_t::iterator itr;
 for ( itr= _mssTable.begin(); itr!= _mssTable.end(); ++itr ) {
   os << itr->first << "\t" << itr->second << endl;
 }
}

//////////////////////////////////////////////////////
void CMapDictionary:: set_dictionary_content() {
 int debug=0;
 CPairs_Parser parser;

 parser.set_pairs_frm_one_fasta_fl( _in_file_name  );
 vector<PAIR_str_t> viPairsIn = parser.return_pairs_in();
 assert( viPairsIn.size() > 0 );
 vector_to_map( viPairsIn, _mssTable );

 _set_nr_defitions();

 if (debug) { 
   cout <<"CMapDictionary:: viPairsIn.size()="<<viPairsIn.size()
	<< " _mssTable.size()=" << _mssTable.size() << endl;
  }
}

//////////////////////////////////////////////////////
CMapDictionary::CMapDictionary( char * tab_file_name ) {
 _in_file_name = new char[ strlen(tab_file_name) + 1];
 strcpy( _in_file_name, tab_file_name );
 _null_string = "NA";
 _debug=1;  // the debug flag for the whole class
}

CMapDictionary::~CMapDictionary( ) {  }

//////////////////////////////////////////////////////
string & CMapDictionary::get_definition( string & inputKey ) {
 if ( _mssTable[ inputKey ] != "" )  return _mssTable[ inputKey ];
 else return _null_string ;
}

int CMapDictionary::num_of_keys() {
 return _mssTable.size();
}

int CMapDictionary::num_of_uniq_defitions( ) { // i am here 103003Thu !!!
 return 0;
}

/* Maybe this should performed by a CCounter class.
MAP_strint_t & CMapDictionary::sample_size_by_defitions( ) { // i am here 103003Thu !!!
 MAP_strint_t * p_sample_size_by_cats = new MAP_strint_t;
 return * p_sample_size_by_cats ;
}
*/

//////////////////////////////////////////////////////
void CMapDictionary:: _set_nr_defitions() {
 MAP_strstr_t::iterator itr;
 for ( itr= _mssTable.begin(); itr!= _mssTable.end(); ++itr ) {
    _nr_defitions.insert( itr->second );
 }
 if ( _debug ) {
   cout << "\nCMapDictionary::_set_nr_defitions:_nr_defitions.size()="<<_nr_defitions.size()<<endl;
   PRINT_ELEMENTS( _nr_defitions, "\nCMapDictionary::_set_nr_defitions:_nr_defitions: " );
 }
}

MAP_strstr_t & CMapDictionary::return_batch_query( SET_str_t s_query_keys ) {// i am here 103003Thu !!!     
 _mssQueryResult.clear();

 return _mssQueryResult; 
}

SET_str_t & CMapDictionary::return_uniq_defitions_queried( SET_str_t s_query_keys ) { // i am here 103003Thu !!!
  _sQuieried_definitions.clear();

 return  _sQuieried_definitions; 
}

