/* Program: Generate a MS02 null graph, output to a pairwise tab file
   Author:  Hong Qin, October 2003
*/

#include <string>
#include <iostream>
#include <map>
//#include <iomanip>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>
#include "algostuff.hpp"
#include <fstream>

using namespace std;

typedef struct {
 int    verbose;
 int 	debug;
 char   input_pairwise_tab[1024];
 char   input_id2category_tab[1024];
 char   output_pairwise_tab[1024];
 char   output_format[1024];
 int	output_aggregation_choice;
 // char   input_format[1024];
 int 	num_of_ms02_nulls;
} OPTION_PARA;

static OPTION_PARA myoption;

typedef struct {
 int 	iV;
 int 	iE;
 int 	iCategories;
} GRAPH_STAT;

//static GRAPH_STAT input_graph_stat;	// not used yet. for consistency checks
//static GRAPH_STAT current_graph_stat;	// not used yet. for consistency checks

//////////////////////////////////
void _ms02_get_parameters( int argc, char* argv[] ) {
 int c;
 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",       required_argument, 0, 'i'},
          {"name2category_tab_in",  optional_argument, 0, 'c'},
          {"output_pairwise_tab",   optional_argument, 0, 'o'},
          {"num_of_ms02_nulls",     optional_argument, 0, 'n'},
       //   {"input_format",   	    optional_argument, 0, 't'},
          {"output_format",         optional_argument, 0, 'f'},
          {"debug",  		    optional_argument, 0, 'd'},
          {"collective_output",     no_argument,  &myoption.output_aggregation_choice, 1},
          {"separate_output",       no_argument,  &myoption.output_aggregation_choice, 0},
          {"verbose", 		    no_argument,  &myoption.verbose, 1},
          {"brief",   		    no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:c:o:n:t:f:d:", long_options, &option_index);

      if (c == -1)        break;

      switch (c)   {
        case 0 :	break;

        case 'n':
          //cout<< "option -n\n" << optarg << endl;
   	  myoption.num_of_ms02_nulls = atoi( optarg );
          break;

        case 'd':
            cout<< "option -d :" << optarg << endl;
            myoption.debug = atoi( optarg );
          break;

        case 'i':
	  //cout << "option i, optarg is " << optarg << endl;
	  strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'c':
	  //cout << "case c, optarg is " << optarg << endl;
	  strcpy( myoption.input_id2category_tab, optarg );
          break;

        case 'o':
          strcpy( myoption.output_pairwise_tab, optarg );
          break;

        case 'f':
	  cout << " case f, optarg is " << optarg << endl;
	  if ( ( ! strncmp(optarg,"pairwise", 4) ) or ( ! strncmp(optarg,"Pairwise", 4) ) ) {
	     //cout<< "inside of case 'f' if loop" << endl;
          	strcpy( myoption.output_format, "pairwise" );
	  } else {//	cout<< "inside of case 'f' else loop" << endl;
	  	cout << "Warning. Only pairwise output format is currently implemented.\n";
		abort();
	  }
          break;

        case '?':
          break;

        default:
          abort ();
        }
 } //while loop

}

//////////////////////////////////
void _ms02_help() {
  cout << "myoption:" << endl  << "\tverbos\t" << myoption.verbose << endl;
  cout << "\tnum_of_ms02_nulls\t" << myoption.num_of_ms02_nulls <<endl;
  cout << "\tdebug\t" << myoption.debug<<endl;
  if ( myoption.input_pairwise_tab[0] != '0' ) {
  cout << "\tinput_pairwise_tab\t"  << myoption.input_pairwise_tab << endl; }
  if ( myoption.output_pairwise_tab[0] != '\0' ) {
  cout << "\toutput_pairwise_tab\t" << myoption.output_pairwise_tab << endl; }
}


//////////////////////////////////
int main(int argc, char *argv[]){

 myoption.verbose= 0;
 myoption.debug  = 0;
 myoption.num_of_ms02_nulls = 1;
 myoption.output_aggregation_choice = 1;
 strcpy (myoption.output_format, "pairwise");

/* long tp;
 time (&tp);
 srand (tp); move this to permutator.cpp
 MyRandom rd;
*/
 _ms02_get_parameters( argc, argv );

 if (myoption.debug) { cout << "\n---------------------------\n"; }

 if ( myoption.input_pairwise_tab[0] == '\0' ) {   _ms02_help(); return 1;  }

 CPairs_Parser parser1;
 Graph g, g2, g_ms02;
 string file_name;
 string longfile =  myoption.input_pairwise_tab;
 string outfile_suffix;

 cout << "longfile=" << longfile << endl;
 set_shortfile_name(  longfile, file_name );
 if ( myoption.debug) {
    cout << "\nlongfile is " << longfile << endl;
    cout << "set_shortfile_name( longfile, file_name )\n"
	   << "filename is now:\"" <<file_name<< "\""<<endl;
 }

 if ( myoption.output_pairwise_tab[0] != '\0' ) {
   outfile_suffix = myoption.output_pairwise_tab;
 } else {
   outfile_suffix = "_ms02." + file_name;
 }

 if ( myoption.debug ) {
  cout << "outfile_suffix = " << outfile_suffix << endl;
 }

// parser1.generate_undirected_graph_without_self_pairing(longfile, g);
// g.print();

 parser1.generate_undirected_graph_without_self_pairing(longfile, g_ms02);
 if ( myoption.debug ) g_ms02.print();

 MLMAP_ii_t mliiIn1 =  g_ms02.return_mliiEdges();

 MLMAP_ii_t mliiEdgesOUT;

 CPermutator permutor1;
 permutor1.generate_MS02_null_pairs_without_self_pairs_1( mliiIn1, mliiEdgesOUT );
 g_ms02.reassign_neighbours_by_mliiEdges( mliiEdgesOUT  );
 g_ms02.print();

 ofstream outfile( outfile_suffix.c_str() );
 char* cHeader = ">ms02 output\n";
 g_ms02.print_pairs_in( outfile, cHeader );

 return 0;
}
