/* v 0.00
 Single source dijkstra shortest path, 
 Return shortest-path of a list of input nodes
 This program returns a single answer. 
 (c) Hogn Qin Dec 11, 2005 hong_man@yahoo.com
*/
#include <string>
#include <iostream>
#include <map>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"
#include "permutator.h"
#include "getopt.h"
#include <cstring>
#include "mapdictionary.h"

#include <fstream>
#include "dijkstra.h"
#include "node_parser.h"
using namespace std;        

typedef struct {
 int    verbose;
 int 	debug;
 char   input_pairwise_tab[1024];
 char   input_node_tab[1024];
 char   output_path_file[1024];
} OPTION_PARA;
 
static OPTION_PARA myoption;

int main(int argc, char *argv[]){
 myoption.verbose=0;
 myoption.debug  =0;

 int c;

 while (1)    {
      static struct option long_options[] =   {
          {"in_pairwise_tab",       required_argument, 0, 'i'},
          {"node_tab_in",   		optional_argument, 0, 'n'},
          {"output_path_fiel",   	optional_argument, 0, 'o'},
          {"debug",  		    	optional_argument, 0, 'd'},
          {"verbose", 		    	no_argument,  &myoption.verbose, 1},
          {"brief",   		    	no_argument,  &myoption.verbose, 0},
          {0, 0, 0, 0}
        };

      int option_index = 0;
      c = getopt_long (argc, argv, "i:n:o:d", long_options, &option_index);
 
      if (c == -1) break;
 
      switch (c)   {
        case 0 :	break;

        case 'd':
          cout<< "option -d\n" << optarg << endl;
	  myoption.debug = atoi( optarg );
          break;
 
        case 'i':
	    cout << "option i, optarg is " << optarg << endl;
	    strcpy( myoption.input_pairwise_tab, optarg );
          break;

        case 'n':
	    cout << "case n, optarg is " << optarg << endl;
	    strcpy( myoption.input_node_tab, optarg );
          break;
 
        case 'o':
          strcpy( myoption.output_path_file, optarg );  
          break;
 
        case '?':
          break;
 
        default:
          abort ();
        }
 } //while loop

 int debug = myoption.debug;

 long tp;
 time (&tp);
 srand (tp);

 Graph g, g2, g1;
 CPairs_Parser parser1;
 Dijkstra dk1;
 CNode_Parser np1;

 
 string longfile =  myoption.input_pairwise_tab;
 string node_file = myoption.input_node_tab;     
 
 np1.set_vsIds_frm_fl( node_file );

 parser1.generate_undirected_graph_without_self_pairing(longfile, g1 );
 if (debug) {  cout<<"The graph is "; 
   g1.print(); 
 }

 std::vector<Node*> vpPath;

 cout <<"\n---------multiple-------------\n";
 std::vector<Node*> vpNodes;  //the input Nodes
 std::vector< std::vector<Node*> * > vpvpReturnPaths; 

 //pick nodes for shortest_path return
 for ( unsigned i=0; i<np1.vsIds.size(); ++i ) {
   //cout<<"Looking for "<< np1.vsIds[i] << " among ";
   for ( unsigned j=0; j<g1.vNodes.size(); ++j ) {
     //cout << g1.vNodes[j].pId << " ";
     if ( np1.vsIds[i] == (string) g1.vNodes[j].pId ) {
       vpNodes.push_back( & g1.vNodes[j] );
     }
   }
   //cout<<endl;
 }

string sTmp = myoption.output_path_file;
ofstream outfile( sTmp.c_str() );

for( unsigned k=0; k < (vpNodes.size() -1); ++k) { 
//for( unsigned k=1; k < 2; ++k) { 
 vpvpReturnPaths.clear();
 outfile <<">source is "<< vpNodes[k]->pId <<"\n";
 dk1.dijkstra_noweight( & g1, vpNodes[k] );
// dk1.dijkstra_noweight( & g1, & g1.vNodes[k]);
 dk1.multiple_trace_back( vpNodes, vpvpReturnPaths );
 for( unsigned i=k; i<vpvpReturnPaths.size(); ++i) {
   std::vector<Node*> vpTmpPath = * vpvpReturnPaths[i];
   // outfile <<"#Path " <<i << " is:\n";
   for( unsigned j=0; j<(vpTmpPath.size() -1); ++j ) {
     outfile<< vpTmpPath[j]->pId<<"<-";
   }
   outfile << vpTmpPath[ vpTmpPath.size()-1 ]->pId <<endl;
 }//i
 outfile<<"\n";
}//k
 return 0;
}
