/***************************************************************************
                          util.h  -  description
                             -------------------
    begin                : Mon Oct 20, 2003
    copyright            : (C) 2003 by Hong Qin
    email                : hongqin@uchicago.edu
 ***************************************************************************/
#ifndef _UTIL_H
#define _UTIL_H 
#include <cstdlib>
#include "mytypes.h"
#include <map>
#include <list>
#include <string>
#include <vector>
#include "algostuff.hpp"
#include <cmath>

void reverse( char s[]);
void itoa(int, char s[] );
int  trim( char s[] );

inline int  even_num( int in ) { return  (int) (floor( in / 2) * 2); };

void set_shortfile_name( string & longfilename, string & shortfilename );

PAIR_str_t  small2big_pair( string s1, string s2);
 
void small2big_swap( string & s1, string & s2);
void array_to_vector_int( int in[], VI& out, int iSize );
bool exists_vi ( VI& viIn, int value );
bool ajacent_vi( VI& viIn, int value );

void mlmapii_to_list( MLMAP_ii_t& in, LI& out );
void list_to_mlmapii( LI& in, MLMAP_ii_t& out );

void mlmapii_to_vector( MLMAP_ii_t& in, VI& out );
void vector_to_mlmapii( VI& in, MLMAP_ii_t& out );

void find_SelfPairsFirstPositions_vector( VI& viIn, VI& viSelfPairsFirstPositions );     
void find_new_positions( VI& viIn, VI& viSelfPairsFirstPositions, VI& viNewPositions );    
void find_new_positions( VI& viIn, VI& viOldPositions, VI& viNewPositions, int distance );    
void swap_positions_in_vector( VI& viIn, VI& viSelfPairsFirstPositions, VI& viNewPositions ); 

void find_positions_of_first_redundant_pairs( VI& viIn, VI& viRedundantPairPositions );  
void find_a_new_position_for_the_first_redundant_pair_position( VI& viIn, VI& viRedundantPairPositions, VI& viNewPositions);

class MyRandom {
 public:
  ptrdiff_t operator() (ptrdiff_t max) {
     double tmp;
     tmp = static_cast<double>( rand()) / static_cast<double> (RAND_MAX);
     return static_cast<ptrdiff_t> (tmp * max);
  }
};

#endif 
