/***************************************************************************
                          mapdictionary.h  -  description
                             -------------------
    begin                : Tue Oct 30, 2003
    copyright            : (C) 2003 by Hong Qin
    email                : hongqin@uchicago.edu

Class CMapDictionary is std::map implementation of the abstract CDictionary.
It can be used to check the category of each orf. 
CDictionary can be initiated by a tab file.
It can return simple statistics, such as sample distributions by categories, total entries.
It can translate the definitions into new ones by an input lookup table.
Output from CDictionary can be ported into R.

****************************************************************************/
#ifndef _MAPDICTIONARY_H
#define _MAPDICTIONARY_H 

#include "dictionary.h"

class CMapDictionary : public CDictionary {
public:
  int					_debug;

 CMapDictionary( char * tab_file_name );
 virtual ~CMapDictionary() ;

 void print( );
 void print( std::ostream& os );

 void set_dictionary_content();
 
 int num_of_keys( ) ;
 int num_of_uniq_defitions( ) ;

 // single query
 std::string &  get_definition( std::string & inputKey ) ;

 // batch query
 MAP_strstr_t &  return_batch_query( SET_str_t s_query_keys );
 SET_str_t &     return_uniq_defitions_queried( SET_str_t s_query_keys ) ;

protected:

private:
  char*					_in_file_name;
  MAP_strstr_t				_mssTable;
  SET_str_t 				_nr_defitions;

  std::string				_null_string;

  SET_str_t				_sQueryKeys;
  MAP_strstr_t				_mssQueryResult;
  SET_str_t				_sQuieried_definitions;

  void _set_nr_defitions();


};

#endif 
